/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2026-02-18 15:14:01 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=88 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `noc_autologin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(45) DEFAULT NULL,
  `token` varchar(45) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=MyISAM AUTO_INCREMENT=257 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=434 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=665 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`),
  KEY `woo_idx_comment_date_type` (`comment_date_gmt`,`comment_type`,`comment_approved`,`comment_post_ID`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_depicter_documents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `slug` varchar(100) NOT NULL,
  `type` varchar(50) NOT NULL DEFAULT 'custom',
  `author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `sections_count` mediumint(9) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `thumbnail` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'draft',
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `password` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `created_at` (`created_at`),
  KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_depicter_leads` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `source_id` bigint(20) unsigned NOT NULL,
  `content_id` bigint(20) NOT NULL,
  `content_name` varchar(150) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_depicter_lead_fields` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `type` varchar(50) NOT NULL DEFAULT '',
  `value` text NOT NULL DEFAULT '',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_depicter_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `relation` varchar(30) NOT NULL DEFAULT '',
  `relation_id` bigint(20) NOT NULL,
  `meta_key` varchar(30) NOT NULL DEFAULT '',
  `meta_value` text NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_depicter_options` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` text NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_depicter_queue_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(50) NOT NULL DEFAULT 'default',
  `payload` longtext NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `reserved_at` datetime DEFAULT NULL,
  `available_at` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  `last_error` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `available_at` (`available_at`),
  KEY `queue` (`queue`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_activity_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `sub_type` varchar(100) NOT NULL,
  `severity` int(8) NOT NULL,
  `title` text NOT NULL,
  `data` longtext NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `sub_type_idx` (`sub_type`),
  KEY `severity_idx` (`severity`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_backups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `archive_name` varchar(350) NOT NULL DEFAULT '',
  `status` int(11) NOT NULL,
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE','TEMPORARY') NOT NULL DEFAULT '',
  `package` longtext NOT NULL,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`(191)),
  KEY `archive_name` (`archive_name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_entities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `value_1` varchar(255) NOT NULL DEFAULT '',
  `value_2` varchar(255) NOT NULL DEFAULT '',
  `value_3` varchar(255) NOT NULL DEFAULT '',
  `value_4` varchar(255) NOT NULL DEFAULT '',
  `value_5` varchar(255) NOT NULL DEFAULT '',
  `data` longtext NOT NULL,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`(191)),
  KEY `value_2` (`value_2`(191)),
  KEY `value_3` (`value_3`(191)),
  KEY `value_4` (`value_4`(191)),
  KEY `value_5` (`value_5`(191))
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_masterslider_options` (
  `ID` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(120) NOT NULL,
  `option_value` text NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_masterslider_sliders` (
  `ID` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `alias` varchar(100) NOT NULL,
  `type` varchar(64) NOT NULL,
  `slides_num` smallint(5) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `params` mediumtext NOT NULL,
  `custom_styles` text NOT NULL DEFAULT '',
  `custom_fonts` text NOT NULL DEFAULT '',
  `status` varchar(10) NOT NULL DEFAULT 'draft',
  PRIMARY KEY (`ID`),
  KEY `date_created` (`date_created`),
  KEY `alias` (`alias`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=2418 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=6068 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=331 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1342 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT current_timestamp(),
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`),
  KEY `idx_date_paid_status_parent` (`date_paid`,`status`,`parent_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`),
  KEY `idx_user_email` (`user_email`(100))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`),
  KEY `session_expiry` (`session_expiry`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `zone_id` (`zone_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wpr_above_the_fold` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `lcp` longtext DEFAULT '',
  `viewport` longtext DEFAULT '',
  `error_message` longtext DEFAULT NULL,
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191))
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wpr_lazy_render_content` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `below_the_fold` longtext DEFAULT '',
  `error_message` longtext DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191))
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wpr_performance_monitoring` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `title` text DEFAULT '',
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `job_id` varchar(255) NOT NULL DEFAULT '',
  `queue_name` varchar(255) NOT NULL DEFAULT '',
  `retries` tinyint(1) NOT NULL DEFAULT 1,
  `status` varchar(255) DEFAULT NULL,
  `data` longtext NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `submitted_at` timestamp NULL DEFAULT NULL,
  `next_retry_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `score` tinyint(3) DEFAULT 0,
  `report_url` varchar(255) DEFAULT '',
  `is_blurred` tinyint(1) NOT NULL DEFAULT 0,
  `metric_data` longtext DEFAULT NULL,
  `error_code` varchar(32) DEFAULT NULL,
  `error_message` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191)),
  KEY `error_code_index` (`error_code`),
  KEY `is_blurred` (`is_blurred`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wpr_preconnect_external_domains` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `domains` longtext DEFAULT '',
  `error_message` longtext DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191))
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wpr_preload_fonts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `fonts` longtext DEFAULT '',
  `error_message` longtext DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wpr_rocket_cache` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_locked` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(191)),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wpr_rucss_used_css` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `css` longtext DEFAULT NULL,
  `hash` varchar(32) DEFAULT '',
  `error_code` varchar(32) DEFAULT NULL,
  `error_message` longtext DEFAULT NULL,
  `unprocessedcss` longtext DEFAULT NULL,
  `retries` tinyint(1) NOT NULL DEFAULT 1,
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `job_id` varchar(255) NOT NULL DEFAULT '',
  `queue_name` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `submitted_at` timestamp NULL DEFAULT NULL,
  `next_retry_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191)),
  KEY `error_code_index` (`error_code`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `wp_users` VALUES 
("1","admin","$wp$2y$10$GXFXeVSpBc1.H4HIG/hduudHsirUp61owCx57UcLCBRb58s.HT.Qi","admin","hedi.chqir@gmail.com","https://leg.miklub.fr","2026-02-17 11:06:52","","0","admin"),
("2","makedealstn","$wp$2y$10$.rjlZKzNu1uPPPAozXpz8.hPfGt.3daLxdSR8525Zxyyl9ws4gGNK","makedealstn","makedealstn@gmail.com","","2026-02-18 13:11:33","1771420293:$generic$PvUnxxfz4agsKqY_c1B1uYTyI3F26Ip4kdb2bag_","0","makedealstn");

INSERT IGNORE INTO `wp_usermeta` VALUES 
("1","1","nickname","admin"),
("2","1","first_name",""),
("3","1","last_name",""),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","wp_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("13","1","wp_user_level","10"),
("14","1","dismissed_wp_pointers","master_1_0_view_help,msp_1_4_3__25samples"),
("15","1","show_welcome_panel","0"),
("16","1","session_tokens","a:4:{s:64:\"414788ac1b9ab78fd6fbeccd284fdade4564f72a148b09b35ca8b9517e5963bc\";a:4:{s:10:\"expiration\";i:1771499311;s:2:\"ip\";s:15:\"147.161.180.107\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36\";s:5:\"login\";i:1771326511;}s:64:\"9bbfd6c192a23cf755eb24af23b23c1d7e5a007d07c0741da5774887acd5e022\";a:4:{s:10:\"expiration\";i:1772547273;s:2:\"ip\";s:15:\"147.161.180.107\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36\";s:5:\"login\";i:1771337673;}s:64:\"0f2a2d3749145b5622f28f703689890ee54b690dde53ddd4a86608389786d6d8\";a:4:{s:10:\"expiration\";i:1771583460;s:2:\"ip\";s:15:\"147.161.180.107\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36\";s:5:\"login\";i:1771410660;}s:64:\"e149c649cf9715659b7dda7f094aa3f8ed8b0b59986ba41a7bd42b9434e10dae\";a:4:{s:10:\"expiration\";i:1771599939;s:2:\"ip\";s:15:\"196.203.109.138\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36\";s:5:\"login\";i:1771427139;}}"),
("17","1","wp_dashboard_quick_press_last_post_id","5"),
("18","1","community-events-location","a:1:{s:2:\"ip\";s:13:\"196.203.109.0\";}"),
("19","1","element-pack-notice-id-license-issue","1"),
("20","1","elementor_introduction","a:4:{s:27:\"e-editor-one-notice-pointer\";b:1;s:27:\"ai-get-started-announcement\";b:1;s:20:\"globals_introduction\";b:1;s:30:\"e-ai-product-image-unification\";b:1;}"),
("21","1","_woocommerce_persistent_cart_1","a:1:{s:4:\"cart\";a:3:{s:32:\"c9e1074f5b3f9fc8ea15d152add07294\";a:11:{s:3:\"key\";s:32:\"c9e1074f5b3f9fc8ea15d152add07294\";s:10:\"product_id\";i:104;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";i:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:70;s:17:\"line_subtotal_tax\";d:0;s:10:\"line_total\";d:70;s:8:\"line_tax\";d:0;}s:32:\"ac627ab1ccbdb62ec96e702f07f6425b\";a:11:{s:3:\"key\";s:32:\"ac627ab1ccbdb62ec96e702f07f6425b\";s:10:\"product_id\";i:99;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";i:2;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:140;s:17:\"line_subtotal_tax\";d:0;s:10:\"line_total\";d:140;s:8:\"line_tax\";d:0;}s:32:\"f899139df5e1059396431415e770c6dd\";a:11:{s:3:\"key\";s:32:\"f899139df5e1059396431415e770c6dd\";s:10:\"product_id\";i:100;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";i:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:70;s:17:\"line_subtotal_tax\";d:0;s:10:\"line_total\";d:70;s:8:\"line_tax\";d:0;}}}"),
("22","1","wc_last_active","1771427362"),
("23","1","elementor_admin_notices","a:1:{s:20:\"experiment_promotion\";a:2:{s:9:\"is_viewed\";b:1;s:4:\"meta\";a:0:{}}}"),
("24","1","wp_user-settings","libraryContent=browse&editor=tinymce&hidetb=1&posts_list_mode=list"),
("25","1","wp_user-settings-time","1771399940"),
("26","1","_elementor_structure_popup_dismissed","1"),
("27","1","elementor_dismissed_editor_notices","a:2:{i:0;s:36:\"container-aux_container_width_notice\";i:1;s:20:\"image_optimizer_hint\";}"),
("28","1","closedpostboxes_dashboard","a:7:{i:0;s:24:\"wc_admin_dashboard_setup\";i:1;s:20:\"e-dashboard-overview\";i:2;s:21:\"dashboard_site_health\";i:3;s:19:\"dashboard_right_now\";i:4;s:18:\"dashboard_activity\";i:5;s:21:\"dashboard_quick_press\";i:6;s:17:\"dashboard_primary\";}"),
("29","1","metaboxhidden_dashboard","a:0:{}"),
("30","1","meta-box-order_dashboard","a:4:{s:6:\"normal\";s:87:\"wc_admin_dashboard_setup,e-dashboard-overview,dashboard_site_health,dashboard_right_now\";s:4:\"side\";s:58:\"dashboard_quick_press,dashboard_primary,dashboard_activity\";s:7:\"column3\";s:0:\"\";s:7:\"column4\";s:0:\"\";}"),
("31","1","meta-box-order_product","a:3:{s:4:\"side\";s:84:\"submitdiv,postimagediv,woocommerce-product-images,product_catdiv,tagsdiv-product_tag\";s:6:\"normal\";s:55:\"woocommerce-product-data,postcustom,slugdiv,postexcerpt\";s:8:\"advanced\";s:0:\"\";}"),
("32","1","auxshp_wishlist_items","a:1:{i:99;s:19:\"2026-02-17 13:31:19\";}"),
("34","1","nav_menu_recently_edited","46"),
("35","1","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("36","1","metaboxhidden_nav-menus","a:9:{i:0;s:19:\"aux_archive_menubox\";i:1;s:21:\"add-post-type-product\";i:2;s:17:\"add-post-type-faq\";i:3;s:12:\"add-post_tag\";i:4;s:15:\"add-post_format\";i:5;s:17:\"add-product_brand\";i:6;s:15:\"add-product_cat\";i:7;s:15:\"add-product_tag\";i:8;s:16:\"add-faq-category\";}"),
("37","1","twitter",""),
("38","1","facebook",""),
("39","1","googleplus",""),
("40","1","flickr",""),
("41","1","delicious",""),
("42","1","pinterest",""),
("43","1","github",""),
("44","1","skills",""),
("45","1","last_update","1771337795"),
("46","1","wp_persisted_preferences","a:3:{s:4:\"core\";a:1:{s:26:\"isComplementaryAreaVisible\";b:1;}s:14:\"core/edit-post\";a:1:{s:12:\"welcomeGuide\";b:0;}s:9:\"_modified\";s:24:\"2026-02-17T14:16:29.688Z\";}"),
("47","1","wc_order_count_wp","0"),
("48","1","closedpostboxes_product","a:0:{}"),
("49","1","metaboxhidden_product","a:2:{i:0;s:10:\"postcustom\";i:1;s:7:\"slugdiv\";}"),
("51","2","nickname","makedealstn"),
("52","2","first_name",""),
("53","2","last_name",""),
("54","2","description",""),
("55","2","rich_editing","true"),
("56","2","syntax_highlighting","true"),
("57","2","comment_shortcuts","false"),
("58","2","admin_color","fresh"),
("59","2","use_ssl","0"),
("60","2","show_admin_bar_front","true"),
("61","2","locale",""),
("62","2","wp_capabilities","a:1:{s:8:\"customer\";b:1;}"),
("63","2","wp_user_level","0"),
("64","2","_wc_order_attribution_source_type","typein"),
("65","2","_wc_order_attribution_utm_source","(direct)"),
("66","2","_wc_order_attribution_session_entry","https://leg.miklub.fr/"),
("67","2","_wc_order_attribution_session_start_time","2026-02-18 13:10:36"),
("68","2","_wc_order_attribution_session_pages","3"),
("69","2","_wc_order_attribution_session_count","1"),
("70","2","_wc_order_attribution_user_agent","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36"),
("71","2","_wc_order_attribution_device_type","Desktop"),
("72","2","default_password_nag","1"),
("73","2","twitter",""),
("74","2","facebook",""),
("75","2","googleplus",""),
("76","2","flickr",""),
("77","2","delicious",""),
("78","2","pinterest",""),
("79","2","github",""),
("80","2","skills",""),
("81","2","last_update","1771420293"),
("83","2","_woocommerce_persistent_cart_1","a:1:{s:4:\"cart\";a:1:{s:32:\"f899139df5e1059396431415e770c6dd\";a:6:{s:3:\"key\";s:32:\"f899139df5e1059396431415e770c6dd\";s:10:\"product_id\";i:100;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";i:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";}}}"),
("84","2","wc_last_active","1771420564"),
("86","1","rocket_boxes","a:0:{}");

INSERT IGNORE INTO `wp_actionscheduler_actions` VALUES 
("11","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-02-17 11:27:38","2026-02-17 11:27:38","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771327658;s:18:\"\0*\0first_timestamp\";i:1771327658;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771327658;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-02-17 12:00:50","2026-02-17 12:00:50","1",NULL),
("12","action_scheduler/migration_hook","complete","2026-02-17 11:28:41","2026-02-17 11:28:41","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771327721;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771327721;}","2","1","2026-02-17 12:00:50","2026-02-17 12:00:50","1",NULL),
("13","wc-admin_process_pending_orders_batch","complete","2026-02-17 11:27:41","2026-02-17 11:27:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771327661;s:18:\"\0*\0first_timestamp\";i:1771327661;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771327661;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","3","1","2026-02-17 12:00:50","2026-02-17 12:00:50","1",NULL),
("14","woocommerce_cleanup_draft_orders","complete","2026-02-17 11:27:41","2026-02-17 11:27:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771327661;s:18:\"\0*\0first_timestamp\";i:1771327661;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771327661;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2026-02-17 12:00:50","2026-02-17 12:00:50","1",NULL),
("15","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","failed","2026-02-17 11:36:48","2026-02-17 11:36:48","10","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","4","1","2026-02-17 12:00:50","2026-02-17 12:00:50","1",NULL),
("16","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 11:36:51","2026-02-17 11:36:51","10","[101,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328211;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328211;}","5","1","2026-02-17 12:00:50","2026-02-17 12:00:50","1",NULL),
("17","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 11:36:53","2026-02-17 11:36:53","10","[102,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328213;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328213;}","5","1","2026-02-17 12:00:50","2026-02-17 12:00:50","1",NULL),
("18","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 11:36:55","2026-02-17 11:36:55","10","[104,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328215;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328215;}","5","1","2026-02-17 12:00:50","2026-02-17 12:00:50","1",NULL),
("19","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 11:36:58","2026-02-17 11:36:58","10","[106,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328218;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328218;}","5","1","2026-02-17 12:00:50","2026-02-17 12:00:50","1",NULL),
("20","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 11:37:00","2026-02-17 11:37:00","10","[108,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328220;}","5","1","2026-02-17 12:00:50","2026-02-17 12:00:50","1",NULL),
("21","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 11:37:03","2026-02-17 11:37:03","10","[110,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328223;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328223;}","5","1","2026-02-17 12:00:50","2026-02-17 12:00:50","1",NULL),
("22","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 11:37:06","2026-02-17 11:37:06","10","[112,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328226;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328226;}","5","1","2026-02-17 12:00:50","2026-02-17 12:00:50","1",NULL),
("23","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 11:37:09","2026-02-17 11:37:09","10","[115,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328229;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328229;}","5","1","2026-02-17 12:00:50","2026-02-17 12:00:50","1",NULL),
("24","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 11:37:11","2026-02-17 11:37:11","10","[116,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328231;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328231;}","5","1","2026-02-17 12:00:50","2026-02-17 12:00:50","1",NULL),
("25","wc-admin_process_pending_orders_batch","complete","2026-02-18 00:00:50","2026-02-18 00:00:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771372850;s:18:\"\0*\0first_timestamp\";i:1771327661;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771372850;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","3","1","2026-02-18 01:58:21","2026-02-18 01:58:21","179",NULL),
("26","woocommerce_cleanup_draft_orders","complete","2026-02-18 12:00:50","2026-02-18 12:00:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771416050;s:18:\"\0*\0first_timestamp\";i:1771327661;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771416050;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2026-02-18 13:10:36","2026-02-18 13:10:36","382",NULL),
("27","woocommerce_scheduled_sales","complete","2026-02-18 00:00:00","2026-02-18 00:00:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771372800;s:18:\"\0*\0first_timestamp\";i:1771372800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771372800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2026-02-18 01:58:21","2026-02-18 01:58:21","179",NULL),
("28","woocommerce_cancel_unpaid_orders","complete","2026-02-17 13:00:50","2026-02-17 13:00:50","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771333250;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771333250;}","6","1","2026-02-17 13:01:40","2026-02-17 13:01:40","62",NULL),
("29","woocommerce_cleanup_personal_data","complete","2026-02-17 12:01:00","2026-02-17 12:01:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771329660;s:18:\"\0*\0first_timestamp\";i:1771329660;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771329660;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2026-02-17 12:01:54","2026-02-17 12:01:54","5",NULL),
("30","woocommerce_cleanup_logs","complete","2026-02-18 03:00:00","2026-02-18 03:00:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771383600;s:18:\"\0*\0first_timestamp\";i:1771383600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771383600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2026-02-18 04:08:35","2026-02-18 04:08:35","182",NULL),
("31","woocommerce_cleanup_sessions","complete","2026-02-18 06:00:00","2026-02-18 06:00:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771394400;s:18:\"\0*\0first_timestamp\";i:1771394400;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771394400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","6","1","2026-02-18 06:48:44","2026-02-18 06:48:44","185",NULL),
("32","woocommerce_geoip_updater","complete","2026-02-18 06:00:00","2026-02-18 06:00:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771394400;s:18:\"\0*\0first_timestamp\";i:1771394400;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771394400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}","6","1","2026-02-18 06:48:44","2026-02-18 06:48:44","185",NULL),
("33","woocommerce_cleanup_rate_limits_wrapper","complete","2026-02-18 03:00:00","2026-02-18 03:00:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771383600;s:18:\"\0*\0first_timestamp\";i:1771383600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771383600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2026-02-18 04:08:35","2026-02-18 04:08:35","182",NULL),
("34","wc_admin_daily_wrapper","complete","2026-02-17 12:00:50","2026-02-17 12:00:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771329650;s:18:\"\0*\0first_timestamp\";i:1771329650;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771329650;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2026-02-17 12:00:51","2026-02-17 12:00:51","2",NULL),
("35","generate_category_lookup_table_wrapper","complete","2026-02-17 12:01:00","2026-02-17 12:01:00","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771329660;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771329660;}","6","1","2026-02-17 12:01:54","2026-02-17 12:01:54","5",NULL),
("36","woocommerce_refresh_order_count_cache","complete","2026-02-18 00:00:50","2026-02-18 00:00:50","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771372850;s:18:\"\0*\0first_timestamp\";i:1771372850;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771372850;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","7","1","2026-02-18 01:58:21","2026-02-18 01:58:21","179",NULL),
("37","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-02-18 12:00:50","2026-02-18 12:00:50","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771416050;s:18:\"\0*\0first_timestamp\";i:1771327658;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771416050;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-02-18 13:10:38","2026-02-18 13:10:38","382",NULL),
("38","wc_admin_daily_wrapper","complete","2026-02-18 12:00:51","2026-02-18 12:00:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771416051;s:18:\"\0*\0first_timestamp\";i:1771329650;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771416051;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2026-02-18 13:10:37","2026-02-18 13:10:37","382",NULL),
("39","woocommerce_cleanup_personal_data","complete","2026-02-18 12:01:54","2026-02-18 12:01:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771416114;s:18:\"\0*\0first_timestamp\";i:1771329660;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771416114;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2026-02-18 13:10:38","2026-02-18 13:10:38","382",NULL),
("40","woocommerce_cancel_unpaid_orders","complete","2026-02-17 14:01:40","2026-02-17 14:01:40","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336900;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336900;}","6","1","2026-02-17 14:07:01","2026-02-17 14:07:01","140",NULL),
("41","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:20:38","2026-02-17 13:20:38","10","[99,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771334438;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771334438;}","5","1","2026-02-17 13:20:39","2026-02-17 13:20:39","81",NULL),
("42","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:24:20","2026-02-17 13:24:20","10","[99,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771334660;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771334660;}","5","1","2026-02-17 13:24:45","2026-02-17 13:24:45","86",NULL),
("43","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:24:48","2026-02-17 13:24:48","10","[99,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771334688;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771334688;}","5","1","2026-02-17 13:25:22","2026-02-17 13:25:22","88",NULL),
("44","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:34:12","2026-02-17 13:34:12","10","[100,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771335252;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771335252;}","5","1","2026-02-17 13:34:57","2026-02-17 13:34:57","98",NULL),
("45","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:36:08","2026-02-17 13:36:08","10","[99,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771335368;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771335368;}","5","1","2026-02-17 13:36:41","2026-02-17 13:36:41","102",NULL),
("46","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:38:55","2026-02-17 13:38:55","10","[142,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771335535;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771335535;}","5","1","2026-02-17 13:39:29","2026-02-17 13:39:29","106",NULL),
("47","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:38:55","2026-02-17 13:38:55","10","[143,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771335535;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771335535;}","5","1","2026-02-17 13:39:29","2026-02-17 13:39:29","106",NULL),
("48","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:38:55","2026-02-17 13:38:55","10","[144,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771335535;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771335535;}","5","1","2026-02-17 13:39:29","2026-02-17 13:39:29","106",NULL),
("49","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:38:55","2026-02-17 13:38:55","10","[101,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771335535;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771335535;}","5","1","2026-02-17 13:39:29","2026-02-17 13:39:29","106",NULL),
("50","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:39:43","2026-02-17 13:39:43","10","[101,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771335583;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771335583;}","5","1","2026-02-17 13:39:43","2026-02-17 13:39:43","108",NULL),
("51","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:40:02","2026-02-17 13:40:02","10","[101,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771335602;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771335602;}","5","1","2026-02-17 13:40:42","2026-02-17 13:40:42","110",NULL),
("52","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:42:54","2026-02-17 13:42:54","10","[102,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771335774;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771335774;}","5","1","2026-02-17 13:43:02","2026-02-17 13:43:02","115",NULL),
("53","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:43:35","2026-02-17 13:43:35","10","[139,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771335815;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771335815;}","5","1","2026-02-17 13:43:43","2026-02-17 13:43:43","117",NULL),
("54","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:43:35","2026-02-17 13:43:35","10","[140,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771335815;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771335815;}","5","1","2026-02-17 13:43:43","2026-02-17 13:43:43","117",NULL),
("55","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:43:35","2026-02-17 13:43:35","10","[141,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771335815;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771335815;}","5","1","2026-02-17 13:43:43","2026-02-17 13:43:43","117",NULL),
("56","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:43:35","2026-02-17 13:43:35","10","[102,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771335815;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771335815;}","5","1","2026-02-17 13:43:43","2026-02-17 13:43:43","117",NULL),
("57","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:45:24","2026-02-17 13:45:24","10","[103,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771335924;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771335924;}","5","1","2026-02-17 13:45:26","2026-02-17 13:45:26","120",NULL),
("58","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:45:57","2026-02-17 13:45:57","10","[103,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771335957;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771335957;}","5","1","2026-02-17 13:46:42","2026-02-17 13:46:42","123",NULL),
("59","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:48:43","2026-02-17 13:48:43","10","[121,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336123;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336123;}","5","1","2026-02-17 13:48:43","2026-02-17 13:48:43","126",NULL),
("60","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:48:43","2026-02-17 13:48:43","10","[122,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336123;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336123;}","5","1","2026-02-17 13:48:43","2026-02-17 13:48:43","126",NULL),
("61","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:48:44","2026-02-17 13:48:44","10","[123,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336124;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336124;}","5","1","2026-02-17 13:48:56","2026-02-17 13:48:56","128",NULL),
("62","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:48:44","2026-02-17 13:48:44","10","[104,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336124;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336124;}","5","1","2026-02-17 13:48:56","2026-02-17 13:48:56","128",NULL),
("63","wc_schedule_update_product_default_cat","complete","2026-02-17 13:49:10","2026-02-17 13:49:10","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336150;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336150;}","8","1","2026-02-17 13:49:46","2026-02-17 13:49:46","130",NULL),
("64","wc_schedule_update_product_default_cat","complete","2026-02-17 13:49:11","2026-02-17 13:49:11","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336151;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336151;}","8","1","2026-02-17 13:49:46","2026-02-17 13:49:46","130",NULL),
("65","wc_schedule_update_product_default_cat","complete","2026-02-17 13:49:11","2026-02-17 13:49:11","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336151;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336151;}","8","1","2026-02-17 13:49:46","2026-02-17 13:49:46","130",NULL),
("66","wc_schedule_update_product_default_cat","complete","2026-02-17 13:49:11","2026-02-17 13:49:11","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336151;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336151;}","8","1","2026-02-17 13:49:46","2026-02-17 13:49:46","130",NULL),
("67","wc_schedule_update_product_default_cat","complete","2026-02-17 13:49:11","2026-02-17 13:49:11","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336151;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336151;}","8","1","2026-02-17 13:49:46","2026-02-17 13:49:46","130",NULL),
("68","wc_schedule_update_product_default_cat","complete","2026-02-17 13:49:11","2026-02-17 13:49:11","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336151;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336151;}","8","1","2026-02-17 13:49:46","2026-02-17 13:49:46","130",NULL),
("69","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[105,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","133",NULL),
("70","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[124,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","133",NULL),
("71","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[125,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","133",NULL),
("72","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[126,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","133",NULL),
("73","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[106,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","133",NULL),
("74","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[107,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","133",NULL),
("75","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[127,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","133",NULL),
("76","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[128,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","133",NULL),
("77","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[129,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","133",NULL),
("78","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[108,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","133",NULL),
("79","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[109,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","133",NULL),
("80","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[130,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","133",NULL),
("81","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[131,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","133",NULL),
("82","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[132,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","133",NULL),
("83","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[110,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","133",NULL),
("84","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[111,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","133",NULL),
("85","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[133,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","133",NULL),
("86","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[134,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","133",NULL),
("87","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[135,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","133",NULL),
("88","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[112,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","133",NULL),
("89","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[113,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","133",NULL),
("90","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[114,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","133",NULL),
("91","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[118,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","133",NULL),
("92","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[119,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","133",NULL),
("93","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[120,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","133",NULL),
("94","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[115,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","134",NULL),
("95","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[136,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","134",NULL),
("96","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[137,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","134",NULL),
("97","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[138,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","134",NULL),
("98","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:42","2026-02-17 13:50:42","10","[116,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336242;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","134",NULL),
("99","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:50:43","2026-02-17 13:50:43","10","[117,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336243;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336243;}","5","1","2026-02-17 13:51:06","2026-02-17 13:51:06","134",NULL),
("100","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-17 13:51:58","2026-02-17 13:51:58","10","[103,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771336318;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771336318;}","5","1","2026-02-17 13:52:09","2026-02-17 13:52:09","137",NULL),
("101","woocommerce_cancel_unpaid_orders","complete","2026-02-17 15:07:01","2026-02-17 15:07:01","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771340821;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771340821;}","6","1","2026-02-17 15:36:13","2026-02-17 15:36:13","174",NULL),
("102","woocommerce_cancel_unpaid_orders","complete","2026-02-17 16:36:13","2026-02-17 16:36:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771346173;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771346173;}","6","1","2026-02-17 22:22:37","2026-02-17 22:22:37","177",NULL),
("103","woocommerce_cancel_unpaid_orders","complete","2026-02-17 23:22:37","2026-02-17 23:22:37","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771370557;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771370557;}","6","1","2026-02-18 01:58:21","2026-02-18 01:58:21","179",NULL),
("104","woocommerce_cancel_unpaid_orders","complete","2026-02-18 02:58:21","2026-02-18 02:58:21","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771383501;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771383501;}","6","1","2026-02-18 04:08:35","2026-02-18 04:08:35","182",NULL),
("105","woocommerce_scheduled_sales","pending","2026-02-19 01:58:21","2026-02-19 01:58:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771466301;s:18:\"\0*\0first_timestamp\";i:1771372800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771466301;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("106","wc-admin_process_pending_orders_batch","complete","2026-02-18 13:58:21","2026-02-18 13:58:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771423101;s:18:\"\0*\0first_timestamp\";i:1771327661;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771423101;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","3","1","2026-02-18 15:05:32","2026-02-18 15:05:32","418",NULL),
("107","woocommerce_refresh_order_count_cache","complete","2026-02-18 13:58:21","2026-02-18 13:58:21","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771423101;s:18:\"\0*\0first_timestamp\";i:1771372850;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771423101;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","7","1","2026-02-18 15:05:32","2026-02-18 15:05:32","418",NULL),
("108","woocommerce_cancel_unpaid_orders","complete","2026-02-18 05:08:35","2026-02-18 05:08:35","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771391315;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771391315;}","6","1","2026-02-18 06:48:44","2026-02-18 06:48:44","185",NULL),
("109","woocommerce_cleanup_logs","pending","2026-02-19 04:08:35","2026-02-19 04:08:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771474115;s:18:\"\0*\0first_timestamp\";i:1771383600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771474115;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("110","woocommerce_cleanup_rate_limits_wrapper","pending","2026-02-19 04:08:35","2026-02-19 04:08:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771474115;s:18:\"\0*\0first_timestamp\";i:1771383600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771474115;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("111","woocommerce_cancel_unpaid_orders","complete","2026-02-18 07:48:44","2026-02-18 07:48:44","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771400924;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771400924;}","6","1","2026-02-18 08:10:28","2026-02-18 08:10:28","211",NULL),
("113","woocommerce_geoip_updater","pending","2026-03-05 06:48:44","2026-03-05 06:48:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772693324;s:18:\"\0*\0first_timestamp\";i:1771394400;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772693324;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}","6","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("114","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-18 07:32:57","2026-02-18 07:32:57","10","[101,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771399977;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771399977;}","5","1","2026-02-18 07:32:58","2026-02-18 07:32:58","196",NULL),
("115","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-18 07:34:01","2026-02-18 07:34:01","10","[103,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771400041;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771400041;}","5","1","2026-02-18 07:34:01","2026-02-18 07:34:01","198",NULL),
("117","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-18 08:19:10","2026-02-18 08:19:10","10","[103,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771402750;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771402750;}","5","1","2026-02-18 08:19:12","2026-02-18 08:19:12","223",NULL),
("118","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-18 08:20:25","2026-02-18 08:20:25","10","[103,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771402825;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771402825;}","5","1","2026-02-18 08:20:49","2026-02-18 08:20:49","226",NULL),
("119","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-18 08:21:13","2026-02-18 08:21:13","10","[103,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771402873;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771402873;}","5","1","2026-02-18 08:21:25","2026-02-18 08:21:25","228",NULL),
("120","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-18 08:23:04","2026-02-18 08:23:04","10","[104,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771402984;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771402984;}","5","1","2026-02-18 08:23:40","2026-02-18 08:23:40","232",NULL),
("121","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-18 08:23:19","2026-02-18 08:23:19","10","[99,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771402999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771402999;}","5","1","2026-02-18 08:23:40","2026-02-18 08:23:40","232",NULL),
("122","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-18 08:24:36","2026-02-18 08:24:36","10","[101,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771403076;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771403076;}","5","1","2026-02-18 08:24:43","2026-02-18 08:24:43","234",NULL),
("123","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-18 08:25:11","2026-02-18 08:25:11","10","[102,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771403111;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771403111;}","5","1","2026-02-18 08:25:39","2026-02-18 08:25:39","236",NULL),
("124","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-18 08:25:51","2026-02-18 08:25:51","10","[100,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771403151;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771403151;}","5","1","2026-02-18 08:25:58","2026-02-18 08:25:58","238",NULL),
("125","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-18 08:26:19","2026-02-18 08:26:19","10","[100,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771403179;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771403179;}","5","1","2026-02-18 08:26:39","2026-02-18 08:26:39","240",NULL),
("126","woocommerce_tracker_send_event_wrapper","complete","2026-02-18 08:41:52","2026-02-18 08:41:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771404112;s:18:\"\0*\0first_timestamp\";i:1771404112;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771404112;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2026-02-18 08:42:13","2026-02-18 08:42:13","258",NULL),
("127","fetch_patterns","complete","2026-02-18 08:41:42","2026-02-18 08:41:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771404102;s:18:\"\0*\0first_timestamp\";i:1771404102;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771404102;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2026-02-18 08:41:43","2026-02-18 08:41:43","256",NULL),
("129","woocommerce_tracker_send_event_wrapper","pending","2026-02-19 08:42:13","2026-02-19 08:42:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771490533;s:18:\"\0*\0first_timestamp\";i:1771404112;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771490533;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("130","woocommerce_cancel_unpaid_orders","complete","2026-02-18 09:45:58","2026-02-18 09:45:58","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771407958;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771407958;}","6","1","2026-02-18 09:46:39","2026-02-18 09:46:39","320",NULL),
("131","woocommerce_run_product_attribute_lookup_update_callback","complete","2026-02-18 09:13:55","2026-02-18 09:13:55","10","[100,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771406035;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771406035;}","5","1","2026-02-18 09:14:40","2026-02-18 09:14:40","290",NULL),
("132","fetch_patterns","complete","2026-02-18 09:33:11","2026-02-18 09:33:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771407191;s:18:\"\0*\0first_timestamp\";i:1771407191;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771407191;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2026-02-18 09:33:55","2026-02-18 09:33:55","304",NULL),
("133","action_scheduler/migration_hook","complete","2026-02-18 09:34:11","2026-02-18 09:34:11","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771407251;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771407251;}","2","1","2026-02-18 09:34:39","2026-02-18 09:34:39","307",NULL),
("135","woocommerce_cancel_unpaid_orders","complete","2026-02-18 10:46:39","2026-02-18 10:46:39","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771411599;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771411599;}","6","1","2026-02-18 10:47:18","2026-02-18 10:47:18","372",NULL),
("137","action_scheduler/migration_hook","complete","2026-02-18 10:33:13","2026-02-18 10:33:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771410793;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771410793;}","2","1","2026-02-18 10:33:57","2026-02-18 10:33:57","362",NULL),
("138","fetch_patterns","complete","2026-02-18 10:32:20","2026-02-18 10:32:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771410740;s:18:\"\0*\0first_timestamp\";i:1771410740;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771410740;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2026-02-18 10:33:11","2026-02-18 10:33:11","360",NULL),
("140","woocommerce_cancel_unpaid_orders","complete","2026-02-18 11:47:18","2026-02-18 11:47:18","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771415238;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771415238;}","6","1","2026-02-18 13:10:36","2026-02-18 13:10:36","382",NULL),
("141","woocommerce_cancel_unpaid_orders","complete","2026-02-18 14:10:36","2026-02-18 14:10:36","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771423836;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771423836;}","6","1","2026-02-18 15:05:32","2026-02-18 15:05:32","418",NULL),
("142","woocommerce_cleanup_draft_orders","pending","2026-02-19 13:10:36","2026-02-19 13:10:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771506636;s:18:\"\0*\0first_timestamp\";i:1771327661;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771506636;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("143","wc_admin_daily_wrapper","pending","2026-02-19 13:10:37","2026-02-19 13:10:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771506637;s:18:\"\0*\0first_timestamp\";i:1771329650;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771506637;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("144","woocommerce_cleanup_personal_data","pending","2026-02-19 13:10:38","2026-02-19 13:10:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771506638;s:18:\"\0*\0first_timestamp\";i:1771329660;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771506638;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("145","woocommerce_cleanup_sessions","pending","2026-02-19 06:00:00","2026-02-19 06:00:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771480800;s:18:\"\0*\0first_timestamp\";i:1771480800;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771480800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","6","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("146","generate_category_lookup_table_wrapper","complete","2026-02-18 13:10:48","2026-02-18 13:10:48","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771420248;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771420248;}","6","1","2026-02-18 13:15:31","2026-02-18 13:15:31","384",NULL),
("147","action_scheduler_run_recurring_actions_schedule_hook","pending","2026-02-19 13:10:38","2026-02-19 13:10:38","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771506638;s:18:\"\0*\0first_timestamp\";i:1771327658;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771506638;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("148","fetch_patterns","complete","2026-02-18 13:17:36","2026-02-18 13:17:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771420656;s:18:\"\0*\0first_timestamp\";i:1771420656;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771420656;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2026-02-18 13:17:43","2026-02-18 13:17:43","388",NULL),
("149","action_scheduler/migration_hook","complete","2026-02-18 13:18:36","2026-02-18 13:18:36","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771420716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771420716;}","2","1","2026-02-18 13:18:50","2026-02-18 13:18:50","390",NULL),
("150","fetch_patterns","pending","2026-02-19 13:17:43","2026-02-19 13:17:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771507063;s:18:\"\0*\0first_timestamp\";i:1771420656;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771507063;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("152","rocket_job_warmup","complete","2026-02-18 13:19:26","2026-02-18 13:19:26","10","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2026-02-18 13:19:32","2026-02-18 13:19:32","392",NULL),
("153","rocket_insights_credit_reset","complete","2026-02-18 13:19:28","2026-02-18 13:19:28","1","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771420768;s:18:\"\0*\0first_timestamp\";i:1771420768;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771420768;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}","11","1","2026-02-18 13:19:28","2026-02-18 13:19:28","392",NULL),
("158","rocket_job_warmup_url","complete","2026-02-18 13:19:32","2026-02-18 13:19:32","10","[\"https:\\/\\/leg.miklub.fr\\/boutique\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2026-02-18 13:19:34","2026-02-18 13:19:34","393",NULL),
("159","rocket_job_warmup_url","complete","2026-02-18 13:19:32","2026-02-18 13:19:32","10","[\"https:\\/\\/leg.miklub.fr\\/mon-compte\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2026-02-18 13:19:34","2026-02-18 13:19:34","393",NULL),
("160","rocket_job_warmup_url","complete","2026-02-18 13:19:32","2026-02-18 13:19:32","10","[\"https:\\/\\/leg.miklub.fr\\/contact\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2026-02-18 13:19:34","2026-02-18 13:19:34","393",NULL),
("161","rocket_job_warmup_url","complete","2026-02-18 13:19:32","2026-02-18 13:19:32","10","[\"https:\\/\\/leg.miklub.fr\\/produit\\/cotton-light\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2026-02-18 13:19:34","2026-02-18 13:19:34","393",NULL),
("162","rocket_job_warmup_url","complete","2026-02-18 13:19:32","2026-02-18 13:19:32","10","[\"https:\\/\\/leg.miklub.fr\\/?add-to-cart=99\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2026-02-18 13:19:34","2026-02-18 13:19:34","393",NULL),
("163","rocket_job_warmup_url","complete","2026-02-18 13:19:32","2026-02-18 13:19:32","10","[\"https:\\/\\/leg.miklub.fr\\/produit\\/adapt-seamless-leggings-noir\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2026-02-18 13:19:34","2026-02-18 13:19:34","393",NULL),
("164","rocket_job_warmup_url","complete","2026-02-18 13:19:32","2026-02-18 13:19:32","10","[\"https:\\/\\/leg.miklub.fr\\/?add-to-cart=100\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2026-02-18 13:19:34","2026-02-18 13:19:34","393",NULL),
("165","rocket_job_warmup_url","complete","2026-02-18 13:19:32","2026-02-18 13:19:32","10","[\"https:\\/\\/leg.miklub.fr\\/produit\\/green-dress\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2026-02-18 13:19:34","2026-02-18 13:19:34","393",NULL),
("166","rocket_job_warmup_url","complete","2026-02-18 13:19:32","2026-02-18 13:19:32","10","[\"https:\\/\\/leg.miklub.fr\\/?add-to-cart=101\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2026-02-18 13:19:34","2026-02-18 13:19:34","393",NULL),
("167","rocket_job_warmup_url","complete","2026-02-18 13:19:32","2026-02-18 13:19:32","10","[\"https:\\/\\/leg.miklub.fr\\/produit\\/floral-spring\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2026-02-18 13:19:34","2026-02-18 13:19:34","393",NULL),
("213","wc-admin_process_pending_orders_batch","pending","2026-02-19 03:05:32","2026-02-19 03:05:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771470332;s:18:\"\0*\0first_timestamp\";i:1771327661;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771470332;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","3","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("214","woocommerce_refresh_order_count_cache","pending","2026-02-19 03:05:32","2026-02-19 03:05:32","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771470332;s:18:\"\0*\0first_timestamp\";i:1771372850;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771470332;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","7","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("215","woocommerce_cancel_unpaid_orders","pending","2026-02-18 16:05:32","2026-02-18 16:05:32","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771430732;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771430732;}","6","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("216","rocket_preload_job_check_finished","pending","2026-02-18 15:12:53","2026-02-18 15:12:53","10","[1771427513]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771427573;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771427573;}","9","0","2026-02-18 15:13:43","2026-02-18 15:13:43","433",NULL),
("217","rocket_preload_job_preload_url","complete","2026-02-18 15:12:00","2026-02-18 15:12:00","10","[\"https:\\/\\/leg.miklub.fr\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-02-18 15:12:06","2026-02-18 15:12:06","428",NULL),
("218","rocket_preload_job_preload_url","complete","2026-02-18 15:12:00","2026-02-18 15:12:00","10","[\"https:\\/\\/leg.miklub.fr\\/dress-up-your-pet-day\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-02-18 15:12:09","2026-02-18 15:12:09","428",NULL),
("219","rocket_preload_job_preload_url","complete","2026-02-18 15:12:00","2026-02-18 15:12:00","10","[\"https:\\/\\/leg.miklub.fr\\/startup-goodlord-appoints-love-film\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-02-18 15:12:12","2026-02-18 15:12:12","428",NULL),
("220","rocket_preload_job_preload_url","complete","2026-02-18 15:12:00","2026-02-18 15:12:00","10","[\"https:\\/\\/leg.miklub.fr\\/british-designer-creates-a-full-sized-designer\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-02-18 15:12:15","2026-02-18 15:12:15","428",NULL),
("221","rocket_preload_job_preload_url","complete","2026-02-18 15:12:00","2026-02-18 15:12:00","10","[\"https:\\/\\/leg.miklub.fr\\/samuel-life-in-other-word\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-02-18 15:12:18","2026-02-18 15:12:18","428",NULL),
("222","rocket_preload_job_preload_url","complete","2026-02-18 15:12:32","2026-02-18 15:12:32","10","[\"https:\\/\\/leg.miklub.fr\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-02-18 15:13:00","2026-02-18 15:13:00","431",NULL),
("223","rocket_preload_job_preload_url","complete","2026-02-18 15:12:32","2026-02-18 15:12:32","10","[\"https:\\/\\/leg.miklub.fr\\/dress-up-your-pet-day\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-02-18 15:13:03","2026-02-18 15:13:03","431",NULL),
("224","rocket_preload_job_preload_url","complete","2026-02-18 15:12:32","2026-02-18 15:12:32","10","[\"https:\\/\\/leg.miklub.fr\\/startup-goodlord-appoints-love-film\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-02-18 15:13:03","2026-02-18 15:13:03","431",NULL),
("225","rocket_preload_job_preload_url","complete","2026-02-18 15:12:32","2026-02-18 15:12:32","10","[\"https:\\/\\/leg.miklub.fr\\/british-designer-creates-a-full-sized-designer\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-02-18 15:13:03","2026-02-18 15:13:03","431",NULL),
("226","rocket_preload_job_preload_url","complete","2026-02-18 15:12:32","2026-02-18 15:12:32","10","[\"https:\\/\\/leg.miklub.fr\\/samuel-life-in-other-word\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-02-18 15:13:03","2026-02-18 15:13:03","431",NULL),
("227","rocket_preload_job_preload_url","complete","2026-02-18 15:12:32","2026-02-18 15:12:32","10","[\"https:\\/\\/leg.miklub.fr\\/liste-de-souhaits\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-02-18 15:13:06","2026-02-18 15:13:06","431",NULL),
("228","rocket_preload_job_preload_url","complete","2026-02-18 15:12:32","2026-02-18 15:12:32","10","[\"https:\\/\\/leg.miklub.fr\\/contact\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-02-18 15:13:10","2026-02-18 15:13:10","431",NULL),
("229","rocket_preload_job_preload_url","complete","2026-02-18 15:12:32","2026-02-18 15:12:32","10","[\"https:\\/\\/leg.miklub.fr\\/politique-dexpedition\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-02-18 15:13:13","2026-02-18 15:13:13","431",NULL),
("230","rocket_preload_job_preload_url","complete","2026-02-18 15:12:32","2026-02-18 15:12:32","10","[\"https:\\/\\/leg.miklub.fr\\/wishlist-2\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-02-18 15:13:16","2026-02-18 15:13:16","431",NULL),
("231","rocket_preload_job_preload_url","complete","2026-02-18 15:12:32","2026-02-18 15:12:32","10","[\"https:\\/\\/leg.miklub.fr\\/boutique\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-02-18 15:13:19","2026-02-18 15:13:19","431",NULL),
("232","rocket_preload_job_preload_url","complete","2026-02-18 15:12:32","2026-02-18 15:12:32","10","[\"https:\\/\\/leg.miklub.fr\\/politique-de-confidentialite\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-02-18 15:13:22","2026-02-18 15:13:22","431",NULL),
("233","rocket_preload_job_preload_url","complete","2026-02-18 15:12:32","2026-02-18 15:12:32","10","[\"https:\\/\\/leg.miklub.fr\\/conditions-generales-dutilisation\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-02-18 15:13:46","2026-02-18 15:13:46","433",NULL),
("234","rocket_preload_job_preload_url","complete","2026-02-18 15:12:32","2026-02-18 15:12:32","10","[\"https:\\/\\/leg.miklub.fr\\/produit\\/cotton-light\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-02-18 15:13:49","2026-02-18 15:13:49","433",NULL),
("235","rocket_preload_job_preload_url","complete","2026-02-18 15:12:32","2026-02-18 15:12:32","10","[\"https:\\/\\/leg.miklub.fr\\/produit\\/adapt-seamless-leggings-noir\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-02-18 15:13:52","2026-02-18 15:13:52","433",NULL),
("236","rocket_preload_job_preload_url","complete","2026-02-18 15:12:32","2026-02-18 15:12:32","10","[\"https:\\/\\/leg.miklub.fr\\/produit\\/green-dress\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-02-18 15:13:55","2026-02-18 15:13:55","433",NULL),
("237","rocket_preload_job_preload_url","complete","2026-02-18 15:12:32","2026-02-18 15:12:32","10","[\"https:\\/\\/leg.miklub.fr\\/produit\\/floral-spring\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-02-18 15:13:58","2026-02-18 15:13:58","433",NULL),
("238","rocket_preload_job_preload_url","complete","2026-02-18 15:12:32","2026-02-18 15:12:32","10","[\"https:\\/\\/leg.miklub.fr\\/produit\\/summer-outfit\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-02-18 15:14:01","2026-02-18 15:14:01","433",NULL),
("239","rocket_preload_job_preload_url","in-progress","2026-02-18 15:12:33","2026-02-18 15:12:33","10","[\"https:\\/\\/leg.miklub.fr\\/produit\\/purple-cotton\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-02-18 15:14:01","2026-02-18 15:14:01","433",NULL),
("240","rocket_preload_job_preload_url","pending","2026-02-18 15:12:33","2026-02-18 15:12:33","10","[\"https:\\/\\/leg.miklub.fr\\/category\\/uncategorized\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","0","2026-02-18 15:13:43","2026-02-18 15:13:43","433",NULL),
("241","rocket_preload_job_preload_url","pending","2026-02-18 15:12:33","2026-02-18 15:12:33","10","[\"https:\\/\\/leg.miklub.fr\\/category\\/bags\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","0","2026-02-18 15:13:43","2026-02-18 15:13:43","433",NULL),
("242","rocket_preload_job_preload_url","pending","2026-02-18 15:12:33","2026-02-18 15:12:33","10","[\"https:\\/\\/leg.miklub.fr\\/category\\/blazers\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","0","2026-02-18 15:13:43","2026-02-18 15:13:43","433",NULL),
("243","rocket_preload_job_preload_url","pending","2026-02-18 15:12:33","2026-02-18 15:12:33","10","[\"https:\\/\\/leg.miklub.fr\\/category\\/boots\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","0","2026-02-18 15:13:43","2026-02-18 15:13:43","433",NULL),
("244","rocket_preload_job_preload_url","pending","2026-02-18 15:12:33","2026-02-18 15:12:33","10","[\"https:\\/\\/leg.miklub.fr\\/tag\\/mountain\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","0","2026-02-18 15:13:43","2026-02-18 15:13:43","433",NULL),
("245","rocket_preload_job_preload_url","pending","2026-02-18 15:12:33","2026-02-18 15:12:33","10","[\"https:\\/\\/leg.miklub.fr\\/tag\\/outdoor\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","0","2026-02-18 15:13:43","2026-02-18 15:13:43","433",NULL),
("246","rocket_preload_job_preload_url","pending","2026-02-18 15:12:33","2026-02-18 15:12:33","10","[\"https:\\/\\/leg.miklub.fr\\/tag\\/tour\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","0","2026-02-18 15:13:43","2026-02-18 15:13:43","433",NULL),
("247","rocket_preload_job_preload_url","pending","2026-02-18 15:12:33","2026-02-18 15:12:33","10","[\"https:\\/\\/leg.miklub.fr\\/product-category\\/empower-seamless-leggings\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","0","2026-02-18 15:13:43","2026-02-18 15:13:43","433",NULL),
("248","rocket_preload_job_preload_url","pending","2026-02-18 15:12:33","2026-02-18 15:12:33","10","[\"https:\\/\\/leg.miklub.fr\\/product-category\\/adapt-seamless-leggings\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","0","2026-02-18 15:13:43","2026-02-18 15:13:43","433",NULL),
("249","rocket_preload_job_preload_url","pending","2026-02-18 15:12:33","2026-02-18 15:12:33","10","[\"https:\\/\\/leg.miklub.fr\\/product-tag\\/rouge-wine\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","0","2026-02-18 15:13:43","2026-02-18 15:13:43","433",NULL),
("250","rocket_preload_job_preload_url","pending","2026-02-18 15:12:33","2026-02-18 15:12:33","10","[\"https:\\/\\/leg.miklub.fr\\/product-tag\\/staple-leggings\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","0","2026-02-18 15:13:43","2026-02-18 15:13:43","433",NULL),
("251","rocket_preload_job_preload_url","pending","2026-02-18 15:12:33","2026-02-18 15:12:33","10","[\"https:\\/\\/leg.miklub.fr\\/product-tag\\/adapt-seamless-leggings\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","0","2026-02-18 15:13:43","2026-02-18 15:13:43","433",NULL),
("252","rocket_preload_job_preload_url","pending","2026-02-18 15:12:33","2026-02-18 15:12:33","10","[\"https:\\/\\/leg.miklub.fr\\/product-tag\\/deep-navy\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","0","2026-02-18 15:13:43","2026-02-18 15:13:43","433",NULL),
("253","rocket_preload_job_preload_url","pending","2026-02-18 15:12:33","2026-02-18 15:12:33","10","[\"https:\\/\\/leg.miklub.fr\\/product-tag\\/cocoa-marron\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","0","2026-02-18 15:13:43","2026-02-18 15:13:43","433",NULL),
("254","rocket_preload_job_preload_url","pending","2026-02-18 15:12:33","2026-02-18 15:12:33","10","[\"https:\\/\\/leg.miklub.fr\\/product-tag\\/empower-seamless-leggings\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","0","2026-02-18 15:13:43","2026-02-18 15:13:43","433",NULL),
("255","rocket_preload_job_preload_url","pending","2026-02-18 15:12:33","2026-02-18 15:12:33","10","[\"https:\\/\\/leg.miklub.fr\\/product-tag\\/dark-vert\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","0","2026-02-18 15:13:43","2026-02-18 15:13:43","433",NULL),
("256","rocket_preload_job_preload_url","pending","2026-02-18 15:12:33","2026-02-18 15:12:33","10","[\"https:\\/\\/leg.miklub.fr\\/author\\/admin\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","0","2026-02-18 15:13:43","2026-02-18 15:13:43","433",NULL);

INSERT IGNORE INTO `wp_actionscheduler_claims` VALUES 
("395","2026-02-18 13:19:34"),
("433","2026-02-18 15:13:43");

INSERT IGNORE INTO `wp_actionscheduler_groups` VALUES 
("1","ActionScheduler"),
("2","action-scheduler-migration"),
("3","wc-admin-data"),
("4",""),
("5","woocommerce-db-updates"),
("6","woocommerce"),
("7","count"),
("8","wc_update_product_default_cat"),
("9","rocket-preload"),
("10","rocket-performance-hints-warmup"),
("11","rocket-insights"),
("12","rocket-rucss");

INSERT IGNORE INTO `wp_actionscheduler_logs` VALUES 
("1","11","action created","2026-02-17 11:27:38","2026-02-17 11:27:38"),
("2","12","action created","2026-02-17 11:27:41","2026-02-17 11:27:41"),
("3","13","action created","2026-02-17 11:27:41","2026-02-17 11:27:41"),
("4","14","action created","2026-02-17 11:27:41","2026-02-17 11:27:41"),
("5","15","action créée","2026-02-17 11:36:48","2026-02-17 11:36:48"),
("6","16","action créée","2026-02-17 11:36:50","2026-02-17 11:36:50"),
("7","17","action créée","2026-02-17 11:36:52","2026-02-17 11:36:52"),
("8","18","action créée","2026-02-17 11:36:54","2026-02-17 11:36:54"),
("9","19","action créée","2026-02-17 11:36:57","2026-02-17 11:36:57"),
("10","20","action créée","2026-02-17 11:36:59","2026-02-17 11:36:59"),
("11","21","action créée","2026-02-17 11:37:02","2026-02-17 11:37:02"),
("12","22","action créée","2026-02-17 11:37:05","2026-02-17 11:37:05"),
("13","23","action créée","2026-02-17 11:37:08","2026-02-17 11:37:08"),
("14","24","action créée","2026-02-17 11:37:10","2026-02-17 11:37:10"),
("15","13","action commencée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("16","13","action terminée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("17","25","action créée","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("18","14","action commencée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("19","14","action terminée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("20","26","action créée","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("21","12","action commencée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("22","12","action terminée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("23","15","action commencée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("24","15","échec de l’action via Async Request : L’action planifiée pour woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications ne sera pas exécutée car aucun rappel n’est enregistré.","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("25","16","action commencée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("26","16","action terminée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("27","17","action commencée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("28","17","action terminée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("29","18","action commencée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("30","18","action terminée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("31","19","action commencée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("32","19","action terminée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("33","20","action commencée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("34","20","action terminée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("35","21","action commencée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("36","21","action terminée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("37","22","action commencée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("38","22","action terminée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("39","23","action commencée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("40","23","action terminée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("41","24","action commencée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("42","24","action terminée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("43","11","action commencée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("44","27","action créée","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("45","28","action créée","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("46","29","action créée","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("47","30","action créée","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("48","31","action créée","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("49","32","action créée","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("50","33","action créée","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("51","34","action créée","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("52","35","action créée","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("53","36","action créée","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("54","11","action terminée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("55","37","action créée","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("56","34","action commencée via Async Request","2026-02-17 12:00:50","2026-02-17 12:00:50"),
("57","34","action terminée via Async Request","2026-02-17 12:00:51","2026-02-17 12:00:51"),
("58","38","action créée","2026-02-17 12:00:51","2026-02-17 12:00:51"),
("59","29","action commencée via Async Request","2026-02-17 12:01:53","2026-02-17 12:01:53"),
("60","29","action terminée via Async Request","2026-02-17 12:01:54","2026-02-17 12:01:54"),
("61","39","action créée","2026-02-17 12:01:54","2026-02-17 12:01:54"),
("62","35","action commencée via Async Request","2026-02-17 12:01:54","2026-02-17 12:01:54"),
("63","35","action terminée via Async Request","2026-02-17 12:01:54","2026-02-17 12:01:54"),
("64","28","action commencée via WP Cron","2026-02-17 13:01:40","2026-02-17 13:01:40"),
("65","40","action créée","2026-02-17 13:01:40","2026-02-17 13:01:40"),
("66","28","action terminée via WP Cron","2026-02-17 13:01:40","2026-02-17 13:01:40"),
("67","41","action créée","2026-02-17 13:20:37","2026-02-17 13:20:37"),
("68","41","action commencée via WP Cron","2026-02-17 13:20:39","2026-02-17 13:20:39"),
("69","41","action terminée via WP Cron","2026-02-17 13:20:39","2026-02-17 13:20:39"),
("70","42","action créée","2026-02-17 13:24:19","2026-02-17 13:24:19"),
("71","42","action commencée via WP Cron","2026-02-17 13:24:45","2026-02-17 13:24:45"),
("72","42","action terminée via WP Cron","2026-02-17 13:24:45","2026-02-17 13:24:45"),
("73","43","action créée","2026-02-17 13:24:47","2026-02-17 13:24:47"),
("74","43","action commencée via Async Request","2026-02-17 13:25:22","2026-02-17 13:25:22"),
("75","43","action terminée via Async Request","2026-02-17 13:25:22","2026-02-17 13:25:22"),
("76","44","action créée","2026-02-17 13:34:11","2026-02-17 13:34:11"),
("77","44","action commencée via Async Request","2026-02-17 13:34:57","2026-02-17 13:34:57"),
("78","44","action terminée via Async Request","2026-02-17 13:34:57","2026-02-17 13:34:57"),
("79","45","action créée","2026-02-17 13:36:07","2026-02-17 13:36:07"),
("80","45","action commencée via WP Cron","2026-02-17 13:36:41","2026-02-17 13:36:41"),
("81","45","action terminée via WP Cron","2026-02-17 13:36:41","2026-02-17 13:36:41"),
("82","46","action créée","2026-02-17 13:38:54","2026-02-17 13:38:54"),
("83","47","action créée","2026-02-17 13:38:54","2026-02-17 13:38:54"),
("84","48","action créée","2026-02-17 13:38:54","2026-02-17 13:38:54"),
("85","49","action créée","2026-02-17 13:38:54","2026-02-17 13:38:54"),
("86","46","action commencée via Async Request","2026-02-17 13:39:29","2026-02-17 13:39:29"),
("87","46","action terminée via Async Request","2026-02-17 13:39:29","2026-02-17 13:39:29"),
("88","47","action commencée via Async Request","2026-02-17 13:39:29","2026-02-17 13:39:29"),
("89","47","action terminée via Async Request","2026-02-17 13:39:29","2026-02-17 13:39:29"),
("90","48","action commencée via Async Request","2026-02-17 13:39:29","2026-02-17 13:39:29"),
("91","48","action terminée via Async Request","2026-02-17 13:39:29","2026-02-17 13:39:29"),
("92","49","action commencée via Async Request","2026-02-17 13:39:29","2026-02-17 13:39:29"),
("93","49","action terminée via Async Request","2026-02-17 13:39:29","2026-02-17 13:39:29"),
("94","50","action créée","2026-02-17 13:39:42","2026-02-17 13:39:42"),
("95","50","action commencée via WP Cron","2026-02-17 13:39:43","2026-02-17 13:39:43"),
("96","50","action terminée via WP Cron","2026-02-17 13:39:43","2026-02-17 13:39:43"),
("97","51","action créée","2026-02-17 13:40:01","2026-02-17 13:40:01"),
("98","51","action commencée via Async Request","2026-02-17 13:40:42","2026-02-17 13:40:42"),
("99","51","action terminée via Async Request","2026-02-17 13:40:42","2026-02-17 13:40:42"),
("100","52","action créée","2026-02-17 13:42:53","2026-02-17 13:42:53"),
("101","52","action commencée via Async Request","2026-02-17 13:43:02","2026-02-17 13:43:02"),
("102","52","action terminée via Async Request","2026-02-17 13:43:02","2026-02-17 13:43:02"),
("103","53","action créée","2026-02-17 13:43:34","2026-02-17 13:43:34"),
("104","54","action créée","2026-02-17 13:43:34","2026-02-17 13:43:34"),
("105","55","action créée","2026-02-17 13:43:34","2026-02-17 13:43:34"),
("106","56","action créée","2026-02-17 13:43:34","2026-02-17 13:43:34"),
("107","53","action commencée via WP Cron","2026-02-17 13:43:43","2026-02-17 13:43:43"),
("108","53","action terminée via WP Cron","2026-02-17 13:43:43","2026-02-17 13:43:43"),
("109","54","action commencée via WP Cron","2026-02-17 13:43:43","2026-02-17 13:43:43"),
("110","54","action terminée via WP Cron","2026-02-17 13:43:43","2026-02-17 13:43:43"),
("111","55","action commencée via WP Cron","2026-02-17 13:43:43","2026-02-17 13:43:43"),
("112","55","action terminée via WP Cron","2026-02-17 13:43:43","2026-02-17 13:43:43"),
("113","56","action commencée via WP Cron","2026-02-17 13:43:43","2026-02-17 13:43:43"),
("114","56","action terminée via WP Cron","2026-02-17 13:43:43","2026-02-17 13:43:43"),
("115","57","action créée","2026-02-17 13:45:23","2026-02-17 13:45:23"),
("116","57","action commencée via Async Request","2026-02-17 13:45:26","2026-02-17 13:45:26"),
("117","57","action terminée via Async Request","2026-02-17 13:45:26","2026-02-17 13:45:26"),
("118","58","action créée","2026-02-17 13:45:56","2026-02-17 13:45:56"),
("119","58","action commencée via WP Cron","2026-02-17 13:46:42","2026-02-17 13:46:42"),
("120","58","action terminée via WP Cron","2026-02-17 13:46:42","2026-02-17 13:46:42"),
("121","59","action créée","2026-02-17 13:48:42","2026-02-17 13:48:42"),
("122","60","action créée","2026-02-17 13:48:42","2026-02-17 13:48:42"),
("123","61","action créée","2026-02-17 13:48:43","2026-02-17 13:48:43"),
("124","62","action créée","2026-02-17 13:48:43","2026-02-17 13:48:43"),
("125","59","action commencée via WP Cron","2026-02-17 13:48:43","2026-02-17 13:48:43"),
("126","59","action terminée via WP Cron","2026-02-17 13:48:43","2026-02-17 13:48:43"),
("127","60","action commencée via WP Cron","2026-02-17 13:48:43","2026-02-17 13:48:43"),
("128","60","action terminée via WP Cron","2026-02-17 13:48:43","2026-02-17 13:48:43"),
("129","61","action commencée via Async Request","2026-02-17 13:48:56","2026-02-17 13:48:56"),
("130","61","action terminée via Async Request","2026-02-17 13:48:56","2026-02-17 13:48:56"),
("131","62","action commencée via Async Request","2026-02-17 13:48:56","2026-02-17 13:48:56"),
("132","62","action terminée via Async Request","2026-02-17 13:48:56","2026-02-17 13:48:56"),
("133","63","action créée","2026-02-17 13:49:11","2026-02-17 13:49:11"),
("134","64","action créée","2026-02-17 13:49:11","2026-02-17 13:49:11"),
("135","65","action créée","2026-02-17 13:49:11","2026-02-17 13:49:11"),
("136","66","action créée","2026-02-17 13:49:11","2026-02-17 13:49:11"),
("137","67","action créée","2026-02-17 13:49:11","2026-02-17 13:49:11"),
("138","68","action créée","2026-02-17 13:49:11","2026-02-17 13:49:11"),
("139","63","action commencée via WP Cron","2026-02-17 13:49:46","2026-02-17 13:49:46"),
("140","63","action terminée via WP Cron","2026-02-17 13:49:46","2026-02-17 13:49:46"),
("141","64","action commencée via WP Cron","2026-02-17 13:49:46","2026-02-17 13:49:46"),
("142","64","action terminée via WP Cron","2026-02-17 13:49:46","2026-02-17 13:49:46"),
("143","65","action commencée via WP Cron","2026-02-17 13:49:46","2026-02-17 13:49:46"),
("144","65","action terminée via WP Cron","2026-02-17 13:49:46","2026-02-17 13:49:46"),
("145","66","action commencée via WP Cron","2026-02-17 13:49:46","2026-02-17 13:49:46"),
("146","66","action terminée via WP Cron","2026-02-17 13:49:46","2026-02-17 13:49:46"),
("147","67","action commencée via WP Cron","2026-02-17 13:49:46","2026-02-17 13:49:46"),
("148","67","action terminée via WP Cron","2026-02-17 13:49:46","2026-02-17 13:49:46"),
("149","68","action commencée via WP Cron","2026-02-17 13:49:46","2026-02-17 13:49:46"),
("150","68","action terminée via WP Cron","2026-02-17 13:49:46","2026-02-17 13:49:46"),
("151","69","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("152","70","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("153","71","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("154","72","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("155","73","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("156","74","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("157","75","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("158","76","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("159","77","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("160","78","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("161","79","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("162","80","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("163","81","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("164","82","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("165","83","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("166","84","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("167","85","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("168","86","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("169","87","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("170","88","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("171","89","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("172","90","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("173","91","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("174","92","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("175","93","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("176","94","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("177","95","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("178","96","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("179","97","action créée","2026-02-17 13:50:41","2026-02-17 13:50:41"),
("180","98","action créée","2026-02-17 13:50:42","2026-02-17 13:50:42"),
("181","99","action créée","2026-02-17 13:50:42","2026-02-17 13:50:42"),
("182","69","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("183","69","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("184","70","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("185","70","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("186","71","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("187","71","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("188","72","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("189","72","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("190","73","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("191","73","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("192","74","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("193","74","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("194","75","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("195","75","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("196","76","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("197","76","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("198","77","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("199","77","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("200","78","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("201","78","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("202","79","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("203","79","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("204","80","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("205","80","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("206","81","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("207","81","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("208","82","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("209","82","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("210","83","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("211","83","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("212","84","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("213","84","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("214","85","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("215","85","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("216","86","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("217","86","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("218","87","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("219","87","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("220","88","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("221","88","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("222","89","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("223","89","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("224","90","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("225","90","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("226","91","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("227","91","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("228","92","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("229","92","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("230","93","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("231","93","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("232","94","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("233","94","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("234","95","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("235","95","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("236","96","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("237","96","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("238","97","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("239","97","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("240","98","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("241","98","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("242","99","action commencée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("243","99","action terminée via Async Request","2026-02-17 13:51:06","2026-02-17 13:51:06"),
("244","100","action créée","2026-02-17 13:51:58","2026-02-17 13:51:58"),
("245","100","action commencée via Async Request","2026-02-17 13:52:09","2026-02-17 13:52:09"),
("246","100","action terminée via Async Request","2026-02-17 13:52:09","2026-02-17 13:52:09"),
("247","40","action commencée via WP Cron","2026-02-17 14:07:01","2026-02-17 14:07:01"),
("248","101","action créée","2026-02-17 14:07:01","2026-02-17 14:07:01"),
("249","40","action terminée via WP Cron","2026-02-17 14:07:01","2026-02-17 14:07:01"),
("250","101","action commencée via WP Cron","2026-02-17 15:36:13","2026-02-17 15:36:13"),
("251","102","action créée","2026-02-17 15:36:13","2026-02-17 15:36:13"),
("252","101","action terminée via WP Cron","2026-02-17 15:36:13","2026-02-17 15:36:13"),
("253","102","action commencée via WP Cron","2026-02-17 22:22:37","2026-02-17 22:22:37"),
("254","103","action créée","2026-02-17 22:22:37","2026-02-17 22:22:37"),
("255","102","action terminée via WP Cron","2026-02-17 22:22:37","2026-02-17 22:22:37"),
("256","103","action commencée via WP Cron","2026-02-18 01:58:21","2026-02-18 01:58:21"),
("257","104","action créée","2026-02-18 01:58:21","2026-02-18 01:58:21"),
("258","103","action terminée via WP Cron","2026-02-18 01:58:21","2026-02-18 01:58:21"),
("259","27","action commencée via WP Cron","2026-02-18 01:58:21","2026-02-18 01:58:21"),
("260","27","action terminée via WP Cron","2026-02-18 01:58:21","2026-02-18 01:58:21"),
("261","105","action créée","2026-02-18 01:58:21","2026-02-18 01:58:21"),
("262","25","action commencée via WP Cron","2026-02-18 01:58:21","2026-02-18 01:58:21"),
("263","25","action terminée via WP Cron","2026-02-18 01:58:21","2026-02-18 01:58:21"),
("264","106","action créée","2026-02-18 01:58:21","2026-02-18 01:58:21"),
("265","36","action commencée via WP Cron","2026-02-18 01:58:21","2026-02-18 01:58:21"),
("266","36","action terminée via WP Cron","2026-02-18 01:58:21","2026-02-18 01:58:21"),
("267","107","action créée","2026-02-18 01:58:21","2026-02-18 01:58:21"),
("268","104","action commencée via WP Cron","2026-02-18 04:08:35","2026-02-18 04:08:35"),
("269","108","action créée","2026-02-18 04:08:35","2026-02-18 04:08:35"),
("270","104","action terminée via WP Cron","2026-02-18 04:08:35","2026-02-18 04:08:35"),
("271","30","action commencée via WP Cron","2026-02-18 04:08:35","2026-02-18 04:08:35"),
("272","30","action terminée via WP Cron","2026-02-18 04:08:35","2026-02-18 04:08:35"),
("273","109","action créée","2026-02-18 04:08:35","2026-02-18 04:08:35"),
("274","33","action commencée via WP Cron","2026-02-18 04:08:35","2026-02-18 04:08:35"),
("275","33","action terminée via WP Cron","2026-02-18 04:08:35","2026-02-18 04:08:35"),
("276","110","action créée","2026-02-18 04:08:35","2026-02-18 04:08:35"),
("277","108","action commencée via WP Cron","2026-02-18 06:48:44","2026-02-18 06:48:44"),
("278","111","action créée","2026-02-18 06:48:44","2026-02-18 06:48:44"),
("279","108","action terminée via WP Cron","2026-02-18 06:48:44","2026-02-18 06:48:44"),
("280","31","action commencée via WP Cron","2026-02-18 06:48:44","2026-02-18 06:48:44"),
("281","31","action terminée via WP Cron","2026-02-18 06:48:44","2026-02-18 06:48:44"),
("283","32","action commencée via WP Cron","2026-02-18 06:48:44","2026-02-18 06:48:44"),
("284","32","action terminée via WP Cron","2026-02-18 06:48:44","2026-02-18 06:48:44"),
("285","113","action créée","2026-02-18 06:48:44","2026-02-18 06:48:44"),
("286","114","action créée","2026-02-18 07:32:57","2026-02-18 07:32:57"),
("287","114","action commencée via WP Cron","2026-02-18 07:32:58","2026-02-18 07:32:58"),
("288","114","action terminée via WP Cron","2026-02-18 07:32:58","2026-02-18 07:32:58"),
("289","115","action créée","2026-02-18 07:34:00","2026-02-18 07:34:00"),
("290","115","action commencée via WP Cron","2026-02-18 07:34:01","2026-02-18 07:34:01"),
("291","115","action terminée via WP Cron","2026-02-18 07:34:01","2026-02-18 07:34:01"),
("292","111","action commencée via Async Request","2026-02-18 08:10:28","2026-02-18 08:10:28"),
("294","111","action terminée via Async Request","2026-02-18 08:10:28","2026-02-18 08:10:28"),
("295","117","action créée","2026-02-18 08:19:09","2026-02-18 08:19:09"),
("296","117","action commencée via Async Request","2026-02-18 08:19:12","2026-02-18 08:19:12"),
("297","117","action terminée via Async Request","2026-02-18 08:19:12","2026-02-18 08:19:12"),
("298","118","action créée","2026-02-18 08:20:25","2026-02-18 08:20:25"),
("299","118","action commencée via WP Cron","2026-02-18 08:20:49","2026-02-18 08:20:49"),
("300","118","action terminée via WP Cron","2026-02-18 08:20:49","2026-02-18 08:20:49"),
("301","119","action créée","2026-02-18 08:21:12","2026-02-18 08:21:12"),
("302","119","action commencée via Async Request","2026-02-18 08:21:25","2026-02-18 08:21:25"),
("303","119","action terminée via Async Request","2026-02-18 08:21:25","2026-02-18 08:21:25"),
("304","120","action créée","2026-02-18 08:23:03","2026-02-18 08:23:03"),
("305","121","action créée","2026-02-18 08:23:18","2026-02-18 08:23:18"),
("306","120","action commencée via WP Cron","2026-02-18 08:23:40","2026-02-18 08:23:40"),
("307","120","action terminée via WP Cron","2026-02-18 08:23:40","2026-02-18 08:23:40"),
("308","121","action commencée via WP Cron","2026-02-18 08:23:40","2026-02-18 08:23:40"),
("309","121","action terminée via WP Cron","2026-02-18 08:23:40","2026-02-18 08:23:40"),
("310","122","action créée","2026-02-18 08:24:35","2026-02-18 08:24:35"),
("311","122","action commencée via WP Cron","2026-02-18 08:24:43","2026-02-18 08:24:43"),
("312","122","action terminée via WP Cron","2026-02-18 08:24:43","2026-02-18 08:24:43"),
("313","123","action créée","2026-02-18 08:25:10","2026-02-18 08:25:10"),
("314","123","action commencée via WP Cron","2026-02-18 08:25:39","2026-02-18 08:25:39"),
("315","123","action terminée via WP Cron","2026-02-18 08:25:39","2026-02-18 08:25:39"),
("316","124","action créée","2026-02-18 08:25:50","2026-02-18 08:25:50"),
("317","124","action commencée via Async Request","2026-02-18 08:25:58","2026-02-18 08:25:58"),
("318","124","action terminée via Async Request","2026-02-18 08:25:58","2026-02-18 08:25:58"),
("319","125","action créée","2026-02-18 08:26:18","2026-02-18 08:26:18"),
("320","125","action commencée via WP Cron","2026-02-18 08:26:39","2026-02-18 08:26:39"),
("321","125","action terminée via WP Cron","2026-02-18 08:26:39","2026-02-18 08:26:39"),
("322","126","action créée","2026-02-18 08:41:42","2026-02-18 08:41:42"),
("323","127","action créée","2026-02-18 08:41:42","2026-02-18 08:41:42"),
("324","127","action commencée via WP Cron","2026-02-18 08:41:43","2026-02-18 08:41:43"),
("325","127","action terminée via WP Cron","2026-02-18 08:41:43","2026-02-18 08:41:43"),
("327","126","action commencée via Async Request","2026-02-18 08:42:13","2026-02-18 08:42:13"),
("328","126","action terminée via Async Request","2026-02-18 08:42:13","2026-02-18 08:42:13"),
("329","129","action créée","2026-02-18 08:42:13","2026-02-18 08:42:13"),
("331","130","action créée","2026-02-18 08:45:58","2026-02-18 08:45:58"),
("332","131","action créée","2026-02-18 09:13:54","2026-02-18 09:13:54"),
("333","131","action commencée via WP Cron","2026-02-18 09:14:40","2026-02-18 09:14:40"),
("334","131","action terminée via WP Cron","2026-02-18 09:14:40","2026-02-18 09:14:40"),
("336","132","action créée","2026-02-18 09:33:11","2026-02-18 09:33:11"),
("337","133","action créée","2026-02-18 09:33:11","2026-02-18 09:33:11"),
("338","132","action commencée via Async Request","2026-02-18 09:33:54","2026-02-18 09:33:54"),
("339","132","action terminée via Async Request","2026-02-18 09:33:55","2026-02-18 09:33:55"),
("341","133","action commencée via WP Cron","2026-02-18 09:34:39","2026-02-18 09:34:39"),
("342","133","action terminée via WP Cron","2026-02-18 09:34:39","2026-02-18 09:34:39"),
("343","130","action commencée via WP Cron","2026-02-18 09:46:39","2026-02-18 09:46:39"),
("344","135","action créée","2026-02-18 09:46:39","2026-02-18 09:46:39"),
("345","130","action terminée via WP Cron","2026-02-18 09:46:39","2026-02-18 09:46:39"),
("348","137","action créée","2026-02-18 10:32:13","2026-02-18 10:32:13"),
("350","138","action créée","2026-02-18 10:32:20","2026-02-18 10:32:20"),
("351","138","action commencée via WP Cron","2026-02-18 10:33:10","2026-02-18 10:33:10"),
("352","138","action terminée via WP Cron","2026-02-18 10:33:11","2026-02-18 10:33:11"),
("354","137","action commencée via Async Request","2026-02-18 10:33:57","2026-02-18 10:33:57"),
("355","137","action terminée via Async Request","2026-02-18 10:33:57","2026-02-18 10:33:57"),
("356","135","action commencée via Async Request","2026-02-18 10:47:18","2026-02-18 10:47:18"),
("357","140","action créée","2026-02-18 10:47:18","2026-02-18 10:47:18"),
("358","135","action terminée via Async Request","2026-02-18 10:47:18","2026-02-18 10:47:18"),
("359","140","action commencée via WP Cron","2026-02-18 13:10:36","2026-02-18 13:10:36"),
("360","141","action créée","2026-02-18 13:10:36","2026-02-18 13:10:36"),
("361","140","action terminée via WP Cron","2026-02-18 13:10:36","2026-02-18 13:10:36"),
("362","26","action commencée via WP Cron","2026-02-18 13:10:36","2026-02-18 13:10:36"),
("363","26","action terminée via WP Cron","2026-02-18 13:10:36","2026-02-18 13:10:36"),
("364","142","action créée","2026-02-18 13:10:36","2026-02-18 13:10:36"),
("365","38","action commencée via WP Cron","2026-02-18 13:10:36","2026-02-18 13:10:36"),
("366","38","action terminée via WP Cron","2026-02-18 13:10:37","2026-02-18 13:10:37"),
("367","143","action créée","2026-02-18 13:10:37","2026-02-18 13:10:37"),
("368","39","action commencée via WP Cron","2026-02-18 13:10:37","2026-02-18 13:10:37"),
("369","39","action terminée via WP Cron","2026-02-18 13:10:38","2026-02-18 13:10:38"),
("370","144","action créée","2026-02-18 13:10:38","2026-02-18 13:10:38"),
("371","37","action commencée via WP Cron","2026-02-18 13:10:38","2026-02-18 13:10:38"),
("373","145","action créée","2026-02-18 13:10:38","2026-02-18 13:10:38"),
("374","146","action créée","2026-02-18 13:10:38","2026-02-18 13:10:38"),
("375","37","action terminée via WP Cron","2026-02-18 13:10:38","2026-02-18 13:10:38"),
("376","147","action créée","2026-02-18 13:10:38","2026-02-18 13:10:38"),
("377","146","action commencée via WP Cron","2026-02-18 13:15:31","2026-02-18 13:15:31"),
("378","146","action terminée via WP Cron","2026-02-18 13:15:31","2026-02-18 13:15:31"),
("380","148","action créée","2026-02-18 13:17:36","2026-02-18 13:17:36"),
("381","149","action créée","2026-02-18 13:17:36","2026-02-18 13:17:36"),
("382","148","action commencée via WP Cron","2026-02-18 13:17:42","2026-02-18 13:17:42"),
("383","148","action terminée via WP Cron","2026-02-18 13:17:43","2026-02-18 13:17:43"),
("384","150","action créée","2026-02-18 13:17:43","2026-02-18 13:17:43"),
("385","149","action commencée via WP Cron","2026-02-18 13:18:50","2026-02-18 13:18:50"),
("386","149","action terminée via WP Cron","2026-02-18 13:18:50","2026-02-18 13:18:50"),
("388","152","action créée","2026-02-18 13:19:26","2026-02-18 13:19:26"),
("389","153","action créée","2026-02-18 13:19:28","2026-02-18 13:19:28"),
("390","153","action commencée via Async Request","2026-02-18 13:19:28","2026-02-18 13:19:28"),
("391","153","action terminée via Async Request","2026-02-18 13:19:28","2026-02-18 13:19:28"),
("398","152","action commencée via Async Request","2026-02-18 13:19:28","2026-02-18 13:19:28"),
("400","158","action créée","2026-02-18 13:19:32","2026-02-18 13:19:32"),
("401","159","action créée","2026-02-18 13:19:32","2026-02-18 13:19:32"),
("402","160","action créée","2026-02-18 13:19:32","2026-02-18 13:19:32"),
("403","161","action créée","2026-02-18 13:19:32","2026-02-18 13:19:32"),
("404","162","action créée","2026-02-18 13:19:32","2026-02-18 13:19:32"),
("405","163","action créée","2026-02-18 13:19:32","2026-02-18 13:19:32"),
("406","164","action créée","2026-02-18 13:19:32","2026-02-18 13:19:32"),
("407","165","action créée","2026-02-18 13:19:32","2026-02-18 13:19:32"),
("408","166","action créée","2026-02-18 13:19:32","2026-02-18 13:19:32"),
("409","167","action créée","2026-02-18 13:19:32","2026-02-18 13:19:32"),
("410","152","action terminée via Async Request","2026-02-18 13:19:32","2026-02-18 13:19:32"),
("423","158","action commencée via Async Request","2026-02-18 13:19:34","2026-02-18 13:19:34"),
("424","158","action terminée via Async Request","2026-02-18 13:19:34","2026-02-18 13:19:34"),
("425","159","action commencée via Async Request","2026-02-18 13:19:34","2026-02-18 13:19:34"),
("426","159","action terminée via Async Request","2026-02-18 13:19:34","2026-02-18 13:19:34"),
("427","160","action commencée via Async Request","2026-02-18 13:19:34","2026-02-18 13:19:34"),
("428","160","action terminée via Async Request","2026-02-18 13:19:34","2026-02-18 13:19:34"),
("429","161","action commencée via Async Request","2026-02-18 13:19:34","2026-02-18 13:19:34"),
("430","161","action terminée via Async Request","2026-02-18 13:19:34","2026-02-18 13:19:34"),
("431","162","action commencée via Async Request","2026-02-18 13:19:34","2026-02-18 13:19:34"),
("432","162","action terminée via Async Request","2026-02-18 13:19:34","2026-02-18 13:19:34"),
("433","163","action commencée via Async Request","2026-02-18 13:19:34","2026-02-18 13:19:34"),
("434","163","action terminée via Async Request","2026-02-18 13:19:34","2026-02-18 13:19:34"),
("435","164","action commencée via Async Request","2026-02-18 13:19:34","2026-02-18 13:19:34"),
("436","164","action terminée via Async Request","2026-02-18 13:19:34","2026-02-18 13:19:34"),
("437","165","action commencée via Async Request","2026-02-18 13:19:34","2026-02-18 13:19:34"),
("438","165","action terminée via Async Request","2026-02-18 13:19:34","2026-02-18 13:19:34"),
("439","166","action commencée via Async Request","2026-02-18 13:19:34","2026-02-18 13:19:34"),
("440","166","action terminée via Async Request","2026-02-18 13:19:34","2026-02-18 13:19:34"),
("441","167","action commencée via Async Request","2026-02-18 13:19:34","2026-02-18 13:19:34"),
("442","167","action terminée via Async Request","2026-02-18 13:19:34","2026-02-18 13:19:34"),
("572","106","action commencée via WP Cron","2026-02-18 15:05:32","2026-02-18 15:05:32"),
("573","106","action terminée via WP Cron","2026-02-18 15:05:32","2026-02-18 15:05:32"),
("574","213","action créée","2026-02-18 15:05:32","2026-02-18 15:05:32"),
("575","107","action commencée via WP Cron","2026-02-18 15:05:32","2026-02-18 15:05:32"),
("576","107","action terminée via WP Cron","2026-02-18 15:05:32","2026-02-18 15:05:32"),
("577","214","action créée","2026-02-18 15:05:32","2026-02-18 15:05:32"),
("578","141","action commencée via WP Cron","2026-02-18 15:05:32","2026-02-18 15:05:32"),
("579","215","action créée","2026-02-18 15:05:32","2026-02-18 15:05:32"),
("580","141","action terminée via WP Cron","2026-02-18 15:05:32","2026-02-18 15:05:32"),
("581","216","action créée","2026-02-18 15:11:53","2026-02-18 15:11:53"),
("582","217","action créée","2026-02-18 15:12:00","2026-02-18 15:12:00"),
("583","218","action créée","2026-02-18 15:12:00","2026-02-18 15:12:00"),
("584","219","action créée","2026-02-18 15:12:00","2026-02-18 15:12:00"),
("585","220","action créée","2026-02-18 15:12:00","2026-02-18 15:12:00"),
("586","221","action créée","2026-02-18 15:12:00","2026-02-18 15:12:00"),
("587","217","action commencée via WP Cron","2026-02-18 15:12:00","2026-02-18 15:12:00"),
("588","217","action terminée via WP Cron","2026-02-18 15:12:06","2026-02-18 15:12:06"),
("589","218","action commencée via WP Cron","2026-02-18 15:12:06","2026-02-18 15:12:06"),
("590","218","action terminée via WP Cron","2026-02-18 15:12:09","2026-02-18 15:12:09"),
("591","219","action commencée via WP Cron","2026-02-18 15:12:09","2026-02-18 15:12:09"),
("592","219","action terminée via WP Cron","2026-02-18 15:12:12","2026-02-18 15:12:12"),
("593","220","action commencée via WP Cron","2026-02-18 15:12:12","2026-02-18 15:12:12"),
("594","220","action terminée via WP Cron","2026-02-18 15:12:15","2026-02-18 15:12:15"),
("595","221","action commencée via WP Cron","2026-02-18 15:12:15","2026-02-18 15:12:15"),
("596","221","action terminée via WP Cron","2026-02-18 15:12:18","2026-02-18 15:12:18"),
("597","222","action créée","2026-02-18 15:12:32","2026-02-18 15:12:32"),
("598","223","action créée","2026-02-18 15:12:32","2026-02-18 15:12:32"),
("599","224","action créée","2026-02-18 15:12:32","2026-02-18 15:12:32"),
("600","225","action créée","2026-02-18 15:12:32","2026-02-18 15:12:32"),
("601","226","action créée","2026-02-18 15:12:32","2026-02-18 15:12:32"),
("602","227","action créée","2026-02-18 15:12:32","2026-02-18 15:12:32"),
("603","228","action créée","2026-02-18 15:12:32","2026-02-18 15:12:32"),
("604","229","action créée","2026-02-18 15:12:32","2026-02-18 15:12:32"),
("605","230","action créée","2026-02-18 15:12:32","2026-02-18 15:12:32"),
("606","231","action créée","2026-02-18 15:12:32","2026-02-18 15:12:32"),
("607","232","action créée","2026-02-18 15:12:32","2026-02-18 15:12:32"),
("608","233","action créée","2026-02-18 15:12:32","2026-02-18 15:12:32"),
("609","234","action créée","2026-02-18 15:12:32","2026-02-18 15:12:32"),
("610","235","action créée","2026-02-18 15:12:32","2026-02-18 15:12:32"),
("611","236","action créée","2026-02-18 15:12:32","2026-02-18 15:12:32"),
("612","237","action créée","2026-02-18 15:12:32","2026-02-18 15:12:32"),
("613","238","action créée","2026-02-18 15:12:33","2026-02-18 15:12:33"),
("614","239","action créée","2026-02-18 15:12:33","2026-02-18 15:12:33"),
("615","240","action créée","2026-02-18 15:12:33","2026-02-18 15:12:33"),
("616","241","action créée","2026-02-18 15:12:33","2026-02-18 15:12:33"),
("617","242","action créée","2026-02-18 15:12:33","2026-02-18 15:12:33"),
("618","243","action créée","2026-02-18 15:12:33","2026-02-18 15:12:33"),
("619","244","action créée","2026-02-18 15:12:33","2026-02-18 15:12:33"),
("620","245","action créée","2026-02-18 15:12:33","2026-02-18 15:12:33"),
("621","246","action créée","2026-02-18 15:12:33","2026-02-18 15:12:33"),
("622","247","action créée","2026-02-18 15:12:33","2026-02-18 15:12:33"),
("623","248","action créée","2026-02-18 15:12:33","2026-02-18 15:12:33"),
("624","249","action créée","2026-02-18 15:12:33","2026-02-18 15:12:33"),
("625","250","action créée","2026-02-18 15:12:33","2026-02-18 15:12:33"),
("626","251","action créée","2026-02-18 15:12:33","2026-02-18 15:12:33"),
("627","252","action créée","2026-02-18 15:12:33","2026-02-18 15:12:33"),
("628","253","action créée","2026-02-18 15:12:33","2026-02-18 15:12:33"),
("629","254","action créée","2026-02-18 15:12:33","2026-02-18 15:12:33"),
("630","255","action créée","2026-02-18 15:12:33","2026-02-18 15:12:33"),
("631","256","action créée","2026-02-18 15:12:33","2026-02-18 15:12:33"),
("632","222","action commencée via WP Cron","2026-02-18 15:12:57","2026-02-18 15:12:57"),
("633","222","action terminée via WP Cron","2026-02-18 15:13:00","2026-02-18 15:13:00"),
("634","223","action commencée via WP Cron","2026-02-18 15:13:00","2026-02-18 15:13:00"),
("635","223","action terminée via WP Cron","2026-02-18 15:13:03","2026-02-18 15:13:03"),
("636","224","action commencée via WP Cron","2026-02-18 15:13:03","2026-02-18 15:13:03"),
("637","224","action terminée via WP Cron","2026-02-18 15:13:03","2026-02-18 15:13:03"),
("638","225","action commencée via WP Cron","2026-02-18 15:13:03","2026-02-18 15:13:03"),
("639","225","action terminée via WP Cron","2026-02-18 15:13:03","2026-02-18 15:13:03"),
("640","226","action commencée via WP Cron","2026-02-18 15:13:03","2026-02-18 15:13:03"),
("641","226","action terminée via WP Cron","2026-02-18 15:13:03","2026-02-18 15:13:03"),
("642","227","action commencée via WP Cron","2026-02-18 15:13:03","2026-02-18 15:13:03"),
("643","227","action terminée via WP Cron","2026-02-18 15:13:06","2026-02-18 15:13:06"),
("644","228","action commencée via WP Cron","2026-02-18 15:13:06","2026-02-18 15:13:06"),
("645","228","action terminée via WP Cron","2026-02-18 15:13:10","2026-02-18 15:13:10"),
("646","229","action commencée via WP Cron","2026-02-18 15:13:10","2026-02-18 15:13:10"),
("647","229","action terminée via WP Cron","2026-02-18 15:13:13","2026-02-18 15:13:13"),
("648","230","action commencée via WP Cron","2026-02-18 15:13:13","2026-02-18 15:13:13"),
("649","230","action terminée via WP Cron","2026-02-18 15:13:16","2026-02-18 15:13:16"),
("650","231","action commencée via WP Cron","2026-02-18 15:13:16","2026-02-18 15:13:16"),
("651","231","action terminée via WP Cron","2026-02-18 15:13:19","2026-02-18 15:13:19"),
("652","232","action commencée via WP Cron","2026-02-18 15:13:19","2026-02-18 15:13:19"),
("653","232","action terminée via WP Cron","2026-02-18 15:13:22","2026-02-18 15:13:22"),
("654","233","action commencée via WP Cron","2026-02-18 15:13:43","2026-02-18 15:13:43"),
("655","233","action terminée via WP Cron","2026-02-18 15:13:46","2026-02-18 15:13:46"),
("656","234","action commencée via WP Cron","2026-02-18 15:13:46","2026-02-18 15:13:46"),
("657","234","action terminée via WP Cron","2026-02-18 15:13:49","2026-02-18 15:13:49"),
("658","235","action commencée via WP Cron","2026-02-18 15:13:49","2026-02-18 15:13:49"),
("659","235","action terminée via WP Cron","2026-02-18 15:13:52","2026-02-18 15:13:52"),
("660","236","action commencée via WP Cron","2026-02-18 15:13:52","2026-02-18 15:13:52"),
("661","236","action terminée via WP Cron","2026-02-18 15:13:55","2026-02-18 15:13:55"),
("662","237","action commencée via WP Cron","2026-02-18 15:13:55","2026-02-18 15:13:55"),
("663","237","action terminée via WP Cron","2026-02-18 15:13:58","2026-02-18 15:13:58"),
("664","238","action commencée via WP Cron","2026-02-18 15:13:58","2026-02-18 15:13:58"),
("665","238","action terminée via WP Cron","2026-02-18 15:14:01","2026-02-18 15:14:01"),
("666","239","action commencée via WP Cron","2026-02-18 15:14:01","2026-02-18 15:14:01");

INSERT IGNORE INTO `wp_comments` VALUES 
("1","1","A WordPress Commenter","wapuu@wordpress.example","https://wordpress.org/","","2026-02-17 11:06:52","2026-02-17 11:06:52","Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com/\">Gravatar</a>.","0","post-trashed","","comment","0","0"),
("2","145","Lura Blaim","luira@gmail.com","http://google.com","::1","2019-04-08 08:15:48","2019-04-08 08:15:48","Company that’s grown from 270 to 480 employees in the last 12 months, we’re always passionate about bringing tech talent to NYC. That’s why we’re especially excited to kick off the new commit. Ut maximus molestie nisi, id suscipit erat cursus viverra. Donec tristique nulla sed rutrum semper.","0","1","","comment","0","0"),
("3","145","Lura Blaim","luira@gmail.com","http://google.com","::1","2019-04-08 08:16:05","2019-04-08 08:16:05","Company that’s grown from 270 to 480 employees in the last 12 months, we’re always passionate.","0","1","","comment","2","0"),
("4","145","Lura Blaim","luira@gmail.com","http://google.com","::1","2019-04-08 08:16:28","2019-04-08 08:16:28","Company that’s grown from 270 to 480 employees in the last 12 months, we’re always passionate about bringing tech talent to NYC. That’s why we’re especially excited to kick off the new commit. Ut maximus molestie nisi, id suscipit erat cursus viverra. Donec tristique nulla sed rutrum semper..","0","1","","comment","0","0");

INSERT IGNORE INTO `wp_duplicator_activity_logs` VALUES 
("1","websites_scan","scan_start","10","Scan","{\n    \"packageId\": 1,\n    \"packageName\": \"20260218_legg\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 0,\n    \"dirCount\": 0,\n    \"size\": 0,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 0,\n    \"dbSize\": 0,\n    \"dbRowCount\": 0\n}","0","4.5.24.4","2026-02-18 15:13:07","2026-02-18 15:13:07"),
("2","websites_scan","scan_end","10","Scan Completed","{\n    \"packageId\": 1,\n    \"packageName\": \"20260218_legg\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 19733,\n    \"dirCount\": 3530,\n    \"size\": 610138474,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 70,\n    \"dbSize\": 10034140,\n    \"dbRowCount\": 7538\n}","1","4.5.24.4","2026-02-18 15:13:44","2026-02-18 15:13:44"),
("3","backup_create","start","10","Backup creation: 20260218_legg","{\n    \"packageId\": 2,\n    \"packageName\": \"20260218_legg\",\n    \"packageStatus\": 10,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20260218_legg_f6f7432dae0b13389808_20260218151305\",\n    \"logFileName\": \"20260218_legg_f6f7432dae0b13389808_20260218151305_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 19733,\n    \"dirCount\": 3530,\n    \"size\": 610138474,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Shell Exec\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Manual\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 70,\n    \"dbSizeDisplay\": \"9.57MB\",\n    \"execution_start_time\": 1771427638.451019\n}","0","4.5.24.4","2026-02-18 15:13:58","2026-02-18 15:13:58"),
("4","backup_create","db_dump","10","Backup creation: 20260218_legg - Database Dump","{\n    \"packageId\": 2,\n    \"packageName\": \"20260218_legg\",\n    \"packageStatus\": 20,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20260218_legg_f6f7432dae0b13389808_20260218151305\",\n    \"logFileName\": \"20260218_legg_f6f7432dae0b13389808_20260218151305_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 19733,\n    \"dirCount\": 3530,\n    \"size\": 610138474,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Shell Exec\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Manual\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 70,\n    \"dbSizeDisplay\": \"9.57MB\",\n    \"execution_start_time\": 1771427638.451019\n}","3","4.5.24.4","2026-02-18 15:13:58","2026-02-18 15:13:58");

INSERT IGNORE INTO `wp_duplicator_backups` VALUES 
("1","Standard","20260218_legg","f6f7432dae0b13389808_20260218151305","20260218_legg_f6f7432dae0b13389808_20260218151305_archive.zip","5","MANUAL,ZIP_ARCHIVE,TEMPORARY","{\n    \"ID\": 1,\n    \"VersionWP\": \"6.9.1\",\n    \"VersionDB\": \"10.6.21\",\n    \"VersionPHP\": \"8.1.31\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20260218_legg\",\n    \"hash\": \"f6f7432dae0b13389808_20260218151305\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/leg.miklub.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20260218_legg_f6f7432dae0b13389808_20260218151305_scan.json\",\n    \"timer_start\": -1,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/vewwfjty\\/leg\\/.opcache\",\n            \"\\/home\\/vewwfjty\\/leg\\/.tmb\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/bps-backup\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/cache\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/old-cache\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/updraft\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/wfcache\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/vewwfjty\\/leg\\/.htaccess\",\n            \"\\/home\\/vewwfjty\\/leg\\/.user.ini\",\n            \"\\/home\\/vewwfjty\\/leg\\/php.ini\",\n            \"\\/home\\/vewwfjty\\/leg\\/web.config\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-config.php\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20260218_legg_f6f7432dae0b13389808_20260218151305_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/vewwfjty\\/leg\\/\",\n        \"Size\": 610138474,\n        \"Dirs\": [],\n        \"DirCount\": 3530,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 19733,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 223551933,\n                        \"bytes\": \"213.2MB\",\n                        \"nodes\": 18057,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 111315580,\n                        \"bytes\": \"106.16MB\",\n                        \"nodes\": 335,\n                        \"name\": \"04\",\n                        \"dir\": \"wp-content\\/uploads\\/2019\",\n                        \"path\": \"wp-content\\/uploads\\/2019\\/04\"\n                    },\n                    {\n                        \"ubytes\": 127332842,\n                        \"bytes\": \"121.43MB\",\n                        \"nodes\": 386,\n                        \"name\": \"2019\",\n                        \"dir\": \"wp-content\\/uploads\",\n                        \"path\": \"wp-content\\/uploads\\/2019\"\n                    },\n                    {\n                        \"ubytes\": 161878259,\n                        \"bytes\": \"154.38MB\",\n                        \"nodes\": 336,\n                        \"name\": \"02\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\"\n                    },\n                    {\n                        \"ubytes\": 161878259,\n                        \"bytes\": \"154.38MB\",\n                        \"nodes\": 337,\n                        \"name\": \"2026\",\n                        \"dir\": \"wp-content\\/uploads\",\n                        \"path\": \"wp-content\\/uploads\\/2026\"\n                    },\n                    {\n                        \"ubytes\": 289767042,\n                        \"bytes\": \"276.34MB\",\n                        \"nodes\": 772,\n                        \"name\": \"uploads\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/uploads\"\n                    },\n                    {\n                        \"ubytes\": 548626694,\n                        \"bytes\": \"523.21MB\",\n                        \"nodes\": 20044,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-snapshots\",\n                    \"\\/home\\/vewwfjty\\/leg\\/.opcache\",\n                    \"\\/home\\/vewwfjty\\/leg\\/.tmb\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/backups-dup-lite\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/backups-dup-pro\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/ai1wm-backups\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/backupwordpress\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/content\\/cache\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/contents\\/cache\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/managewp\\/backups\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/old-cache\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/updraft\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/wpvividbackups\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/wishlist-backup\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/wfcache\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/bps-backup\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/cache\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [\n                    {\n                        \"ubytes\": 5847327,\n                        \"bytes\": \"5.58MB\",\n                        \"nodes\": 1,\n                        \"name\": \"Pormotion.svg\",\n                        \"dir\": \"wp-content\\/plugins\\/depicter\\/resources\\/scripts\\/dashboard\\/assets\",\n                        \"path\": \"wp-content\\/plugins\\/depicter\\/resources\\/scripts\\/dashboard\\/assets\\/Pormotion.svg\"\n                    },\n                    {\n                        \"ubytes\": 12049457,\n                        \"bytes\": \"11.49MB\",\n                        \"nodes\": 1,\n                        \"name\": \"icons-wnYyNBXs.js\",\n                        \"dir\": \"wp-content\\/plugins\\/depicter\\/resources\\/scripts\\/editor\\/assets\",\n                        \"path\": \"wp-content\\/plugins\\/depicter\\/resources\\/scripts\\/editor\\/assets\\/icons-wnYyNBXs.js\"\n                    },\n                    {\n                        \"ubytes\": 5610855,\n                        \"bytes\": \"5.35MB\",\n                        \"nodes\": 1,\n                        \"name\": \"depicter-editor.js\",\n                        \"dir\": \"wp-content\\/plugins\\/depicter\\/resources\\/scripts\\/editor\",\n                        \"path\": \"wp-content\\/plugins\\/depicter\\/resources\\/scripts\\/editor\\/depicter-editor.js\"\n                    },\n                    {\n                        \"ubytes\": 6026453,\n                        \"bytes\": \"5.75MB\",\n                        \"nodes\": 1,\n                        \"name\": \"blonde-girl-with-ponytail-holding-rolled-pink-yoga-mat-1.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\\/02\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\\/blonde-girl-with-ponytail-holding-rolled-pink-yoga-mat-1.jpg\"\n                    },\n                    {\n                        \"ubytes\": 6026453,\n                        \"bytes\": \"5.75MB\",\n                        \"nodes\": 1,\n                        \"name\": \"blonde-girl-with-ponytail-holding-rolled-pink-yoga-mat.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\\/02\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\\/blonde-girl-with-ponytail-holding-rolled-pink-yoga-mat.jpg\"\n                    },\n                    {\n                        \"ubytes\": 18476193,\n                        \"bytes\": \"17.62MB\",\n                        \"nodes\": 1,\n                        \"name\": \"front-view-beautiful-women-with-copy-space-1.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\\/02\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\\/front-view-beautiful-women-with-copy-space-1.jpg\"\n                    },\n                    {\n                        \"ubytes\": 18476193,\n                        \"bytes\": \"17.62MB\",\n                        \"nodes\": 1,\n                        \"name\": \"front-view-beautiful-women-with-copy-space.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\\/02\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\\/front-view-beautiful-women-with-copy-space.jpg\"\n                    },\n                    {\n                        \"ubytes\": 7177267,\n                        \"bytes\": \"6.84MB\",\n                        \"nodes\": 1,\n                        \"name\": \"girl-with-ponytail-standing-holding-pink-yoga-mat.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\\/02\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\\/girl-with-ponytail-standing-holding-pink-yoga-mat.jpg\"\n                    },\n                    {\n                        \"ubytes\": 8991177,\n                        \"bytes\": \"8.57MB\",\n                        \"nodes\": 1,\n                        \"name\": \"group-beautiful-women-posing-gym.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\\/02\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\\/group-beautiful-women-posing-gym.jpg\"\n                    },\n                    {\n                        \"ubytes\": 9525814,\n                        \"bytes\": \"9.08MB\",\n                        \"nodes\": 1,\n                        \"name\": \"portrait-confident-fitness-woman-sports-clothing-looking-confident-female-posing-studio-near-gray-wall.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\\/02\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\\/portrait-confident-fitness-woman-sports-clothing-looking-confident-female-posing-studio-near-gray-wall.jpg\"\n                    },\n                    {\n                        \"ubytes\": 6053871,\n                        \"bytes\": \"5.77MB\",\n                        \"nodes\": 1,\n                        \"name\": \"sexy-fitness-smiling-woman-pink-sports-clothing-young-beautiful-model-with-perfect-bodyfemale-posing-studiocheerful-happy-stretching-out-before-training.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\\/02\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\\/sexy-fitness-smiling-woman-pink-sports-clothing-young-beautiful-model-with-perfect-bodyfemale-posing-studiocheerful-happy-stretching-out-before-training.jpg\"\n                    },\n                    {\n                        \"ubytes\": 18302778,\n                        \"bytes\": \"17.45MB\",\n                        \"nodes\": 1,\n                        \"name\": \"sportswoman-listening-music-earphones.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\\/02\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\\/sportswoman-listening-music-earphones.jpg\"\n                    },\n                    {\n                        \"ubytes\": 11015294,\n                        \"bytes\": \"10.51MB\",\n                        \"nodes\": 1,\n                        \"name\": \"sporty-woman-stretching-urban-environment.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\\/02\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\\/sporty-woman-stretching-urban-environment.jpg\"\n                    },\n                    {\n                        \"ubytes\": 10940254,\n                        \"bytes\": \"10.43MB\",\n                        \"nodes\": 1,\n                        \"name\": \"young-woman-is-resting-after-jogging-park.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\\/02\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\\/young-woman-is-resting-after-jogging-park.jpg\"\n                    },\n                    {\n                        \"ubytes\": 12721560,\n                        \"bytes\": \"12.13MB\",\n                        \"nodes\": 1,\n                        \"name\": \"young-woman-stretching-street.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\\/02\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\\/young-woman-stretching-street.jpg\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/home\\/vewwfjty\\/leg\\/.htaccess\",\n                    \"\\/home\\/vewwfjty\\/leg\\/.user.ini\",\n                    \"\\/home\\/vewwfjty\\/leg\\/php.ini\",\n                    \"\\/home\\/vewwfjty\\/leg\\/web.config\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/debug.log\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"text\": \"\\/home\\/vewwfjty\\/leg <span class=\\\"size\\\" >581.87MB<\\/span> <span class=\\\"nodes\\\" >23263<\\/span>\",\n                \"fullPath\": \"\\/home\\/vewwfjty\\/leg\",\n                \"type\": \"folder\",\n                \"state\": {\n                    \"opened\": true,\n                    \"disabled\": false,\n                    \"selected\": false,\n                    \"checked\": false,\n                    \"checkbox_disabled\": true\n                },\n                \"children\": [\n                    {\n                        \"text\": \"wp-content <span class=\\\"size\\\" >523.21MB<\\/span> <span class=\\\"nodes\\\" >20044<\\/span>\",\n                        \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\",\n                        \"type\": \"folder\",\n                        \"state\": {\n                            \"opened\": true,\n                            \"disabled\": false,\n                            \"selected\": false,\n                            \"checked\": false,\n                            \"checkbox_disabled\": false\n                        },\n                        \"children\": [\n                            {\n                                \"text\": \"plugins <span class=\\\"size\\\" >213.2MB<\\/span> <span class=\\\"nodes\\\" >18057<\\/span>\",\n                                \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/plugins\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": true,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": [\n                                    {\n                                        \"text\": \"depicter <span class=\\\"size\\\" >33.22MB<\\/span> <span class=\\\"nodes\\\" >2012<\\/span>\",\n                                        \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/plugins\\/depicter\",\n                                        \"type\": \"folder\",\n                                        \"state\": {\n                                            \"opened\": true,\n                                            \"disabled\": false,\n                                            \"selected\": false,\n                                            \"checked\": false,\n                                            \"checkbox_disabled\": false\n                                        },\n                                        \"children\": [\n                                            {\n                                                \"text\": \"resources <span class=\\\"size\\\" >27.86MB<\\/span> <span class=\\\"nodes\\\" >308<\\/span>\",\n                                                \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/plugins\\/depicter\\/resources\",\n                                                \"type\": \"folder\",\n                                                \"state\": {\n                                                    \"opened\": true,\n                                                    \"disabled\": false,\n                                                    \"selected\": false,\n                                                    \"checked\": false,\n                                                    \"checkbox_disabled\": false\n                                                },\n                                                \"children\": [\n                                                    {\n                                                        \"text\": \"scripts <span class=\\\"size\\\" >27.46MB<\\/span> <span class=\\\"nodes\\\" >268<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/plugins\\/depicter\\/resources\\/scripts\",\n                                                        \"type\": \"folder\",\n                                                        \"state\": {\n                                                            \"opened\": true,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": [\n                                                            {\n                                                                \"text\": \"dashboard <span class=\\\"size\\\" >8.64MB<\\/span> <span class=\\\"nodes\\\" >33<\\/span>\",\n                                                                \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/plugins\\/depicter\\/resources\\/scripts\\/dashboard\",\n                                                                \"type\": \"folder\",\n                                                                \"state\": {\n                                                                    \"opened\": true,\n                                                                    \"disabled\": false,\n                                                                    \"selected\": false,\n                                                                    \"checked\": false,\n                                                                    \"checkbox_disabled\": false\n                                                                },\n                                                                \"children\": [\n                                                                    {\n                                                                        \"text\": \"assets <span class=\\\"size\\\" >6.49MB<\\/span> <span class=\\\"nodes\\\" >30<\\/span>\",\n                                                                        \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/plugins\\/depicter\\/resources\\/scripts\\/dashboard\\/assets\",\n                                                                        \"type\": \"folder\",\n                                                                        \"state\": {\n                                                                            \"opened\": true,\n                                                                            \"disabled\": false,\n                                                                            \"selected\": false,\n                                                                            \"checked\": false,\n                                                                            \"checkbox_disabled\": false\n                                                                        },\n                                                                        \"children\": [\n                                                                            {\n                                                                                \"text\": \"Pormotion.svg <span class=\\\"size\\\" >5.58MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                                                \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/plugins\\/depicter\\/resources\\/scripts\\/dashboard\\/assets\\/Pormotion.svg\",\n                                                                                \"type\": \"file\",\n                                                                                \"state\": {\n                                                                                    \"opened\": false,\n                                                                                    \"disabled\": false,\n                                                                                    \"selected\": false,\n                                                                                    \"checked\": false,\n                                                                                    \"checkbox_disabled\": false\n                                                                                },\n                                                                                \"children\": null,\n                                                                                \"li_attr\": {\n                                                                                    \"class\": \" warning-node\"\n                                                                                },\n                                                                                \"a_attr\": []\n                                                                            }\n                                                                        ],\n                                                                        \"li_attr\": {\n                                                                            \"data-full-loaded\": false,\n                                                                            \"class\": \" warning-childs\"\n                                                                        },\n                                                                        \"a_attr\": []\n                                                                    }\n                                                                ],\n                                                                \"li_attr\": {\n                                                                    \"data-full-loaded\": false,\n                                                                    \"class\": \" warning-childs\"\n                                                                },\n                                                                \"a_attr\": []\n                                                            },\n                                                            {\n                                                                \"text\": \"editor <span class=\\\"size\\\" >18.31MB<\\/span> <span class=\\\"nodes\\\" >26<\\/span>\",\n                                                                \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/plugins\\/depicter\\/resources\\/scripts\\/editor\",\n                                                                \"type\": \"folder\",\n                                                                \"state\": {\n                                                                    \"opened\": true,\n                                                                    \"disabled\": false,\n                                                                    \"selected\": false,\n                                                                    \"checked\": false,\n                                                                    \"checkbox_disabled\": false\n                                                                },\n                                                                \"children\": [\n                                                                    {\n                                                                        \"text\": \"assets <span class=\\\"size\\\" >12.92MB<\\/span> <span class=\\\"nodes\\\" >23<\\/span>\",\n                                                                        \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/plugins\\/depicter\\/resources\\/scripts\\/editor\\/assets\",\n                                                                        \"type\": \"folder\",\n                                                                        \"state\": {\n                                                                            \"opened\": true,\n                                                                            \"disabled\": false,\n                                                                            \"selected\": false,\n                                                                            \"checked\": false,\n                                                                            \"checkbox_disabled\": false\n                                                                        },\n                                                                        \"children\": [\n                                                                            {\n                                                                                \"text\": \"icons-wnYyNBXs.js <span class=\\\"size\\\" >11.49MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                                                \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/plugins\\/depicter\\/resources\\/scripts\\/editor\\/assets\\/icons-wnYyNBXs.js\",\n                                                                                \"type\": \"file\",\n                                                                                \"state\": {\n                                                                                    \"opened\": false,\n                                                                                    \"disabled\": false,\n                                                                                    \"selected\": false,\n                                                                                    \"checked\": false,\n                                                                                    \"checkbox_disabled\": false\n                                                                                },\n                                                                                \"children\": null,\n                                                                                \"li_attr\": {\n                                                                                    \"class\": \" warning-node\"\n                                                                                },\n                                                                                \"a_attr\": []\n                                                                            }\n                                                                        ],\n                                                                        \"li_attr\": {\n                                                                            \"data-full-loaded\": false,\n                                                                            \"class\": \" warning-childs\"\n                                                                        },\n                                                                        \"a_attr\": []\n                                                                    },\n                                                                    {\n                                                                        \"text\": \"depicter-editor.js <span class=\\\"size\\\" >5.35MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                                        \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/plugins\\/depicter\\/resources\\/scripts\\/editor\\/depicter-editor.js\",\n                                                                        \"type\": \"file\",\n                                                                        \"state\": {\n                                                                            \"opened\": false,\n                                                                            \"disabled\": false,\n                                                                            \"selected\": false,\n                                                                            \"checked\": false,\n                                                                            \"checkbox_disabled\": false\n                                                                        },\n                                                                        \"children\": null,\n                                                                        \"li_attr\": {\n                                                                            \"class\": \" warning-node\"\n                                                                        },\n                                                                        \"a_attr\": []\n                                                                    }\n                                                                ],\n                                                                \"li_attr\": {\n                                                                    \"data-full-loaded\": false,\n                                                                    \"class\": \" warning-childs\"\n                                                                },\n                                                                \"a_attr\": []\n                                                            }\n                                                        ],\n                                                        \"li_attr\": {\n                                                            \"data-full-loaded\": false,\n                                                            \"class\": \" warning-childs\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    }\n                                                ],\n                                                \"li_attr\": {\n                                                    \"data-full-loaded\": false,\n                                                    \"class\": \" warning-childs\"\n                                                },\n                                                \"a_attr\": []\n                                            }\n                                        ],\n                                        \"li_attr\": {\n                                            \"data-full-loaded\": false,\n                                            \"class\": \" warning-childs\"\n                                        },\n                                        \"a_attr\": []\n                                    }\n                                ],\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-node\"\n                                },\n                                \"a_attr\": []\n                            },\n                            {\n                                \"text\": \"uploads <span class=\\\"size\\\" >276.34MB<\\/span> <span class=\\\"nodes\\\" >772<\\/span>\",\n                                \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": true,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": [\n                                    {\n                                        \"text\": \"2019 <span class=\\\"size\\\" >121.43MB<\\/span> <span class=\\\"nodes\\\" >386<\\/span>\",\n                                        \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/2019\",\n                                        \"type\": \"folder\",\n                                        \"state\": {\n                                            \"opened\": true,\n                                            \"disabled\": false,\n                                            \"selected\": false,\n                                            \"checked\": false,\n                                            \"checkbox_disabled\": false\n                                        },\n                                        \"children\": [\n                                            {\n                                                \"text\": \"04 <span class=\\\"size\\\" >106.16MB<\\/span> <span class=\\\"nodes\\\" >335<\\/span>\",\n                                                \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/2019\\/04\",\n                                                \"type\": \"folder\",\n                                                \"state\": {\n                                                    \"opened\": false,\n                                                    \"disabled\": false,\n                                                    \"selected\": false,\n                                                    \"checked\": false,\n                                                    \"checkbox_disabled\": false\n                                                },\n                                                \"children\": true,\n                                                \"li_attr\": {\n                                                    \"data-full-loaded\": false,\n                                                    \"class\": \" warning-node\"\n                                                },\n                                                \"a_attr\": []\n                                            }\n                                        ],\n                                        \"li_attr\": {\n                                            \"data-full-loaded\": false,\n                                            \"class\": \" warning-node\"\n                                        },\n                                        \"a_attr\": []\n                                    },\n                                    {\n                                        \"text\": \"2026 <span class=\\\"size\\\" >154.38MB<\\/span> <span class=\\\"nodes\\\" >337<\\/span>\",\n                                        \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/2026\",\n                                        \"type\": \"folder\",\n                                        \"state\": {\n                                            \"opened\": true,\n                                            \"disabled\": false,\n                                            \"selected\": false,\n                                            \"checked\": false,\n                                            \"checkbox_disabled\": false\n                                        },\n                                        \"children\": [\n                                            {\n                                                \"text\": \"02 <span class=\\\"size\\\" >154.38MB<\\/span> <span class=\\\"nodes\\\" >336<\\/span>\",\n                                                \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/2026\\/02\",\n                                                \"type\": \"folder\",\n                                                \"state\": {\n                                                    \"opened\": true,\n                                                    \"disabled\": false,\n                                                    \"selected\": false,\n                                                    \"checked\": false,\n                                                    \"checkbox_disabled\": false\n                                                },\n                                                \"children\": [\n                                                    {\n                                                        \"text\": \"blonde-girl-with-ponytail-holding-rolled-pink-yoga-mat-1.jpg <span class=\\\"size\\\" >5.75MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/2026\\/02\\/blonde-girl-with-ponytail-holding-rolled-pink-yoga-mat-1.jpg\",\n                                                        \"type\": \"file\",\n                                                        \"state\": {\n                                                            \"opened\": false,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": null,\n                                                        \"li_attr\": {\n                                                            \"class\": \" warning-node\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    },\n                                                    {\n                                                        \"text\": \"blonde-girl-with-ponytail-holding-rolled-pink-yoga-mat.jpg <span class=\\\"size\\\" >5.75MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/2026\\/02\\/blonde-girl-with-ponytail-holding-rolled-pink-yoga-mat.jpg\",\n                                                        \"type\": \"file\",\n                                                        \"state\": {\n                                                            \"opened\": false,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": null,\n                                                        \"li_attr\": {\n                                                            \"class\": \" warning-node\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    },\n                                                    {\n                                                        \"text\": \"front-view-beautiful-women-with-copy-space-1.jpg <span class=\\\"size\\\" >17.62MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/2026\\/02\\/front-view-beautiful-women-with-copy-space-1.jpg\",\n                                                        \"type\": \"file\",\n                                                        \"state\": {\n                                                            \"opened\": false,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": null,\n                                                        \"li_attr\": {\n                                                            \"class\": \" warning-node\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    },\n                                                    {\n                                                        \"text\": \"front-view-beautiful-women-with-copy-space.jpg <span class=\\\"size\\\" >17.62MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/2026\\/02\\/front-view-beautiful-women-with-copy-space.jpg\",\n                                                        \"type\": \"file\",\n                                                        \"state\": {\n                                                            \"opened\": false,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": null,\n                                                        \"li_attr\": {\n                                                            \"class\": \" warning-node\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    },\n                                                    {\n                                                        \"text\": \"girl-with-ponytail-standing-holding-pink-yoga-mat.jpg <span class=\\\"size\\\" >6.84MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/2026\\/02\\/girl-with-ponytail-standing-holding-pink-yoga-mat.jpg\",\n                                                        \"type\": \"file\",\n                                                        \"state\": {\n                                                            \"opened\": false,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": null,\n                                                        \"li_attr\": {\n                                                            \"class\": \" warning-node\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    },\n                                                    {\n                                                        \"text\": \"group-beautiful-women-posing-gym.jpg <span class=\\\"size\\\" >8.57MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/2026\\/02\\/group-beautiful-women-posing-gym.jpg\",\n                                                        \"type\": \"file\",\n                                                        \"state\": {\n                                                            \"opened\": false,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": null,\n                                                        \"li_attr\": {\n                                                            \"class\": \" warning-node\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    },\n                                                    {\n                                                        \"text\": \"portrait-confident-fitness-woman-sports-clothing-looking-confident-female-posing-studio-near-gray-wall.jpg <span class=\\\"size\\\" >9.08MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/2026\\/02\\/portrait-confident-fitness-woman-sports-clothing-looking-confident-female-posing-studio-near-gray-wall.jpg\",\n                                                        \"type\": \"file\",\n                                                        \"state\": {\n                                                            \"opened\": false,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": null,\n                                                        \"li_attr\": {\n                                                            \"class\": \" warning-node\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    },\n                                                    {\n                                                        \"text\": \"sexy-fitness-smiling-woman-pink-sports-clothing-young-beautiful-model-with-perfect-bodyfemale-posing-studiocheerful-happy-stretching-out-before-training.jpg <span class=\\\"size\\\" >5.77MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/2026\\/02\\/sexy-fitness-smiling-woman-pink-sports-clothing-young-beautiful-model-with-perfect-bodyfemale-posing-studiocheerful-happy-stretching-out-before-training.jpg\",\n                                                        \"type\": \"file\",\n                                                        \"state\": {\n                                                            \"opened\": false,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": null,\n                                                        \"li_attr\": {\n                                                            \"class\": \" warning-node\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    },\n                                                    {\n                                                        \"text\": \"sportswoman-listening-music-earphones.jpg <span class=\\\"size\\\" >17.45MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/2026\\/02\\/sportswoman-listening-music-earphones.jpg\",\n                                                        \"type\": \"file\",\n                                                        \"state\": {\n                                                            \"opened\": false,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": null,\n                                                        \"li_attr\": {\n                                                            \"class\": \" warning-node\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    },\n                                                    {\n                                                        \"text\": \"sporty-woman-stretching-urban-environment.jpg <span class=\\\"size\\\" >10.51MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/2026\\/02\\/sporty-woman-stretching-urban-environment.jpg\",\n                                                        \"type\": \"file\",\n                                                        \"state\": {\n                                                            \"opened\": false,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": null,\n                                                        \"li_attr\": {\n                                                            \"class\": \" warning-node\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    },\n                                                    {\n                                                        \"text\": \"young-woman-is-resting-after-jogging-park.jpg <span class=\\\"size\\\" >10.43MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/2026\\/02\\/young-woman-is-resting-after-jogging-park.jpg\",\n                                                        \"type\": \"file\",\n                                                        \"state\": {\n                                                            \"opened\": false,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": null,\n                                                        \"li_attr\": {\n                                                            \"class\": \" warning-node\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    },\n                                                    {\n                                                        \"text\": \"young-woman-stretching-street.jpg <span class=\\\"size\\\" >12.13MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/2026\\/02\\/young-woman-stretching-street.jpg\",\n                                                        \"type\": \"file\",\n                                                        \"state\": {\n                                                            \"opened\": false,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": null,\n                                                        \"li_attr\": {\n                                                            \"class\": \" warning-node\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    }\n                                                ],\n                                                \"li_attr\": {\n                                                    \"data-full-loaded\": false,\n                                                    \"class\": \" warning-node\"\n                                                },\n                                                \"a_attr\": []\n                                            }\n                                        ],\n                                        \"li_attr\": {\n                                            \"data-full-loaded\": false,\n                                            \"class\": \" warning-node\"\n                                        },\n                                        \"a_attr\": []\n                                    }\n                                ],\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-node\"\n                                },\n                                \"a_attr\": []\n                            }\n                        ],\n                        \"li_attr\": {\n                            \"data-full-loaded\": false,\n                            \"class\": \" warning-node\"\n                        },\n                        \"a_attr\": []\n                    }\n                ],\n                \"li_attr\": {\n                    \"data-full-loaded\": false,\n                    \"class\": \" root-node core-node warning-childs\"\n                },\n                \"a_attr\": {\n                    \"title\": \"Core WordPress directories should not be filtered. Use caution when excluding files.\"\n                }\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20260218_legg_f6f7432dae0b13389808_20260218151305_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"uDev6bgBY9D4wZnQ7ukPKcK8W0dUTQt73X6gtU4xdDDCxl2whbPJjB4c6Tfb+GpSkTNFtdPHWuUs\\/QmJ5ubtRw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"latin1\",\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"MyISAM\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": true,\n            \"name\": \"vewwfjty_4pzKATzE1\",\n            \"tablesBaseCount\": 70,\n            \"tablesFinalCount\": 70,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 7538,\n            \"tablesSizeOnDisk\": 10034140,\n            \"tablesList\": {\n                \"noc_autologin\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"190\",\n                    \"insertedRows\": 0,\n                    \"size\": 99180\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 3114\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 0,\n                    \"size\": 9584\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"493\",\n                    \"insertedRows\": 0,\n                    \"size\": 64644\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 10416\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 10796\n                },\n                \"wp_depicter_documents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"wp_depicter_leads\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_depicter_lead_fields\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_depicter_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_depicter_options\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_depicter_queue_jobs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 11860\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 43628\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 40332\n                },\n                \"wp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_masterslider_options\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 49148\n                },\n                \"wp_masterslider_sliders\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 91920\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"1028\",\n                    \"insertedRows\": 0,\n                    \"size\": 4674484\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"4948\",\n                    \"insertedRows\": 0,\n                    \"size\": 2409016\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"303\",\n                    \"insertedRows\": 0,\n                    \"size\": 2175452\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 0,\n                    \"size\": 12896\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"50\",\n                    \"insertedRows\": 0,\n                    \"size\": 15256\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"109\",\n                    \"insertedRows\": 0,\n                    \"size\": 18515\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"50\",\n                    \"insertedRows\": 0,\n                    \"size\": 8892\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 0,\n                    \"size\": 23108\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 8540\n                },\n                \"wp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"56\",\n                    \"insertedRows\": 0,\n                    \"size\": 26728\n                },\n                \"wp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"81\",\n                    \"insertedRows\": 0,\n                    \"size\": 21824\n                },\n                \"wp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 2099\n                },\n                \"wp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 6216\n                },\n                \"wp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"wp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 3832\n                },\n                \"wp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 9372\n                },\n                \"wp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 0,\n                    \"size\": 11992\n                },\n                \"wp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 9288\n                },\n                \"wp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"wp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 3200\n                },\n                \"wp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"wp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 9840\n                },\n                \"wp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 2068\n                },\n                \"wp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 4128\n                },\n                \"wp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 2092\n                },\n                \"wp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wpr_above_the_fold\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 20736\n                },\n                \"wp_wpr_lazy_render_content\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 14900\n                },\n                \"wp_wpr_performance_monitoring\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16756\n                },\n                \"wp_wpr_preconnect_external_domains\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 15124\n                },\n                \"wp_wpr_preload_fonts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"35\",\n                    \"insertedRows\": 0,\n                    \"size\": 14796\n                },\n                \"wp_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.6.21\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20260218_legg_f6f7432dae0b13389808_20260218151305_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 5,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 610138474,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"isProcessing\": false,\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": [],\n            \"generalExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.4\",\n    \"created\": \"2026-02-18 15:13:05\",\n    \"updated\": \"2026-02-18 15:13:44\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\",\n        \"TEMPORARY\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 1,\n    \"mainActivityLogId\": 0\n}","4.5.24.4","2026-02-18 15:13:05","2026-02-18 15:13:44"),
("2","Standard","20260218_legg","f6f7432dae0b13389808_20260218151305","20260218_legg_f6f7432dae0b13389808_20260218151305_archive.zip","20","MANUAL,ZIP_ARCHIVE","{\n    \"ID\": 2,\n    \"VersionWP\": \"6.9.1\",\n    \"VersionDB\": \"10.6.21\",\n    \"VersionPHP\": \"8.1.31\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20260218_legg\",\n    \"hash\": \"f6f7432dae0b13389808_20260218151305\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/leg.miklub.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20260218_legg_f6f7432dae0b13389808_20260218151305_scan.json\",\n    \"timer_start\": 1771427638.451019,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/vewwfjty\\/leg\\/.opcache\",\n            \"\\/home\\/vewwfjty\\/leg\\/.tmb\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/bps-backup\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/cache\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/old-cache\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/updraft\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/wfcache\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/vewwfjty\\/leg\\/.htaccess\",\n            \"\\/home\\/vewwfjty\\/leg\\/.user.ini\",\n            \"\\/home\\/vewwfjty\\/leg\\/php.ini\",\n            \"\\/home\\/vewwfjty\\/leg\\/web.config\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-config.php\",\n            \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20260218_legg_f6f7432dae0b13389808_20260218151305_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/vewwfjty\\/leg\\/\",\n        \"Size\": 610138474,\n        \"Dirs\": [],\n        \"DirCount\": 3530,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 19733,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 223551933,\n                        \"bytes\": \"213.2MB\",\n                        \"nodes\": 18057,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 111315580,\n                        \"bytes\": \"106.16MB\",\n                        \"nodes\": 335,\n                        \"name\": \"04\",\n                        \"dir\": \"wp-content\\/uploads\\/2019\",\n                        \"path\": \"wp-content\\/uploads\\/2019\\/04\"\n                    },\n                    {\n                        \"ubytes\": 127332842,\n                        \"bytes\": \"121.43MB\",\n                        \"nodes\": 386,\n                        \"name\": \"2019\",\n                        \"dir\": \"wp-content\\/uploads\",\n                        \"path\": \"wp-content\\/uploads\\/2019\"\n                    },\n                    {\n                        \"ubytes\": 161878259,\n                        \"bytes\": \"154.38MB\",\n                        \"nodes\": 336,\n                        \"name\": \"02\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\"\n                    },\n                    {\n                        \"ubytes\": 161878259,\n                        \"bytes\": \"154.38MB\",\n                        \"nodes\": 337,\n                        \"name\": \"2026\",\n                        \"dir\": \"wp-content\\/uploads\",\n                        \"path\": \"wp-content\\/uploads\\/2026\"\n                    },\n                    {\n                        \"ubytes\": 289767042,\n                        \"bytes\": \"276.34MB\",\n                        \"nodes\": 772,\n                        \"name\": \"uploads\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/uploads\"\n                    },\n                    {\n                        \"ubytes\": 548626694,\n                        \"bytes\": \"523.21MB\",\n                        \"nodes\": 20044,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-snapshots\",\n                    \"\\/home\\/vewwfjty\\/leg\\/.opcache\",\n                    \"\\/home\\/vewwfjty\\/leg\\/.tmb\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/backups-dup-lite\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/backups-dup-pro\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/ai1wm-backups\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/backupwordpress\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/content\\/cache\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/contents\\/cache\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/managewp\\/backups\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/old-cache\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/updraft\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/wpvividbackups\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/wishlist-backup\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/wfcache\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/bps-backup\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/cache\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [\n                    {\n                        \"ubytes\": 5847327,\n                        \"bytes\": \"5.58MB\",\n                        \"nodes\": 1,\n                        \"name\": \"Pormotion.svg\",\n                        \"dir\": \"wp-content\\/plugins\\/depicter\\/resources\\/scripts\\/dashboard\\/assets\",\n                        \"path\": \"wp-content\\/plugins\\/depicter\\/resources\\/scripts\\/dashboard\\/assets\\/Pormotion.svg\"\n                    },\n                    {\n                        \"ubytes\": 12049457,\n                        \"bytes\": \"11.49MB\",\n                        \"nodes\": 1,\n                        \"name\": \"icons-wnYyNBXs.js\",\n                        \"dir\": \"wp-content\\/plugins\\/depicter\\/resources\\/scripts\\/editor\\/assets\",\n                        \"path\": \"wp-content\\/plugins\\/depicter\\/resources\\/scripts\\/editor\\/assets\\/icons-wnYyNBXs.js\"\n                    },\n                    {\n                        \"ubytes\": 5610855,\n                        \"bytes\": \"5.35MB\",\n                        \"nodes\": 1,\n                        \"name\": \"depicter-editor.js\",\n                        \"dir\": \"wp-content\\/plugins\\/depicter\\/resources\\/scripts\\/editor\",\n                        \"path\": \"wp-content\\/plugins\\/depicter\\/resources\\/scripts\\/editor\\/depicter-editor.js\"\n                    },\n                    {\n                        \"ubytes\": 6026453,\n                        \"bytes\": \"5.75MB\",\n                        \"nodes\": 1,\n                        \"name\": \"blonde-girl-with-ponytail-holding-rolled-pink-yoga-mat-1.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\\/02\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\\/blonde-girl-with-ponytail-holding-rolled-pink-yoga-mat-1.jpg\"\n                    },\n                    {\n                        \"ubytes\": 6026453,\n                        \"bytes\": \"5.75MB\",\n                        \"nodes\": 1,\n                        \"name\": \"blonde-girl-with-ponytail-holding-rolled-pink-yoga-mat.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\\/02\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\\/blonde-girl-with-ponytail-holding-rolled-pink-yoga-mat.jpg\"\n                    },\n                    {\n                        \"ubytes\": 18476193,\n                        \"bytes\": \"17.62MB\",\n                        \"nodes\": 1,\n                        \"name\": \"front-view-beautiful-women-with-copy-space-1.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\\/02\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\\/front-view-beautiful-women-with-copy-space-1.jpg\"\n                    },\n                    {\n                        \"ubytes\": 18476193,\n                        \"bytes\": \"17.62MB\",\n                        \"nodes\": 1,\n                        \"name\": \"front-view-beautiful-women-with-copy-space.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\\/02\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\\/front-view-beautiful-women-with-copy-space.jpg\"\n                    },\n                    {\n                        \"ubytes\": 7177267,\n                        \"bytes\": \"6.84MB\",\n                        \"nodes\": 1,\n                        \"name\": \"girl-with-ponytail-standing-holding-pink-yoga-mat.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\\/02\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\\/girl-with-ponytail-standing-holding-pink-yoga-mat.jpg\"\n                    },\n                    {\n                        \"ubytes\": 8991177,\n                        \"bytes\": \"8.57MB\",\n                        \"nodes\": 1,\n                        \"name\": \"group-beautiful-women-posing-gym.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\\/02\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\\/group-beautiful-women-posing-gym.jpg\"\n                    },\n                    {\n                        \"ubytes\": 9525814,\n                        \"bytes\": \"9.08MB\",\n                        \"nodes\": 1,\n                        \"name\": \"portrait-confident-fitness-woman-sports-clothing-looking-confident-female-posing-studio-near-gray-wall.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\\/02\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\\/portrait-confident-fitness-woman-sports-clothing-looking-confident-female-posing-studio-near-gray-wall.jpg\"\n                    },\n                    {\n                        \"ubytes\": 6053871,\n                        \"bytes\": \"5.77MB\",\n                        \"nodes\": 1,\n                        \"name\": \"sexy-fitness-smiling-woman-pink-sports-clothing-young-beautiful-model-with-perfect-bodyfemale-posing-studiocheerful-happy-stretching-out-before-training.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\\/02\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\\/sexy-fitness-smiling-woman-pink-sports-clothing-young-beautiful-model-with-perfect-bodyfemale-posing-studiocheerful-happy-stretching-out-before-training.jpg\"\n                    },\n                    {\n                        \"ubytes\": 18302778,\n                        \"bytes\": \"17.45MB\",\n                        \"nodes\": 1,\n                        \"name\": \"sportswoman-listening-music-earphones.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\\/02\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\\/sportswoman-listening-music-earphones.jpg\"\n                    },\n                    {\n                        \"ubytes\": 11015294,\n                        \"bytes\": \"10.51MB\",\n                        \"nodes\": 1,\n                        \"name\": \"sporty-woman-stretching-urban-environment.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\\/02\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\\/sporty-woman-stretching-urban-environment.jpg\"\n                    },\n                    {\n                        \"ubytes\": 10940254,\n                        \"bytes\": \"10.43MB\",\n                        \"nodes\": 1,\n                        \"name\": \"young-woman-is-resting-after-jogging-park.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\\/02\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\\/young-woman-is-resting-after-jogging-park.jpg\"\n                    },\n                    {\n                        \"ubytes\": 12721560,\n                        \"bytes\": \"12.13MB\",\n                        \"nodes\": 1,\n                        \"name\": \"young-woman-stretching-street.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2026\\/02\",\n                        \"path\": \"wp-content\\/uploads\\/2026\\/02\\/young-woman-stretching-street.jpg\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/home\\/vewwfjty\\/leg\\/.htaccess\",\n                    \"\\/home\\/vewwfjty\\/leg\\/.user.ini\",\n                    \"\\/home\\/vewwfjty\\/leg\\/php.ini\",\n                    \"\\/home\\/vewwfjty\\/leg\\/web.config\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/debug.log\",\n                    \"\\/home\\/vewwfjty\\/leg\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"treeList\": []\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20260218_legg_f6f7432dae0b13389808_20260218151305_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"2m\\/HPlII3LqawGoVmewhorJwNx4idfL\\/\\/AyqqJm+jNSkAhoEgOkOl6RxQz49cvPCMPJf9NBUbBL+OPLtIsXWbQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"latin1\",\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"MyISAM\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": true,\n            \"name\": \"vewwfjty_4pzKATzE1\",\n            \"tablesBaseCount\": 70,\n            \"tablesFinalCount\": 70,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 7538,\n            \"tablesSizeOnDisk\": 10034140,\n            \"tablesList\": {\n                \"noc_autologin\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"190\",\n                    \"insertedRows\": 0,\n                    \"size\": 99180\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 3114\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 0,\n                    \"size\": 9584\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"493\",\n                    \"insertedRows\": 0,\n                    \"size\": 64644\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 10416\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 10796\n                },\n                \"wp_depicter_documents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"wp_depicter_leads\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_depicter_lead_fields\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_depicter_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_depicter_options\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_depicter_queue_jobs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 11860\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 43628\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 40332\n                },\n                \"wp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_masterslider_options\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 49148\n                },\n                \"wp_masterslider_sliders\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 91920\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"1028\",\n                    \"insertedRows\": 0,\n                    \"size\": 4674484\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"4948\",\n                    \"insertedRows\": 0,\n                    \"size\": 2409016\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"303\",\n                    \"insertedRows\": 0,\n                    \"size\": 2175452\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 0,\n                    \"size\": 12896\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"50\",\n                    \"insertedRows\": 0,\n                    \"size\": 15256\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"109\",\n                    \"insertedRows\": 0,\n                    \"size\": 18515\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"50\",\n                    \"insertedRows\": 0,\n                    \"size\": 8892\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 0,\n                    \"size\": 23108\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 8540\n                },\n                \"wp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"56\",\n                    \"insertedRows\": 0,\n                    \"size\": 26728\n                },\n                \"wp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"81\",\n                    \"insertedRows\": 0,\n                    \"size\": 21824\n                },\n                \"wp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 2099\n                },\n                \"wp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 6216\n                },\n                \"wp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"wp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 3832\n                },\n                \"wp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 9372\n                },\n                \"wp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 0,\n                    \"size\": 11992\n                },\n                \"wp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 9288\n                },\n                \"wp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"wp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 3200\n                },\n                \"wp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"wp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 9840\n                },\n                \"wp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 2068\n                },\n                \"wp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 4128\n                },\n                \"wp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 2092\n                },\n                \"wp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wpr_above_the_fold\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 20736\n                },\n                \"wp_wpr_lazy_render_content\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 14900\n                },\n                \"wp_wpr_performance_monitoring\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16756\n                },\n                \"wp_wpr_preconnect_external_domains\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 15124\n                },\n                \"wp_wpr_preload_fonts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"35\",\n                    \"insertedRows\": 0,\n                    \"size\": 14796\n                },\n                \"wp_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.6.21\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20260218_legg_f6f7432dae0b13389808_20260218151305_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/vewwfjty\\/leg\\/wp-content\\/backups-dup-pro\\/tmp\\/20260218_legg_f6f7432dae0b13389808_20260218151305_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 20,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 1771427643,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 610138474,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"wp_users\",\n            \"wp_usermeta\",\n            \"noc_autologin\",\n            \"wp_actionscheduler_actions\",\n            \"wp_actionscheduler_claims\",\n            \"wp_actionscheduler_groups\",\n            \"wp_actionscheduler_logs\",\n            \"wp_commentmeta\",\n            \"wp_comments\",\n            \"wp_depicter_documents\",\n            \"wp_depicter_leads\",\n            \"wp_depicter_lead_fields\",\n            \"wp_depicter_meta\",\n            \"wp_depicter_options\",\n            \"wp_depicter_queue_jobs\",\n            \"wp_duplicator_activity_logs\",\n            \"wp_duplicator_backups\",\n            \"wp_duplicator_entities\",\n            \"wp_e_events\",\n            \"wp_links\",\n            \"wp_masterslider_options\",\n            \"wp_masterslider_sliders\",\n            \"wp_options\",\n            \"wp_postmeta\",\n            \"wp_posts\",\n            \"wp_termmeta\",\n            \"wp_terms\",\n            \"wp_term_relationships\",\n            \"wp_term_taxonomy\",\n            \"wp_wc_admin_notes\",\n            \"wp_wc_admin_note_actions\",\n            \"wp_wc_category_lookup\",\n            \"wp_wc_customer_lookup\",\n            \"wp_wc_download_log\",\n            \"wp_wc_orders\",\n            \"wp_wc_orders_meta\",\n            \"wp_wc_order_addresses\",\n            \"wp_wc_order_coupon_lookup\",\n            \"wp_wc_order_operational_data\",\n            \"wp_wc_order_product_lookup\",\n            \"wp_wc_order_stats\",\n            \"wp_wc_order_tax_lookup\",\n            \"wp_wc_product_attributes_lookup\",\n            \"wp_wc_product_download_directories\",\n            \"wp_wc_product_meta_lookup\",\n            \"wp_wc_rate_limits\",\n            \"wp_wc_reserved_stock\",\n            \"wp_wc_tax_rate_classes\",\n            \"wp_wc_webhooks\",\n            \"wp_woocommerce_api_keys\",\n            \"wp_woocommerce_attribute_taxonomies\",\n            \"wp_woocommerce_downloadable_product_permissions\",\n            \"wp_woocommerce_log\",\n            \"wp_woocommerce_order_itemmeta\",\n            \"wp_woocommerce_order_items\",\n            \"wp_woocommerce_payment_tokenmeta\",\n            \"wp_woocommerce_payment_tokens\",\n            \"wp_woocommerce_sessions\",\n            \"wp_woocommerce_shipping_zones\",\n            \"wp_woocommerce_shipping_zone_locations\",\n            \"wp_woocommerce_shipping_zone_methods\",\n            \"wp_woocommerce_tax_rates\",\n            \"wp_woocommerce_tax_rate_locations\",\n            \"wp_wpr_above_the_fold\",\n            \"wp_wpr_lazy_render_content\",\n            \"wp_wpr_performance_monitoring\",\n            \"wp_wpr_preconnect_external_domains\",\n            \"wp_wpr_preload_fonts\",\n            \"wp_wpr_rocket_cache\",\n            \"wp_wpr_rucss_used_css\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1771427638.459823,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 7560,\n            \"tables\": {\n                \"wp_users\": {\n                    \"start\": \"2\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"noc_autologin\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_depicter_documents\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_depicter_leads\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_depicter_lead_fields\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_depicter_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_depicter_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_depicter_queue_jobs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_activity_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_backups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_masterslider_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_masterslider_sliders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_admin_notes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_admin_note_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_category_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_customer_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_download_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_orders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_orders_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_addresses\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_coupon_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_operational_data\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_product_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_stats\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_tax_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_product_attributes_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_product_download_directories\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_product_meta_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_rate_limits\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_reserved_stock\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_tax_rate_classes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_webhooks\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_api_keys\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_attribute_taxonomies\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_downloadable_product_permissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_order_itemmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_order_items\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_payment_tokenmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_payment_tokens\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_sessions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_shipping_zones\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_shipping_zone_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_shipping_zone_methods\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_tax_rates\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_tax_rate_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpr_above_the_fold\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpr_lazy_render_content\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpr_performance_monitoring\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpr_preconnect_external_domains\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpr_preload_fonts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpr_rocket_cache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpr_rucss_used_css\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"isProcessing\": false,\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": [],\n            \"generalExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.4\",\n    \"created\": \"2026-02-18 15:13:05\",\n    \"updated\": \"2026-02-18 15:14:03\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 1,\n    \"mainActivityLogId\": 3\n}","4.5.24.4","2026-02-18 15:13:05","2026-02-18 15:14:03");

INSERT IGNORE INTO `wp_duplicator_entities` VALUES 
("1","DUP_PRO_Global_Entity","","","","","","{\n    \"email_summary_frequency\": \"weekly\",\n    \"email_summary_recipients\": [\n        \"hedi.chqir@gmail.com\"\n    ],\n    \"usageTracking\": true,\n    \"amNotices\": true,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 1,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 32,\n    \"homepath_as_abspath\": false,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"max_package_transfer_time_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 20,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"hedi.chqir@gmail.com\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 0,\n    \"ajax_protocol\": \"https\",\n    \"custom_ajax_url\": \"https:\\/\\/leg.miklub.fr\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"purgeBackupRecords\": 0,\n    \"manual_mode_storage_ids\": [\n        3\n    ],\n    \"license_key_visible\": 1,\n    \"last_system_check_timestamp\": 0,\n    \"initial_activation_timestamp\": 1771427530,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"recoveryCustomPath\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 1,\n    \"version\": \"4.5.24.4\",\n    \"created\": \"2026-02-18 15:12:09\",\n    \"updated\": \"2026-02-18 15:13:05\"\n}","4.5.24.4","2026-02-18 15:12:09","2026-02-18 15:13:05"),
("2","Dynamic_Entity","","","","","","{\n    \"data\": \"QqUYyQD7\\/fZkWsW7QUGCgjb4hAmM4cKSp7RzEh88r\\/NZYEbSpf71mRPnEXZWuguXQthDmRkv2fJ85I2p+aZ7NNbEQItwGc1v\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 2,\n    \"version\": \"4.5.24.4\",\n    \"created\": \"2026-02-18 15:12:09\",\n    \"updated\": \"2026-02-18 15:12:09\",\n    \"dataIsEncrypted\": true\n}","4.5.24.4","2026-02-18 15:12:09","2026-02-18 15:12:09"),
("3","DUP_PRO_Storage_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"notes\": \"The default location for storage on this server.\",\n    \"storage_type\": -2,\n    \"config\": \"No9jCHGIyq2go33mx2DEmv9W5x2ssVMkX7uiPHzlHAvkDPwNevoq9uam\\/rB\\/CzHKi8n8YSbWtcKSCaGv637bp0CXi3EMgN2rd9A1RIq7V1oHdmmzheN\\/UFLkkYTbUi1PeojHhwkikDo8W94W75rl2Afyidi3G1LSoYro4t8rLpbo2Ss3W\\/80mlkMi9wOc+iWDDDoVZi1RtoMgWDyMn5GRbwHHlbZIQUTRV6YW1Dltv0C9onvPe+dCQ==\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 3,\n    \"version\": \"4.5.24.4\",\n    \"created\": \"2026-02-18 15:12:09\",\n    \"updated\": \"2026-02-18 15:12:09\"\n}","4.5.24.4","2026-02-18 15:12:09","2026-02-18 15:12:09"),
("4","EmailSummary","","","","","","{\n    \"manualPackageIds\": [],\n    \"scheduledPackageIds\": [],\n    \"failedPackageIds\": [],\n    \"failedUploads\": [],\n    \"cancelledUploads\": [],\n    \"successfulUploads\": [],\n    \"scheduleIds\": [],\n    \"storageIds\": [],\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 4,\n    \"version\": \"4.5.24.4\",\n    \"created\": \"2026-02-18 15:12:09\",\n    \"updated\": \"2026-02-18 15:12:09\"\n}","4.5.24.4","2026-02-18 15:12:09","2026-02-18 15:12:09"),
("5","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"HmbclaEhKwTCosGgwxKEXy+yySueSmHJcQDV9gP3\\/HX2IvVH4xcY5wGus8WDtVeIM0PMdFkWKY77mMEoEq90\\/Q==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 5,\n    \"version\": \"4.5.24.4\",\n    \"created\": \"2026-02-18 15:12:09\",\n    \"updated\": \"2026-02-18 15:12:09\"\n}","4.5.24.4","2026-02-18 15:12:09","2026-02-18 15:12:09"),
("6","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"[Manual Mode]\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"+nfCiH5NgTDJFCExRLwdXlWA9Yp6fSzuHuhZTOpCtvC\\/kKbN+JCv8Xzdap8phJl2wLYh2+IiN3y7fbSvxtHUtw==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -1,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 6,\n    \"version\": \"4.5.24.4\",\n    \"created\": \"2026-02-18 15:12:09\",\n    \"updated\": \"2026-02-18 15:13:05\"\n}","4.5.24.4","2026-02-18 15:12:09","2026-02-18 15:13:05"),
("7","LicenseDataEntity","","","","","","{\n    \"licenseKey\": \"Xih\\/dkRUFTKgPuS9AzknCjM+wREu4XwrDbgWMz31wjOOSrLiGttWC264JA+lG7uulA2OlozONUjvA01ZuQtWSgwbH6BoNgHH1yvao629brwpq6RV\\/81Bb9iZfyl5Y4QC\",\n    \"status\": \"kZRQ81ZSf0NBz2adjKNLrvBoW1j9nJjPY1rC6i3ep1KFM7Y7dyxZCPpxK0vm85QTEoXDIwqqoCKtTPq3bjoaj\\/5Y17dc4qJ2\",\n    \"type\": \"ktfLoGlccevuamKqtsJxSdL5ipvU0rF5DaG5jg7Zt41trMg4XAAT3z8cT\\/w+nOyi\\/uVIgkJmPWJUjUMEEF4DHCu40C92+9+n\",\n    \"data\": \"rhHc+4j1SSKzW+rfRxiQrE3oPh04mO9zQx061AlcOGqwR+FZcZoL7Z61vQxabb+2N1u\\/foN6+MLt41BO8BKD1KPogmUrCd+LXUB43dnznKTPmLnGi434GTigyciKUuBG25m+INQn3tTT+\\/UPEDynKlaZNQ8xiC8E0kfNs8EuxGOe0F3l12KjwAPdqnQ4NMZVOkdxOr5KXS8XW3mRIvYL98KvfX8HAnlsrANB3eF\\/69S1V+3M0mqc\\/Y5Q3MxfDD2Hn\\/cGSKgLi7+b00wSIm31WB9\\/XyF\\/dNIBW7UXyhGWbxLPyU6t+5BNJvxufHu\\/\\/Y77TlI0ohK0KI5EnVecLZiQDM+ueIixuWQZJf4i2xeSsqKAAFDxOB5ffc8LGYaTbZR3k79pFe2y1E2Rksg2GQNJ+LdD78jipRyV9KJYyi48TfHnzu7\\/E6su8yysm8S\\/i5YPuS4YK\\/GHDNOt5TCMadkdzayemXIuq0t4\",\n    \"lastRemoteUpdate\": \"2026-02-18 15:12:11\",\n    \"lastFailureTime\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 7,\n    \"version\": \"4.5.24.4\",\n    \"created\": \"2026-02-18 15:12:09\",\n    \"updated\": \"2026-02-18 15:12:11\"\n}","4.5.24.4","2026-02-18 15:12:09","2026-02-18 15:12:11"),
("8","DUP_PRO_System_Global_Entity","","","","","","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1771427637,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 8,\n    \"version\": \"4.5.24.4\",\n    \"created\": \"2026-02-18 15:12:10\",\n    \"updated\": \"2026-02-18 15:13:57\"\n}","4.5.24.4","2026-02-18 15:12:10","2026-02-18 15:13:57");

INSERT IGNORE INTO `wp_masterslider_options` VALUES 
("1","preset_effect","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"),
("2","buttons_style","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"),
("3","masterslider_custom_css_ver","2.9"),
("4","preset_style","eyJtZXRhIjp7fX0="),
("5","buttons_css",".msp-preset-btn-84{ background-color: #b97ebb;color: #fff; } .msp-preset-btn-84:hover{ background-color:#ca89cc;color: #fff; } .msp-preset-btn-84:active{ top:1px } .msp-preset-btn-85{ background-color: #b97ebb;color: #fff; } .msp-preset-btn-85:hover{ background-color:#ca89cc;color: #fff; } .msp-preset-btn-85:active{ top:1px } .msp-preset-btn-86{ color: #b97ebb;border:solid 1px #b97ebb; } .msp-preset-btn-86:hover{ border-color:#ca89cc;color:#ca89cc } .msp-preset-btn-86:active{ top:1px } .msp-preset-btn-87{ background-color: #b97ebb;color: #fff; } .msp-preset-btn-87:hover{ background-color:#ca89cc;color: #fff; } .msp-preset-btn-87:active{ top:1px } .msp-preset-btn-88{ background-color: #b97ebb;color: #fff;box-shadow:0 5px #9a699c; } .msp-preset-btn-88:hover{ background-color:#ca89cc;box-shadow:0 4px #9a699c;top:1px;color: #fff; } .msp-preset-btn-88:active{ box-shadow:0 2px #9a699c;top:3px; } .msp-preset-btn-89{ background-color: #5472D2;color: #fff; } .msp-preset-btn-89:hover{ background-color:#5d7fe9;color: #fff; } .msp-preset-btn-89:active{ top:1px } .msp-preset-btn-90{ background-color: #5472D2;color: #fff; } .msp-preset-btn-90:hover{ background-color:#5d7fe9;color: #fff; } .msp-preset-btn-90:active{ top:1px } .msp-preset-btn-91{ color: #5472D2;border:solid 1px #5472D2; } .msp-preset-btn-91:hover{ border-color:#5d7fe9;color:#5d7fe9 } .msp-preset-btn-91:active{ top:1px } .msp-preset-btn-92{ background-color: #5472D2;color: #fff; } .msp-preset-btn-92:hover{ background-color:#5d7fe9;color: #fff; } .msp-preset-btn-92:active{ top:1px } .msp-preset-btn-93{ background-color: #5472D2;color: #fff;box-shadow:0 5px #4c68be; } .msp-preset-btn-93:hover{ background-color:#5d7fe9;box-shadow:0 4px #4c68be;top:1px;color: #fff; } .msp-preset-btn-93:active{ box-shadow:0 2px #4c68be;top:3px; } .msp-preset-btn-94{ background-color: #00c1cf;color: #fff; } .msp-preset-btn-94:hover{ background-color:#01D4E4;color: #fff; } .msp-preset-btn-94:active{ top:1px } .msp-preset-btn-95{ background-color: #00c1cf;color: #fff; } .msp-preset-btn-95:hover{ background-color:#01D4E4;color: #fff; } .msp-preset-btn-95:active{ top:1px } .msp-preset-btn-96{ color: #00c1cf;border:solid 1px #00c1cf; } .msp-preset-btn-96:hover{ border-color:#01D4E4;color:#01D4E4 } .msp-preset-btn-96:active{ top:1px } .msp-preset-btn-97{ background-color: #00c1cf;color: #fff; } .msp-preset-btn-97:hover{ background-color:#01D4E4;color: #fff; } .msp-preset-btn-97:active{ top:1px } .msp-preset-btn-98{ background-color: #00c1cf;color: #fff;box-shadow:0 5px #00afbc; } .msp-preset-btn-98:hover{ background-color:#01D4E4;box-shadow:0 4px #00afbc;top:1px;color: #fff; } .msp-preset-btn-98:active{ box-shadow:0 2px #00afbc;top:3px; } .msp-preset-btn-99{ background-color: #4cadc9;color: #fff; } .msp-preset-btn-99:hover{ background-color:#63b2c9;color: #fff; } .msp-preset-btn-99:active{ top:1px } .msp-preset-btn-100{ background-color: #4cadc9;color: #fff; } .msp-preset-btn-100:hover{ background-color:#63b2c9;color: #fff; } .msp-preset-btn-100:active{ top:1px } .msp-preset-btn-101{ color: #4cadc9;border:solid 1px #4cadc9; } .msp-preset-btn-101:hover{ border-color:#63b2c9;color:#63b2c9 } .msp-preset-btn-101:active{ top:1px } .msp-preset-btn-102{ background-color: #4cadc9;color: #fff; } .msp-preset-btn-102:hover{ background-color:#63b2c9;color: #fff; } .msp-preset-btn-102:active{ top:1px } .msp-preset-btn-103{ background-color: #4cadc9;color: #fff;box-shadow:0 5px #1aa2c9; } .msp-preset-btn-103:hover{ background-color:#63b2c9;box-shadow:0 4px #1aa2c9;top:1px;color: #fff; } .msp-preset-btn-103:active{ box-shadow:0 2px #1aa2c9;top:3px; } .msp-preset-btn-104{ background-color: #cec2ab;color: #fff; } .msp-preset-btn-104:hover{ background-color:#cebd9d;color: #fff; } .msp-preset-btn-104:active{ top:1px } .msp-preset-btn-105{ background-color: #cec2ab;color: #fff; } .msp-preset-btn-105:hover{ background-color:#cebd9d;color: #fff; } .msp-preset-btn-105:active{ top:1px } .msp-preset-btn-106{ color: #cec2ab;border:solid 1px #cec2ab; } .msp-preset-btn-106:hover{ border-color:#cebd9d;color:#cebd9d } .msp-preset-btn-106:active{ top:1px } .msp-preset-btn-107{ background-color: #cec2ab;color: #fff; } .msp-preset-btn-107:hover{ background-color:#cebd9d;color: #fff; } .msp-preset-btn-107:active{ top:1px } .msp-preset-btn-108{ background-color: #cec2ab;color: #fff;box-shadow:0 5px #C2B7A2; } .msp-preset-btn-108:hover{ background-color:#cebd9d;box-shadow:0 4px #C2B7A2;top:1px;color: #fff; } .msp-preset-btn-108:active{ box-shadow:0 2px #C2B7A2;top:3px; } .msp-preset-btn-109{ background-color: #50485b;color: #fff; } .msp-preset-btn-109:hover{ background-color:#6a6176;color: #fff; } .msp-preset-btn-109:active{ top:1px } .msp-preset-btn-110{ background-color: #50485b;color: #fff; } .msp-preset-btn-110:hover{ background-color:#6a6176;color: #fff; } .msp-preset-btn-110:active{ top:1px } .msp-preset-btn-111{ color: #50485b;border:solid 1px #50485b; } .msp-preset-btn-111:hover{ border-color:#6a6176;color:#6a6176 } .msp-preset-btn-111:active{ top:1px } .msp-preset-btn-112{ background-color: #50485b;color: #fff; } .msp-preset-btn-112:hover{ background-color:#6a6176;color: #fff; } .msp-preset-btn-112:active{ top:1px } .msp-preset-btn-113{ background-color: #50485b;color: #fff;box-shadow:0 5px #412d5b; } .msp-preset-btn-113:hover{ background-color:#6a6176;box-shadow:0 4px #412d5b;top:1px;color: #fff; } .msp-preset-btn-113:active{ box-shadow:0 2px #412d5b;top:3px; } .msp-preset-btn-114{ background-color: #8d6dc4;color: #fff; } .msp-preset-btn-114:hover{ background-color:#977cc4;color: #fff; } .msp-preset-btn-114:active{ top:1px } .msp-preset-btn-115{ background-color: #8d6dc4;color: #fff; } .msp-preset-btn-115:hover{ background-color:#977cc4;color: #fff; } .msp-preset-btn-115:active{ top:1px } .msp-preset-btn-116{ color: #8d6dc4;border:solid 1px #8d6dc4; } .msp-preset-btn-116:hover{ border-color:#977cc4;color:#977cc4 } .msp-preset-btn-116:active{ top:1px } .msp-preset-btn-117{ background-color: #8d6dc4;color: #fff; } .msp-preset-btn-117:hover{ background-color:#977cc4;color: #fff; } .msp-preset-btn-117:active{ top:1px } .msp-preset-btn-118{ background-color: #8d6dc4;color: #fff;box-shadow:0 5px #7c51c4; } .msp-preset-btn-118:hover{ background-color:#977cc4;box-shadow:0 4px #7c51c4;top:1px;color: #fff; } .msp-preset-btn-118:active{ box-shadow:0 2px #7c51c4;top:3px; } .msp-preset-btn-119{ background-color: #75d69c;color: #fff; } .msp-preset-btn-119:hover{ background-color:#7de5a7;color: #fff; } .msp-preset-btn-119:active{ top:1px } .msp-preset-btn-120{ background-color: #75d69c;color: #fff; } .msp-preset-btn-120:hover{ background-color:#7de5a7;color: #fff; } .msp-preset-btn-120:active{ top:1px } .msp-preset-btn-121{ color: #75d69c;border:solid 1px #75d69c; } .msp-preset-btn-121:hover{ border-color:#7de5a7;color:#7de5a7 } .msp-preset-btn-121:active{ top:1px } .msp-preset-btn-122{ background-color: #75d69c;color: #fff; } .msp-preset-btn-122:hover{ background-color:#7de5a7;color: #fff; } .msp-preset-btn-122:active{ top:1px } .msp-preset-btn-123{ background-color: #75d69c;color: #fff;box-shadow:0 5px #41d67d; } .msp-preset-btn-123:hover{ background-color:#7de5a7;box-shadow:0 4px #41d67d;top:1px;color: #fff; } .msp-preset-btn-123:active{ box-shadow:0 2px #41d67d;top:3px; } .msp-preset-btn-124{ background-color: #222;color: #fff; } .msp-preset-btn-124:hover{ background-color:#333;color: #fff; } .msp-preset-btn-124:active{ top:1px } .msp-preset-btn-125{ background-color: #222;color: #fff; } .msp-preset-btn-125:hover{ background-color:#333;color: #fff; } .msp-preset-btn-125:active{ top:1px } .msp-preset-btn-126{ color: #222;border:solid 1px #222; } .msp-preset-btn-126:hover{ border-color:#333;color:#333 } .msp-preset-btn-126:active{ top:1px } .msp-preset-btn-127{ background-color: #222;color: #fff; } .msp-preset-btn-127:hover{ background-color:#333;color: #fff; } .msp-preset-btn-127:active{ top:1px } .msp-preset-btn-128{ background-color: #222;color: #fff;box-shadow:0 5px #000; } .msp-preset-btn-128:hover{ background-color:#333;box-shadow:0 4px #000;top:1px;color: #fff; } .msp-preset-btn-128:active{ box-shadow:0 2px #000;top:3px; } .msp-preset-btn-129{ background-color: #dedede;color: #666; } .msp-preset-btn-129:hover{ background-color:#d1d1d1;color: #666; } .msp-preset-btn-129:active{ top:1px } .msp-preset-btn-130{ background-color: #dedede;color: #666; } .msp-preset-btn-130:hover{ background-color:#d1d1d1;color: #666; } .msp-preset-btn-130:active{ top:1px } .msp-preset-btn-131{ color: #dedede;border:solid 1px #dedede; } .msp-preset-btn-131:hover{ border-color:#d1d1d1;color:#d1d1d1 } .msp-preset-btn-131:active{ top:1px } .msp-preset-btn-132{ background-color: #dedede;color: #666; } .msp-preset-btn-132:hover{ background-color:#d1d1d1;color: #666; } .msp-preset-btn-132:active{ top:1px } .msp-preset-btn-133{ background-color: #dedede;color: #666;box-shadow:0 5px #CACACA; } .msp-preset-btn-133:hover{ background-color:#d1d1d1;color: #666;box-shadow:0 4px #CACACA;top:1px } .msp-preset-btn-133:active{ box-shadow:0 2px #CACACA;top:3px; } .msp-preset-btn-134{ background-color: #f7be68;color: #fff; } .msp-preset-btn-134:hover{ background-color:#e9b362;color: #fff; } .msp-preset-btn-134:active{ top:1px } .msp-preset-btn-135{ background-color: #f7be68;color: #fff; } .msp-preset-btn-135:hover{ background-color:#e9b362;color: #fff; } .msp-preset-btn-135:active{ top:1px } .msp-preset-btn-136{ color: #f7be68;border:solid 1px #f7be68; } .msp-preset-btn-136:hover{ border-color:#e9b362;color:#e9b362 } .msp-preset-btn-136:active{ top:1px } .msp-preset-btn-137{ background-color: #f7be68;color: #fff; } .msp-preset-btn-137:hover{ background-color:#e9b362;color: #fff; } .msp-preset-btn-137:active{ top:1px } .msp-preset-btn-138{ background-color: #f7be68;color: #fff;box-shadow:0 5px #E7AF59; } .msp-preset-btn-138:hover{ background-color:#e9b362;box-shadow:0 4px #E7AF59;top:1px;color: #fff; } .msp-preset-btn-138:active{ box-shadow:0 2px #E7AF59;top:3px; } .msp-preset-btn-139{ background-color: #5aa1e3;color: #fff; } .msp-preset-btn-139:hover{ background-color:#5faaef;color: #fff; } .msp-preset-btn-139:active{ top:1px } .msp-preset-btn-140{ background-color: #5aa1e3;color: #fff; } .msp-preset-btn-140:hover{ background-color:#5faaef;color: #fff; } .msp-preset-btn-140:active{ top:1px } .msp-preset-btn-141{ color: #5aa1e3;border:solid 1px #5aa1e3; } .msp-preset-btn-141:hover{ border-color:#5faaef;color:#5faaef } .msp-preset-btn-141:active{ top:1px } .msp-preset-btn-142{ background-color: #5aa1e3;color: #fff; } .msp-preset-btn-142:hover{ background-color:#5faaef;color: #fff; } .msp-preset-btn-142:active{ top:1px } .msp-preset-btn-143{ background-color: #5aa1e3;color: #fff;box-shadow:0 5px #4c87bf; } .msp-preset-btn-143:hover{ background-color:#5faaef;box-shadow:0 4px #4c87bf;top:1px;color: #fff; } .msp-preset-btn-143:active{ box-shadow:0 2px #4c87bf;top:3px; } .msp-preset-btn-144{ background-color: #6dab3c;color: #fff; } .msp-preset-btn-144:hover{ background-color:#76b941;color: #fff; } .msp-preset-btn-144:active{ top:1px } .msp-preset-btn-145{ background-color: #6dab3c;color: #fff; } .msp-preset-btn-145:hover{ background-color:#76b941;color: #fff; } .msp-preset-btn-145:active{ top:1px } .msp-preset-btn-146{ color: #6dab3c;border:solid 1px #6dab3c; } .msp-preset-btn-146:hover{ border-color:#76b941;color:#76b941 } .msp-preset-btn-146:active{ top:1px } .msp-preset-btn-147{ background-color: #6dab3c;color: #fff; } .msp-preset-btn-147:hover{ background-color:#76b941;color: #fff; } .msp-preset-btn-147:active{ top:1px } .msp-preset-btn-148{ background-color: #6dab3c;color: #fff;box-shadow:0 5px #5e9334; } .msp-preset-btn-148:hover{ background-color:#76b941;box-shadow:0 4px #5e9334;top:1px;color: #fff; } .msp-preset-btn-148:active{ box-shadow:0 2px #5e9334;top:3px; } .msp-preset-btn-149{ background-color: #f4524d;color: #fff; } .msp-preset-btn-149:hover{ background-color:#e04b47;color: #fff; } .msp-preset-btn-149:active{ top:1px } .msp-preset-btn-150{ background-color: #f4524d;color: #fff; } .msp-preset-btn-150:hover{ background-color:#e04b47;color: #fff; } .msp-preset-btn-150:active{ top:1px } .msp-preset-btn-151{ color: #f4524d;border:solid 1px #f4524d; } .msp-preset-btn-151:hover{ border-color:#e04b47;color:#e04b47 } .msp-preset-btn-151:active{ top:1px } .msp-preset-btn-152{ background-color: #f4524d;color: #fff; } .msp-preset-btn-152:hover{ background-color:#e04b47;color: #fff; } .msp-preset-btn-152:active{ top:1px } .msp-preset-btn-153{ background-color: #f4524d;color: #fff;box-shadow:0 5px #cb4440; } .msp-preset-btn-153:hover{ background-color:#e04b47;box-shadow:0 4px #cb4440;top:1px;color: #fff; } .msp-preset-btn-153:active{ box-shadow:0 2px #cb4440;top:3px; } .msp-preset-btn-154{ background-color: #f79468;color: #fff; } .msp-preset-btn-154:hover{ background-color:#e78a61;color: #fff; } .msp-preset-btn-154:active{ top:1px } .msp-preset-btn-155{ background-color: #f79468;color: #fff; } .msp-preset-btn-155:hover{ background-color:#e78a61;color: #fff; } .msp-preset-btn-155:active{ top:1px } .msp-preset-btn-156{ color: #f79468;border:solid 1px #f79468; } .msp-preset-btn-156:hover{ border-color:#e78a61;color:#e78a61 } .msp-preset-btn-156:active{ top:1px } .msp-preset-btn-157{ background-color: #f79468;color: #fff; } .msp-preset-btn-157:hover{ background-color:#e78a61;color: #fff; } .msp-preset-btn-157:active{ top:1px } .msp-preset-btn-158{ background-color: #f79468;color: #fff;box-shadow:0 5px #da835c; } .msp-preset-btn-158:hover{ background-color:#e78a61;box-shadow:0 4px #da835c;top:1px;color: #fff; } .msp-preset-btn-158:active{ box-shadow:0 2px #da835c;top:3px; }");

INSERT IGNORE INTO `wp_masterslider_sliders` VALUES 
("2","Untitled Slider","ms-2","post","0","2020-10-05 11:58:52","2020-10-05 11:58:52","s:6:\"a:0:{}\";","","","draft"),
("3","Shop Pro","aux-shop-pro-slider","custom","2","2019-04-24 11:56:26","2026-02-17 13:06:12","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",".msp-cn-2-5 { background-color:#ffffff;font-weight:normal;line-height:normal;box-shaodw: 20px 33px 40px rgba(0, 0, 0, 0.01); } \n.msp-cn-3-6 { font-family:\"Playfair Display\";font-weight:normal;font-size:46px;text-align:center;line-height:96px;color:#3d3d3d; } \n.msp-cn-2-7 { font-family:\"Montserrat\";font-weight:600;font-size:16px;line-height:19px;color:#1359b6; } \n.msp-cn-2-8 { font-family:\"Montserrat\";font-weight:normal;font-size:16px;line-height:24px;color:#3d3d3d; } \n.msp-cn-2-9 { font-family:\"Poppins\";font-weight:600;font-size:14px;line-height:20px;color:#3d3d3d; } \n.aux-shop-pro-slider .ms-overlay-layers .ms-slide-layers { overflow: visible; }","Playfair+Display:regular|Montserrat:600,regular|Poppins:600","published");

INSERT IGNORE INTO `wp_options` VALUES 
("1","cron","a:36:{i:1771427648;a:1:{s:19:\"depicter/queue/cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1771427668;a:3:{s:24:\"rocket_saas_pending_jobs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:24:\"rocket_saas_pending_jobs\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}s:32:\"action_scheduler_run_queue_rucss\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}s:26:\"rocket_saas_on_submit_jobs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:26:\"rocket_saas_on_submit_jobs\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1771427669;a:1:{s:30:\"rocket_preload_process_pending\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:30:\"rocket_preload_process_pending\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1771427678;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1771427946;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"bd757ca2fc5d2e0ddd66905c9a4bdc7f\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:329;}}}}i:1771427969;a:1:{s:23:\"rocket_purge_time_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:34:\"rocket_expired_cache_cron_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1771428429;a:1:{s:32:\"duplicator_backup_storages_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:41:\"duplicator_backup_storages_check_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:900;}}}i:1771428460;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1771428461;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1771428466;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1771430813;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1771434703;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"8797c94e93fad722f2dd0a9a704fd268\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:330;}}}}i:1771456111;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1771457228;a:1:{s:24:\"depicter_check_authorize\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1771457263;a:1:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1771459612;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1771461412;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1771463212;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1771464029;a:1:{s:37:\"rocket_preload_revert_old_failed_rows\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:29:\"rocket_revert_old_failed_rows\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1771474620;a:1:{s:29:\"mc4wp_refresh_mailchimp_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1771499213;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1771499311;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1771499312;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1771499392;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1771500428;a:1:{s:27:\"depicter_collect_usage_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1771500460;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1771507168;a:1:{s:32:\"rocket_performance_hints_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1771513929;a:1:{s:31:\"duplicator_activity_log_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"duplicator_daily_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1771679968;a:1:{s:30:\"rocket_remove_saas_failed_jobs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:30:\"rocket_remove_saas_failed_jobs\";s:4:\"args\";a:0:{}s:8:\"interval\";i:259200;}}}i:1771855200;a:1:{s:33:\"duplicator_pro_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1771931213;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1772002784;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1772017613;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1772025568;a:2:{s:27:\"rocket_update_dynamic_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:33:\"rocket_saas_clean_rows_time_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1772026168;a:1:{s:36:\"rocket_preload_clean_rows_time_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","on"),
("2","siteurl","https://leg.miklub.fr","on"),
("3","home","https://leg.miklub.fr","on"),
("4","blogname","Legg","on"),
("5","blogdescription","","on"),
("6","users_can_register","0","on"),
("7","admin_email","hedi.chqir@gmail.com","on"),
("8","start_of_week","1","on"),
("9","use_balanceTags","0","on"),
("10","use_smilies","1","on"),
("11","require_name_email","1","on"),
("12","comments_notify","1","on"),
("13","posts_per_rss","10","on"),
("14","rss_use_excerpt","1","on"),
("15","mailserver_url","mail.example.com","on"),
("16","mailserver_login","login@example.com","on"),
("17","mailserver_pass","","on"),
("18","mailserver_port","110","on"),
("19","default_category","1","on"),
("20","default_comment_status","open","on"),
("21","default_ping_status","open","on"),
("22","default_pingback_flag","1","on"),
("23","posts_per_page","10","on"),
("24","date_format","F j, Y","on"),
("25","time_format","g:i a","on"),
("26","links_updated_date_format","F j, Y g:i a","on"),
("27","comment_moderation","0","on"),
("28","moderation_notify","1","on"),
("29","permalink_structure","/%postname%/","on"),
("30","rewrite_rules","a:296:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:11:\"boutique/?$\";s:27:\"index.php?post_type=product\";s:41:\"boutique/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:36:\"boutique/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:28:\"boutique/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:10:\"faq/all/?$\";s:23:\"index.php?post_type=faq\";s:40:\"faq/all/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?post_type=faq&feed=$matches[1]\";s:35:\"faq/all/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?post_type=faq&feed=$matches[1]\";s:27:\"faq/all/page/([0-9]{1,})/?$\";s:41:\"index.php?post_type=faq&paged=$matches[1]\";s:15:\"^checkout-link$\";s:28:\"index.php?checkout-link=true\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:55:\"e-floating-buttons/([^/]+)/wc/file/transient(/(.*))?/?$\";s:70:\"index.php?e-floating-buttons=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"e-floating-buttons/([^/]+)/wc-api(/(.*))?/?$\";s:59:\"index.php?e-floating-buttons=$matches[1]&wc-api=$matches[3]\";s:61:\"e-floating-buttons/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:72:\"e-floating-buttons/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:50:\"e-floating-buttons/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"e-floating-buttons/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:47:\"elementor_component/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"elementor_component/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"elementor_component/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"elementor_component/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"elementor_component/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"elementor_component/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:36:\"elementor_component/([^/]+)/embed/?$\";s:52:\"index.php?elementor_component=$matches[1]&embed=true\";s:40:\"elementor_component/([^/]+)/trackback/?$\";s:46:\"index.php?elementor_component=$matches[1]&tb=1\";s:48:\"elementor_component/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?elementor_component=$matches[1]&paged=$matches[2]\";s:55:\"elementor_component/([^/]+)/comment-page-([0-9]{1,})/?$\";s:59:\"index.php?elementor_component=$matches[1]&cpage=$matches[2]\";s:56:\"elementor_component/([^/]+)/wc/file/transient(/(.*))?/?$\";s:71:\"index.php?elementor_component=$matches[1]&wc/file/transient=$matches[3]\";s:45:\"elementor_component/([^/]+)/wc-api(/(.*))?/?$\";s:60:\"index.php?elementor_component=$matches[1]&wc-api=$matches[3]\";s:62:\"elementor_component/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:73:\"elementor_component/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:51:\"elementor_component/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:62:\"elementor_component/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:44:\"elementor_component/([^/]+)(?:/([0-9]+))?/?$\";s:58:\"index.php?elementor_component=$matches[1]&page=$matches[2]\";s:36:\"elementor_component/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"elementor_component/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"elementor_component/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"elementor_component/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"elementor_component/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"elementor_component/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:45:\"marque/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:40:\"marque/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:21:\"marque/(.+?)/embed/?$\";s:46:\"index.php?product_brand=$matches[1]&embed=true\";s:33:\"marque/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&paged=$matches[2]\";s:15:\"marque/(.+?)/?$\";s:35:\"index.php?product_brand=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"produit/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"produit/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"produit/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"produit/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"produit/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"produit/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"produit/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"produit/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"produit/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"produit/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"produit/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"produit/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:44:\"produit/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"produit/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:50:\"produit/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"produit/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"produit/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"produit/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"produit/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"produit/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"produit/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"produit/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"produit/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"produit/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"produit/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"faq/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"faq/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"faq/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"faq/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"faq/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"faq/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:20:\"faq/([^/]+)/embed/?$\";s:36:\"index.php?faq=$matches[1]&embed=true\";s:24:\"faq/([^/]+)/trackback/?$\";s:30:\"index.php?faq=$matches[1]&tb=1\";s:44:\"faq/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?faq=$matches[1]&feed=$matches[2]\";s:39:\"faq/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?faq=$matches[1]&feed=$matches[2]\";s:32:\"faq/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?faq=$matches[1]&paged=$matches[2]\";s:39:\"faq/([^/]+)/comment-page-([0-9]{1,})/?$\";s:43:\"index.php?faq=$matches[1]&cpage=$matches[2]\";s:40:\"faq/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?faq=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"faq/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?faq=$matches[1]&wc-api=$matches[3]\";s:46:\"faq/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:57:\"faq/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:35:\"faq/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:46:\"faq/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:28:\"faq/([^/]+)(?:/([0-9]+))?/?$\";s:42:\"index.php?faq=$matches[1]&page=$matches[2]\";s:20:\"faq/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:30:\"faq/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:50:\"faq/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:45:\"faq/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:45:\"faq/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:26:\"faq/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:51:\"faq-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?faq-category=$matches[1]&feed=$matches[2]\";s:46:\"faq-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?faq-category=$matches[1]&feed=$matches[2]\";s:27:\"faq-category/(.+?)/embed/?$\";s:45:\"index.php?faq-category=$matches[1]&embed=true\";s:39:\"faq-category/(.+?)/page/?([0-9]{1,})/?$\";s:52:\"index.php?faq-category=$matches[1]&paged=$matches[2]\";s:21:\"faq-category/(.+?)/?$\";s:34:\"index.php?faq-category=$matches[1]\";s:63:\"berocket_taxonomy_data/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:61:\"index.php?berocket_taxonomy_data=$matches[1]&feed=$matches[2]\";s:58:\"berocket_taxonomy_data/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:61:\"index.php?berocket_taxonomy_data=$matches[1]&feed=$matches[2]\";s:39:\"berocket_taxonomy_data/([^/]+)/embed/?$\";s:55:\"index.php?berocket_taxonomy_data=$matches[1]&embed=true\";s:51:\"berocket_taxonomy_data/([^/]+)/page/?([0-9]{1,})/?$\";s:62:\"index.php?berocket_taxonomy_data=$matches[1]&paged=$matches[2]\";s:33:\"berocket_taxonomy_data/([^/]+)/?$\";s:44:\"index.php?berocket_taxonomy_data=$matches[1]\";s:38:\"mc4wp-form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"mc4wp-form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"mc4wp-form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"mc4wp-form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"mc4wp-form/([^/]+)/embed/?$\";s:43:\"index.php?mc4wp-form=$matches[1]&embed=true\";s:31:\"mc4wp-form/([^/]+)/trackback/?$\";s:37:\"index.php?mc4wp-form=$matches[1]&tb=1\";s:39:\"mc4wp-form/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&paged=$matches[2]\";s:46:\"mc4wp-form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&cpage=$matches[2]\";s:47:\"mc4wp-form/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?mc4wp-form=$matches[1]&wc/file/transient=$matches[3]\";s:36:\"mc4wp-form/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?mc4wp-form=$matches[1]&wc-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:64:\"mc4wp-form/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"mc4wp-form/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:35:\"mc4wp-form/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?mc4wp-form=$matches[1]&page=$matches[2]\";s:27:\"mc4wp-form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"mc4wp-form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"mc4wp-form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"mc4wp-form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:23:\"index.php?sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=152&cpage=$matches[1]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","on"),
("31","hack_file","0","on"),
("32","blog_charset","UTF-8","on"),
("33","moderation_keys","","off"),
("34","active_plugins","a:13:{i:0;s:33:\"auxin-elements/auxin-elements.php\";i:1;s:35:\"auxin-pro-tools/auxin-pro-tools.php\";i:2;s:25:\"auxin-shop/auxin-shop.php\";i:3;s:36:\"contact-form-7/wp-contact-form-7.php\";i:4;s:21:\"depicter/depicter.php\";i:5;s:32:\"duplicate-page/duplicatepage.php\";i:6;s:33:\"duplicator-pro/duplicator-pro.php\";i:7;s:23:\"elementor/elementor.php\";i:8;s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";i:9;s:29:\"masterslider/masterslider.php\";i:10;s:63:\"minmax-quantity-for-woocommerce/woocommerce-minmax-quantity.php\";i:11;s:27:\"woocommerce/woocommerce.php\";i:12;s:23:\"wp-rocket/wp-rocket.php\";}","on"),
("35","category_base","","on"),
("36","ping_sites","https://rpc.pingomatic.com/","on"),
("37","comment_max_links","2","on"),
("38","gmt_offset","0","on"),
("39","default_email_category","1","on"),
("40","recently_edited","","off"),
("41","template","phlox-pro","on"),
("42","stylesheet","phlox-pro","on"),
("43","comment_registration","0","on"),
("44","html_type","text/html","on"),
("45","use_trackback","0","on"),
("46","default_role","subscriber","on"),
("47","db_version","60717","on"),
("48","uploads_use_yearmonth_folders","1","on"),
("49","upload_path","","on"),
("50","blog_public","1","on"),
("51","default_link_category","2","on"),
("52","show_on_front","page","on"),
("53","tag_base","","on"),
("54","show_avatars","1","on"),
("55","avatar_rating","G","on"),
("56","upload_url_path","","on"),
("57","thumbnail_size_w","150","on"),
("58","thumbnail_size_h","150","on"),
("59","thumbnail_crop","1","on"),
("60","medium_size_w","300","on"),
("61","medium_size_h","300","on"),
("62","avatar_default","mystery","on"),
("63","large_size_w","1024","on"),
("64","large_size_h","1024","on"),
("65","image_default_link_type","none","on"),
("66","image_default_size","","on"),
("67","image_default_align","","on"),
("68","close_comments_for_old_posts","0","on"),
("69","close_comments_days_old","14","on"),
("70","thread_comments","1","on"),
("71","thread_comments_depth","5","on"),
("72","page_comments","0","on"),
("73","comments_per_page","50","on"),
("74","default_comments_page","newest","on"),
("75","comment_order","asc","on"),
("76","sticky_posts","a:0:{}","on"),
("77","widget_categories","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","auto"),
("78","widget_text","a:3:{i:1;a:0:{}i:2;a:4:{s:5:\"title\";s:7:\"Contact\";s:4:\"text\";s:110:\"Patricia C. Amedee 4401 Waldeck Street\nGrapevine Nashville, TX 76051\n\ninfo@yourdomain.com\n+99 (0) 101 0000 888\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}","on"),
("79","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","auto"),
("80","uninstall_plugins","a:3:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:63:\"minmax-quantity-for-woocommerce/woocommerce-minmax-quantity.php\";a:2:{i:0;s:20:\"BeRocket_MM_Quantity\";i:1;s:12:\"deactivation\";}s:35:\"litespeed-cache/litespeed-cache.php\";s:47:\"LiteSpeed\\Activation::uninstall_litespeed_cache\";}","off"),
("81","timezone_string","","on"),
("82","page_for_posts","0","on"),
("83","page_on_front","152","on"),
("84","default_post_format","0","on"),
("85","link_manager_enabled","0","on"),
("86","finished_splitting_shared_terms","1","on"),
("87","site_icon","0","on"),
("88","medium_large_size_w","768","on"),
("89","medium_large_size_h","768","on"),
("90","wp_page_for_privacy_policy","274","on"),
("91","show_comments_cookies_opt_in","1","on"),
("92","admin_email_lifespan","1786878412","on"),
("93","disallowed_keys","","off"),
("94","comment_previously_approved","1","on"),
("95","auto_plugin_theme_update_emails","a:0:{}","off"),
("96","auto_update_core_dev","enabled","on"),
("97","auto_update_core_minor","enabled","on"),
("98","auto_update_core_major","enabled","on"),
("99","wp_force_deactivated_plugins","a:0:{}","on"),
("100","wp_attachment_pages_enabled","0","on"),
("101","wp_notes_notify","1","on"),
("102","initial_db_version","60717","on"),
("103","wp_user_roles","a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:174:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:8:\"edit_faq\";b:1;s:8:\"read_faq\";b:1;s:10:\"delete_faq\";b:1;s:9:\"edit_faqs\";b:1;s:16:\"edit_others_faqs\";b:1;s:12:\"publish_faqs\";b:1;s:17:\"read_private_faqs\";b:1;s:11:\"delete_faqs\";b:1;s:19:\"delete_private_faqs\";b:1;s:21:\"delete_published_faqs\";b:1;s:18:\"delete_others_faqs\";b:1;s:17:\"edit_private_faqs\";b:1;s:19:\"edit_published_faqs\";b:1;s:16:\"manage_faq_terms\";b:1;s:14:\"edit_faq_terms\";b:1;s:16:\"delete_faq_terms\";b:1;s:16:\"assign_faq_terms\";b:1;s:15:\"access_depicter\";b:1;s:13:\"edit_depicter\";b:1;s:20:\"edit_others_depicter\";b:1;s:16:\"publish_depicter\";b:1;s:15:\"delete_depicter\";b:1;s:22:\"delete_others_depicter\";b:1;s:15:\"create_depicter\";b:1;s:15:\"import_depicter\";b:1;s:15:\"export_depicter\";b:1;s:18:\"duplicate_depicter\";b:1;s:15:\"manage_depicter\";b:1;s:18:\"manage_woocommerce\";b:1;s:16:\"create_customers\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:19:\"access_masterslider\";b:1;s:20:\"publish_masterslider\";b:1;s:19:\"delete_masterslider\";b:1;s:19:\"create_masterslider\";b:1;s:19:\"export_masterslider\";b:1;s:22:\"duplicate_masterslider\";b:1;s:15:\"manage_berocket\";b:1;s:23:\"manage_berocket_account\";b:1;s:9:\"edit_post\";b:1;s:9:\"read_post\";b:1;s:11:\"delete_post\";b:1;s:10:\"loco_admin\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:20:\"duplicator_pro_basic\";b:1;s:21:\"duplicator_pro_create\";b:1;s:23:\"duplicator_pro_schedule\";b:1;s:22:\"duplicator_pro_storage\";b:1;s:29:\"duplicator_pro_backup_restore\";b:1;s:21:\"duplicator_pro_import\";b:1;s:21:\"duplicator_pro_export\";b:1;s:23:\"duplicator_pro_settings\";b:1;s:22:\"duplicator_pro_license\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:68:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:8:\"edit_faq\";b:1;s:8:\"read_faq\";b:1;s:10:\"delete_faq\";b:1;s:9:\"edit_faqs\";b:1;s:16:\"edit_others_faqs\";b:1;s:12:\"publish_faqs\";b:1;s:17:\"read_private_faqs\";b:1;s:11:\"delete_faqs\";b:1;s:19:\"delete_private_faqs\";b:1;s:21:\"delete_published_faqs\";b:1;s:18:\"delete_others_faqs\";b:1;s:17:\"edit_private_faqs\";b:1;s:19:\"edit_published_faqs\";b:1;s:16:\"manage_faq_terms\";b:1;s:14:\"edit_faq_terms\";b:1;s:16:\"delete_faq_terms\";b:1;s:16:\"assign_faq_terms\";b:1;s:15:\"access_depicter\";b:1;s:13:\"edit_depicter\";b:1;s:20:\"edit_others_depicter\";b:1;s:16:\"publish_depicter\";b:1;s:15:\"delete_depicter\";b:1;s:22:\"delete_others_depicter\";b:1;s:15:\"create_depicter\";b:1;s:15:\"import_depicter\";b:1;s:15:\"export_depicter\";b:1;s:18:\"duplicate_depicter\";b:1;s:15:\"manage_depicter\";b:1;s:19:\"access_masterslider\";b:1;s:20:\"publish_masterslider\";b:1;s:19:\"delete_masterslider\";b:1;s:19:\"create_masterslider\";b:1;s:19:\"export_masterslider\";b:1;s:22:\"duplicate_masterslider\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:93:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:16:\"create_customers\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:10:\"translator\";a:2:{s:4:\"name\";s:10:\"Translator\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:10:\"loco_admin\";b:1;}}}","on"),
("104","fresh_site","0","off"),
("105","user_count","2","off"),
("106","widget_block","a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}","auto"),
("107","sidebars_widgets","a:13:{s:40:\"auxin-global-primary-sidebar-widget-area\";a:3:{i:0;s:32:\"woocommerce_top_rated_products-2\";i:1;s:32:\"woocommerce_product_categories-2\";i:2;s:26:\"woocommerce_price_filter-2\";}s:42:\"auxin-global-secondary-sidebar-widget-area\";a:0:{}s:39:\"auxin-pages-primary-sidebar-widget-area\";a:0:{}s:41:\"auxin-pages-secondary-sidebar-widget-area\";a:0:{}s:38:\"auxin-blog-primary-sidebar-widget-area\";a:0:{}s:40:\"auxin-blog-secondary-sidebar-widget-area\";a:0:{}s:32:\"auxin-search-sidebar-widget-area\";a:0:{}s:31:\"auxin-subfooter-bar-widget-area\";a:0:{}s:33:\"auxin-footer1-sidebar-widget-area\";a:1:{i:0;s:10:\"nav_menu-2\";}s:33:\"auxin-footer2-sidebar-widget-area\";a:1:{i:0;s:10:\"nav_menu-3\";}s:33:\"auxin-footer3-sidebar-widget-area\";a:1:{i:0;s:6:\"text-2\";}s:33:\"auxin-footer4-sidebar-widget-area\";a:1:{i:0;s:19:\"mc4wp_form_widget-2\";}s:13:\"array_version\";i:3;}","auto"),
("108","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("109","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("110","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("111","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("112","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("113","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("114","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("115","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("116","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("117","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("118","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("119","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("120","widget_nav_menu","a:3:{i:2;a:2:{s:5:\"title\";s:11:\"INFORMATION\";s:8:\"nav_menu\";i:47;}i:3;a:2:{s:5:\"title\";s:10:\"MY ACCOUNT\";s:8:\"nav_menu\";i:48;}s:12:\"_multiwidget\";i:1;}","auto"),
("121","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("122","_transient_wp_core_block_css_files","a:2:{s:7:\"version\";s:5:\"6.9.1\";s:5:\"files\";a:584:{i:0;s:31:\"accordion-heading/style-rtl.css\";i:1;s:35:\"accordion-heading/style-rtl.min.css\";i:2;s:27:\"accordion-heading/style.css\";i:3;s:31:\"accordion-heading/style.min.css\";i:4;s:28:\"accordion-item/style-rtl.css\";i:5;s:32:\"accordion-item/style-rtl.min.css\";i:6;s:24:\"accordion-item/style.css\";i:7;s:28:\"accordion-item/style.min.css\";i:8;s:29:\"accordion-panel/style-rtl.css\";i:9;s:33:\"accordion-panel/style-rtl.min.css\";i:10;s:25:\"accordion-panel/style.css\";i:11;s:29:\"accordion-panel/style.min.css\";i:12;s:23:\"accordion/style-rtl.css\";i:13;s:27:\"accordion/style-rtl.min.css\";i:14;s:19:\"accordion/style.css\";i:15;s:23:\"accordion/style.min.css\";i:16;s:23:\"archives/editor-rtl.css\";i:17;s:27:\"archives/editor-rtl.min.css\";i:18;s:19:\"archives/editor.css\";i:19;s:23:\"archives/editor.min.css\";i:20;s:22:\"archives/style-rtl.css\";i:21;s:26:\"archives/style-rtl.min.css\";i:22;s:18:\"archives/style.css\";i:23;s:22:\"archives/style.min.css\";i:24;s:20:\"audio/editor-rtl.css\";i:25;s:24:\"audio/editor-rtl.min.css\";i:26;s:16:\"audio/editor.css\";i:27;s:20:\"audio/editor.min.css\";i:28;s:19:\"audio/style-rtl.css\";i:29;s:23:\"audio/style-rtl.min.css\";i:30;s:15:\"audio/style.css\";i:31;s:19:\"audio/style.min.css\";i:32;s:19:\"audio/theme-rtl.css\";i:33;s:23:\"audio/theme-rtl.min.css\";i:34;s:15:\"audio/theme.css\";i:35;s:19:\"audio/theme.min.css\";i:36;s:21:\"avatar/editor-rtl.css\";i:37;s:25:\"avatar/editor-rtl.min.css\";i:38;s:17:\"avatar/editor.css\";i:39;s:21:\"avatar/editor.min.css\";i:40;s:20:\"avatar/style-rtl.css\";i:41;s:24:\"avatar/style-rtl.min.css\";i:42;s:16:\"avatar/style.css\";i:43;s:20:\"avatar/style.min.css\";i:44;s:21:\"button/editor-rtl.css\";i:45;s:25:\"button/editor-rtl.min.css\";i:46;s:17:\"button/editor.css\";i:47;s:21:\"button/editor.min.css\";i:48;s:20:\"button/style-rtl.css\";i:49;s:24:\"button/style-rtl.min.css\";i:50;s:16:\"button/style.css\";i:51;s:20:\"button/style.min.css\";i:52;s:22:\"buttons/editor-rtl.css\";i:53;s:26:\"buttons/editor-rtl.min.css\";i:54;s:18:\"buttons/editor.css\";i:55;s:22:\"buttons/editor.min.css\";i:56;s:21:\"buttons/style-rtl.css\";i:57;s:25:\"buttons/style-rtl.min.css\";i:58;s:17:\"buttons/style.css\";i:59;s:21:\"buttons/style.min.css\";i:60;s:22:\"calendar/style-rtl.css\";i:61;s:26:\"calendar/style-rtl.min.css\";i:62;s:18:\"calendar/style.css\";i:63;s:22:\"calendar/style.min.css\";i:64;s:25:\"categories/editor-rtl.css\";i:65;s:29:\"categories/editor-rtl.min.css\";i:66;s:21:\"categories/editor.css\";i:67;s:25:\"categories/editor.min.css\";i:68;s:24:\"categories/style-rtl.css\";i:69;s:28:\"categories/style-rtl.min.css\";i:70;s:20:\"categories/style.css\";i:71;s:24:\"categories/style.min.css\";i:72;s:19:\"code/editor-rtl.css\";i:73;s:23:\"code/editor-rtl.min.css\";i:74;s:15:\"code/editor.css\";i:75;s:19:\"code/editor.min.css\";i:76;s:18:\"code/style-rtl.css\";i:77;s:22:\"code/style-rtl.min.css\";i:78;s:14:\"code/style.css\";i:79;s:18:\"code/style.min.css\";i:80;s:18:\"code/theme-rtl.css\";i:81;s:22:\"code/theme-rtl.min.css\";i:82;s:14:\"code/theme.css\";i:83;s:18:\"code/theme.min.css\";i:84;s:22:\"columns/editor-rtl.css\";i:85;s:26:\"columns/editor-rtl.min.css\";i:86;s:18:\"columns/editor.css\";i:87;s:22:\"columns/editor.min.css\";i:88;s:21:\"columns/style-rtl.css\";i:89;s:25:\"columns/style-rtl.min.css\";i:90;s:17:\"columns/style.css\";i:91;s:21:\"columns/style.min.css\";i:92;s:33:\"comment-author-name/style-rtl.css\";i:93;s:37:\"comment-author-name/style-rtl.min.css\";i:94;s:29:\"comment-author-name/style.css\";i:95;s:33:\"comment-author-name/style.min.css\";i:96;s:29:\"comment-content/style-rtl.css\";i:97;s:33:\"comment-content/style-rtl.min.css\";i:98;s:25:\"comment-content/style.css\";i:99;s:29:\"comment-content/style.min.css\";i:100;s:26:\"comment-date/style-rtl.css\";i:101;s:30:\"comment-date/style-rtl.min.css\";i:102;s:22:\"comment-date/style.css\";i:103;s:26:\"comment-date/style.min.css\";i:104;s:31:\"comment-edit-link/style-rtl.css\";i:105;s:35:\"comment-edit-link/style-rtl.min.css\";i:106;s:27:\"comment-edit-link/style.css\";i:107;s:31:\"comment-edit-link/style.min.css\";i:108;s:32:\"comment-reply-link/style-rtl.css\";i:109;s:36:\"comment-reply-link/style-rtl.min.css\";i:110;s:28:\"comment-reply-link/style.css\";i:111;s:32:\"comment-reply-link/style.min.css\";i:112;s:30:\"comment-template/style-rtl.css\";i:113;s:34:\"comment-template/style-rtl.min.css\";i:114;s:26:\"comment-template/style.css\";i:115;s:30:\"comment-template/style.min.css\";i:116;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:117;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:118;s:38:\"comments-pagination-numbers/editor.css\";i:119;s:42:\"comments-pagination-numbers/editor.min.css\";i:120;s:34:\"comments-pagination/editor-rtl.css\";i:121;s:38:\"comments-pagination/editor-rtl.min.css\";i:122;s:30:\"comments-pagination/editor.css\";i:123;s:34:\"comments-pagination/editor.min.css\";i:124;s:33:\"comments-pagination/style-rtl.css\";i:125;s:37:\"comments-pagination/style-rtl.min.css\";i:126;s:29:\"comments-pagination/style.css\";i:127;s:33:\"comments-pagination/style.min.css\";i:128;s:29:\"comments-title/editor-rtl.css\";i:129;s:33:\"comments-title/editor-rtl.min.css\";i:130;s:25:\"comments-title/editor.css\";i:131;s:29:\"comments-title/editor.min.css\";i:132;s:23:\"comments/editor-rtl.css\";i:133;s:27:\"comments/editor-rtl.min.css\";i:134;s:19:\"comments/editor.css\";i:135;s:23:\"comments/editor.min.css\";i:136;s:22:\"comments/style-rtl.css\";i:137;s:26:\"comments/style-rtl.min.css\";i:138;s:18:\"comments/style.css\";i:139;s:22:\"comments/style.min.css\";i:140;s:20:\"cover/editor-rtl.css\";i:141;s:24:\"cover/editor-rtl.min.css\";i:142;s:16:\"cover/editor.css\";i:143;s:20:\"cover/editor.min.css\";i:144;s:19:\"cover/style-rtl.css\";i:145;s:23:\"cover/style-rtl.min.css\";i:146;s:15:\"cover/style.css\";i:147;s:19:\"cover/style.min.css\";i:148;s:22:\"details/editor-rtl.css\";i:149;s:26:\"details/editor-rtl.min.css\";i:150;s:18:\"details/editor.css\";i:151;s:22:\"details/editor.min.css\";i:152;s:21:\"details/style-rtl.css\";i:153;s:25:\"details/style-rtl.min.css\";i:154;s:17:\"details/style.css\";i:155;s:21:\"details/style.min.css\";i:156;s:20:\"embed/editor-rtl.css\";i:157;s:24:\"embed/editor-rtl.min.css\";i:158;s:16:\"embed/editor.css\";i:159;s:20:\"embed/editor.min.css\";i:160;s:19:\"embed/style-rtl.css\";i:161;s:23:\"embed/style-rtl.min.css\";i:162;s:15:\"embed/style.css\";i:163;s:19:\"embed/style.min.css\";i:164;s:19:\"embed/theme-rtl.css\";i:165;s:23:\"embed/theme-rtl.min.css\";i:166;s:15:\"embed/theme.css\";i:167;s:19:\"embed/theme.min.css\";i:168;s:19:\"file/editor-rtl.css\";i:169;s:23:\"file/editor-rtl.min.css\";i:170;s:15:\"file/editor.css\";i:171;s:19:\"file/editor.min.css\";i:172;s:18:\"file/style-rtl.css\";i:173;s:22:\"file/style-rtl.min.css\";i:174;s:14:\"file/style.css\";i:175;s:18:\"file/style.min.css\";i:176;s:23:\"footnotes/style-rtl.css\";i:177;s:27:\"footnotes/style-rtl.min.css\";i:178;s:19:\"footnotes/style.css\";i:179;s:23:\"footnotes/style.min.css\";i:180;s:23:\"freeform/editor-rtl.css\";i:181;s:27:\"freeform/editor-rtl.min.css\";i:182;s:19:\"freeform/editor.css\";i:183;s:23:\"freeform/editor.min.css\";i:184;s:22:\"gallery/editor-rtl.css\";i:185;s:26:\"gallery/editor-rtl.min.css\";i:186;s:18:\"gallery/editor.css\";i:187;s:22:\"gallery/editor.min.css\";i:188;s:21:\"gallery/style-rtl.css\";i:189;s:25:\"gallery/style-rtl.min.css\";i:190;s:17:\"gallery/style.css\";i:191;s:21:\"gallery/style.min.css\";i:192;s:21:\"gallery/theme-rtl.css\";i:193;s:25:\"gallery/theme-rtl.min.css\";i:194;s:17:\"gallery/theme.css\";i:195;s:21:\"gallery/theme.min.css\";i:196;s:20:\"group/editor-rtl.css\";i:197;s:24:\"group/editor-rtl.min.css\";i:198;s:16:\"group/editor.css\";i:199;s:20:\"group/editor.min.css\";i:200;s:19:\"group/style-rtl.css\";i:201;s:23:\"group/style-rtl.min.css\";i:202;s:15:\"group/style.css\";i:203;s:19:\"group/style.min.css\";i:204;s:19:\"group/theme-rtl.css\";i:205;s:23:\"group/theme-rtl.min.css\";i:206;s:15:\"group/theme.css\";i:207;s:19:\"group/theme.min.css\";i:208;s:21:\"heading/style-rtl.css\";i:209;s:25:\"heading/style-rtl.min.css\";i:210;s:17:\"heading/style.css\";i:211;s:21:\"heading/style.min.css\";i:212;s:19:\"html/editor-rtl.css\";i:213;s:23:\"html/editor-rtl.min.css\";i:214;s:15:\"html/editor.css\";i:215;s:19:\"html/editor.min.css\";i:216;s:20:\"image/editor-rtl.css\";i:217;s:24:\"image/editor-rtl.min.css\";i:218;s:16:\"image/editor.css\";i:219;s:20:\"image/editor.min.css\";i:220;s:19:\"image/style-rtl.css\";i:221;s:23:\"image/style-rtl.min.css\";i:222;s:15:\"image/style.css\";i:223;s:19:\"image/style.min.css\";i:224;s:19:\"image/theme-rtl.css\";i:225;s:23:\"image/theme-rtl.min.css\";i:226;s:15:\"image/theme.css\";i:227;s:19:\"image/theme.min.css\";i:228;s:29:\"latest-comments/style-rtl.css\";i:229;s:33:\"latest-comments/style-rtl.min.css\";i:230;s:25:\"latest-comments/style.css\";i:231;s:29:\"latest-comments/style.min.css\";i:232;s:27:\"latest-posts/editor-rtl.css\";i:233;s:31:\"latest-posts/editor-rtl.min.css\";i:234;s:23:\"latest-posts/editor.css\";i:235;s:27:\"latest-posts/editor.min.css\";i:236;s:26:\"latest-posts/style-rtl.css\";i:237;s:30:\"latest-posts/style-rtl.min.css\";i:238;s:22:\"latest-posts/style.css\";i:239;s:26:\"latest-posts/style.min.css\";i:240;s:18:\"list/style-rtl.css\";i:241;s:22:\"list/style-rtl.min.css\";i:242;s:14:\"list/style.css\";i:243;s:18:\"list/style.min.css\";i:244;s:22:\"loginout/style-rtl.css\";i:245;s:26:\"loginout/style-rtl.min.css\";i:246;s:18:\"loginout/style.css\";i:247;s:22:\"loginout/style.min.css\";i:248;s:19:\"math/editor-rtl.css\";i:249;s:23:\"math/editor-rtl.min.css\";i:250;s:15:\"math/editor.css\";i:251;s:19:\"math/editor.min.css\";i:252;s:18:\"math/style-rtl.css\";i:253;s:22:\"math/style-rtl.min.css\";i:254;s:14:\"math/style.css\";i:255;s:18:\"math/style.min.css\";i:256;s:25:\"media-text/editor-rtl.css\";i:257;s:29:\"media-text/editor-rtl.min.css\";i:258;s:21:\"media-text/editor.css\";i:259;s:25:\"media-text/editor.min.css\";i:260;s:24:\"media-text/style-rtl.css\";i:261;s:28:\"media-text/style-rtl.min.css\";i:262;s:20:\"media-text/style.css\";i:263;s:24:\"media-text/style.min.css\";i:264;s:19:\"more/editor-rtl.css\";i:265;s:23:\"more/editor-rtl.min.css\";i:266;s:15:\"more/editor.css\";i:267;s:19:\"more/editor.min.css\";i:268;s:30:\"navigation-link/editor-rtl.css\";i:269;s:34:\"navigation-link/editor-rtl.min.css\";i:270;s:26:\"navigation-link/editor.css\";i:271;s:30:\"navigation-link/editor.min.css\";i:272;s:29:\"navigation-link/style-rtl.css\";i:273;s:33:\"navigation-link/style-rtl.min.css\";i:274;s:25:\"navigation-link/style.css\";i:275;s:29:\"navigation-link/style.min.css\";i:276;s:33:\"navigation-submenu/editor-rtl.css\";i:277;s:37:\"navigation-submenu/editor-rtl.min.css\";i:278;s:29:\"navigation-submenu/editor.css\";i:279;s:33:\"navigation-submenu/editor.min.css\";i:280;s:25:\"navigation/editor-rtl.css\";i:281;s:29:\"navigation/editor-rtl.min.css\";i:282;s:21:\"navigation/editor.css\";i:283;s:25:\"navigation/editor.min.css\";i:284;s:24:\"navigation/style-rtl.css\";i:285;s:28:\"navigation/style-rtl.min.css\";i:286;s:20:\"navigation/style.css\";i:287;s:24:\"navigation/style.min.css\";i:288;s:23:\"nextpage/editor-rtl.css\";i:289;s:27:\"nextpage/editor-rtl.min.css\";i:290;s:19:\"nextpage/editor.css\";i:291;s:23:\"nextpage/editor.min.css\";i:292;s:24:\"page-list/editor-rtl.css\";i:293;s:28:\"page-list/editor-rtl.min.css\";i:294;s:20:\"page-list/editor.css\";i:295;s:24:\"page-list/editor.min.css\";i:296;s:23:\"page-list/style-rtl.css\";i:297;s:27:\"page-list/style-rtl.min.css\";i:298;s:19:\"page-list/style.css\";i:299;s:23:\"page-list/style.min.css\";i:300;s:24:\"paragraph/editor-rtl.css\";i:301;s:28:\"paragraph/editor-rtl.min.css\";i:302;s:20:\"paragraph/editor.css\";i:303;s:24:\"paragraph/editor.min.css\";i:304;s:23:\"paragraph/style-rtl.css\";i:305;s:27:\"paragraph/style-rtl.min.css\";i:306;s:19:\"paragraph/style.css\";i:307;s:23:\"paragraph/style.min.css\";i:308;s:35:\"post-author-biography/style-rtl.css\";i:309;s:39:\"post-author-biography/style-rtl.min.css\";i:310;s:31:\"post-author-biography/style.css\";i:311;s:35:\"post-author-biography/style.min.css\";i:312;s:30:\"post-author-name/style-rtl.css\";i:313;s:34:\"post-author-name/style-rtl.min.css\";i:314;s:26:\"post-author-name/style.css\";i:315;s:30:\"post-author-name/style.min.css\";i:316;s:25:\"post-author/style-rtl.css\";i:317;s:29:\"post-author/style-rtl.min.css\";i:318;s:21:\"post-author/style.css\";i:319;s:25:\"post-author/style.min.css\";i:320;s:33:\"post-comments-count/style-rtl.css\";i:321;s:37:\"post-comments-count/style-rtl.min.css\";i:322;s:29:\"post-comments-count/style.css\";i:323;s:33:\"post-comments-count/style.min.css\";i:324;s:33:\"post-comments-form/editor-rtl.css\";i:325;s:37:\"post-comments-form/editor-rtl.min.css\";i:326;s:29:\"post-comments-form/editor.css\";i:327;s:33:\"post-comments-form/editor.min.css\";i:328;s:32:\"post-comments-form/style-rtl.css\";i:329;s:36:\"post-comments-form/style-rtl.min.css\";i:330;s:28:\"post-comments-form/style.css\";i:331;s:32:\"post-comments-form/style.min.css\";i:332;s:32:\"post-comments-link/style-rtl.css\";i:333;s:36:\"post-comments-link/style-rtl.min.css\";i:334;s:28:\"post-comments-link/style.css\";i:335;s:32:\"post-comments-link/style.min.css\";i:336;s:26:\"post-content/style-rtl.css\";i:337;s:30:\"post-content/style-rtl.min.css\";i:338;s:22:\"post-content/style.css\";i:339;s:26:\"post-content/style.min.css\";i:340;s:23:\"post-date/style-rtl.css\";i:341;s:27:\"post-date/style-rtl.min.css\";i:342;s:19:\"post-date/style.css\";i:343;s:23:\"post-date/style.min.css\";i:344;s:27:\"post-excerpt/editor-rtl.css\";i:345;s:31:\"post-excerpt/editor-rtl.min.css\";i:346;s:23:\"post-excerpt/editor.css\";i:347;s:27:\"post-excerpt/editor.min.css\";i:348;s:26:\"post-excerpt/style-rtl.css\";i:349;s:30:\"post-excerpt/style-rtl.min.css\";i:350;s:22:\"post-excerpt/style.css\";i:351;s:26:\"post-excerpt/style.min.css\";i:352;s:34:\"post-featured-image/editor-rtl.css\";i:353;s:38:\"post-featured-image/editor-rtl.min.css\";i:354;s:30:\"post-featured-image/editor.css\";i:355;s:34:\"post-featured-image/editor.min.css\";i:356;s:33:\"post-featured-image/style-rtl.css\";i:357;s:37:\"post-featured-image/style-rtl.min.css\";i:358;s:29:\"post-featured-image/style.css\";i:359;s:33:\"post-featured-image/style.min.css\";i:360;s:34:\"post-navigation-link/style-rtl.css\";i:361;s:38:\"post-navigation-link/style-rtl.min.css\";i:362;s:30:\"post-navigation-link/style.css\";i:363;s:34:\"post-navigation-link/style.min.css\";i:364;s:27:\"post-template/style-rtl.css\";i:365;s:31:\"post-template/style-rtl.min.css\";i:366;s:23:\"post-template/style.css\";i:367;s:27:\"post-template/style.min.css\";i:368;s:24:\"post-terms/style-rtl.css\";i:369;s:28:\"post-terms/style-rtl.min.css\";i:370;s:20:\"post-terms/style.css\";i:371;s:24:\"post-terms/style.min.css\";i:372;s:31:\"post-time-to-read/style-rtl.css\";i:373;s:35:\"post-time-to-read/style-rtl.min.css\";i:374;s:27:\"post-time-to-read/style.css\";i:375;s:31:\"post-time-to-read/style.min.css\";i:376;s:24:\"post-title/style-rtl.css\";i:377;s:28:\"post-title/style-rtl.min.css\";i:378;s:20:\"post-title/style.css\";i:379;s:24:\"post-title/style.min.css\";i:380;s:26:\"preformatted/style-rtl.css\";i:381;s:30:\"preformatted/style-rtl.min.css\";i:382;s:22:\"preformatted/style.css\";i:383;s:26:\"preformatted/style.min.css\";i:384;s:24:\"pullquote/editor-rtl.css\";i:385;s:28:\"pullquote/editor-rtl.min.css\";i:386;s:20:\"pullquote/editor.css\";i:387;s:24:\"pullquote/editor.min.css\";i:388;s:23:\"pullquote/style-rtl.css\";i:389;s:27:\"pullquote/style-rtl.min.css\";i:390;s:19:\"pullquote/style.css\";i:391;s:23:\"pullquote/style.min.css\";i:392;s:23:\"pullquote/theme-rtl.css\";i:393;s:27:\"pullquote/theme-rtl.min.css\";i:394;s:19:\"pullquote/theme.css\";i:395;s:23:\"pullquote/theme.min.css\";i:396;s:39:\"query-pagination-numbers/editor-rtl.css\";i:397;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:398;s:35:\"query-pagination-numbers/editor.css\";i:399;s:39:\"query-pagination-numbers/editor.min.css\";i:400;s:31:\"query-pagination/editor-rtl.css\";i:401;s:35:\"query-pagination/editor-rtl.min.css\";i:402;s:27:\"query-pagination/editor.css\";i:403;s:31:\"query-pagination/editor.min.css\";i:404;s:30:\"query-pagination/style-rtl.css\";i:405;s:34:\"query-pagination/style-rtl.min.css\";i:406;s:26:\"query-pagination/style.css\";i:407;s:30:\"query-pagination/style.min.css\";i:408;s:25:\"query-title/style-rtl.css\";i:409;s:29:\"query-title/style-rtl.min.css\";i:410;s:21:\"query-title/style.css\";i:411;s:25:\"query-title/style.min.css\";i:412;s:25:\"query-total/style-rtl.css\";i:413;s:29:\"query-total/style-rtl.min.css\";i:414;s:21:\"query-total/style.css\";i:415;s:25:\"query-total/style.min.css\";i:416;s:20:\"query/editor-rtl.css\";i:417;s:24:\"query/editor-rtl.min.css\";i:418;s:16:\"query/editor.css\";i:419;s:20:\"query/editor.min.css\";i:420;s:19:\"quote/style-rtl.css\";i:421;s:23:\"quote/style-rtl.min.css\";i:422;s:15:\"quote/style.css\";i:423;s:19:\"quote/style.min.css\";i:424;s:19:\"quote/theme-rtl.css\";i:425;s:23:\"quote/theme-rtl.min.css\";i:426;s:15:\"quote/theme.css\";i:427;s:19:\"quote/theme.min.css\";i:428;s:23:\"read-more/style-rtl.css\";i:429;s:27:\"read-more/style-rtl.min.css\";i:430;s:19:\"read-more/style.css\";i:431;s:23:\"read-more/style.min.css\";i:432;s:18:\"rss/editor-rtl.css\";i:433;s:22:\"rss/editor-rtl.min.css\";i:434;s:14:\"rss/editor.css\";i:435;s:18:\"rss/editor.min.css\";i:436;s:17:\"rss/style-rtl.css\";i:437;s:21:\"rss/style-rtl.min.css\";i:438;s:13:\"rss/style.css\";i:439;s:17:\"rss/style.min.css\";i:440;s:21:\"search/editor-rtl.css\";i:441;s:25:\"search/editor-rtl.min.css\";i:442;s:17:\"search/editor.css\";i:443;s:21:\"search/editor.min.css\";i:444;s:20:\"search/style-rtl.css\";i:445;s:24:\"search/style-rtl.min.css\";i:446;s:16:\"search/style.css\";i:447;s:20:\"search/style.min.css\";i:448;s:20:\"search/theme-rtl.css\";i:449;s:24:\"search/theme-rtl.min.css\";i:450;s:16:\"search/theme.css\";i:451;s:20:\"search/theme.min.css\";i:452;s:24:\"separator/editor-rtl.css\";i:453;s:28:\"separator/editor-rtl.min.css\";i:454;s:20:\"separator/editor.css\";i:455;s:24:\"separator/editor.min.css\";i:456;s:23:\"separator/style-rtl.css\";i:457;s:27:\"separator/style-rtl.min.css\";i:458;s:19:\"separator/style.css\";i:459;s:23:\"separator/style.min.css\";i:460;s:23:\"separator/theme-rtl.css\";i:461;s:27:\"separator/theme-rtl.min.css\";i:462;s:19:\"separator/theme.css\";i:463;s:23:\"separator/theme.min.css\";i:464;s:24:\"shortcode/editor-rtl.css\";i:465;s:28:\"shortcode/editor-rtl.min.css\";i:466;s:20:\"shortcode/editor.css\";i:467;s:24:\"shortcode/editor.min.css\";i:468;s:24:\"site-logo/editor-rtl.css\";i:469;s:28:\"site-logo/editor-rtl.min.css\";i:470;s:20:\"site-logo/editor.css\";i:471;s:24:\"site-logo/editor.min.css\";i:472;s:23:\"site-logo/style-rtl.css\";i:473;s:27:\"site-logo/style-rtl.min.css\";i:474;s:19:\"site-logo/style.css\";i:475;s:23:\"site-logo/style.min.css\";i:476;s:27:\"site-tagline/editor-rtl.css\";i:477;s:31:\"site-tagline/editor-rtl.min.css\";i:478;s:23:\"site-tagline/editor.css\";i:479;s:27:\"site-tagline/editor.min.css\";i:480;s:26:\"site-tagline/style-rtl.css\";i:481;s:30:\"site-tagline/style-rtl.min.css\";i:482;s:22:\"site-tagline/style.css\";i:483;s:26:\"site-tagline/style.min.css\";i:484;s:25:\"site-title/editor-rtl.css\";i:485;s:29:\"site-title/editor-rtl.min.css\";i:486;s:21:\"site-title/editor.css\";i:487;s:25:\"site-title/editor.min.css\";i:488;s:24:\"site-title/style-rtl.css\";i:489;s:28:\"site-title/style-rtl.min.css\";i:490;s:20:\"site-title/style.css\";i:491;s:24:\"site-title/style.min.css\";i:492;s:26:\"social-link/editor-rtl.css\";i:493;s:30:\"social-link/editor-rtl.min.css\";i:494;s:22:\"social-link/editor.css\";i:495;s:26:\"social-link/editor.min.css\";i:496;s:27:\"social-links/editor-rtl.css\";i:497;s:31:\"social-links/editor-rtl.min.css\";i:498;s:23:\"social-links/editor.css\";i:499;s:27:\"social-links/editor.min.css\";i:500;s:26:\"social-links/style-rtl.css\";i:501;s:30:\"social-links/style-rtl.min.css\";i:502;s:22:\"social-links/style.css\";i:503;s:26:\"social-links/style.min.css\";i:504;s:21:\"spacer/editor-rtl.css\";i:505;s:25:\"spacer/editor-rtl.min.css\";i:506;s:17:\"spacer/editor.css\";i:507;s:21:\"spacer/editor.min.css\";i:508;s:20:\"spacer/style-rtl.css\";i:509;s:24:\"spacer/style-rtl.min.css\";i:510;s:16:\"spacer/style.css\";i:511;s:20:\"spacer/style.min.css\";i:512;s:20:\"table/editor-rtl.css\";i:513;s:24:\"table/editor-rtl.min.css\";i:514;s:16:\"table/editor.css\";i:515;s:20:\"table/editor.min.css\";i:516;s:19:\"table/style-rtl.css\";i:517;s:23:\"table/style-rtl.min.css\";i:518;s:15:\"table/style.css\";i:519;s:19:\"table/style.min.css\";i:520;s:19:\"table/theme-rtl.css\";i:521;s:23:\"table/theme-rtl.min.css\";i:522;s:15:\"table/theme.css\";i:523;s:19:\"table/theme.min.css\";i:524;s:24:\"tag-cloud/editor-rtl.css\";i:525;s:28:\"tag-cloud/editor-rtl.min.css\";i:526;s:20:\"tag-cloud/editor.css\";i:527;s:24:\"tag-cloud/editor.min.css\";i:528;s:23:\"tag-cloud/style-rtl.css\";i:529;s:27:\"tag-cloud/style-rtl.min.css\";i:530;s:19:\"tag-cloud/style.css\";i:531;s:23:\"tag-cloud/style.min.css\";i:532;s:28:\"template-part/editor-rtl.css\";i:533;s:32:\"template-part/editor-rtl.min.css\";i:534;s:24:\"template-part/editor.css\";i:535;s:28:\"template-part/editor.min.css\";i:536;s:27:\"template-part/theme-rtl.css\";i:537;s:31:\"template-part/theme-rtl.min.css\";i:538;s:23:\"template-part/theme.css\";i:539;s:27:\"template-part/theme.min.css\";i:540;s:24:\"term-count/style-rtl.css\";i:541;s:28:\"term-count/style-rtl.min.css\";i:542;s:20:\"term-count/style.css\";i:543;s:24:\"term-count/style.min.css\";i:544;s:30:\"term-description/style-rtl.css\";i:545;s:34:\"term-description/style-rtl.min.css\";i:546;s:26:\"term-description/style.css\";i:547;s:30:\"term-description/style.min.css\";i:548;s:23:\"term-name/style-rtl.css\";i:549;s:27:\"term-name/style-rtl.min.css\";i:550;s:19:\"term-name/style.css\";i:551;s:23:\"term-name/style.min.css\";i:552;s:28:\"term-template/editor-rtl.css\";i:553;s:32:\"term-template/editor-rtl.min.css\";i:554;s:24:\"term-template/editor.css\";i:555;s:28:\"term-template/editor.min.css\";i:556;s:27:\"term-template/style-rtl.css\";i:557;s:31:\"term-template/style-rtl.min.css\";i:558;s:23:\"term-template/style.css\";i:559;s:27:\"term-template/style.min.css\";i:560;s:27:\"text-columns/editor-rtl.css\";i:561;s:31:\"text-columns/editor-rtl.min.css\";i:562;s:23:\"text-columns/editor.css\";i:563;s:27:\"text-columns/editor.min.css\";i:564;s:26:\"text-columns/style-rtl.css\";i:565;s:30:\"text-columns/style-rtl.min.css\";i:566;s:22:\"text-columns/style.css\";i:567;s:26:\"text-columns/style.min.css\";i:568;s:19:\"verse/style-rtl.css\";i:569;s:23:\"verse/style-rtl.min.css\";i:570;s:15:\"verse/style.css\";i:571;s:19:\"verse/style.min.css\";i:572;s:20:\"video/editor-rtl.css\";i:573;s:24:\"video/editor-rtl.min.css\";i:574;s:16:\"video/editor.css\";i:575;s:20:\"video/editor.min.css\";i:576;s:19:\"video/style-rtl.css\";i:577;s:23:\"video/style-rtl.min.css\";i:578;s:15:\"video/style.css\";i:579;s:19:\"video/style.min.css\";i:580;s:19:\"video/theme-rtl.css\";i:581;s:23:\"video/theme-rtl.min.css\";i:582;s:15:\"video/theme.css\";i:583;s:19:\"video/theme.min.css\";}}","on"),
("126","WPLANG","fr_FR","auto"),
("324","theme_mods_twentytwentyfive","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1771326554;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}","off"),
("325","_transient_wp_styles_for_blocks","a:2:{s:4:\"hash\";s:32:\"bb0724c7bd62f3312bedc6ab662b3d3d\";s:6:\"blocks\";a:6:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:18:\"core/term-template\";s:120:\":where(.wp-block-term-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-term-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}","on"),
("328","_site_transient_timeout_browser_8e253f85246590342756399a57054cb8","1771931312","off"),
("329","_site_transient_browser_8e253f85246590342756399a57054cb8","a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"144.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","off"),
("330","_site_transient_timeout_php_check_feede18ab91a39786f5028b7215ed6a6","1771931312","off"),
("331","_site_transient_php_check_feede18ab91a39786f5028b7215ed6a6","a:5:{s:19:\"recommended_version\";s:3:\"8.3\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:0;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}","off"),
("338","can_compress_scripts","0","on"),
("355","current_theme","Phlox Pro","auto"),
("356","theme_mods_phlox-pro","a:39:{i:0;b:0;s:20:\"last_checked_version\";s:6:\"5.17.7\";s:18:\"custom_css_post_id\";i:174;s:25:\"are_pro_options_inherited\";i:1;s:12:\"initial_date\";s:19:\"2021-03-15 10:07:46\";s:15:\"initial_version\";s:5:\"5.5.8\";s:18:\"nav_menu_locations\";a:1:{s:14:\"header-primary\";i:46;}s:12:\"font_subsets\";s:0:\"\";s:9:\"font_urls\";a:1:{s:18:\"auxin-fonts-google\";s:366:\"//fonts.googleapis.com/css?family=Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic|Playfair Display:regular,italic,700,700italic,900,900italic|Poppins:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\";}s:17:\"custom_css_string\";s:14649:\"/* header-logo-width \n=========================*/\n.aux-logo-header .aux-logo-anchor{ max-width:80px; }\n/* header-logo-max-height-type \n=========================*/\n.aux-logo-header .aux-logo-anchor > img { max-height:66px; }\n/* site-frame-background-color \n=========================*/\n@media screen and (min-width: 700px) { .aux-framed .aux-side-frames, body.aux-framed:after, .aux-framed .aux-side-frames:before, .aux-framed .aux-side-frames:after {background-color:#111111;}}\n/* site-header-container-height \n=========================*/\n.site-header-section .aux-header-elements:not(.aux-vertical-menu-elements), .site-header-section .aux-fill .aux-menu-depth-0 > .aux-item-content { height:66px; }\n/* site-transparent-header-bgcolor \n=========================*/\n.site-header-section { background-color:rgba(255, 255, 255, 0); }\n/* site-header-container-scaled-height \n=========================*/\n.aux-top-sticky .site-header-section.aux-sticky .aux-fill .aux-menu-depth-0 > .aux-item-content, .aux-top-sticky .site-header-section.aux-sticky .aux-header-elements,.aux-elementor-header.aux-sticky [data-elementor-type=\"header\"] > .elementor-section > .elementor-container,.aux-elementor-header.aux-sticky .elementor-section-wrap > .elementor-section > .elementor-container { min-height:80px; }\n/* sticky-header-color \n=========================*/\n.aux-elementor-header.aux-sticky .elementor-section-wrap > .elementor-section, .aux-elementor-header.aux-sticky [data-elementor-type=\"header\"] > .elementor-section { background-color:#FFFFFF !important; }\n/* site-vertical-menu-background-color \n=========================*/\n.aux-vertical-menu-side { background-color:#FFF; }\n/* site-header-navigation-item-height \n=========================*/\n.site-header-section .aux-middle .aux-menu-depth-0 > .aux-item-content { height:60px; }\n/* site-mobile-header-toggle-button-color \n=========================*/\n.site-header-section .aux-header .aux-burger:before, .site-header-section .aux-header .aux-burger:after, .site-header-section .aux-header .aux-burger .mid-line { border-color:#3d3d3d; }\n/* site-menu-full-screen-background-color \n=========================*/\n#fs-menu-search:before { background-color:rgba(255, 255, 255, 0.95); }\n/* site-top-header-background-color \n=========================*/\n#top-header {background-color:#FFFFFF;}\n/* post-title-bar-overlay-pattern-opacity \n=========================*/\n.single-post .aux-overlay-bg-hash::before { opacity:0.15; }\n/* page-title-bar-overlay-pattern-opacity \n=========================*/\n.page .aux-overlay-bg-hash::before { opacity:0.5; }\n/* subfooter-bar-layout-bg-color \n=========================*/\n.aux-subfooter-bar { background-color:#fafafa; }\n/* subfooter-bar-top-border-color \n=========================*/\n.aux-subfooter-bar { border-top:1px solid #EAEAEA; }\n/* subfooter-layout-bg-image-position \n=========================*/\n.aux-subfooter {background-position:center center;}\n/* subfooter-layout-bg-image-size \n=========================*/\n.aux-subfooter {background-size:cover;}\n/* subfooter-layout-bg-image-repeat \n=========================*/\n.aux-subfooter {background-repeat:no-repeat;}\n/* subfooter-top-border-color \n=========================*/\n.aux-subfooter { border-top:1px solid rgba(234, 234, 234, 0); }\n/* site-footer-bg-color \n=========================*/\n.aux-site-footer {background-color:#222222;}\n/* footer-top-border-color \n=========================*/\n.aux-site-footer {border-top:1px solid rgba(234, 234, 234, 0);}\n/* footer-top-border-width \n=========================*/\n.aux-site-footer { border-top-width:0px; }\n/* site-secondary-logo-max-height \n=========================*/\n.aux-logo-footer .aux-logo-anchor img { max-height:50px; }\n/* product-title-bar-overlay-pattern-opacity \n=========================*/\n.single-product .aux-overlay-bg-hash::before { opacity:0.5; }\n/* site-title-typography \n=========================*/\n.aux-logo-text .site-title{ font-family:\'Poppins\'; color:rgb(61, 61, 61); font-size:18.6px; font-weight:600; line-height:27px; text-transform:uppercase; font-size:18.6px; } \n/* header-main-menu-typography \n=========================*/\n.site-header-section .aux-menu-depth-0 > .aux-item-content .aux-menu-label{ font-family:\'Montserrat\'; color:rgb(61, 61, 61); font-size:14px; font-weight:500; line-height:18px; text-transform:uppercase; } \n/* body-typography \n=========================*/\nbody{ font-family:\'Montserrat\'; } \n/* general-heading-h3 \n=========================*/\nbody h3, body .aux-h3{ font-family:\'Playfair Display\'; } \n/* subfooter-layout-bg-color \n=========================*/\n.aux-subfooter { background-color:#3d3d3d; }\n/* subfooter-widget-title-typography \n=========================*/\n.aux-subfooter .aux-widget-area .widget-title{ font-family:\'Playfair Display\'; color:rgb(255, 255, 255); font-size:16px; font-weight:500; text-transform:uppercase; line-height:21px; } \n/* subfooter-widget-text-typography \n=========================*/\n.aux-subfooter .aux-widget-area p{ font-family:\'Montserrat\'; color:rgb(255, 255, 255); font-size:16px; font-weight:300; line-height:23px; } \n/* subfooter-widget-link-typography \n=========================*/\n.aux-subfooter .aux-widget-area a{ font-family:\'Montserrat\'; color:rgb(255, 255, 255); font-size:16px; font-weight:300; line-height:28px; } \n/* footer-copyright-typography \n=========================*/\n.aux-copyright{ font-family:\'Montserrat\'; color:rgb(196, 196, 196); font-size:16px; font-weight:300; line-height:24px; } \n/* product-setting-section-single-appearance-title \n=========================*/\n.single-product .entry-title{ font-family:\'Playfair Display\'; color:var(--e-global-color-text); font-size:22px; font-weight:400; line-height:30px; } \n/* product-setting-section-single-appearance-price \n=========================*/\n.woocommerce-page.single-product .summary .price .amount, .woocommerce-page.single-product .summary .price ins .amount{ font-family:\'Montserrat\'; color:rgb(61, 61, 61); font-size:52px; font-weight:500; line-height:63px; } \n/* product-setting-section-single-appearance-reg-price \n=========================*/\n.woocommerce-page.single-product .summary .price del .amount, .woocommerce-page.single-product .summary .price del{ font-family:\'Montserrat\'; color:var(--e-global-color-secondary); font-size:22px; font-weight:500; line-height:28px; } \n/* product-setting-section-single-appearance-add-to-btn \n=========================*/\n.single-product .cart .auxshp-add-to-cart{ font-family:\'Poppins\'; color:rgb(255, 255, 255); font-size:14px; font-weight:600; line-height:21px; } \n/* product-setting-section-single-appearance-description \n=========================*/\n.single-product .woocommerce-product-details__short-description{ font-family:\'Montserrat\'; color:var(--e-global-color-text); font-size:16px; font-weight:500; line-height:24px; } \n/* product-related-posts-label-typo \n=========================*/\n.single-product .auxshp-related-products .widget-title{ font-family:\'Playfair Display\'; color:var(--e-global-color-text); font-size:28px; line-height:37px; } \n/* product-setting-section-single-appearance-review-title \n=========================*/\n.single-product .woocommerce-Reviews-title{ font-family:\'Playfair Display\'; color:var(--e-global-color-text); font-size:22px; font-weight:400; line-height:30px; } \n/* product-setting-section-single-appearance-review-author \n=========================*/\n.single-product .woocommerce-review__author{ font-family:\'Montserrat\'; color:var(--e-global-color-text); font-size:16px; font-weight:500; line-height:19px; } \n/* product-setting-section-single-appearance-review-date \n=========================*/\n.single-product .woocommerce-review__published-date{ font-family:\'Montserrat\'; color:var(--e-global-color-secondary); font-size:16px; font-weight:500; line-height:19px; } \n/* product-setting-section-single-appearance-review-content \n=========================*/\n.single-product .woocommerce-Reviews .comment-text{ font-family:\'Montserrat\'; color:var(--e-global-color-text); font-size:16px; font-weight:500; line-height:24px; } \n/* product-setting-section-single-appearance-review-replay-title \n=========================*/\n.single-product .woocommerce-Reviews .comment-reply-title{ font-family:\'Montserrat\'; color:rgb(61, 61, 61); font-size:16px; font-weight:600; line-height:24px; } \n/* product-setting-section-single-appearance-review-cm-notes \n=========================*/\n.single-product .woocommerce-Reviews .comment-notes{ font-family:\'Montserrat\'; color:rgb(61, 61, 61); font-size:16px; font-weight:500; line-height:23px; } \n/* blog-page-title-typography \n=========================*/\n.blog .hentry .entry-title{ font-family:\'Playfair Display\'; color:var(--e-global-color-text); font-size:38px; font-weight:400; line-height:52px; } \n/* blog-page-info-typography \n=========================*/\n.blog .aux-archive .aux-primary .hentry .entry-info{ font-family:\'Montserrat\'; color:var(--e-global-color-secondary); font-size:14px; font-weight:500; text-transform:uppercase; line-height:18px; } \n/* blog-page-content-typography \n=========================*/\n.blog .hentry .entry-content{ font-family:\'Montserrat\'; color:var(--e-global-color-text); font-size:16px; font-weight:500; line-height:23px; } \n/* single-post-title-typography \n=========================*/\n.single-post .aux-primary .hentry .entry-title{ font-family:\'Playfair Display\'; color:var(--e-global-color-text); font-size:38px; font-weight:400; line-height:52px; } \n/* single-post-content-typography \n=========================*/\n.single-post .hentry .entry-content{ font-family:\'Montserrat\'; color:var(--e-global-color-text); font-size:16px; font-weight:500; line-height:23px; } \n/* single-post-info-typography \n=========================*/\n.single-post .hentry .entry-info{ font-family:\'Montserrat\'; color:var(--e-global-color-secondary); font-size:14px; font-weight:500; text-transform:uppercase; line-height:18px; } \n/* single-post-info-terms-typography \n=========================*/\n.single-post .hentry .entry-info a{ color:var(--e-global-color-secondary); } \n/* single-post-meta-typography \n=========================*/\n.single-post .hentry footer.entry-meta .entry-tax{ font-family:\'Montserrat\'; color:var(--e-global-color-secondary); font-size:14px; font-weight:500; font-style:normal; line-height:18px; } \n/* single-post-meta-terms-typography \n=========================*/\n.single-post .hentry footer.entry-meta .entry-tax a, .single-post .hentry footer.entry-meta .entry-tax i{ color:var(--e-global-color-text); text-decoration:none; } \n/* comment-forms-label-typo \n=========================*/\n#commentform label{ font-family:\'Montserrat\'; color:var(--e-global-color-text); font-size:16px; font-weight:500; line-height:23px; } \n/* comment-forms-replay-title-typo \n=========================*/\n#reply-title > span{ font-family:\'Montserrat\'; color:var(--e-global-color-text); font-size:16px; font-weight:500; line-height:23px; } \n/* comment-forms-notes-typo \n=========================*/\n#commentform .comment-notes{ font-family:\'Montserrat\'; color:var(--e-global-color-text); font-size:16px; font-weight:400; line-height:23px; } \n/* comment-forms-response-title-typo \n=========================*/\n.comments-title, .comment-reply-title{ font-family:\'Playfair Display\'; color:var(--e-global-color-text); font-size:21px; font-weight:400; line-height:30px; } \n/* comment-forms-button-typo \n=========================*/\n#commentform .form-submit input[type=\"submit\"]{ font-family:\'Poppins\'; color:rgb(255, 255, 255); font-size:14px; font-weight:600; line-height:20px; } \n/* comment-author-typo \n=========================*/\n.aux-commentlist .comment-author .fn, .aux-commentlist .comment-author .fn a{ font-family:\'Montserrat\'; color:var(--e-global-color-text); font-size:16px; font-weight:600; line-height:19px; } \n/* comment-info-typo \n=========================*/\n.aux-commentlist .comment .comment-author time a{ font-family:\'Montserrat\'; color:var(--e-global-color-secondary); font-size:14px; font-weight:500; text-transform:uppercase; line-height:19px; } \n/* comment-content-typo \n=========================*/\n.aux-commentlist .comment .comment-body{ font-family:\'Montserrat\'; color:var(--e-global-color-text); font-size:16px; font-weight:500; line-height:23px; } \n/* blog-post-share-button-icon-size \n=========================*/\n.single-post .aux-single-post-share span::before { font-size:10px; }\n/* product-single-wishlist-button-icon-size \n=========================*/\n.single-product .auxshp-wishlist .auxshp-wishlist-icon::before { font-size:25px; }\n/* product-single-share-button-icon-size \n=========================*/\n.single-product .aux-share-btn span::before { font-size:25px; }\n/* site-featured-color-1 \n=========================*/\n:root {--auxin-featured-color-1: #1359b6;}\n/* site-featured-color-2 \n=========================*/\n:root {--auxin-featured-color-2: #222222;}\n/* site-featured-color-3 \n=========================*/\n:root {--auxin-featured-color-3: #c4c4c4;}\n/* site-featured-color-4 \n=========================*/\n:root {--auxin-featured-color-4: #3d3d3d;}\n/* site-featured-color-5 \n=========================*/\n:root {--auxin-featured-color-5: #f9f9f9;}\n/* site-featured-color-6 \n=========================*/\n:root {--auxin-featured-color-6: #aaaaaa;}\n/* site-featured-color-7 \n=========================*/\n:root {--auxin-featured-color-7: #d3d3d3;}\n/* site-featured-color-8 \n=========================*/\n:root {--auxin-featured-color-8: #e74c3c;}\n/* elementor-color-primary \n=========================*/\n.aux-customize-preview.elementor-kit-902 {--e-global-color-primary: #1359B6;}\n/* elementor-color-secondary \n=========================*/\n.aux-customize-preview.elementor-kit-902 {--e-global-color-secondary: #AAAAAA;}\n/* elementor-color-text \n=========================*/\n.aux-customize-preview.elementor-kit-902 {--e-global-color-text: #3D3D3D;}\n/* elementor-color-accent \n=========================*/\n.aux-customize-preview.elementor-kit-902 {--e-global-color-accent: #D3D3D3;}\n/* general-heading-h1 \n=========================*/\nbody h1, body .aux-h1{ font-family:\'Playfair Display\'; } \n/* general-heading-h2 \n=========================*/\nbody h2, body .aux-h2{ font-family:\'Playfair Display\'; } \n/* general-heading-h4 \n=========================*/\nbody h4, body .aux-h4{ font-family:\'Playfair Display\'; } \n/* general-heading-h5 \n=========================*/\nbody h5, body .aux-h5{ font-family:\'Montserrat\'; } \n/* product-setting-section-shop-page-product-title-typo \n=========================*/\n.aux-shop-archive .products-loop .auxshp-loop-title, .aux-shop-archive .products-loop .auxshp-loop-title .auxshp-title-heading{ font-weight:400; } \n\";s:16:\"custom_css_array\";a:83:{s:17:\"header_logo_width\";s:52:\".aux-logo-header .aux-logo-anchor{ max-width:80px; }\";s:27:\"header_logo_max_height_type\";s:60:\".aux-logo-header .aux-logo-anchor > img { max-height:66px; }\";s:27:\"site_frame_background_color\";s:192:\"@media screen and (min-width: 700px) { .aux-framed .aux-side-frames, body.aux-framed:after, .aux-framed .aux-side-frames:before, .aux-framed .aux-side-frames:after {background-color:#111111;}}\";s:28:\"site_header_container_height\";s:161:\".site-header-section .aux-header-elements:not(.aux-vertical-menu-elements), .site-header-section .aux-fill .aux-menu-depth-0 > .aux-item-content { height:66px; }\";s:31:\"site_transparent_header_bgcolor\";s:65:\".site-header-section { background-color:rgba(255, 255, 255, 0); }\";s:35:\"site_header_container_scaled_height\";s:395:\".aux-top-sticky .site-header-section.aux-sticky .aux-fill .aux-menu-depth-0 > .aux-item-content, .aux-top-sticky .site-header-section.aux-sticky .aux-header-elements,.aux-elementor-header.aux-sticky [data-elementor-type=\"header\"] > .elementor-section > .elementor-container,.aux-elementor-header.aux-sticky .elementor-section-wrap > .elementor-section > .elementor-container { min-height:80px; }\";s:19:\"sticky_header_color\";s:204:\".aux-elementor-header.aux-sticky .elementor-section-wrap > .elementor-section, .aux-elementor-header.aux-sticky [data-elementor-type=\"header\"] > .elementor-section { background-color:#FFFFFF !important; }\";s:35:\"site_vertical_menu_background_color\";s:50:\".aux-vertical-menu-side { background-color:#FFF; }\";s:34:\"site_header_navigation_item_height\";s:87:\".site-header-section .aux-middle .aux-menu-depth-0 > .aux-item-content { height:60px; }\";s:38:\"site_mobile_header_toggle_button_color\";s:185:\".site-header-section .aux-header .aux-burger:before, .site-header-section .aux-header .aux-burger:after, .site-header-section .aux-header .aux-burger .mid-line { border-color:#3d3d3d; }\";s:38:\"site_menu_full_screen_background_color\";s:70:\"#fs-menu-search:before { background-color:rgba(255, 255, 255, 0.95); }\";s:32:\"site_top_header_background_color\";s:39:\"#top-header {background-color:#FFFFFF;}\";s:38:\"post_title_bar_overlay_pattern_opacity\";s:59:\".single-post .aux-overlay-bg-hash::before { opacity:0.15; }\";s:38:\"page_title_bar_overlay_pattern_opacity\";s:51:\".page .aux-overlay-bg-hash::before { opacity:0.5; }\";s:29:\"subfooter_bar_layout_bg_color\";s:48:\".aux-subfooter-bar { background-color:#fafafa; }\";s:30:\"subfooter_bar_top_border_color\";s:52:\".aux-subfooter-bar { border-top:1px solid #EAEAEA; }\";s:34:\"subfooter_layout_bg_image_position\";s:51:\".aux-subfooter {background-position:center center;}\";s:30:\"subfooter_layout_bg_image_size\";s:39:\".aux-subfooter {background-size:cover;}\";s:32:\"subfooter_layout_bg_image_repeat\";s:45:\".aux-subfooter {background-repeat:no-repeat;}\";s:26:\"subfooter_top_border_color\";s:63:\".aux-subfooter { border-top:1px solid rgba(234, 234, 234, 0); }\";s:20:\"site_footer_bg_color\";s:44:\".aux-site-footer {background-color:#222222;}\";s:23:\"footer_top_border_color\";s:63:\".aux-site-footer {border-top:1px solid rgba(234, 234, 234, 0);}\";s:23:\"footer_top_border_width\";s:42:\".aux-site-footer { border-top-width:0px; }\";s:30:\"site_secondary_logo_max_height\";s:58:\".aux-logo-footer .aux-logo-anchor img { max-height:50px; }\";s:41:\"product_title_bar_overlay_pattern_opacity\";s:61:\".single-product .aux-overlay-bg-hash::before { opacity:0.5; }\";s:21:\"site_title_typography\";s:173:\".aux-logo-text .site-title{ font-family:\'Poppins\'; color:rgb(61, 61, 61); font-size:18.6px; font-weight:600; line-height:27px; text-transform:uppercase; font-size:18.6px; } \";s:27:\"header_main_menu_typography\";s:204:\".site-header-section .aux-menu-depth-0 > .aux-item-content .aux-menu-label{ font-family:\'Montserrat\'; color:rgb(61, 61, 61); font-size:14px; font-weight:500; line-height:18px; text-transform:uppercase; } \";s:15:\"body_typography\";s:34:\"body{ font-family:\'Montserrat\'; } \";s:18:\"general_heading_h3\";s:57:\"body h3, body .aux-h3{ font-family:\'Playfair Display\'; } \";s:25:\"subfooter_layout_bg_color\";s:44:\".aux-subfooter { background-color:#3d3d3d; }\";s:33:\"subfooter_widget_title_typography\";s:184:\".aux-subfooter .aux-widget-area .widget-title{ font-family:\'Playfair Display\'; color:rgb(255, 255, 255); font-size:16px; font-weight:500; text-transform:uppercase; line-height:21px; } \";s:32:\"subfooter_widget_text_typography\";s:140:\".aux-subfooter .aux-widget-area p{ font-family:\'Montserrat\'; color:rgb(255, 255, 255); font-size:16px; font-weight:300; line-height:23px; } \";s:32:\"subfooter_widget_link_typography\";s:140:\".aux-subfooter .aux-widget-area a{ font-family:\'Montserrat\'; color:rgb(255, 255, 255); font-size:16px; font-weight:300; line-height:28px; } \";s:27:\"footer_copyright_typography\";s:121:\".aux-copyright{ font-family:\'Montserrat\'; color:rgb(196, 196, 196); font-size:16px; font-weight:300; line-height:24px; } \";s:47:\"product_setting_section_single_appearance_title\";s:149:\".single-product .entry-title{ font-family:\'Playfair Display\'; color:var(--e-global-color-text); font-size:22px; font-weight:400; line-height:30px; } \";s:47:\"product_setting_section_single_appearance_price\";s:222:\".woocommerce-page.single-product .summary .price .amount, .woocommerce-page.single-product .summary .price ins .amount{ font-family:\'Montserrat\'; color:rgb(61, 61, 61); font-size:52px; font-weight:500; line-height:63px; } \";s:51:\"product_setting_section_single_appearance_reg_price\";s:234:\".woocommerce-page.single-product .summary .price del .amount, .woocommerce-page.single-product .summary .price del{ font-family:\'Montserrat\'; color:var(--e-global-color-secondary); font-size:22px; font-weight:500; line-height:28px; } \";s:52:\"product_setting_section_single_appearance_add_to_btn\";s:145:\".single-product .cart .auxshp-add-to-cart{ font-family:\'Poppins\'; color:rgb(255, 255, 255); font-size:14px; font-weight:600; line-height:21px; } \";s:53:\"product_setting_section_single_appearance_description\";s:178:\".single-product .woocommerce-product-details__short-description{ font-family:\'Montserrat\'; color:var(--e-global-color-text); font-size:16px; font-weight:500; line-height:24px; } \";s:32:\"product_related_posts_label_typo\";s:158:\".single-product .auxshp-related-products .widget-title{ font-family:\'Playfair Display\'; color:var(--e-global-color-text); font-size:28px; line-height:37px; } \";s:54:\"product_setting_section_single_appearance_review_title\";s:163:\".single-product .woocommerce-Reviews-title{ font-family:\'Playfair Display\'; color:var(--e-global-color-text); font-size:22px; font-weight:400; line-height:30px; } \";s:55:\"product_setting_section_single_appearance_review_author\";s:158:\".single-product .woocommerce-review__author{ font-family:\'Montserrat\'; color:var(--e-global-color-text); font-size:16px; font-weight:500; line-height:19px; } \";s:53:\"product_setting_section_single_appearance_review_date\";s:171:\".single-product .woocommerce-review__published-date{ font-family:\'Montserrat\'; color:var(--e-global-color-secondary); font-size:16px; font-weight:500; line-height:19px; } \";s:56:\"product_setting_section_single_appearance_review_content\";s:165:\".single-product .woocommerce-Reviews .comment-text{ font-family:\'Montserrat\'; color:var(--e-global-color-text); font-size:16px; font-weight:500; line-height:24px; } \";s:61:\"product_setting_section_single_appearance_review_replay_title\";s:161:\".single-product .woocommerce-Reviews .comment-reply-title{ font-family:\'Montserrat\'; color:rgb(61, 61, 61); font-size:16px; font-weight:600; line-height:24px; } \";s:57:\"product_setting_section_single_appearance_review_cm_notes\";s:155:\".single-product .woocommerce-Reviews .comment-notes{ font-family:\'Montserrat\'; color:rgb(61, 61, 61); font-size:16px; font-weight:500; line-height:23px; } \";s:26:\"blog_page_title_typography\";s:147:\".blog .hentry .entry-title{ font-family:\'Playfair Display\'; color:var(--e-global-color-text); font-size:38px; font-weight:400; line-height:52px; } \";s:25:\"blog_page_info_typography\";s:197:\".blog .aux-archive .aux-primary .hentry .entry-info{ font-family:\'Montserrat\'; color:var(--e-global-color-secondary); font-size:14px; font-weight:500; text-transform:uppercase; line-height:18px; } \";s:28:\"blog_page_content_typography\";s:143:\".blog .hentry .entry-content{ font-family:\'Montserrat\'; color:var(--e-global-color-text); font-size:16px; font-weight:500; line-height:23px; } \";s:28:\"single_post_title_typography\";s:167:\".single-post .aux-primary .hentry .entry-title{ font-family:\'Playfair Display\'; color:var(--e-global-color-text); font-size:38px; font-weight:400; line-height:52px; } \";s:30:\"single_post_content_typography\";s:150:\".single-post .hentry .entry-content{ font-family:\'Montserrat\'; color:var(--e-global-color-text); font-size:16px; font-weight:500; line-height:23px; } \";s:27:\"single_post_info_typography\";s:178:\".single-post .hentry .entry-info{ font-family:\'Montserrat\'; color:var(--e-global-color-secondary); font-size:14px; font-weight:500; text-transform:uppercase; line-height:18px; } \";s:33:\"single_post_info_terms_typography\";s:77:\".single-post .hentry .entry-info a{ color:var(--e-global-color-secondary); } \";s:27:\"single_post_meta_typography\";s:188:\".single-post .hentry footer.entry-meta .entry-tax{ font-family:\'Montserrat\'; color:var(--e-global-color-secondary); font-size:14px; font-weight:500; font-style:normal; line-height:18px; } \";s:33:\"single_post_meta_terms_typography\";s:164:\".single-post .hentry footer.entry-meta .entry-tax a, .single-post .hentry footer.entry-meta .entry-tax i{ color:var(--e-global-color-text); text-decoration:none; } \";s:24:\"comment_forms_label_typo\";s:133:\"#commentform label{ font-family:\'Montserrat\'; color:var(--e-global-color-text); font-size:16px; font-weight:500; line-height:23px; } \";s:31:\"comment_forms_replay_title_typo\";s:134:\"#reply-title > span{ font-family:\'Montserrat\'; color:var(--e-global-color-text); font-size:16px; font-weight:500; line-height:23px; } \";s:24:\"comment_forms_notes_typo\";s:142:\"#commentform .comment-notes{ font-family:\'Montserrat\'; color:var(--e-global-color-text); font-size:16px; font-weight:400; line-height:23px; } \";s:33:\"comment_forms_response_title_typo\";s:158:\".comments-title, .comment-reply-title{ font-family:\'Playfair Display\'; color:var(--e-global-color-text); font-size:21px; font-weight:400; line-height:30px; } \";s:25:\"comment_forms_button_typo\";s:150:\"#commentform .form-submit input[type=\"submit\"]{ font-family:\'Poppins\'; color:rgb(255, 255, 255); font-size:14px; font-weight:600; line-height:20px; } \";s:19:\"comment_author_typo\";s:191:\".aux-commentlist .comment-author .fn, .aux-commentlist .comment-author .fn a{ font-family:\'Montserrat\'; color:var(--e-global-color-text); font-size:16px; font-weight:600; line-height:19px; } \";s:17:\"comment_info_typo\";s:194:\".aux-commentlist .comment .comment-author time a{ font-family:\'Montserrat\'; color:var(--e-global-color-secondary); font-size:14px; font-weight:500; text-transform:uppercase; line-height:19px; } \";s:20:\"comment_content_typo\";s:154:\".aux-commentlist .comment .comment-body{ font-family:\'Montserrat\'; color:var(--e-global-color-text); font-size:16px; font-weight:500; line-height:23px; } \";s:32:\"blog_post_share_button_icon_size\";s:68:\".single-post .aux-single-post-share span::before { font-size:10px; }\";s:40:\"product_single_wishlist_button_icon_size\";s:82:\".single-product .auxshp-wishlist .auxshp-wishlist-icon::before { font-size:25px; }\";s:37:\"product_single_share_button_icon_size\";s:63:\".single-product .aux-share-btn span::before { font-size:25px; }\";s:21:\"site_featured_color_1\";s:42:\":root {--auxin-featured-color-1: #1359b6;}\";s:21:\"site_featured_color_2\";s:42:\":root {--auxin-featured-color-2: #222222;}\";s:21:\"site_featured_color_3\";s:42:\":root {--auxin-featured-color-3: #c4c4c4;}\";s:21:\"site_featured_color_4\";s:42:\":root {--auxin-featured-color-4: #3d3d3d;}\";s:21:\"site_featured_color_5\";s:42:\":root {--auxin-featured-color-5: #f9f9f9;}\";s:21:\"site_featured_color_6\";s:42:\":root {--auxin-featured-color-6: #aaaaaa;}\";s:21:\"site_featured_color_7\";s:42:\":root {--auxin-featured-color-7: #d3d3d3;}\";s:21:\"site_featured_color_8\";s:42:\":root {--auxin-featured-color-8: #e74c3c;}\";s:23:\"elementor_color_primary\";s:77:\".aux-customize-preview.elementor-kit-902 {--e-global-color-primary: #1359B6;}\";s:25:\"elementor_color_secondary\";s:79:\".aux-customize-preview.elementor-kit-902 {--e-global-color-secondary: #AAAAAA;}\";s:20:\"elementor_color_text\";s:74:\".aux-customize-preview.elementor-kit-902 {--e-global-color-text: #3D3D3D;}\";s:22:\"elementor_color_accent\";s:76:\".aux-customize-preview.elementor-kit-902 {--e-global-color-accent: #D3D3D3;}\";s:18:\"general_heading_h1\";s:57:\"body h1, body .aux-h1{ font-family:\'Playfair Display\'; } \";s:18:\"general_heading_h2\";s:57:\"body h2, body .aux-h2{ font-family:\'Playfair Display\'; } \";s:18:\"general_heading_h4\";s:57:\"body h4, body .aux-h4{ font-family:\'Playfair Display\'; } \";s:18:\"general_heading_h5\";s:51:\"body h5, body .aux-h5{ font-family:\'Montserrat\'; } \";s:52:\"product_setting_section_shop_page_product_title_typo\";s:147:\".aux-shop-archive .products-loop .auxshp-loop-title, .aux-shop-archive .products-loop .auxshp-loop-title .auxshp-title-heading{ font-weight:400; } \";}s:16:\"custom_js_string\";s:249:\"/* theme_options_custom \n=========================*/\nvar qty = document.querySelectorAll(\'.woocommerce-page .quantity\');\nqty.forEach( function( element) {\n    element.classList.add(\'aux-shop-quantity\');\n    element.classList.remove(\'quantity\');\n})\n\n\";s:15:\"custom_js_array\";a:1:{s:20:\"theme_options_custom\";s:195:\"var qty = document.querySelectorAll(\'.woocommerce-page .quantity\');\nqty.forEach( function( element) {\n    element.classList.add(\'aux-shop-quantity\');\n    element.classList.remove(\'quantity\');\n})\n\";}s:23:\"are_auxin_caps_assigned\";i:1;s:19:\"initial_version_pro\";s:6:\"5.17.7\";s:16:\"initial_date_pro\";s:19:\"2026-02-17 11:09:22\";s:10:\"client_key\";s:34:\"ys4WlubHyHacm2bL49ZM9r6H36L0VRZicW\";s:24:\"auxin_capabilities_added\";i:1;s:13:\"custom_js_ver\";d:6.3;s:20:\"use_inline_custom_js\";b:0;s:14:\"custom_css_ver\";d:5.5;s:21:\"use_inline_custom_css\";b:0;s:26:\"auxin_wp_image_sizes_ratio\";i:1;s:45:\"auxin_permalink_permalink_options_initialized\";i:1;s:37:\"auxin_permalink_pending_rewrite_rules\";i:0;s:25:\"default_template_imported\";b:1;s:35:\"auxin_permalink_portfolio_structure\";s:9:\"portfolio\";s:29:\"auxin_permalink_faq_structure\";s:3:\"faq\";s:37:\"auxin_permalink_faq_archive_structure\";s:7:\"faq/all\";s:42:\"auxin_permalink_faq_faq_category_structure\";s:12:\"faq-category\";s:26:\"redirected_to_welcome_page\";i:1;s:32:\"elementor_page_typography_scheme\";i:1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1556094426;s:4:\"data\";a:13:{s:19:\"wp_inactive_widgets\";a:0:{}s:40:\"auxin-global-primary-sidebar-widget-area\";a:3:{i:0;s:32:\"woocommerce_top_rated_products-2\";i:1;s:32:\"woocommerce_product_categories-2\";i:2;s:26:\"woocommerce_price_filter-2\";}s:42:\"auxin-global-secondary-sidebar-widget-area\";a:0:{}s:39:\"auxin-pages-primary-sidebar-widget-area\";a:0:{}s:41:\"auxin-pages-secondary-sidebar-widget-area\";a:0:{}s:38:\"auxin-blog-primary-sidebar-widget-area\";a:0:{}s:40:\"auxin-blog-secondary-sidebar-widget-area\";a:0:{}s:32:\"auxin-search-sidebar-widget-area\";a:0:{}s:31:\"auxin-subfooter-bar-widget-area\";a:0:{}s:33:\"auxin-footer1-sidebar-widget-area\";a:1:{i:0;s:10:\"nav_menu-2\";}s:33:\"auxin-footer2-sidebar-widget-area\";a:1:{i:0;s:10:\"nav_menu-3\";}s:33:\"auxin-footer3-sidebar-widget-area\";a:1:{i:0;s:6:\"text-2\";}s:33:\"auxin-footer4-sidebar-widget-area\";a:1:{i:0;s:19:\"mc4wp_form_widget-2\";}}}s:35:\"rate_scale_notice_remind_later_date\";i:0;s:33:\"auxin_permalink_product_structure\";s:7:\"product\";s:41:\"auxin_permalink_product_archive_structure\";s:11:\"product/all\";s:47:\"auxin_permalink_product_product_brand_structure\";s:6:\"marque\";s:45:\"auxin_permalink_product_product_cat_structure\";s:16:\"product-category\";s:45:\"auxin_permalink_product_product_tag_structure\";s:11:\"product-tag\";}","on"),
("357","theme_switched","","auto"),
("359","phlox-pro_license","a:1:{s:5:\"token\";s:9:\"activated\";}","off"),
("360","_transient_auxin_check_token_validation_status","1","on"),
("363","_site_transient_timeout_auxin_font_icons_list_fontastic","1773918554","off"),
("364","_site_transient_auxin_font_icons_list_fontastic","a:956:{i:0;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"2 arrows\";s:9:\"classname\";s:17:\".auxicon-2-arrows\";s:7:\"content\";s:3:\"\\61\";}i:1;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"4 arrows\";s:9:\"classname\";s:17:\".auxicon-4-arrows\";s:7:\"content\";s:3:\"\\62\";}i:2;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Back\";s:9:\"classname\";s:13:\".auxicon-back\";s:7:\"content\";s:3:\"\\63\";}i:3;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Back pack\";s:9:\"classname\";s:18:\".auxicon-back-pack\";s:7:\"content\";s:3:\"\\64\";}i:4;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Basket 1\";s:9:\"classname\";s:17:\".auxicon-basket-1\";s:7:\"content\";s:3:\"\\65\";}i:5;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Basket 2\";s:9:\"classname\";s:17:\".auxicon-basket-2\";s:7:\"content\";s:3:\"\\66\";}i:6;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Big candy\";s:9:\"classname\";s:18:\".auxicon-big-candy\";s:7:\"content\";s:3:\"\\67\";}i:7;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Bottle\";s:9:\"classname\";s:15:\".auxicon-bottle\";s:7:\"content\";s:3:\"\\68\";}i:8;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Bow tie\";s:9:\"classname\";s:16:\".auxicon-bow-tie\";s:7:\"content\";s:3:\"\\69\";}i:9;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Box 1\";s:9:\"classname\";s:14:\".auxicon-box-1\";s:7:\"content\";s:3:\"\\6a\";}i:10;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Box 2\";s:9:\"classname\";s:14:\".auxicon-box-2\";s:7:\"content\";s:3:\"\\6b\";}i:11;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Box open\";s:9:\"classname\";s:17:\".auxicon-box-open\";s:7:\"content\";s:3:\"\\6c\";}i:12;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Candy\";s:9:\"classname\";s:14:\".auxicon-candy\";s:7:\"content\";s:3:\"\\6d\";}i:13;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Cd cover\";s:9:\"classname\";s:17:\".auxicon-cd-cover\";s:7:\"content\";s:3:\"\\6e\";}i:14;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Chopsticks\";s:9:\"classname\";s:19:\".auxicon-chopsticks\";s:7:\"content\";s:3:\"\\6f\";}i:15;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Cloud\";s:9:\"classname\";s:14:\".auxicon-cloud\";s:7:\"content\";s:3:\"\\70\";}i:16;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Cloud down\";s:9:\"classname\";s:19:\".auxicon-cloud-down\";s:7:\"content\";s:3:\"\\71\";}i:17;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Cloud up\";s:9:\"classname\";s:17:\".auxicon-cloud-up\";s:7:\"content\";s:3:\"\\72\";}i:18;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Cloud v 1\";s:9:\"classname\";s:18:\".auxicon-cloud-v-1\";s:7:\"content\";s:3:\"\\73\";}i:19;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Cloud v 2\";s:9:\"classname\";s:18:\".auxicon-cloud-v-2\";s:7:\"content\";s:3:\"\\74\";}i:20;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Cloud x 1\";s:9:\"classname\";s:18:\".auxicon-cloud-x-1\";s:7:\"content\";s:3:\"\\75\";}i:21;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Cloud x 2\";s:9:\"classname\";s:18:\".auxicon-cloud-x-2\";s:7:\"content\";s:3:\"\\76\";}i:22;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Cofee cup 1\";s:9:\"classname\";s:20:\".auxicon-cofee-cup-1\";s:7:\"content\";s:3:\"\\77\";}i:23;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Cofee cup 2\";s:9:\"classname\";s:20:\".auxicon-cofee-cup-2\";s:7:\"content\";s:3:\"\\78\";}i:24;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Credit card 1\";s:9:\"classname\";s:22:\".auxicon-credit-card-1\";s:7:\"content\";s:3:\"\\79\";}i:25;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Credit card 2\";s:9:\"classname\";s:22:\".auxicon-credit-card-2\";s:7:\"content\";s:3:\"\\7a\";}i:26;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Credit card 3\";s:9:\"classname\";s:22:\".auxicon-credit-card-3\";s:7:\"content\";s:3:\"\\41\";}i:27;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Credit card 4\";s:9:\"classname\";s:22:\".auxicon-credit-card-4\";s:7:\"content\";s:3:\"\\42\";}i:28;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Cup 1\";s:9:\"classname\";s:14:\".auxicon-cup-1\";s:7:\"content\";s:3:\"\\43\";}i:29;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Cup 2\";s:9:\"classname\";s:14:\".auxicon-cup-2\";s:7:\"content\";s:3:\"\\44\";}i:30;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Diamond\";s:9:\"classname\";s:16:\".auxicon-diamond\";s:7:\"content\";s:3:\"\\45\";}i:31;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Dollar\";s:9:\"classname\";s:15:\".auxicon-dollar\";s:7:\"content\";s:3:\"\\46\";}i:32;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Dollar bill\";s:9:\"classname\";s:20:\".auxicon-dollar-bill\";s:7:\"content\";s:3:\"\\47\";}i:33;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Dollar coin\";s:9:\"classname\";s:20:\".auxicon-dollar-coin\";s:7:\"content\";s:3:\"\\48\";}i:34;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Download\";s:9:\"classname\";s:17:\".auxicon-download\";s:7:\"content\";s:3:\"\\49\";}i:35;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Euro\";s:9:\"classname\";s:13:\".auxicon-euro\";s:7:\"content\";s:3:\"\\4a\";}i:36;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Euro coin\";s:9:\"classname\";s:18:\".auxicon-euro-coin\";s:7:\"content\";s:3:\"\\4b\";}i:37;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Folder\";s:9:\"classname\";s:15:\".auxicon-folder\";s:7:\"content\";s:3:\"\\4c\";}i:38;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Folder plus\";s:9:\"classname\";s:20:\".auxicon-folder-plus\";s:7:\"content\";s:3:\"\\4d\";}i:39;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Folder v\";s:9:\"classname\";s:17:\".auxicon-folder-v\";s:7:\"content\";s:3:\"\\4e\";}i:40;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Folder x\";s:9:\"classname\";s:17:\".auxicon-folder-x\";s:7:\"content\";s:3:\"\\4f\";}i:41;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Forward\";s:9:\"classname\";s:16:\".auxicon-forward\";s:7:\"content\";s:3:\"\\50\";}i:42;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Glass of water\";s:9:\"classname\";s:23:\".auxicon-glass-of-water\";s:7:\"content\";s:3:\"\\51\";}i:43;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Hamburger\";s:9:\"classname\";s:18:\".auxicon-hamburger\";s:7:\"content\";s:3:\"\\52\";}i:44;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Headphones\";s:9:\"classname\";s:19:\".auxicon-headphones\";s:7:\"content\";s:3:\"\\53\";}i:45;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Headset\";s:9:\"classname\";s:16:\".auxicon-headset\";s:7:\"content\";s:3:\"\\54\";}i:46;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Highlighter\";s:9:\"classname\";s:20:\".auxicon-highlighter\";s:7:\"content\";s:3:\"\\56\";}i:47;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Hot dog\";s:9:\"classname\";s:16:\".auxicon-hot-dog\";s:7:\"content\";s:3:\"\\57\";}i:48;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Ice cream\";s:9:\"classname\";s:18:\".auxicon-ice-cream\";s:7:\"content\";s:3:\"\\58\";}i:49;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Ipod\";s:9:\"classname\";s:13:\".auxicon-ipod\";s:7:\"content\";s:3:\"\\59\";}i:50;O:8:\"stdClass\":3:{s:4:\"name\";s:3:\"Key\";s:9:\"classname\";s:12:\".auxicon-key\";s:7:\"content\";s:3:\"\\5a\";}i:51;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Keyboard\";s:9:\"classname\";s:17:\".auxicon-keyboard\";s:7:\"content\";s:3:\"\\30\";}i:52;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Knife\";s:9:\"classname\";s:14:\".auxicon-knife\";s:7:\"content\";s:3:\"\\31\";}i:53;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Lock round\";s:9:\"classname\";s:19:\".auxicon-lock-round\";s:7:\"content\";s:3:\"\\32\";}i:54;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Lock square\";s:9:\"classname\";s:20:\".auxicon-lock-square\";s:7:\"content\";s:3:\"\\33\";}i:55;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Mouse\";s:9:\"classname\";s:14:\".auxicon-mouse\";s:7:\"content\";s:3:\"\\34\";}i:56;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Musical note 1\";s:9:\"classname\";s:23:\".auxicon-musical-note-1\";s:7:\"content\";s:3:\"\\35\";}i:57;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Musical note 2\";s:9:\"classname\";s:23:\".auxicon-musical-note-2\";s:7:\"content\";s:3:\"\\36\";}i:58;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Paper\";s:9:\"classname\";s:14:\".auxicon-paper\";s:7:\"content\";s:3:\"\\37\";}i:59;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Pause\";s:9:\"classname\";s:14:\".auxicon-pause\";s:7:\"content\";s:3:\"\\38\";}i:60;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Pause round\";s:9:\"classname\";s:20:\".auxicon-pause-round\";s:7:\"content\";s:3:\"\\39\";}i:61;O:8:\"stdClass\":3:{s:4:\"name\";s:3:\"Pen\";s:9:\"classname\";s:12:\".auxicon-pen\";s:7:\"content\";s:3:\"\\21\";}i:62;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Pencil\";s:9:\"classname\";s:15:\".auxicon-pencil\";s:7:\"content\";s:3:\"\\22\";}i:63;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Platter\";s:9:\"classname\";s:16:\".auxicon-platter\";s:7:\"content\";s:3:\"\\23\";}i:64;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Play\";s:9:\"classname\";s:13:\".auxicon-play\";s:7:\"content\";s:3:\"\\24\";}i:65;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Play round\";s:9:\"classname\";s:19:\".auxicon-play-round\";s:7:\"content\";s:3:\"\\25\";}i:66;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Popsicle\";s:9:\"classname\";s:17:\".auxicon-popsicle\";s:7:\"content\";s:3:\"\\26\";}i:67;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Pound\";s:9:\"classname\";s:14:\".auxicon-pound\";s:7:\"content\";s:3:\"\\27\";}i:68;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Pound coin\";s:9:\"classname\";s:19:\".auxicon-pound-coin\";s:7:\"content\";s:3:\"\\28\";}i:69;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Present 1\";s:9:\"classname\";s:18:\".auxicon-present-1\";s:7:\"content\";s:3:\"\\29\";}i:70;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Present 2\";s:9:\"classname\";s:18:\".auxicon-present-2\";s:7:\"content\";s:3:\"\\2a\";}i:71;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Radio\";s:9:\"classname\";s:14:\".auxicon-radio\";s:7:\"content\";s:3:\"\\2b\";}i:72;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Random\";s:9:\"classname\";s:15:\".auxicon-random\";s:7:\"content\";s:3:\"\\2c\";}i:73;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Repeat 1\";s:9:\"classname\";s:17:\".auxicon-repeat-1\";s:7:\"content\";s:3:\"\\2d\";}i:74;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Repeat 2\";s:9:\"classname\";s:17:\".auxicon-repeat-2\";s:7:\"content\";s:3:\"\\2e\";}i:75;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Ring\";s:9:\"classname\";s:13:\".auxicon-ring\";s:7:\"content\";s:3:\"\\2f\";}i:76;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Ruler\";s:9:\"classname\";s:14:\".auxicon-ruler\";s:7:\"content\";s:3:\"\\3a\";}i:77;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Settings 2\";s:9:\"classname\";s:19:\".auxicon-settings-2\";s:7:\"content\";s:3:\"\\3c\";}i:78;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Settings 3\";s:9:\"classname\";s:19:\".auxicon-settings-3\";s:7:\"content\";s:3:\"\\3d\";}i:79;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Shirt 1\";s:9:\"classname\";s:16:\".auxicon-shirt-1\";s:7:\"content\";s:3:\"\\3e\";}i:80;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Shirt 2\";s:9:\"classname\";s:16:\".auxicon-shirt-2\";s:7:\"content\";s:3:\"\\3f\";}i:81;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Shopping bag 1\";s:9:\"classname\";s:23:\".auxicon-shopping-bag-1\";s:7:\"content\";s:3:\"\\40\";}i:82;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Shopping bag 2\";s:9:\"classname\";s:23:\".auxicon-shopping-bag-2\";s:7:\"content\";s:3:\"\\5b\";}i:83;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Shopping bag 3\";s:9:\"classname\";s:23:\".auxicon-shopping-bag-3\";s:7:\"content\";s:3:\"\\5d\";}i:84;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Shopping bag 4\";s:9:\"classname\";s:23:\".auxicon-shopping-bag-4\";s:7:\"content\";s:3:\"\\5e\";}i:85;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Shopping cart 1\";s:9:\"classname\";s:24:\".auxicon-shopping-cart-1\";s:7:\"content\";s:3:\"\\5f\";}i:86;O:8:\"stdClass\":3:{s:4:\"name\";s:17:\"Shopping cart 1 1\";s:9:\"classname\";s:26:\".auxicon-shopping-cart-1-1\";s:7:\"content\";s:3:\"\\60\";}i:87;O:8:\"stdClass\":3:{s:4:\"name\";s:17:\"Shopping cart out\";s:9:\"classname\";s:26:\".auxicon-shopping-cart-out\";s:7:\"content\";s:3:\"\\7b\";}i:88;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Shopping cart x\";s:9:\"classname\";s:24:\".auxicon-shopping-cart-x\";s:7:\"content\";s:3:\"\\7c\";}i:89;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Shpping cart in\";s:9:\"classname\";s:24:\".auxicon-shpping-cart-in\";s:7:\"content\";s:3:\"\\7d\";}i:90;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Slider\";s:9:\"classname\";s:15:\".auxicon-slider\";s:7:\"content\";s:3:\"\\7e\";}i:91;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Soup\";s:9:\"classname\";s:13:\".auxicon-soup\";s:7:\"content\";s:3:\"\\5c\";}i:92;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Spray\";s:9:\"classname\";s:14:\".auxicon-spray\";s:7:\"content\";s:5:\"\\e000\";}i:93;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Store\";s:9:\"classname\";s:14:\".auxicon-store\";s:7:\"content\";s:5:\"\\e001\";}i:94;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Sunglasses 1\";s:9:\"classname\";s:21:\".auxicon-sunglasses-1\";s:7:\"content\";s:5:\"\\e002\";}i:95;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Sunglasses 2\";s:9:\"classname\";s:21:\".auxicon-sunglasses-2\";s:7:\"content\";s:5:\"\\e003\";}i:96;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Tag 1\";s:9:\"classname\";s:14:\".auxicon-tag-1\";s:7:\"content\";s:5:\"\\e004\";}i:97;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Tag 2\";s:9:\"classname\";s:14:\".auxicon-tag-2\";s:7:\"content\";s:5:\"\\e005\";}i:98;O:8:\"stdClass\":3:{s:4:\"name\";s:3:\"Tie\";s:9:\"classname\";s:12:\".auxicon-tie\";s:7:\"content\";s:5:\"\\e006\";}i:99;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Truck 1\";s:9:\"classname\";s:16:\".auxicon-truck-1\";s:7:\"content\";s:5:\"\\e007\";}i:100;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Truck 2\";s:9:\"classname\";s:16:\".auxicon-truck-2\";s:7:\"content\";s:5:\"\\e008\";}i:101;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Upload\";s:9:\"classname\";s:15:\".auxicon-upload\";s:7:\"content\";s:5:\"\\e009\";}i:102;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"User round\";s:9:\"classname\";s:19:\".auxicon-user-round\";s:7:\"content\";s:5:\"\\e00b\";}i:103;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"User v\";s:9:\"classname\";s:15:\".auxicon-user-v\";s:7:\"content\";s:5:\"\\e00c\";}i:104;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"User x\";s:9:\"classname\";s:15:\".auxicon-user-x\";s:7:\"content\";s:5:\"\\e00d\";}i:105;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Vinyl\";s:9:\"classname\";s:14:\".auxicon-vinyl\";s:7:\"content\";s:5:\"\\e00e\";}i:106;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Wallet\";s:9:\"classname\";s:15:\".auxicon-wallet\";s:7:\"content\";s:5:\"\\e00f\";}i:107;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Wallet empty\";s:9:\"classname\";s:21:\".auxicon-wallet-empty\";s:7:\"content\";s:5:\"\\e010\";}i:108;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Watch\";s:9:\"classname\";s:14:\".auxicon-watch\";s:7:\"content\";s:5:\"\\e011\";}i:109;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Wrench 1\";s:9:\"classname\";s:17:\".auxicon-wrench-1\";s:7:\"content\";s:5:\"\\e012\";}i:110;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Wrench 2\";s:9:\"classname\";s:17:\".auxicon-wrench-2\";s:7:\"content\";s:5:\"\\e013\";}i:111;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Alarm clock\";s:9:\"classname\";s:20:\".auxicon-alarm-clock\";s:7:\"content\";s:5:\"\\e014\";}i:112;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Badge\";s:9:\"classname\";s:14:\".auxicon-badge\";s:7:\"content\";s:5:\"\\e015\";}i:113;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Bank\";s:9:\"classname\";s:13:\".auxicon-bank\";s:7:\"content\";s:5:\"\\e016\";}i:114;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Bell\";s:9:\"classname\";s:13:\".auxicon-bell\";s:7:\"content\";s:5:\"\\e017\";}i:115;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Brush\";s:9:\"classname\";s:14:\".auxicon-brush\";s:7:\"content\";s:5:\"\\e018\";}i:116;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Calendar\";s:9:\"classname\";s:17:\".auxicon-calendar\";s:7:\"content\";s:5:\"\\e019\";}i:117;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Camera back\";s:9:\"classname\";s:20:\".auxicon-camera-back\";s:7:\"content\";s:5:\"\\e01a\";}i:118;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Camera front\";s:9:\"classname\";s:21:\".auxicon-camera-front\";s:7:\"content\";s:5:\"\\e01b\";}i:119;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Clipboard\";s:9:\"classname\";s:18:\".auxicon-clipboard\";s:7:\"content\";s:5:\"\\e01c\";}i:120;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Cloud 1\";s:9:\"classname\";s:16:\".auxicon-cloud-1\";s:7:\"content\";s:5:\"\\e01d\";}i:121;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Credit card\";s:9:\"classname\";s:20:\".auxicon-credit-card\";s:7:\"content\";s:5:\"\\e01e\";}i:122;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Dashboard\";s:9:\"classname\";s:18:\".auxicon-dashboard\";s:7:\"content\";s:5:\"\\e01f\";}i:123;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"File\";s:9:\"classname\";s:13:\".auxicon-file\";s:7:\"content\";s:5:\"\\e021\";}i:124;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Folder 1\";s:9:\"classname\";s:17:\".auxicon-folder-1\";s:7:\"content\";s:5:\"\\e022\";}i:125;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Handbag\";s:9:\"classname\";s:16:\".auxicon-handbag\";s:7:\"content\";s:5:\"\\e023\";}i:126;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Heart\";s:9:\"classname\";s:14:\".auxicon-heart\";s:7:\"content\";s:5:\"\\e024\";}i:127;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Home\";s:9:\"classname\";s:13:\".auxicon-home\";s:7:\"content\";s:5:\"\\e025\";}i:128;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Id horizontal\";s:9:\"classname\";s:22:\".auxicon-id-horizontal\";s:7:\"content\";s:5:\"\\e026\";}i:129;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Id vertical\";s:9:\"classname\";s:20:\".auxicon-id-vertical\";s:7:\"content\";s:5:\"\\e027\";}i:130;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Location pin\";s:9:\"classname\";s:21:\".auxicon-location-pin\";s:7:\"content\";s:5:\"\\e028\";}i:131;O:8:\"stdClass\":3:{s:4:\"name\";s:3:\"Mac\";s:9:\"classname\";s:12:\".auxicon-mac\";s:7:\"content\";s:5:\"\\e029\";}i:132;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Music\";s:9:\"classname\";s:14:\".auxicon-music\";s:7:\"content\";s:5:\"\\e02a\";}i:133;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Music playlist\";s:9:\"classname\";s:23:\".auxicon-music-playlist\";s:7:\"content\";s:5:\"\\e02b\";}i:134;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"News\";s:9:\"classname\";s:13:\".auxicon-news\";s:7:\"content\";s:5:\"\\e02c\";}i:135;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Office\";s:9:\"classname\";s:15:\".auxicon-office\";s:7:\"content\";s:5:\"\\e02e\";}i:136;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Pen 1\";s:9:\"classname\";s:14:\".auxicon-pen-1\";s:7:\"content\";s:5:\"\\e02f\";}i:137;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Pencil 1\";s:9:\"classname\";s:17:\".auxicon-pencil-1\";s:7:\"content\";s:5:\"\\e030\";}i:138;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Phone\";s:9:\"classname\";s:14:\".auxicon-phone\";s:7:\"content\";s:5:\"\\e031\";}i:139;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Photos\";s:9:\"classname\";s:15:\".auxicon-photos\";s:7:\"content\";s:5:\"\\e032\";}i:140;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Pictures day\";s:9:\"classname\";s:21:\".auxicon-pictures-day\";s:7:\"content\";s:5:\"\\e033\";}i:141;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Pictures night\";s:9:\"classname\";s:23:\".auxicon-pictures-night\";s:7:\"content\";s:5:\"\\e034\";}i:142;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Settings\";s:9:\"classname\";s:17:\".auxicon-settings\";s:7:\"content\";s:5:\"\\e035\";}i:143;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Share 10\";s:9:\"classname\";s:17:\".auxicon-share-10\";s:7:\"content\";s:5:\"\\e036\";}i:144;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Shop\";s:9:\"classname\";s:13:\".auxicon-shop\";s:7:\"content\";s:5:\"\\e037\";}i:145;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Stopwatch\";s:9:\"classname\";s:18:\".auxicon-stopwatch\";s:7:\"content\";s:5:\"\\e038\";}i:146;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Tablet\";s:9:\"classname\";s:15:\".auxicon-tablet\";s:7:\"content\";s:5:\"\\e039\";}i:147;O:8:\"stdClass\":3:{s:4:\"name\";s:3:\"Tag\";s:9:\"classname\";s:12:\".auxicon-tag\";s:7:\"content\";s:5:\"\\e03a\";}i:148;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Tags\";s:9:\"classname\";s:13:\".auxicon-tags\";s:7:\"content\";s:5:\"\\e03b\";}i:149;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Thumbs down\";s:9:\"classname\";s:20:\".auxicon-thumbs-down\";s:7:\"content\";s:5:\"\\e03c\";}i:150;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Thumbs up\";s:9:\"classname\";s:18:\".auxicon-thumbs-up\";s:7:\"content\";s:5:\"\\e03d\";}i:151;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Trophy\";s:9:\"classname\";s:15:\".auxicon-trophy\";s:7:\"content\";s:5:\"\\e03e\";}i:152;O:8:\"stdClass\":3:{s:4:\"name\";s:2:\"Tv\";s:9:\"classname\";s:11:\".auxicon-tv\";s:7:\"content\";s:5:\"\\e03f\";}i:153;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"User 1\";s:9:\"classname\";s:15:\".auxicon-user-1\";s:7:\"content\";s:5:\"\\e040\";}i:154;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Videos\";s:9:\"classname\";s:15:\".auxicon-videos\";s:7:\"content\";s:5:\"\\e041\";}i:155;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Wallet 1\";s:9:\"classname\";s:17:\".auxicon-wallet-1\";s:7:\"content\";s:5:\"\\e042\";}i:156;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Watch 1\";s:9:\"classname\";s:16:\".auxicon-watch-1\";s:7:\"content\";s:5:\"\\e043\";}i:157;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Addons\";s:9:\"classname\";s:15:\".auxicon-addons\";s:7:\"content\";s:5:\"\\e044\";}i:158;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Arrow\";s:9:\"classname\";s:14:\".auxicon-arrow\";s:7:\"content\";s:5:\"\\e045\";}i:159;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Attachment\";s:9:\"classname\";s:19:\".auxicon-attachment\";s:7:\"content\";s:5:\"\\e046\";}i:160;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Award\";s:9:\"classname\";s:14:\".auxicon-award\";s:7:\"content\";s:5:\"\\e047\";}i:161;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Book\";s:9:\"classname\";s:13:\".auxicon-book\";s:7:\"content\";s:5:\"\\e048\";}i:162;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Calendar 1\";s:9:\"classname\";s:19:\".auxicon-calendar-1\";s:7:\"content\";s:5:\"\\e049\";}i:163;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Card\";s:9:\"classname\";s:13:\".auxicon-card\";s:7:\"content\";s:5:\"\\e04a\";}i:164;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Check\";s:9:\"classname\";s:14:\".auxicon-check\";s:7:\"content\";s:5:\"\\e04b\";}i:165;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Coffee\";s:9:\"classname\";s:15:\".auxicon-coffee\";s:7:\"content\";s:5:\"\\e04c\";}i:166;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Compass\";s:9:\"classname\";s:16:\".auxicon-compass\";s:7:\"content\";s:5:\"\\e04d\";}i:167;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Connection\";s:9:\"classname\";s:19:\".auxicon-connection\";s:7:\"content\";s:5:\"\\e04e\";}i:168;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Crown\";s:9:\"classname\";s:14:\".auxicon-crown\";s:7:\"content\";s:5:\"\\e04f\";}i:169;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Dashboard 1\";s:9:\"classname\";s:20:\".auxicon-dashboard-1\";s:7:\"content\";s:5:\"\\e050\";}i:170;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Direction\";s:9:\"classname\";s:18:\".auxicon-direction\";s:7:\"content\";s:5:\"\\e051\";}i:171;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Download 1\";s:9:\"classname\";s:19:\".auxicon-download-1\";s:7:\"content\";s:5:\"\\e052\";}i:172;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Download data\";s:9:\"classname\";s:22:\".auxicon-download-data\";s:7:\"content\";s:5:\"\\e054\";}i:173;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Drop\";s:9:\"classname\";s:13:\".auxicon-drop\";s:7:\"content\";s:5:\"\\e055\";}i:174;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Expand\";s:9:\"classname\";s:15:\".auxicon-expand\";s:7:\"content\";s:5:\"\\e056\";}i:175;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Featured\";s:9:\"classname\";s:17:\".auxicon-featured\";s:7:\"content\";s:5:\"\\e057\";}i:176;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Flag\";s:9:\"classname\";s:13:\".auxicon-flag\";s:7:\"content\";s:5:\"\\e058\";}i:177;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Folder 2\";s:9:\"classname\";s:17:\".auxicon-folder-2\";s:7:\"content\";s:5:\"\\e059\";}i:178;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Food 1\";s:9:\"classname\";s:15:\".auxicon-food-1\";s:7:\"content\";s:5:\"\\e05a\";}i:179;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Food 2\";s:9:\"classname\";s:15:\".auxicon-food-2\";s:7:\"content\";s:5:\"\\e05b\";}i:180;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Gift\";s:9:\"classname\";s:13:\".auxicon-gift\";s:7:\"content\";s:5:\"\\e05c\";}i:181;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Glasses\";s:9:\"classname\";s:16:\".auxicon-glasses\";s:7:\"content\";s:5:\"\\e05d\";}i:182;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Grid\";s:9:\"classname\";s:13:\".auxicon-grid\";s:7:\"content\";s:5:\"\\e05e\";}i:183;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Home 1\";s:9:\"classname\";s:15:\".auxicon-home-1\";s:7:\"content\";s:5:\"\\e05f\";}i:184;O:8:\"stdClass\":3:{s:4:\"name\";s:3:\"Hot\";s:9:\"classname\";s:12:\".auxicon-hot\";s:7:\"content\";s:5:\"\\e060\";}i:185;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Ice cream 1\";s:9:\"classname\";s:20:\".auxicon-ice-cream-1\";s:7:\"content\";s:5:\"\\e061\";}i:186;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Idea\";s:9:\"classname\";s:13:\".auxicon-idea\";s:7:\"content\";s:5:\"\\e062\";}i:187;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Info\";s:9:\"classname\";s:13:\".auxicon-info\";s:7:\"content\";s:5:\"\\e063\";}i:188;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Label\";s:9:\"classname\";s:14:\".auxicon-label\";s:7:\"content\";s:5:\"\\e064\";}i:189;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Like 2 1\";s:9:\"classname\";s:17:\".auxicon-like-2-1\";s:7:\"content\";s:5:\"\\e065\";}i:190;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Link\";s:9:\"classname\";s:13:\".auxicon-link\";s:7:\"content\";s:5:\"\\e066\";}i:191;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"List\";s:9:\"classname\";s:13:\".auxicon-list\";s:7:\"content\";s:5:\"\\e067\";}i:192;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Loading\";s:9:\"classname\";s:16:\".auxicon-loading\";s:7:\"content\";s:5:\"\\e069\";}i:193;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Login\";s:9:\"classname\";s:14:\".auxicon-login\";s:7:\"content\";s:5:\"\\e06a\";}i:194;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Mail\";s:9:\"classname\";s:13:\".auxicon-mail\";s:7:\"content\";s:5:\"\\e06b\";}i:195;O:8:\"stdClass\":3:{s:4:\"name\";s:3:\"Map\";s:9:\"classname\";s:12:\".auxicon-map\";s:7:\"content\";s:5:\"\\e06c\";}i:196;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Map 1\";s:9:\"classname\";s:14:\".auxicon-map-1\";s:7:\"content\";s:5:\"\\e06d\";}i:197;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Map 2\";s:9:\"classname\";s:14:\".auxicon-map-2\";s:7:\"content\";s:5:\"\\e06e\";}i:198;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Mark\";s:9:\"classname\";s:13:\".auxicon-mark\";s:7:\"content\";s:5:\"\\e06f\";}i:199;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Media\";s:9:\"classname\";s:14:\".auxicon-media\";s:7:\"content\";s:5:\"\\e070\";}i:200;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Menu\";s:9:\"classname\";s:13:\".auxicon-menu\";s:7:\"content\";s:5:\"\\e071\";}i:201;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Message\";s:9:\"classname\";s:16:\".auxicon-message\";s:7:\"content\";s:5:\"\\e072\";}i:202;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Money\";s:9:\"classname\";s:14:\".auxicon-money\";s:7:\"content\";s:5:\"\\e073\";}i:203;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Music 1\";s:9:\"classname\";s:16:\".auxicon-music-1\";s:7:\"content\";s:5:\"\\e074\";}i:204;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Notification 1\";s:9:\"classname\";s:23:\".auxicon-notification-1\";s:7:\"content\";s:5:\"\\e075\";}i:205;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Notification 2\";s:9:\"classname\";s:23:\".auxicon-notification-2\";s:7:\"content\";s:5:\"\\e076\";}i:206;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Packet\";s:9:\"classname\";s:15:\".auxicon-packet\";s:7:\"content\";s:5:\"\\e077\";}i:207;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Pause 1\";s:9:\"classname\";s:16:\".auxicon-pause-1\";s:7:\"content\";s:5:\"\\e078\";}i:208;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Pen 2\";s:9:\"classname\";s:14:\".auxicon-pen-2\";s:7:\"content\";s:5:\"\\e079\";}i:209;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Phone 1\";s:9:\"classname\";s:16:\".auxicon-phone-1\";s:7:\"content\";s:5:\"\\e07a\";}i:210;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Photo\";s:9:\"classname\";s:14:\".auxicon-photo\";s:7:\"content\";s:5:\"\\e07b\";}i:211;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Play 1\";s:9:\"classname\";s:15:\".auxicon-play-1\";s:7:\"content\";s:5:\"\\e07c\";}i:212;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Portfolio\";s:9:\"classname\";s:18:\".auxicon-portfolio\";s:7:\"content\";s:5:\"\\e07d\";}i:213;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Profile 1\";s:9:\"classname\";s:18:\".auxicon-profile-1\";s:7:\"content\";s:5:\"\\e07e\";}i:214;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Profile 2\";s:9:\"classname\";s:18:\".auxicon-profile-2\";s:7:\"content\";s:5:\"\\e07f\";}i:215;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Profile 3\";s:9:\"classname\";s:18:\".auxicon-profile-3\";s:7:\"content\";s:5:\"\\e080\";}i:216;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Profile 4\";s:9:\"classname\";s:18:\".auxicon-profile-4\";s:7:\"content\";s:5:\"\\e081\";}i:217;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Repair\";s:9:\"classname\";s:15:\".auxicon-repair\";s:7:\"content\";s:5:\"\\e082\";}i:218;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Repost\";s:9:\"classname\";s:15:\".auxicon-repost\";s:7:\"content\";s:5:\"\\e083\";}i:219;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Resend\";s:9:\"classname\";s:15:\".auxicon-resend\";s:7:\"content\";s:5:\"\\e084\";}i:220;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Rocket\";s:9:\"classname\";s:15:\".auxicon-rocket\";s:7:\"content\";s:5:\"\\e085\";}i:221;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Save\";s:9:\"classname\";s:13:\".auxicon-save\";s:7:\"content\";s:5:\"\\e086\";}i:222;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Search\";s:9:\"classname\";s:15:\".auxicon-search\";s:7:\"content\";s:5:\"\\e087\";}i:223;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Settings 4\";s:9:\"classname\";s:19:\".auxicon-settings-4\";s:7:\"content\";s:5:\"\\e088\";}i:224;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Share 1\";s:9:\"classname\";s:16:\".auxicon-share-1\";s:7:\"content\";s:5:\"\\e089\";}i:225;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Share 2\";s:9:\"classname\";s:16:\".auxicon-share-2\";s:7:\"content\";s:5:\"\\e08a\";}i:226;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Shop 1\";s:9:\"classname\";s:15:\".auxicon-shop-1\";s:7:\"content\";s:5:\"\\e08b\";}i:227;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Sorting\";s:9:\"classname\";s:16:\".auxicon-sorting\";s:7:\"content\";s:5:\"\\e08c\";}i:228;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Sound\";s:9:\"classname\";s:14:\".auxicon-sound\";s:7:\"content\";s:5:\"\\e08d\";}i:229;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Star rate\";s:9:\"classname\";s:18:\".auxicon-star-rate\";s:7:\"content\";s:5:\"\\e08e\";}i:230;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Stats 1\";s:9:\"classname\";s:16:\".auxicon-stats-1\";s:7:\"content\";s:5:\"\\e08f\";}i:231;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Stats 2\";s:9:\"classname\";s:16:\".auxicon-stats-2\";s:7:\"content\";s:5:\"\\e090\";}i:232;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Stats 3\";s:9:\"classname\";s:16:\".auxicon-stats-3\";s:7:\"content\";s:5:\"\\e091\";}i:233;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Stop\";s:9:\"classname\";s:13:\".auxicon-stop\";s:7:\"content\";s:5:\"\\e092\";}i:234;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Tablet 1\";s:9:\"classname\";s:17:\".auxicon-tablet-1\";s:7:\"content\";s:5:\"\\e093\";}i:235;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Tablet mini\";s:9:\"classname\";s:20:\".auxicon-tablet-mini\";s:7:\"content\";s:5:\"\\e094\";}i:236;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Time\";s:9:\"classname\";s:13:\".auxicon-time\";s:7:\"content\";s:5:\"\\e095\";}i:237;O:8:\"stdClass\":3:{s:4:\"name\";s:3:\"Top\";s:9:\"classname\";s:12:\".auxicon-top\";s:7:\"content\";s:5:\"\\e096\";}i:238;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Trash\";s:9:\"classname\";s:14:\".auxicon-trash\";s:7:\"content\";s:5:\"\\e097\";}i:239;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Treasure\";s:9:\"classname\";s:17:\".auxicon-treasure\";s:7:\"content\";s:5:\"\\e098\";}i:240;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"View\";s:9:\"classname\";s:13:\".auxicon-view\";s:7:\"content\";s:5:\"\\e099\";}i:241;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Vote\";s:9:\"classname\";s:13:\".auxicon-vote\";s:7:\"content\";s:5:\"\\e09a\";}i:242;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Wallet 2\";s:9:\"classname\";s:17:\".auxicon-wallet-2\";s:7:\"content\";s:5:\"\\e09b\";}i:243;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Weather\";s:9:\"classname\";s:16:\".auxicon-weather\";s:7:\"content\";s:5:\"\\e09c\";}i:244;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Wireframe\";s:9:\"classname\";s:18:\".auxicon-wireframe\";s:7:\"content\";s:5:\"\\e09d\";}i:245;O:8:\"stdClass\":3:{s:4:\"name\";s:3:\"Add\";s:9:\"classname\";s:12:\".auxicon-add\";s:7:\"content\";s:5:\"\\e09e\";}i:246;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Alarm\";s:9:\"classname\";s:14:\".auxicon-alarm\";s:7:\"content\";s:5:\"\\e09f\";}i:247;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Anchor\";s:9:\"classname\";s:15:\".auxicon-anchor\";s:7:\"content\";s:5:\"\\e0a0\";}i:248;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Attachment 1\";s:9:\"classname\";s:21:\".auxicon-attachment-1\";s:7:\"content\";s:5:\"\\e0a1\";}i:249;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Brightness\";s:9:\"classname\";s:19:\".auxicon-brightness\";s:7:\"content\";s:5:\"\\e0a2\";}i:250;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Brightness half\";s:9:\"classname\";s:24:\".auxicon-brightness-half\";s:7:\"content\";s:5:\"\\e0a3\";}i:251;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Browser\";s:9:\"classname\";s:16:\".auxicon-browser\";s:7:\"content\";s:5:\"\\e0a4\";}i:252;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Calculator 2\";s:9:\"classname\";s:21:\".auxicon-calculator-2\";s:7:\"content\";s:5:\"\\e0a5\";}i:253;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Calendar 2\";s:9:\"classname\";s:19:\".auxicon-calendar-2\";s:7:\"content\";s:5:\"\\e0a6\";}i:254;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Camera\";s:9:\"classname\";s:15:\".auxicon-camera\";s:7:\"content\";s:5:\"\\e0a7\";}i:255;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Chat\";s:9:\"classname\";s:13:\".auxicon-chat\";s:7:\"content\";s:5:\"\\e0a8\";}i:256;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Circle full\";s:9:\"classname\";s:20:\".auxicon-circle-full\";s:7:\"content\";s:5:\"\\e0a9\";}i:257;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Circle half\";s:9:\"classname\";s:20:\".auxicon-circle-half\";s:7:\"content\";s:5:\"\\e0aa\";}i:258;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Clipboard 1\";s:9:\"classname\";s:20:\".auxicon-clipboard-1\";s:7:\"content\";s:5:\"\\e0ab\";}i:259;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Clock\";s:9:\"classname\";s:14:\".auxicon-clock\";s:7:\"content\";s:5:\"\\e0ac\";}i:260;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Close\";s:9:\"classname\";s:14:\".auxicon-close\";s:7:\"content\";s:5:\"\\e0ad\";}i:261;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Cloud 2\";s:9:\"classname\";s:16:\".auxicon-cloud-2\";s:7:\"content\";s:5:\"\\e0ae\";}i:262;O:8:\"stdClass\":3:{s:4:\"name\";s:3:\"Cmd\";s:9:\"classname\";s:12:\".auxicon-cmd\";s:7:\"content\";s:5:\"\\e0af\";}i:263;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Comments\";s:9:\"classname\";s:17:\".auxicon-comments\";s:7:\"content\";s:5:\"\\e0b0\";}i:264;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Compose\";s:9:\"classname\";s:16:\".auxicon-compose\";s:7:\"content\";s:5:\"\\e0b1\";}i:265;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Delicious 1\";s:9:\"classname\";s:20:\".auxicon-delicious-1\";s:7:\"content\";s:5:\"\\e0b2\";}i:266;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Dribbble 1\";s:9:\"classname\";s:19:\".auxicon-dribbble-1\";s:7:\"content\";s:5:\"\\e0b3\";}i:267;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Envelope\";s:9:\"classname\";s:17:\".auxicon-envelope\";s:7:\"content\";s:5:\"\\e0b4\";}i:268;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Exclamation\";s:9:\"classname\";s:20:\".auxicon-exclamation\";s:7:\"content\";s:5:\"\\e0b5\";}i:269;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Expand 1\";s:9:\"classname\";s:17:\".auxicon-expand-1\";s:7:\"content\";s:5:\"\\e0b6\";}i:270;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Feather\";s:9:\"classname\";s:16:\".auxicon-feather\";s:7:\"content\";s:5:\"\\e0b8\";}i:271;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Forbid\";s:9:\"classname\";s:15:\".auxicon-forbid\";s:7:\"content\";s:5:\"\\e0b9\";}i:272;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Forbid 1\";s:9:\"classname\";s:17:\".auxicon-forbid-1\";s:7:\"content\";s:5:\"\\e0ba\";}i:273;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Fork and knife\";s:9:\"classname\";s:23:\".auxicon-fork-and-knife\";s:7:\"content\";s:5:\"\\e0bb\";}i:274;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Fork and spoon\";s:9:\"classname\";s:23:\".auxicon-fork-and-spoon\";s:7:\"content\";s:5:\"\\e0bc\";}i:275;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Forward 1\";s:9:\"classname\";s:18:\".auxicon-forward-1\";s:7:\"content\";s:5:\"\\e0bd\";}i:276;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Gallary\";s:9:\"classname\";s:16:\".auxicon-gallary\";s:7:\"content\";s:5:\"\\e0be\";}i:277;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Globe\";s:9:\"classname\";s:14:\".auxicon-globe\";s:7:\"content\";s:5:\"\\e0bf\";}i:278;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Googleplus 1\";s:9:\"classname\";s:21:\".auxicon-googleplus-1\";s:7:\"content\";s:5:\"\\e0c0\";}i:279;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Grid 1\";s:9:\"classname\";s:15:\".auxicon-grid-1\";s:7:\"content\";s:5:\"\\e0c1\";}i:280;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Grid alt\";s:9:\"classname\";s:17:\".auxicon-grid-alt\";s:7:\"content\";s:5:\"\\e0c2\";}i:281;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Heart 1\";s:9:\"classname\";s:16:\".auxicon-heart-1\";s:7:\"content\";s:5:\"\\e0c3\";}i:282;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Home 2\";s:9:\"classname\";s:15:\".auxicon-home-2\";s:7:\"content\";s:5:\"\\e0c4\";}i:283;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Hyperlink\";s:9:\"classname\";s:18:\".auxicon-hyperlink\";s:7:\"content\";s:5:\"\\e0c5\";}i:284;O:8:\"stdClass\":3:{s:4:\"name\";s:2:\"In\";s:9:\"classname\";s:11:\".auxicon-in\";s:7:\"content\";s:5:\"\\e0c6\";}i:285;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"In alt\";s:9:\"classname\";s:15:\".auxicon-in-alt\";s:7:\"content\";s:5:\"\\e0c7\";}i:286;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Inbox\";s:9:\"classname\";s:14:\".auxicon-inbox\";s:7:\"content\";s:5:\"\\e0c8\";}i:287;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Inbox alt\";s:9:\"classname\";s:18:\".auxicon-inbox-alt\";s:7:\"content\";s:5:\"\\e0c9\";}i:288;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Ipad\";s:9:\"classname\";s:13:\".auxicon-ipad\";s:7:\"content\";s:5:\"\\e0cb\";}i:289;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Iphone\";s:9:\"classname\";s:15:\".auxicon-iphone\";s:7:\"content\";s:5:\"\\e0cc\";}i:290;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Light bulb\";s:9:\"classname\";s:19:\".auxicon-light-bulb\";s:7:\"content\";s:5:\"\\e0cd\";}i:291;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"List 1\";s:9:\"classname\";s:15:\".auxicon-list-1\";s:7:\"content\";s:5:\"\\e0ce\";}i:292;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Maximize\";s:9:\"classname\";s:17:\".auxicon-maximize\";s:7:\"content\";s:5:\"\\e0cf\";}i:293;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Menu 1\";s:9:\"classname\";s:15:\".auxicon-menu-1\";s:7:\"content\";s:5:\"\\e0d0\";}i:294;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Moon\";s:9:\"classname\";s:13:\".auxicon-moon\";s:7:\"content\";s:5:\"\\e0d1\";}i:295;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Newspaper\";s:9:\"classname\";s:18:\".auxicon-newspaper\";s:7:\"content\";s:5:\"\\e0d2\";}i:296;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Newspaper alt\";s:9:\"classname\";s:22:\".auxicon-newspaper-alt\";s:7:\"content\";s:5:\"\\e0d3\";}i:297;O:8:\"stdClass\":3:{s:4:\"name\";s:3:\"Out\";s:9:\"classname\";s:12:\".auxicon-out\";s:7:\"content\";s:5:\"\\e0d4\";}i:298;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Pause 2\";s:9:\"classname\";s:16:\".auxicon-pause-2\";s:7:\"content\";s:5:\"\\e0d5\";}i:299;O:8:\"stdClass\":3:{s:4:\"name\";s:3:\"Pin\";s:9:\"classname\";s:12:\".auxicon-pin\";s:7:\"content\";s:5:\"\\e0d6\";}i:300;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Pin alt\";s:9:\"classname\";s:16:\".auxicon-pin-alt\";s:7:\"content\";s:5:\"\\e0d7\";}i:301;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Play 2\";s:9:\"classname\";s:15:\".auxicon-play-2\";s:7:\"content\";s:5:\"\\e0d8\";}i:302;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Portfolio 1\";s:9:\"classname\";s:20:\".auxicon-portfolio-1\";s:7:\"content\";s:5:\"\\e0d9\";}i:303;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Question\";s:9:\"classname\";s:17:\".auxicon-question\";s:7:\"content\";s:5:\"\\e0da\";}i:304;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Rewind\";s:9:\"classname\";s:15:\".auxicon-rewind\";s:7:\"content\";s:5:\"\\e0db\";}i:305;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Screen\";s:9:\"classname\";s:15:\".auxicon-screen\";s:7:\"content\";s:5:\"\\e0dc\";}i:306;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Settings 5\";s:9:\"classname\";s:19:\".auxicon-settings-5\";s:7:\"content\";s:5:\"\\e0de\";}i:307;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Sound 1\";s:9:\"classname\";s:16:\".auxicon-sound-1\";s:7:\"content\";s:5:\"\\e0df\";}i:308;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Sound alt\";s:9:\"classname\";s:18:\".auxicon-sound-alt\";s:7:\"content\";s:5:\"\\e0e0\";}i:309;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Sound off\";s:9:\"classname\";s:18:\".auxicon-sound-off\";s:7:\"content\";s:5:\"\\e0e1\";}i:310;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Spinner\";s:9:\"classname\";s:16:\".auxicon-spinner\";s:7:\"content\";s:5:\"\\e0e2\";}i:311;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Stop 1\";s:9:\"classname\";s:15:\".auxicon-stop-1\";s:7:\"content\";s:5:\"\\e0e3\";}i:312;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Store 1\";s:9:\"classname\";s:16:\".auxicon-store-1\";s:7:\"content\";s:5:\"\\e0e4\";}i:313;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Subtract\";s:9:\"classname\";s:17:\".auxicon-subtract\";s:7:\"content\";s:5:\"\\e0e5\";}i:314;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Task\";s:9:\"classname\";s:13:\".auxicon-task\";s:7:\"content\";s:5:\"\\e0e6\";}i:315;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Trash 1\";s:9:\"classname\";s:16:\".auxicon-trash-1\";s:7:\"content\";s:5:\"\\e0e7\";}i:316;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Trash alt\";s:9:\"classname\";s:18:\".auxicon-trash-alt\";s:7:\"content\";s:5:\"\\e0e8\";}i:317;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"User 2\";s:9:\"classname\";s:15:\".auxicon-user-2\";s:7:\"content\";s:5:\"\\e0e9\";}i:318;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Users\";s:9:\"classname\";s:14:\".auxicon-users\";s:7:\"content\";s:5:\"\\e0ea\";}i:319;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Windows 1 1\";s:9:\"classname\";s:20:\".auxicon-windows-1-1\";s:7:\"content\";s:5:\"\\e0eb\";}i:320;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Zoom in\";s:9:\"classname\";s:16:\".auxicon-zoom-in\";s:7:\"content\";s:5:\"\\e0ec\";}i:321;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Zoom out\";s:9:\"classname\";s:17:\".auxicon-zoom-out\";s:7:\"content\";s:5:\"\\e0ed\";}i:322;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Alert\";s:9:\"classname\";s:14:\".auxicon-alert\";s:7:\"content\";s:5:\"\\e0ee\";}i:323;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Alignment align\";s:9:\"classname\";s:24:\".auxicon-alignment-align\";s:7:\"content\";s:5:\"\\e0ef\";}i:324;O:8:\"stdClass\":3:{s:4:\"name\";s:20:\"Alignment aligned to\";s:9:\"classname\";s:29:\".auxicon-alignment-aligned-to\";s:7:\"content\";s:5:\"\\e0f0\";}i:325;O:8:\"stdClass\":3:{s:4:\"name\";s:17:\"Alignment unalign\";s:9:\"classname\";s:26:\".auxicon-alignment-unalign\";s:7:\"content\";s:5:\"\\e0f1\";}i:326;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Arrow down\";s:9:\"classname\";s:19:\".auxicon-arrow-down\";s:7:\"content\";s:5:\"\\e0f2\";}i:327;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Arrow left\";s:9:\"classname\";s:19:\".auxicon-arrow-left\";s:7:\"content\";s:5:\"\\e0f3\";}i:328;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Arrow right\";s:9:\"classname\";s:20:\".auxicon-arrow-right\";s:7:\"content\";s:5:\"\\e0f4\";}i:329;O:8:\"stdClass\":3:{s:4:\"name\";s:16:\"Arrow small down\";s:9:\"classname\";s:25:\".auxicon-arrow-small-down\";s:7:\"content\";s:5:\"\\e0f5\";}i:330;O:8:\"stdClass\":3:{s:4:\"name\";s:16:\"Arrow small left\";s:9:\"classname\";s:25:\".auxicon-arrow-small-left\";s:7:\"content\";s:5:\"\\e0f6\";}i:331;O:8:\"stdClass\":3:{s:4:\"name\";s:17:\"Arrow small right\";s:9:\"classname\";s:26:\".auxicon-arrow-small-right\";s:7:\"content\";s:5:\"\\e0f7\";}i:332;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Arrow small up\";s:9:\"classname\";s:23:\".auxicon-arrow-small-up\";s:7:\"content\";s:5:\"\\e0f8\";}i:333;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Arrow up\";s:9:\"classname\";s:17:\".auxicon-arrow-up\";s:7:\"content\";s:5:\"\\e0f9\";}i:334;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Beer\";s:9:\"classname\";s:13:\".auxicon-beer\";s:7:\"content\";s:5:\"\\e0fa\";}i:335;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Book 1\";s:9:\"classname\";s:15:\".auxicon-book-1\";s:7:\"content\";s:5:\"\\e0fb\";}i:336;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Bookmark\";s:9:\"classname\";s:17:\".auxicon-bookmark\";s:7:\"content\";s:5:\"\\e0fc\";}i:337;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Briefcase\";s:9:\"classname\";s:18:\".auxicon-briefcase\";s:7:\"content\";s:5:\"\\e0fd\";}i:338;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Broadcast\";s:9:\"classname\";s:18:\".auxicon-broadcast\";s:7:\"content\";s:5:\"\\e0fe\";}i:339;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Browser 1\";s:9:\"classname\";s:18:\".auxicon-browser-1\";s:7:\"content\";s:5:\"\\e0ff\";}i:340;O:8:\"stdClass\":3:{s:4:\"name\";s:3:\"Bug\";s:9:\"classname\";s:12:\".auxicon-bug\";s:7:\"content\";s:5:\"\\e100\";}i:341;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Calendar 3\";s:9:\"classname\";s:19:\".auxicon-calendar-3\";s:7:\"content\";s:5:\"\\e101\";}i:342;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Check 1\";s:9:\"classname\";s:16:\".auxicon-check-1\";s:7:\"content\";s:5:\"\\e102\";}i:343;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Checklist\";s:9:\"classname\";s:18:\".auxicon-checklist\";s:7:\"content\";s:5:\"\\e103\";}i:344;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Chevron down\";s:9:\"classname\";s:21:\".auxicon-chevron-down\";s:7:\"content\";s:5:\"\\e104\";}i:345;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Chevron left\";s:9:\"classname\";s:21:\".auxicon-chevron-left\";s:7:\"content\";s:5:\"\\e105\";}i:346;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Chevron right\";s:9:\"classname\";s:22:\".auxicon-chevron-right\";s:7:\"content\";s:5:\"\\e106\";}i:347;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Chevron up\";s:9:\"classname\";s:19:\".auxicon-chevron-up\";s:7:\"content\";s:5:\"\\e107\";}i:348;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Circle slash\";s:9:\"classname\";s:21:\".auxicon-circle-slash\";s:7:\"content\";s:5:\"\\e108\";}i:349;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Circuit board\";s:9:\"classname\";s:22:\".auxicon-circuit-board\";s:7:\"content\";s:5:\"\\e109\";}i:350;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Clippy\";s:9:\"classname\";s:15:\".auxicon-clippy\";s:7:\"content\";s:5:\"\\e10a\";}i:351;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Clock 1\";s:9:\"classname\";s:16:\".auxicon-clock-1\";s:7:\"content\";s:5:\"\\e10b\";}i:352;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Cloud download\";s:9:\"classname\";s:23:\".auxicon-cloud-download\";s:7:\"content\";s:5:\"\\e10c\";}i:353;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Cloud upload\";s:9:\"classname\";s:21:\".auxicon-cloud-upload\";s:7:\"content\";s:5:\"\\e10d\";}i:354;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Code\";s:9:\"classname\";s:13:\".auxicon-code\";s:7:\"content\";s:5:\"\\e10e\";}i:355;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Color mode\";s:9:\"classname\";s:19:\".auxicon-color-mode\";s:7:\"content\";s:5:\"\\e10f\";}i:356;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Comment 2 1\";s:9:\"classname\";s:20:\".auxicon-comment-2-1\";s:7:\"content\";s:5:\"\\e110\";}i:357;O:8:\"stdClass\":3:{s:4:\"name\";s:18:\"Comment discussion\";s:9:\"classname\";s:27:\".auxicon-comment-discussion\";s:7:\"content\";s:5:\"\\e111\";}i:358;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Credit card 5\";s:9:\"classname\";s:22:\".auxicon-credit-card-5\";s:7:\"content\";s:5:\"\\e112\";}i:359;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Dash\";s:9:\"classname\";s:13:\".auxicon-dash\";s:7:\"content\";s:5:\"\\e113\";}i:360;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Dashboard 2\";s:9:\"classname\";s:20:\".auxicon-dashboard-2\";s:7:\"content\";s:5:\"\\e114\";}i:361;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Database\";s:9:\"classname\";s:17:\".auxicon-database\";s:7:\"content\";s:5:\"\\e115\";}i:362;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Device camera\";s:9:\"classname\";s:22:\".auxicon-device-camera\";s:7:\"content\";s:5:\"\\e116\";}i:363;O:8:\"stdClass\":3:{s:4:\"name\";s:19:\"Device camera video\";s:9:\"classname\";s:28:\".auxicon-device-camera-video\";s:7:\"content\";s:5:\"\\e117\";}i:364;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Device desktop\";s:9:\"classname\";s:23:\".auxicon-device-desktop\";s:7:\"content\";s:5:\"\\e118\";}i:365;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Device mobile\";s:9:\"classname\";s:22:\".auxicon-device-mobile\";s:7:\"content\";s:5:\"\\e119\";}i:366;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Diff\";s:9:\"classname\";s:13:\".auxicon-diff\";s:7:\"content\";s:5:\"\\e11a\";}i:367;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Diff added\";s:9:\"classname\";s:19:\".auxicon-diff-added\";s:7:\"content\";s:5:\"\\e11b\";}i:368;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Diff ignored\";s:9:\"classname\";s:21:\".auxicon-diff-ignored\";s:7:\"content\";s:5:\"\\e11c\";}i:369;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Diff modified\";s:9:\"classname\";s:22:\".auxicon-diff-modified\";s:7:\"content\";s:5:\"\\e11d\";}i:370;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Diff removed\";s:9:\"classname\";s:21:\".auxicon-diff-removed\";s:7:\"content\";s:5:\"\\e11e\";}i:371;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Diff renamed\";s:9:\"classname\";s:21:\".auxicon-diff-renamed\";s:7:\"content\";s:5:\"\\e11f\";}i:372;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Ellipsis\";s:9:\"classname\";s:17:\".auxicon-ellipsis\";s:7:\"content\";s:5:\"\\e120\";}i:373;O:8:\"stdClass\":3:{s:4:\"name\";s:3:\"Eye\";s:9:\"classname\";s:12:\".auxicon-eye\";s:7:\"content\";s:5:\"\\e121\";}i:374;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"File binary\";s:9:\"classname\";s:20:\".auxicon-file-binary\";s:7:\"content\";s:5:\"\\e122\";}i:375;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"File code\";s:9:\"classname\";s:18:\".auxicon-file-code\";s:7:\"content\";s:5:\"\\e123\";}i:376;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"File directory\";s:9:\"classname\";s:23:\".auxicon-file-directory\";s:7:\"content\";s:5:\"\\e124\";}i:377;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"File media\";s:9:\"classname\";s:19:\".auxicon-file-media\";s:7:\"content\";s:5:\"\\e125\";}i:378;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"File pdf\";s:9:\"classname\";s:17:\".auxicon-file-pdf\";s:7:\"content\";s:5:\"\\e126\";}i:379;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"File submodule\";s:9:\"classname\";s:23:\".auxicon-file-submodule\";s:7:\"content\";s:5:\"\\e127\";}i:380;O:8:\"stdClass\":3:{s:4:\"name\";s:22:\"File symlink directory\";s:9:\"classname\";s:31:\".auxicon-file-symlink-directory\";s:7:\"content\";s:5:\"\\e128\";}i:381;O:8:\"stdClass\":3:{s:4:\"name\";s:17:\"File symlink file\";s:9:\"classname\";s:26:\".auxicon-file-symlink-file\";s:7:\"content\";s:5:\"\\e129\";}i:382;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"File text\";s:9:\"classname\";s:18:\".auxicon-file-text\";s:7:\"content\";s:5:\"\\e12a\";}i:383;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"File zip\";s:9:\"classname\";s:17:\".auxicon-file-zip\";s:7:\"content\";s:5:\"\\e12b\";}i:384;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Flame\";s:9:\"classname\";s:14:\".auxicon-flame\";s:7:\"content\";s:5:\"\\e12c\";}i:385;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Fold\";s:9:\"classname\";s:13:\".auxicon-fold\";s:7:\"content\";s:5:\"\\e12d\";}i:386;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Gear\";s:9:\"classname\";s:13:\".auxicon-gear\";s:7:\"content\";s:5:\"\\e12e\";}i:387;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Gift 1\";s:9:\"classname\";s:15:\".auxicon-gift-1\";s:7:\"content\";s:5:\"\\e12f\";}i:388;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Gist\";s:9:\"classname\";s:13:\".auxicon-gist\";s:7:\"content\";s:5:\"\\e130\";}i:389;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Gist secret\";s:9:\"classname\";s:20:\".auxicon-gist-secret\";s:7:\"content\";s:5:\"\\e131\";}i:390;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Git branch\";s:9:\"classname\";s:19:\".auxicon-git-branch\";s:7:\"content\";s:5:\"\\e132\";}i:391;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Git commit\";s:9:\"classname\";s:19:\".auxicon-git-commit\";s:7:\"content\";s:5:\"\\e133\";}i:392;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Git compare\";s:9:\"classname\";s:20:\".auxicon-git-compare\";s:7:\"content\";s:5:\"\\e134\";}i:393;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Git merge\";s:9:\"classname\";s:18:\".auxicon-git-merge\";s:7:\"content\";s:5:\"\\e135\";}i:394;O:8:\"stdClass\":3:{s:4:\"name\";s:16:\"Git pull request\";s:9:\"classname\";s:25:\".auxicon-git-pull-request\";s:7:\"content\";s:5:\"\\e136\";}i:395;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Globe 1\";s:9:\"classname\";s:16:\".auxicon-globe-1\";s:7:\"content\";s:5:\"\\e137\";}i:396;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Graph\";s:9:\"classname\";s:14:\".auxicon-graph\";s:7:\"content\";s:5:\"\\e138\";}i:397;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Heart 2\";s:9:\"classname\";s:16:\".auxicon-heart-2\";s:7:\"content\";s:5:\"\\e139\";}i:398;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"History\";s:9:\"classname\";s:16:\".auxicon-history\";s:7:\"content\";s:5:\"\\e13a\";}i:399;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Home 3\";s:9:\"classname\";s:15:\".auxicon-home-3\";s:7:\"content\";s:5:\"\\e13b\";}i:400;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Horizontal rule\";s:9:\"classname\";s:24:\".auxicon-horizontal-rule\";s:7:\"content\";s:5:\"\\e13c\";}i:401;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Hourglass\";s:9:\"classname\";s:18:\".auxicon-hourglass\";s:7:\"content\";s:5:\"\\e13d\";}i:402;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Hubot\";s:9:\"classname\";s:14:\".auxicon-hubot\";s:7:\"content\";s:5:\"\\e13e\";}i:403;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Inbox 1\";s:9:\"classname\";s:16:\".auxicon-inbox-1\";s:7:\"content\";s:5:\"\\e13f\";}i:404;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Info 1\";s:9:\"classname\";s:15:\".auxicon-info-1\";s:7:\"content\";s:5:\"\\e140\";}i:405;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Issue closed\";s:9:\"classname\";s:21:\".auxicon-issue-closed\";s:7:\"content\";s:5:\"\\e141\";}i:406;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Issue opened\";s:9:\"classname\";s:21:\".auxicon-issue-opened\";s:7:\"content\";s:5:\"\\e142\";}i:407;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Issue reopened\";s:9:\"classname\";s:23:\".auxicon-issue-reopened\";s:7:\"content\";s:5:\"\\e143\";}i:408;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Jersey\";s:9:\"classname\";s:15:\".auxicon-jersey\";s:7:\"content\";s:5:\"\\e144\";}i:409;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Jump down\";s:9:\"classname\";s:18:\".auxicon-jump-down\";s:7:\"content\";s:5:\"\\e145\";}i:410;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Jump left\";s:9:\"classname\";s:18:\".auxicon-jump-left\";s:7:\"content\";s:5:\"\\e146\";}i:411;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Jump right\";s:9:\"classname\";s:19:\".auxicon-jump-right\";s:7:\"content\";s:5:\"\\e147\";}i:412;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Jump up\";s:9:\"classname\";s:16:\".auxicon-jump-up\";s:7:\"content\";s:5:\"\\e148\";}i:413;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Key 1\";s:9:\"classname\";s:14:\".auxicon-key-1\";s:7:\"content\";s:5:\"\\e149\";}i:414;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Keyboard 1\";s:9:\"classname\";s:19:\".auxicon-keyboard-1\";s:7:\"content\";s:5:\"\\e14a\";}i:415;O:8:\"stdClass\":3:{s:4:\"name\";s:3:\"Law\";s:9:\"classname\";s:12:\".auxicon-law\";s:7:\"content\";s:5:\"\\e14b\";}i:416;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Light bulb 1\";s:9:\"classname\";s:21:\".auxicon-light-bulb-1\";s:7:\"content\";s:5:\"\\e14c\";}i:417;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Link 1\";s:9:\"classname\";s:15:\".auxicon-link-1\";s:7:\"content\";s:5:\"\\e14d\";}i:418;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Link external\";s:9:\"classname\";s:22:\".auxicon-link-external\";s:7:\"content\";s:5:\"\\e14e\";}i:419;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"List ordered\";s:9:\"classname\";s:21:\".auxicon-list-ordered\";s:7:\"content\";s:5:\"\\e14f\";}i:420;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"List unordered\";s:9:\"classname\";s:23:\".auxicon-list-unordered\";s:7:\"content\";s:5:\"\\e150\";}i:421;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Location\";s:9:\"classname\";s:17:\".auxicon-location\";s:7:\"content\";s:5:\"\\e151\";}i:422;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Lock\";s:9:\"classname\";s:13:\".auxicon-lock\";s:7:\"content\";s:5:\"\\e152\";}i:423;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Logo github\";s:9:\"classname\";s:20:\".auxicon-logo-github\";s:7:\"content\";s:5:\"\\e153\";}i:424;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Mail 1\";s:9:\"classname\";s:15:\".auxicon-mail-1\";s:7:\"content\";s:5:\"\\e154\";}i:425;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Mail read\";s:9:\"classname\";s:18:\".auxicon-mail-read\";s:7:\"content\";s:5:\"\\e155\";}i:426;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Mail reply\";s:9:\"classname\";s:19:\".auxicon-mail-reply\";s:7:\"content\";s:5:\"\\e156\";}i:427;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Mark github\";s:9:\"classname\";s:20:\".auxicon-mark-github\";s:7:\"content\";s:5:\"\\e157\";}i:428;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Markdown\";s:9:\"classname\";s:17:\".auxicon-markdown\";s:7:\"content\";s:5:\"\\e158\";}i:429;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Megaphone\";s:9:\"classname\";s:18:\".auxicon-megaphone\";s:7:\"content\";s:5:\"\\e159\";}i:430;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Mention\";s:9:\"classname\";s:16:\".auxicon-mention\";s:7:\"content\";s:5:\"\\e15a\";}i:431;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Microscope\";s:9:\"classname\";s:19:\".auxicon-microscope\";s:7:\"content\";s:5:\"\\e15b\";}i:432;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Milestone\";s:9:\"classname\";s:18:\".auxicon-milestone\";s:7:\"content\";s:5:\"\\e15c\";}i:433;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Mirror\";s:9:\"classname\";s:15:\".auxicon-mirror\";s:7:\"content\";s:5:\"\\e15d\";}i:434;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Mortar board\";s:9:\"classname\";s:21:\".auxicon-mortar-board\";s:7:\"content\";s:5:\"\\e15e\";}i:435;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Move down\";s:9:\"classname\";s:18:\".auxicon-move-down\";s:7:\"content\";s:5:\"\\e15f\";}i:436;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Move left\";s:9:\"classname\";s:18:\".auxicon-move-left\";s:7:\"content\";s:5:\"\\e160\";}i:437;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Move right\";s:9:\"classname\";s:19:\".auxicon-move-right\";s:7:\"content\";s:5:\"\\e161\";}i:438;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Move up\";s:9:\"classname\";s:16:\".auxicon-move-up\";s:7:\"content\";s:5:\"\\e162\";}i:439;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Mute\";s:9:\"classname\";s:13:\".auxicon-mute\";s:7:\"content\";s:5:\"\\e163\";}i:440;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"No newline\";s:9:\"classname\";s:19:\".auxicon-no-newline\";s:7:\"content\";s:5:\"\\e164\";}i:441;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Octoface\";s:9:\"classname\";s:17:\".auxicon-octoface\";s:7:\"content\";s:5:\"\\e165\";}i:442;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Organization\";s:9:\"classname\";s:21:\".auxicon-organization\";s:7:\"content\";s:5:\"\\e166\";}i:443;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Package\";s:9:\"classname\";s:16:\".auxicon-package\";s:7:\"content\";s:5:\"\\e167\";}i:444;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Paintcan\";s:9:\"classname\";s:17:\".auxicon-paintcan\";s:7:\"content\";s:5:\"\\e168\";}i:445;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Pencil 2\";s:9:\"classname\";s:17:\".auxicon-pencil-2\";s:7:\"content\";s:5:\"\\e169\";}i:446;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Person\";s:9:\"classname\";s:15:\".auxicon-person\";s:7:\"content\";s:5:\"\\e16a\";}i:447;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Pin 1\";s:9:\"classname\";s:14:\".auxicon-pin-1\";s:7:\"content\";s:5:\"\\e16b\";}i:448;O:8:\"stdClass\":3:{s:4:\"name\";s:21:\"Playback fast forward\";s:9:\"classname\";s:30:\".auxicon-playback-fast-forward\";s:7:\"content\";s:5:\"\\e16c\";}i:449;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Playback pause\";s:9:\"classname\";s:23:\".auxicon-playback-pause\";s:7:\"content\";s:5:\"\\e16d\";}i:450;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Playback rewind\";s:9:\"classname\";s:24:\".auxicon-playback-rewind\";s:7:\"content\";s:5:\"\\e16f\";}i:451;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Plug\";s:9:\"classname\";s:13:\".auxicon-plug\";s:7:\"content\";s:5:\"\\e170\";}i:452;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Podium\";s:9:\"classname\";s:15:\".auxicon-podium\";s:7:\"content\";s:5:\"\\e172\";}i:453;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Primitive dot\";s:9:\"classname\";s:22:\".auxicon-primitive-dot\";s:7:\"content\";s:5:\"\\e173\";}i:454;O:8:\"stdClass\":3:{s:4:\"name\";s:16:\"Primitive square\";s:9:\"classname\";s:25:\".auxicon-primitive-square\";s:7:\"content\";s:5:\"\\e174\";}i:455;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Pulse\";s:9:\"classname\";s:14:\".auxicon-pulse\";s:7:\"content\";s:5:\"\\e175\";}i:456;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Puzzle\";s:9:\"classname\";s:15:\".auxicon-puzzle\";s:7:\"content\";s:5:\"\\e176\";}i:457;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Question 1\";s:9:\"classname\";s:19:\".auxicon-question-1\";s:7:\"content\";s:5:\"\\e177\";}i:458;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Quote\";s:9:\"classname\";s:14:\".auxicon-quote\";s:7:\"content\";s:5:\"\\e178\";}i:459;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Radio tower\";s:9:\"classname\";s:20:\".auxicon-radio-tower\";s:7:\"content\";s:5:\"\\e179\";}i:460;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Repo\";s:9:\"classname\";s:13:\".auxicon-repo\";s:7:\"content\";s:5:\"\\e17a\";}i:461;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Repo clone\";s:9:\"classname\";s:19:\".auxicon-repo-clone\";s:7:\"content\";s:5:\"\\e17b\";}i:462;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Repo force push\";s:9:\"classname\";s:24:\".auxicon-repo-force-push\";s:7:\"content\";s:5:\"\\e17c\";}i:463;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Repo forked\";s:9:\"classname\";s:20:\".auxicon-repo-forked\";s:7:\"content\";s:5:\"\\e17d\";}i:464;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Repo pull\";s:9:\"classname\";s:18:\".auxicon-repo-pull\";s:7:\"content\";s:5:\"\\e17e\";}i:465;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Repo push\";s:9:\"classname\";s:18:\".auxicon-repo-push\";s:7:\"content\";s:5:\"\\e17f\";}i:466;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Rocket 1\";s:9:\"classname\";s:17:\".auxicon-rocket-1\";s:7:\"content\";s:5:\"\\e180\";}i:467;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Rss 1\";s:9:\"classname\";s:14:\".auxicon-rss-1\";s:7:\"content\";s:5:\"\\e181\";}i:468;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Ruby\";s:9:\"classname\";s:13:\".auxicon-ruby\";s:7:\"content\";s:5:\"\\e182\";}i:469;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Screen full\";s:9:\"classname\";s:20:\".auxicon-screen-full\";s:7:\"content\";s:5:\"\\e183\";}i:470;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Screen normal\";s:9:\"classname\";s:22:\".auxicon-screen-normal\";s:7:\"content\";s:5:\"\\e184\";}i:471;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Search 2\";s:9:\"classname\";s:17:\".auxicon-search-2\";s:7:\"content\";s:5:\"\\e185\";}i:472;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Server\";s:9:\"classname\";s:15:\".auxicon-server\";s:7:\"content\";s:5:\"\\e186\";}i:473;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Settings 6\";s:9:\"classname\";s:19:\".auxicon-settings-6\";s:7:\"content\";s:5:\"\\e187\";}i:474;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Sign in\";s:9:\"classname\";s:16:\".auxicon-sign-in\";s:7:\"content\";s:5:\"\\e188\";}i:475;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Sign out\";s:9:\"classname\";s:17:\".auxicon-sign-out\";s:7:\"content\";s:5:\"\\e189\";}i:476;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Split\";s:9:\"classname\";s:14:\".auxicon-split\";s:7:\"content\";s:5:\"\\e18a\";}i:477;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Squirrel\";s:9:\"classname\";s:17:\".auxicon-squirrel\";s:7:\"content\";s:5:\"\\e18b\";}i:478;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Star\";s:9:\"classname\";s:13:\".auxicon-star\";s:7:\"content\";s:5:\"\\e18c\";}i:479;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Steps\";s:9:\"classname\";s:14:\".auxicon-steps\";s:7:\"content\";s:5:\"\\e18d\";}i:480;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Stop 2\";s:9:\"classname\";s:15:\".auxicon-stop-2\";s:7:\"content\";s:5:\"\\e18e\";}i:481;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Sync\";s:9:\"classname\";s:13:\".auxicon-sync\";s:7:\"content\";s:5:\"\\e18f\";}i:482;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Tag 3\";s:9:\"classname\";s:14:\".auxicon-tag-3\";s:7:\"content\";s:5:\"\\e190\";}i:483;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Telescope\";s:9:\"classname\";s:18:\".auxicon-telescope\";s:7:\"content\";s:5:\"\\e191\";}i:484;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Terminal\";s:9:\"classname\";s:17:\".auxicon-terminal\";s:7:\"content\";s:5:\"\\e192\";}i:485;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Three bars\";s:9:\"classname\";s:19:\".auxicon-three-bars\";s:7:\"content\";s:5:\"\\e193\";}i:486;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Tools\";s:9:\"classname\";s:14:\".auxicon-tools\";s:7:\"content\";s:5:\"\\e194\";}i:487;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Trashcan\";s:9:\"classname\";s:17:\".auxicon-trashcan\";s:7:\"content\";s:5:\"\\e195\";}i:488;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Triangle down\";s:9:\"classname\";s:22:\".auxicon-triangle-down\";s:7:\"content\";s:5:\"\\e196\";}i:489;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Triangle left\";s:9:\"classname\";s:22:\".auxicon-triangle-left\";s:7:\"content\";s:5:\"\\e197\";}i:490;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Triangle right\";s:9:\"classname\";s:23:\".auxicon-triangle-right\";s:7:\"content\";s:5:\"\\e198\";}i:491;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Triangle up\";s:9:\"classname\";s:20:\".auxicon-triangle-up\";s:7:\"content\";s:5:\"\\e199\";}i:492;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Unfold\";s:9:\"classname\";s:15:\".auxicon-unfold\";s:7:\"content\";s:5:\"\\e19a\";}i:493;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Unmute\";s:9:\"classname\";s:15:\".auxicon-unmute\";s:7:\"content\";s:5:\"\\e19b\";}i:494;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Versions\";s:9:\"classname\";s:17:\".auxicon-versions\";s:7:\"content\";s:5:\"\\e19c\";}i:495;O:8:\"stdClass\":3:{s:4:\"name\";s:1:\"X\";s:9:\"classname\";s:10:\".auxicon-x\";s:7:\"content\";s:5:\"\\e19d\";}i:496;O:8:\"stdClass\":3:{s:4:\"name\";s:3:\"Zap\";s:9:\"classname\";s:12:\".auxicon-zap\";s:7:\"content\";s:5:\"\\e19e\";}i:497;O:8:\"stdClass\":3:{s:4:\"name\";s:25:\"Armchair chair streamline\";s:9:\"classname\";s:34:\".auxicon-armchair-chair-streamline\";s:7:\"content\";s:5:\"\\e617\";}i:498;O:8:\"stdClass\":3:{s:4:\"name\";s:23:\"Arrow streamline target\";s:9:\"classname\";s:32:\".auxicon-arrow-streamline-target\";s:7:\"content\";s:5:\"\\e618\";}i:499;O:8:\"stdClass\":3:{s:4:\"name\";s:28:\"Backpack streamline trekking\";s:9:\"classname\";s:37:\".auxicon-backpack-streamline-trekking\";s:7:\"content\";s:5:\"\\e619\";}i:500;O:8:\"stdClass\":3:{s:4:\"name\";s:23:\"Bag shopping streamline\";s:9:\"classname\";s:32:\".auxicon-bag-shopping-streamline\";s:7:\"content\";s:5:\"\\e61a\";}i:501;O:8:\"stdClass\":3:{s:4:\"name\";s:28:\"Barbecue eat food streamline\";s:9:\"classname\";s:37:\".auxicon-barbecue-eat-food-streamline\";s:7:\"content\";s:5:\"\\e61b\";}i:502;O:8:\"stdClass\":3:{s:4:\"name\";s:34:\"Barista coffee espresso streamline\";s:9:\"classname\";s:43:\".auxicon-barista-coffee-espresso-streamline\";s:7:\"content\";s:5:\"\\e61c\";}i:503;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Bomb bug\";s:9:\"classname\";s:17:\".auxicon-bomb-bug\";s:7:\"content\";s:5:\"\\e61d\";}i:504;O:8:\"stdClass\":3:{s:4:\"name\";s:23:\"Book dowload streamline\";s:9:\"classname\";s:32:\".auxicon-book-dowload-streamline\";s:7:\"content\";s:5:\"\\e61e\";}i:505;O:8:\"stdClass\":3:{s:4:\"name\";s:20:\"Book read streamline\";s:9:\"classname\";s:29:\".auxicon-book-read-streamline\";s:7:\"content\";s:5:\"\\e61f\";}i:506;O:8:\"stdClass\":3:{s:4:\"name\";s:25:\"Browser streamline window\";s:9:\"classname\";s:34:\".auxicon-browser-streamline-window\";s:7:\"content\";s:5:\"\\e620\";}i:507;O:8:\"stdClass\":3:{s:4:\"name\";s:22:\"Brush paint streamline\";s:9:\"classname\";s:31:\".auxicon-brush-paint-streamline\";s:7:\"content\";s:5:\"\\e621\";}i:508;O:8:\"stdClass\":3:{s:4:\"name\";s:30:\"Bubble comment streamline talk\";s:9:\"classname\";s:39:\".auxicon-bubble-comment-streamline-talk\";s:7:\"content\";s:5:\"\\e622\";}i:509;O:8:\"stdClass\":3:{s:4:\"name\";s:27:\"Bubble love streamline talk\";s:9:\"classname\";s:36:\".auxicon-bubble-love-streamline-talk\";s:7:\"content\";s:5:\"\\e623\";}i:510;O:8:\"stdClass\":3:{s:4:\"name\";s:31:\"Caddie shop shopping streamline\";s:9:\"classname\";s:40:\".auxicon-caddie-shop-shopping-streamline\";s:7:\"content\";s:5:\"\\e624\";}i:511;O:8:\"stdClass\":3:{s:4:\"name\";s:26:\"Caddie shopping streamline\";s:9:\"classname\";s:35:\".auxicon-caddie-shopping-streamline\";s:7:\"content\";s:5:\"\\e625\";}i:512;O:8:\"stdClass\":3:{s:4:\"name\";s:32:\"Camera photo polaroid streamline\";s:9:\"classname\";s:41:\".auxicon-camera-photo-polaroid-streamline\";s:7:\"content\";s:5:\"\\e626\";}i:513;O:8:\"stdClass\":3:{s:4:\"name\";s:23:\"Camera photo streamline\";s:9:\"classname\";s:32:\".auxicon-camera-photo-streamline\";s:7:\"content\";s:5:\"\\e627\";}i:514;O:8:\"stdClass\":3:{s:4:\"name\";s:23:\"Camera streamline video\";s:9:\"classname\";s:32:\".auxicon-camera-streamline-video\";s:7:\"content\";s:5:\"\\e628\";}i:515;O:8:\"stdClass\":3:{s:4:\"name\";s:28:\"Chaplin hat movie streamline\";s:9:\"classname\";s:37:\".auxicon-chaplin-hat-movie-streamline\";s:7:\"content\";s:5:\"\\e629\";}i:516;O:8:\"stdClass\":3:{s:4:\"name\";s:31:\"Chef food restaurant streamline\";s:9:\"classname\";s:40:\".auxicon-chef-food-restaurant-streamline\";s:7:\"content\";s:5:\"\\e62a\";}i:517;O:8:\"stdClass\":3:{s:4:\"name\";s:21:\"Clock streamline time\";s:9:\"classname\";s:30:\".auxicon-clock-streamline-time\";s:7:\"content\";s:5:\"\\e62b\";}i:518;O:8:\"stdClass\":3:{s:4:\"name\";s:26:\"Cocktail mojito streamline\";s:9:\"classname\";s:35:\".auxicon-cocktail-mojito-streamline\";s:7:\"content\";s:5:\"\\e62c\";}i:519;O:8:\"stdClass\":3:{s:4:\"name\";s:17:\"Coffee streamline\";s:9:\"classname\";s:26:\".auxicon-coffee-streamline\";s:7:\"content\";s:5:\"\\e62d\";}i:520;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Computer imac\";s:9:\"classname\";s:22:\".auxicon-computer-imac\";s:7:\"content\";s:5:\"\\e62e\";}i:521;O:8:\"stdClass\":3:{s:4:\"name\";s:26:\"Computer macintosh vintage\";s:9:\"classname\";s:35:\".auxicon-computer-macintosh-vintage\";s:7:\"content\";s:5:\"\\e630\";}i:522;O:8:\"stdClass\":3:{s:4:\"name\";s:27:\"Computer network streamline\";s:9:\"classname\";s:36:\".auxicon-computer-network-streamline\";s:7:\"content\";s:5:\"\\e631\";}i:523;O:8:\"stdClass\":3:{s:4:\"name\";s:19:\"Computer streamline\";s:9:\"classname\";s:28:\".auxicon-computer-streamline\";s:7:\"content\";s:5:\"\\e632\";}i:524;O:8:\"stdClass\":3:{s:4:\"name\";s:23:\"Cook pan pot streamline\";s:9:\"classname\";s:32:\".auxicon-cook-pan-pot-streamline\";s:7:\"content\";s:5:\"\\e633\";}i:525;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Crop streamline\";s:9:\"classname\";s:24:\".auxicon-crop-streamline\";s:7:\"content\";s:5:\"\\e634\";}i:526;O:8:\"stdClass\":3:{s:4:\"name\";s:21:\"Crown king streamline\";s:9:\"classname\";s:30:\".auxicon-crown-king-streamline\";s:7:\"content\";s:5:\"\\e635\";}i:527;O:8:\"stdClass\":3:{s:4:\"name\";s:40:\"Danger death delete destroy skull stream\";s:9:\"classname\";s:49:\".auxicon-danger-death-delete-destroy-skull-stream\";s:7:\"content\";s:5:\"\\e636\";}i:528;O:8:\"stdClass\":3:{s:4:\"name\";s:26:\"Dashboard speed streamline\";s:9:\"classname\";s:35:\".auxicon-dashboard-speed-streamline\";s:7:\"content\";s:5:\"\\e637\";}i:529;O:8:\"stdClass\":3:{s:4:\"name\";s:19:\"Database streamline\";s:9:\"classname\";s:28:\".auxicon-database-streamline\";s:7:\"content\";s:5:\"\\e638\";}i:530;O:8:\"stdClass\":3:{s:4:\"name\";s:25:\"Delete garbage streamline\";s:9:\"classname\";s:34:\".auxicon-delete-garbage-streamline\";s:7:\"content\";s:5:\"\\e639\";}i:531;O:8:\"stdClass\":3:{s:4:\"name\";s:39:\"Design graphic tablet streamline tablet\";s:9:\"classname\";s:48:\".auxicon-design-graphic-tablet-streamline-tablet\";s:7:\"content\";s:5:\"\\e63a\";}i:532;O:8:\"stdClass\":3:{s:4:\"name\";s:29:\"Design pencil rule streamline\";s:9:\"classname\";s:38:\".auxicon-design-pencil-rule-streamline\";s:7:\"content\";s:5:\"\\e63b\";}i:533;O:8:\"stdClass\":3:{s:4:\"name\";s:35:\"Diving leisure sea sport streamline\";s:9:\"classname\";s:44:\".auxicon-diving-leisure-sea-sport-streamline\";s:7:\"content\";s:5:\"\\e63c\";}i:534;O:8:\"stdClass\":3:{s:4:\"name\";s:33:\"Drug medecine streamline syringue\";s:9:\"classname\";s:42:\".auxicon-drug-medecine-streamline-syringue\";s:7:\"content\";s:5:\"\\e63d\";}i:535;O:8:\"stdClass\":3:{s:4:\"name\";s:22:\"Earth globe streamline\";s:9:\"classname\";s:31:\".auxicon-earth-globe-streamline\";s:7:\"content\";s:5:\"\\e63e\";}i:536;O:8:\"stdClass\":3:{s:4:\"name\";s:30:\"Eat food fork knife streamline\";s:9:\"classname\";s:39:\".auxicon-eat-food-fork-knife-streamline\";s:7:\"content\";s:5:\"\\e63f\";}i:537;O:8:\"stdClass\":3:{s:4:\"name\";s:26:\"Eat food hotdog streamline\";s:9:\"classname\";s:35:\".auxicon-eat-food-hotdog-streamline\";s:7:\"content\";s:5:\"\\e640\";}i:538;O:8:\"stdClass\":3:{s:4:\"name\";s:22:\"Eye dropper streamline\";s:9:\"classname\";s:31:\".auxicon-eye-dropper-streamline\";s:7:\"content\";s:5:\"\\e644\";}i:539;O:8:\"stdClass\":3:{s:4:\"name\";s:33:\"Factory lift streamline warehouse\";s:9:\"classname\";s:42:\".auxicon-factory-lift-streamline-warehouse\";s:7:\"content\";s:5:\"\\e645\";}i:540;O:8:\"stdClass\":3:{s:4:\"name\";s:36:\"First aid medecine shield streamline\";s:9:\"classname\";s:45:\".auxicon-first-aid-medecine-shield-streamline\";s:7:\"content\";s:5:\"\\e646\";}i:541;O:8:\"stdClass\":3:{s:4:\"name\";s:25:\"Food ice cream streamline\";s:9:\"classname\";s:34:\".auxicon-food-ice-cream-streamline\";s:7:\"content\";s:5:\"\\e647\";}i:542;O:8:\"stdClass\":3:{s:4:\"name\";s:24:\"Frame picture streamline\";s:9:\"classname\";s:33:\".auxicon-frame-picture-streamline\";s:7:\"content\";s:5:\"\\e648\";}i:543;O:8:\"stdClass\":3:{s:4:\"name\";s:24:\"Handle streamline vector\";s:9:\"classname\";s:33:\".auxicon-handle-streamline-vector\";s:7:\"content\";s:5:\"\\e64a\";}i:544;O:8:\"stdClass\":3:{s:4:\"name\";s:23:\"Happy smiley streamline\";s:9:\"classname\";s:32:\".auxicon-happy-smiley-streamline\";s:7:\"content\";s:5:\"\\e64b\";}i:545;O:8:\"stdClass\":3:{s:4:\"name\";s:24:\"Headset sound streamline\";s:9:\"classname\";s:33:\".auxicon-headset-sound-streamline\";s:7:\"content\";s:5:\"\\e64c\";}i:546;O:8:\"stdClass\":3:{s:4:\"name\";s:21:\"Home house streamline\";s:9:\"classname\";s:30:\".auxicon-home-house-streamline\";s:7:\"content\";s:5:\"\\e64d\";}i:547;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Ibook laptop\";s:9:\"classname\";s:21:\".auxicon-ibook-laptop\";s:7:\"content\";s:5:\"\\e64e\";}i:548;O:8:\"stdClass\":3:{s:4:\"name\";s:18:\"Ink pen streamline\";s:9:\"classname\";s:27:\".auxicon-ink-pen-streamline\";s:7:\"content\";s:5:\"\\e64f\";}i:549;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Ipad streamline\";s:9:\"classname\";s:24:\".auxicon-ipad-streamline\";s:7:\"content\";s:5:\"\\e650\";}i:550;O:8:\"stdClass\":3:{s:4:\"name\";s:17:\"Iphone streamline\";s:9:\"classname\";s:26:\".auxicon-iphone-streamline\";s:7:\"content\";s:5:\"\\e651\";}i:551;O:8:\"stdClass\":3:{s:4:\"name\";s:26:\"Ipod mini music streamline\";s:9:\"classname\";s:35:\".auxicon-ipod-mini-music-streamline\";s:7:\"content\";s:5:\"\\e652\";}i:552;O:8:\"stdClass\":3:{s:4:\"name\";s:21:\"Ipod music streamline\";s:9:\"classname\";s:30:\".auxicon-ipod-music-streamline\";s:7:\"content\";s:5:\"\\e653\";}i:553;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Ipod streamline\";s:9:\"classname\";s:24:\".auxicon-ipod-streamline\";s:7:\"content\";s:5:\"\\e654\";}i:554;O:8:\"stdClass\":3:{s:4:\"name\";s:20:\"Japan streamline tea\";s:9:\"classname\";s:29:\".auxicon-japan-streamline-tea\";s:7:\"content\";s:5:\"\\e655\";}i:555;O:8:\"stdClass\":3:{s:4:\"name\";s:25:\"Laptop macbook streamline\";s:9:\"classname\";s:34:\".auxicon-laptop-macbook-streamline\";s:7:\"content\";s:5:\"\\e656\";}i:556;O:8:\"stdClass\":3:{s:4:\"name\";s:20:\"Like love streamline\";s:9:\"classname\";s:29:\".auxicon-like-love-streamline\";s:7:\"content\";s:5:\"\\e657\";}i:557;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Link streamline\";s:9:\"classname\";s:24:\".auxicon-link-streamline\";s:7:\"content\";s:5:\"\\e658\";}i:558;O:8:\"stdClass\":3:{s:4:\"name\";s:22:\"Lock locker streamline\";s:9:\"classname\";s:31:\".auxicon-lock-locker-streamline\";s:7:\"content\";s:5:\"\\e659\";}i:559;O:8:\"stdClass\":3:{s:4:\"name\";s:24:\"Locker streamline unlock\";s:9:\"classname\";s:33:\".auxicon-locker-streamline-unlock\";s:7:\"content\";s:5:\"\\e65a\";}i:560;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Macintosh\";s:9:\"classname\";s:18:\".auxicon-macintosh\";s:7:\"content\";s:5:\"\\e65b\";}i:561;O:8:\"stdClass\":3:{s:4:\"name\";s:27:\"Magic magic wand streamline\";s:9:\"classname\";s:36:\".auxicon-magic-magic-wand-streamline\";s:7:\"content\";s:5:\"\\e65c\";}i:562;O:8:\"stdClass\":3:{s:4:\"name\";s:17:\"Magnet streamline\";s:9:\"classname\";s:26:\".auxicon-magnet-streamline\";s:7:\"content\";s:5:\"\\e65d\";}i:563;O:8:\"stdClass\":3:{s:4:\"name\";s:26:\"Man people streamline user\";s:9:\"classname\";s:35:\".auxicon-man-people-streamline-user\";s:7:\"content\";s:5:\"\\e65e\";}i:564;O:8:\"stdClass\":3:{s:4:\"name\";s:19:\"Map streamline user\";s:9:\"classname\";s:28:\".auxicon-map-streamline-user\";s:7:\"content\";s:5:\"\\e660\";}i:565;O:8:\"stdClass\":3:{s:4:\"name\";s:23:\"Micro record streamline\";s:9:\"classname\";s:32:\".auxicon-micro-record-streamline\";s:7:\"content\";s:5:\"\\e661\";}i:566;O:8:\"stdClass\":3:{s:4:\"name\";s:27:\"Monocle mustache streamline\";s:9:\"classname\";s:36:\".auxicon-monocle-mustache-streamline\";s:7:\"content\";s:5:\"\\e662\";}i:567;O:8:\"stdClass\":3:{s:4:\"name\";s:21:\"Music note streamline\";s:9:\"classname\";s:30:\".auxicon-music-note-streamline\";s:7:\"content\";s:5:\"\\e663\";}i:568;O:8:\"stdClass\":3:{s:4:\"name\";s:24:\"Music speaker streamline\";s:9:\"classname\";s:33:\".auxicon-music-speaker-streamline\";s:7:\"content\";s:5:\"\\e664\";}i:569;O:8:\"stdClass\":3:{s:4:\"name\";s:19:\"Notebook streamline\";s:9:\"classname\";s:28:\".auxicon-notebook-streamline\";s:7:\"content\";s:5:\"\\e665\";}i:570;O:8:\"stdClass\":3:{s:4:\"name\";s:23:\"Paint bucket streamline\";s:9:\"classname\";s:32:\".auxicon-paint-bucket-streamline\";s:7:\"content\";s:5:\"\\e666\";}i:571;O:8:\"stdClass\":3:{s:4:\"name\";s:26:\"Painting pallet streamline\";s:9:\"classname\";s:35:\".auxicon-painting-pallet-streamline\";s:7:\"content\";s:5:\"\\e667\";}i:572;O:8:\"stdClass\":3:{s:4:\"name\";s:24:\"Painting roll streamline\";s:9:\"classname\";s:33:\".auxicon-painting-roll-streamline\";s:7:\"content\";s:5:\"\\e668\";}i:573;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Pen streamline\";s:9:\"classname\";s:23:\".auxicon-pen-streamline\";s:7:\"content\";s:5:\"\\e669\";}i:574;O:8:\"stdClass\":3:{s:4:\"name\";s:16:\"Pen streamline 1\";s:9:\"classname\";s:25:\".auxicon-pen-streamline-1\";s:7:\"content\";s:5:\"\\e66a\";}i:575;O:8:\"stdClass\":3:{s:4:\"name\";s:16:\"Pen streamline 2\";s:9:\"classname\";s:25:\".auxicon-pen-streamline-2\";s:7:\"content\";s:5:\"\\e66b\";}i:576;O:8:\"stdClass\":3:{s:4:\"name\";s:16:\"Pen streamline 3\";s:9:\"classname\";s:25:\".auxicon-pen-streamline-3\";s:7:\"content\";s:5:\"\\e66c\";}i:577;O:8:\"stdClass\":3:{s:4:\"name\";s:25:\"Photo pictures streamline\";s:9:\"classname\";s:34:\".auxicon-photo-pictures-streamline\";s:7:\"content\";s:5:\"\\e66d\";}i:578;O:8:\"stdClass\":3:{s:4:\"name\";s:18:\"Picture streamline\";s:9:\"classname\";s:27:\".auxicon-picture-streamline\";s:7:\"content\";s:5:\"\\e66e\";}i:579;O:8:\"stdClass\":3:{s:4:\"name\";s:20:\"Picture streamline 1\";s:9:\"classname\";s:29:\".auxicon-picture-streamline-1\";s:7:\"content\";s:5:\"\\e66f\";}i:580;O:8:\"stdClass\":3:{s:4:\"name\";s:27:\"Receipt shopping streamline\";s:9:\"classname\";s:36:\".auxicon-receipt-shopping-streamline\";s:7:\"content\";s:5:\"\\e670\";}i:581;O:8:\"stdClass\":3:{s:4:\"name\";s:25:\"Remote control streamline\";s:9:\"classname\";s:34:\".auxicon-remote-control-streamline\";s:7:\"content\";s:5:\"\\e671\";}i:582;O:8:\"stdClass\":3:{s:4:\"name\";s:19:\"Settings streamline\";s:9:\"classname\";s:28:\".auxicon-settings-streamline\";s:7:\"content\";s:5:\"\\e672\";}i:583;O:8:\"stdClass\":3:{s:4:\"name\";s:21:\"Settings streamline 1\";s:9:\"classname\";s:30:\".auxicon-settings-streamline-1\";s:7:\"content\";s:5:\"\\e673\";}i:584;O:8:\"stdClass\":3:{s:4:\"name\";s:21:\"Settings streamline 2\";s:9:\"classname\";s:30:\".auxicon-settings-streamline-2\";s:7:\"content\";s:5:\"\\e674\";}i:585;O:8:\"stdClass\":3:{s:4:\"name\";s:25:\"Shoes snickers streamline\";s:9:\"classname\";s:34:\".auxicon-shoes-snickers-streamline\";s:7:\"content\";s:5:\"\\e675\";}i:586;O:8:\"stdClass\":3:{s:4:\"name\";s:27:\"Speech streamline talk user\";s:9:\"classname\";s:36:\".auxicon-speech-streamline-talk-user\";s:7:\"content\";s:5:\"\\e676\";}i:587;O:8:\"stdClass\":3:{s:4:\"name\";s:16:\"Stamp streamline\";s:9:\"classname\";s:25:\".auxicon-stamp-streamline\";s:7:\"content\";s:5:\"\\e677\";}i:588;O:8:\"stdClass\":3:{s:4:\"name\";s:26:\"Streamline suitcase travel\";s:9:\"classname\";s:35:\".auxicon-streamline-suitcase-travel\";s:7:\"content\";s:5:\"\\e678\";}i:589;O:8:\"stdClass\":3:{s:4:\"name\";s:27:\"Streamline umbrella weather\";s:9:\"classname\";s:36:\".auxicon-streamline-umbrella-weather\";s:7:\"content\";s:5:\"\\e67a\";}i:590;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Align center\";s:9:\"classname\";s:21:\".auxicon-align-center\";s:7:\"content\";s:5:\"\\e67b\";}i:591;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Align justify\";s:9:\"classname\";s:22:\".auxicon-align-justify\";s:7:\"content\";s:5:\"\\e67c\";}i:592;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Align left\";s:9:\"classname\";s:19:\".auxicon-align-left\";s:7:\"content\";s:5:\"\\e67d\";}i:593;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Align right\";s:9:\"classname\";s:20:\".auxicon-align-right\";s:7:\"content\";s:5:\"\\e67e\";}i:594;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Archive 1\";s:9:\"classname\";s:18:\".auxicon-archive-1\";s:7:\"content\";s:5:\"\\e67f\";}i:595;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Arrow down 3\";s:9:\"classname\";s:21:\".auxicon-arrow-down-3\";s:7:\"content\";s:5:\"\\e680\";}i:596;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Arrow left 3\";s:9:\"classname\";s:21:\".auxicon-arrow-left-3\";s:7:\"content\";s:5:\"\\e681\";}i:597;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Arrow right 3\";s:9:\"classname\";s:22:\".auxicon-arrow-right-3\";s:7:\"content\";s:5:\"\\e682\";}i:598;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Arrow up 3\";s:9:\"classname\";s:19:\".auxicon-arrow-up-3\";s:7:\"content\";s:5:\"\\e683\";}i:599;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Atom\";s:9:\"classname\";s:13:\".auxicon-atom\";s:7:\"content\";s:5:\"\\e684\";}i:600;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Bank notes\";s:9:\"classname\";s:19:\".auxicon-bank-notes\";s:7:\"content\";s:5:\"\\e686\";}i:601;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Barbell\";s:9:\"classname\";s:16:\".auxicon-barbell\";s:7:\"content\";s:5:\"\\e687\";}i:602;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Bars\";s:9:\"classname\";s:13:\".auxicon-bars\";s:7:\"content\";s:5:\"\\e688\";}i:603;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Battery 0\";s:9:\"classname\";s:18:\".auxicon-battery-0\";s:7:\"content\";s:5:\"\\e689\";}i:604;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Battery 1 1\";s:9:\"classname\";s:20:\".auxicon-battery-1-1\";s:7:\"content\";s:5:\"\\e68a\";}i:605;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Battery 2 1\";s:9:\"classname\";s:20:\".auxicon-battery-2-1\";s:7:\"content\";s:5:\"\\e68b\";}i:606;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Battery 3 1\";s:9:\"classname\";s:20:\".auxicon-battery-3-1\";s:7:\"content\";s:5:\"\\e68c\";}i:607;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Battery 4 1\";s:9:\"classname\";s:20:\".auxicon-battery-4-1\";s:7:\"content\";s:5:\"\\e68d\";}i:608;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Battery power\";s:9:\"classname\";s:22:\".auxicon-battery-power\";s:7:\"content\";s:5:\"\\e68e\";}i:609;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Beer 2\";s:9:\"classname\";s:15:\".auxicon-beer-2\";s:7:\"content\";s:5:\"\\e68f\";}i:610;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Bolt\";s:9:\"classname\";s:13:\".auxicon-bolt\";s:7:\"content\";s:5:\"\\e690\";}i:611;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Bones\";s:9:\"classname\";s:14:\".auxicon-bones\";s:7:\"content\";s:5:\"\\e691\";}i:612;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Book close\";s:9:\"classname\";s:19:\".auxicon-book-close\";s:7:\"content\";s:5:\"\\e692\";}i:613;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Book open\";s:9:\"classname\";s:18:\".auxicon-book-open\";s:7:\"content\";s:5:\"\\e693\";}i:614;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Bookmark 4\";s:9:\"classname\";s:19:\".auxicon-bookmark-4\";s:7:\"content\";s:5:\"\\e694\";}i:615;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Box 3\";s:9:\"classname\";s:14:\".auxicon-box-3\";s:7:\"content\";s:5:\"\\e695\";}i:616;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Browser 2\";s:9:\"classname\";s:18:\".auxicon-browser-2\";s:7:\"content\";s:5:\"\\e696\";}i:617;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Bubble\";s:9:\"classname\";s:15:\".auxicon-bubble\";s:7:\"content\";s:5:\"\\e697\";}i:618;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Bubble 1\";s:9:\"classname\";s:17:\".auxicon-bubble-1\";s:7:\"content\";s:5:\"\\e698\";}i:619;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Bubble 2\";s:9:\"classname\";s:17:\".auxicon-bubble-2\";s:7:\"content\";s:5:\"\\e699\";}i:620;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Bubble 3\";s:9:\"classname\";s:17:\".auxicon-bubble-3\";s:7:\"content\";s:5:\"\\e69a\";}i:621;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Bucket\";s:9:\"classname\";s:15:\".auxicon-bucket\";s:7:\"content\";s:5:\"\\e69b\";}i:622;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Calculator 3\";s:9:\"classname\";s:21:\".auxicon-calculator-3\";s:7:\"content\";s:5:\"\\e69c\";}i:623;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Calendar 6\";s:9:\"classname\";s:19:\".auxicon-calendar-6\";s:7:\"content\";s:5:\"\\e69d\";}i:624;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Camera 4\";s:9:\"classname\";s:17:\".auxicon-camera-4\";s:7:\"content\";s:5:\"\\e69e\";}i:625;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Cardiac pulse\";s:9:\"classname\";s:22:\".auxicon-cardiac-pulse\";s:7:\"content\";s:5:\"\\e69f\";}i:626;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Cd 1\";s:9:\"classname\";s:13:\".auxicon-cd-1\";s:7:\"content\";s:5:\"\\e6a0\";}i:627;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Character\";s:9:\"classname\";s:18:\".auxicon-character\";s:7:\"content\";s:5:\"\\e6a1\";}i:628;O:8:\"stdClass\":3:{s:4:\"name\";s:16:\"Checkbox checked\";s:9:\"classname\";s:25:\".auxicon-checkbox-checked\";s:7:\"content\";s:5:\"\\e6a2\";}i:629;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Checkmark\";s:9:\"classname\";s:18:\".auxicon-checkmark\";s:7:\"content\";s:5:\"\\e6a3\";}i:630;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Clipboard 3\";s:9:\"classname\";s:20:\".auxicon-clipboard-3\";s:7:\"content\";s:5:\"\\e6a4\";}i:631;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Clock 4\";s:9:\"classname\";s:16:\".auxicon-clock-4\";s:7:\"content\";s:5:\"\\e6a5\";}i:632;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Cloud 5\";s:9:\"classname\";s:16:\".auxicon-cloud-5\";s:7:\"content\";s:5:\"\\e6a6\";}i:633;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Coffee 1\";s:9:\"classname\";s:17:\".auxicon-coffee-1\";s:7:\"content\";s:5:\"\\e6a7\";}i:634;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Comment 2\";s:9:\"classname\";s:18:\".auxicon-comment-2\";s:7:\"content\";s:5:\"\\e6a8\";}i:635;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Connection 0\";s:9:\"classname\";s:21:\".auxicon-connection-0\";s:7:\"content\";s:5:\"\\e6a9\";}i:636;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Connection 1\";s:9:\"classname\";s:21:\".auxicon-connection-1\";s:7:\"content\";s:5:\"\\e6aa\";}i:637;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Connection 2\";s:9:\"classname\";s:21:\".auxicon-connection-2\";s:7:\"content\";s:5:\"\\e6ab\";}i:638;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Connection 3\";s:9:\"classname\";s:21:\".auxicon-connection-3\";s:7:\"content\";s:5:\"\\e6ac\";}i:639;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Connection 4\";s:9:\"classname\";s:21:\".auxicon-connection-4\";s:7:\"content\";s:5:\"\\e6ad\";}i:640;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Credit cards\";s:9:\"classname\";s:21:\".auxicon-credit-cards\";s:7:\"content\";s:5:\"\\e6ae\";}i:641;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Crop\";s:9:\"classname\";s:13:\".auxicon-crop\";s:7:\"content\";s:5:\"\\e6af\";}i:642;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Cube\";s:9:\"classname\";s:13:\".auxicon-cube\";s:7:\"content\";s:5:\"\\e6b0\";}i:643;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Diamond 1\";s:9:\"classname\";s:18:\".auxicon-diamond-1\";s:7:\"content\";s:5:\"\\e6b1\";}i:644;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Download 5\";s:9:\"classname\";s:19:\".auxicon-download-5\";s:7:\"content\";s:5:\"\\e6b2\";}i:645;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Email\";s:9:\"classname\";s:14:\".auxicon-email\";s:7:\"content\";s:5:\"\\e6b3\";}i:646;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Email plane\";s:9:\"classname\";s:20:\".auxicon-email-plane\";s:7:\"content\";s:5:\"\\e6b4\";}i:647;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Enter\";s:9:\"classname\";s:14:\".auxicon-enter\";s:7:\"content\";s:5:\"\\e6b5\";}i:648;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Envelope 1\";s:9:\"classname\";s:19:\".auxicon-envelope-1\";s:7:\"content\";s:5:\"\\e6b6\";}i:649;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Eyedropper\";s:9:\"classname\";s:19:\".auxicon-eyedropper\";s:7:\"content\";s:5:\"\\e6b7\";}i:650;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"File 1\";s:9:\"classname\";s:15:\".auxicon-file-1\";s:7:\"content\";s:5:\"\\e6b8\";}i:651;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"File add\";s:9:\"classname\";s:17:\".auxicon-file-add\";s:7:\"content\";s:5:\"\\e6b9\";}i:652;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"File broken\";s:9:\"classname\";s:20:\".auxicon-file-broken\";s:7:\"content\";s:5:\"\\e6ba\";}i:653;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"File settings\";s:9:\"classname\";s:22:\".auxicon-file-settings\";s:7:\"content\";s:5:\"\\e6bb\";}i:654;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Files\";s:9:\"classname\";s:14:\".auxicon-files\";s:7:\"content\";s:5:\"\\e6bc\";}i:655;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Flag 3\";s:9:\"classname\";s:15:\".auxicon-flag-3\";s:7:\"content\";s:5:\"\\e6bd\";}i:656;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Folder 3\";s:9:\"classname\";s:17:\".auxicon-folder-3\";s:7:\"content\";s:5:\"\\e6be\";}i:657;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Folder add\";s:9:\"classname\";s:19:\".auxicon-folder-add\";s:7:\"content\";s:5:\"\\e6bf\";}i:658;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Folder check\";s:9:\"classname\";s:21:\".auxicon-folder-check\";s:7:\"content\";s:5:\"\\e6c0\";}i:659;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Folder settings\";s:9:\"classname\";s:24:\".auxicon-folder-settings\";s:7:\"content\";s:5:\"\\e6c1\";}i:660;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Forbidden\";s:9:\"classname\";s:18:\".auxicon-forbidden\";s:7:\"content\";s:5:\"\\e6c2\";}i:661;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Frames\";s:9:\"classname\";s:15:\".auxicon-frames\";s:7:\"content\";s:5:\"\\e6c3\";}i:662;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Glass\";s:9:\"classname\";s:14:\".auxicon-glass\";s:7:\"content\";s:5:\"\\e6c4\";}i:663;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Graph 1\";s:9:\"classname\";s:16:\".auxicon-graph-1\";s:7:\"content\";s:5:\"\\e6c5\";}i:664;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Grid 3\";s:9:\"classname\";s:15:\".auxicon-grid-3\";s:7:\"content\";s:5:\"\\e6c6\";}i:665;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Heart 4\";s:9:\"classname\";s:16:\".auxicon-heart-4\";s:7:\"content\";s:5:\"\\e6c7\";}i:666;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Home 6\";s:9:\"classname\";s:15:\".auxicon-home-6\";s:7:\"content\";s:5:\"\\e6c8\";}i:667;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Id card\";s:9:\"classname\";s:16:\".auxicon-id-card\";s:7:\"content\";s:5:\"\\e6c9\";}i:668;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Invoice\";s:9:\"classname\";s:16:\".auxicon-invoice\";s:7:\"content\";s:5:\"\\e6ca\";}i:669;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Ipad 2\";s:9:\"classname\";s:15:\".auxicon-ipad-2\";s:7:\"content\";s:5:\"\\e6cc\";}i:670;O:8:\"stdClass\":3:{s:4:\"name\";s:3:\"Lab\";s:9:\"classname\";s:12:\".auxicon-lab\";s:7:\"content\";s:5:\"\\e6cd\";}i:671;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Laptop 1\";s:9:\"classname\";s:17:\".auxicon-laptop-1\";s:7:\"content\";s:5:\"\\e6ce\";}i:672;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"List 3\";s:9:\"classname\";s:15:\".auxicon-list-3\";s:7:\"content\";s:5:\"\\e6cf\";}i:673;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Lock 2\";s:9:\"classname\";s:15:\".auxicon-lock-2\";s:7:\"content\";s:5:\"\\e6d0\";}i:674;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Locked\";s:9:\"classname\";s:15:\".auxicon-locked\";s:7:\"content\";s:5:\"\\e6d1\";}i:675;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Map 4\";s:9:\"classname\";s:14:\".auxicon-map-4\";s:7:\"content\";s:5:\"\\e6d2\";}i:676;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Measure\";s:9:\"classname\";s:16:\".auxicon-measure\";s:7:\"content\";s:5:\"\\e6d3\";}i:677;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Meter\";s:9:\"classname\";s:14:\".auxicon-meter\";s:7:\"content\";s:5:\"\\e6d4\";}i:678;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Micro\";s:9:\"classname\";s:14:\".auxicon-micro\";s:7:\"content\";s:5:\"\\e6d5\";}i:679;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Micro mute\";s:9:\"classname\";s:19:\".auxicon-micro-mute\";s:7:\"content\";s:5:\"\\e6d6\";}i:680;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Microwave\";s:9:\"classname\";s:18:\".auxicon-microwave\";s:7:\"content\";s:5:\"\\e6d7\";}i:681;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Minus 4\";s:9:\"classname\";s:16:\".auxicon-minus-4\";s:7:\"content\";s:5:\"\\e6d8\";}i:682;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Modem\";s:9:\"classname\";s:14:\".auxicon-modem\";s:7:\"content\";s:5:\"\\e6d9\";}i:683;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Mute 1\";s:9:\"classname\";s:15:\".auxicon-mute-1\";s:7:\"content\";s:5:\"\\e6da\";}i:684;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Newspaper 1\";s:9:\"classname\";s:20:\".auxicon-newspaper-1\";s:7:\"content\";s:5:\"\\e6db\";}i:685;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Paperclip\";s:9:\"classname\";s:18:\".auxicon-paperclip\";s:7:\"content\";s:5:\"\\e6dc\";}i:686;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Pencil 3\";s:9:\"classname\";s:17:\".auxicon-pencil-3\";s:7:\"content\";s:5:\"\\e6dd\";}i:687;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Phone 5\";s:9:\"classname\";s:16:\".auxicon-phone-5\";s:7:\"content\";s:5:\"\\e6df\";}i:688;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Phone 3\";s:9:\"classname\";s:16:\".auxicon-phone-3\";s:7:\"content\";s:5:\"\\e6e0\";}i:689;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Picture\";s:9:\"classname\";s:16:\".auxicon-picture\";s:7:\"content\";s:5:\"\\e6e1\";}i:690;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Pie chart\";s:9:\"classname\";s:18:\".auxicon-pie-chart\";s:7:\"content\";s:5:\"\\e6e2\";}i:691;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Pill\";s:9:\"classname\";s:13:\".auxicon-pill\";s:7:\"content\";s:5:\"\\e6e3\";}i:692;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Pin 4\";s:9:\"classname\";s:14:\".auxicon-pin-4\";s:7:\"content\";s:5:\"\\e6e4\";}i:693;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Printer 1\";s:9:\"classname\";s:18:\".auxicon-printer-1\";s:7:\"content\";s:5:\"\\e6e6\";}i:694;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Printer 2\";s:9:\"classname\";s:18:\".auxicon-printer-2\";s:7:\"content\";s:5:\"\\e6e7\";}i:695;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Refresh 3\";s:9:\"classname\";s:18:\".auxicon-refresh-3\";s:7:\"content\";s:5:\"\\e6e8\";}i:696;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Screen 3\";s:9:\"classname\";s:17:\".auxicon-screen-3\";s:7:\"content\";s:5:\"\\e6ea\";}i:697;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Select\";s:9:\"classname\";s:15:\".auxicon-select\";s:7:\"content\";s:5:\"\\e6eb\";}i:698;O:8:\"stdClass\":3:{s:4:\"name\";s:3:\"Set\";s:9:\"classname\";s:12:\".auxicon-set\";s:7:\"content\";s:5:\"\\e6ec\";}i:699;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Settings 8\";s:9:\"classname\";s:19:\".auxicon-settings-8\";s:7:\"content\";s:5:\"\\e6ed\";}i:700;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Share 4\";s:9:\"classname\";s:16:\".auxicon-share-4\";s:7:\"content\";s:5:\"\\e6ee\";}i:701;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Share outline\";s:9:\"classname\";s:22:\".auxicon-share-outline\";s:7:\"content\";s:5:\"\\e6ef\";}i:702;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Shorts\";s:9:\"classname\";s:15:\".auxicon-shorts\";s:7:\"content\";s:5:\"\\e6f0\";}i:703;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Speaker 1\";s:9:\"classname\";s:18:\".auxicon-speaker-1\";s:7:\"content\";s:5:\"\\e6f1\";}i:704;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Star 4\";s:9:\"classname\";s:15:\".auxicon-star-4\";s:7:\"content\";s:5:\"\\e6f2\";}i:705;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Stopwatch 3\";s:9:\"classname\";s:20:\".auxicon-stopwatch-3\";s:7:\"content\";s:5:\"\\e6f3\";}i:706;O:8:\"stdClass\":3:{s:4:\"name\";s:3:\"Sun\";s:9:\"classname\";s:12:\".auxicon-sun\";s:7:\"content\";s:5:\"\\e6f4\";}i:707;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Syringe\";s:9:\"classname\";s:16:\".auxicon-syringe\";s:7:\"content\";s:5:\"\\e6f5\";}i:708;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Tag 5\";s:9:\"classname\";s:14:\".auxicon-tag-5\";s:7:\"content\";s:5:\"\\e6f6\";}i:709;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Train\";s:9:\"classname\";s:14:\".auxicon-train\";s:7:\"content\";s:5:\"\\e6f7\";}i:710;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Trash 3\";s:9:\"classname\";s:16:\".auxicon-trash-3\";s:7:\"content\";s:5:\"\\e6f8\";}i:711;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Unlocked\";s:9:\"classname\";s:17:\".auxicon-unlocked\";s:7:\"content\";s:5:\"\\e6f9\";}i:712;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"User 4\";s:9:\"classname\";s:15:\".auxicon-user-4\";s:7:\"content\";s:5:\"\\e6fa\";}i:713;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"User outline\";s:9:\"classname\";s:21:\".auxicon-user-outline\";s:7:\"content\";s:5:\"\\e6fb\";}i:714;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Users 1\";s:9:\"classname\";s:16:\".auxicon-users-1\";s:7:\"content\";s:5:\"\\e6fc\";}i:715;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Users outline\";s:9:\"classname\";s:22:\".auxicon-users-outline\";s:7:\"content\";s:5:\"\\e6fd\";}i:716;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Volume\";s:9:\"classname\";s:15:\".auxicon-volume\";s:7:\"content\";s:5:\"\\e6fe\";}i:717;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Volume down\";s:9:\"classname\";s:20:\".auxicon-volume-down\";s:7:\"content\";s:5:\"\\e6ff\";}i:718;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Volume up\";s:9:\"classname\";s:18:\".auxicon-volume-up\";s:7:\"content\";s:5:\"\\e700\";}i:719;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Wifi 1\";s:9:\"classname\";s:15:\".auxicon-wifi-1\";s:7:\"content\";s:5:\"\\e701\";}i:720;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Wifi 2\";s:9:\"classname\";s:15:\".auxicon-wifi-2\";s:7:\"content\";s:5:\"\\e702\";}i:721;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Wifi 3\";s:9:\"classname\";s:15:\".auxicon-wifi-3\";s:7:\"content\";s:5:\"\\e703\";}i:722;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Window delete\";s:9:\"classname\";s:22:\".auxicon-window-delete\";s:7:\"content\";s:5:\"\\e704\";}i:723;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Windows 2\";s:9:\"classname\";s:18:\".auxicon-windows-2\";s:7:\"content\";s:5:\"\\e705\";}i:724;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Zoom\";s:9:\"classname\";s:13:\".auxicon-zoom\";s:7:\"content\";s:5:\"\\e706\";}i:725;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Zoom in 2\";s:9:\"classname\";s:18:\".auxicon-zoom-in-2\";s:7:\"content\";s:5:\"\\e707\";}i:726;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Zoom out 2\";s:9:\"classname\";s:19:\".auxicon-zoom-out-2\";s:7:\"content\";s:5:\"\\e708\";}i:727;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Banknote\";s:9:\"classname\";s:17:\".auxicon-banknote\";s:7:\"content\";s:5:\"\\e709\";}i:728;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Bubble 4\";s:9:\"classname\";s:17:\".auxicon-bubble-4\";s:7:\"content\";s:5:\"\\e70a\";}i:729;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Bulb\";s:9:\"classname\";s:13:\".auxicon-bulb\";s:7:\"content\";s:5:\"\\e70b\";}i:730;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Calendar 7\";s:9:\"classname\";s:19:\".auxicon-calendar-7\";s:7:\"content\";s:5:\"\\e70c\";}i:731;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Camera 5\";s:9:\"classname\";s:17:\".auxicon-camera-5\";s:7:\"content\";s:5:\"\\e70d\";}i:732;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Clip\";s:9:\"classname\";s:13:\".auxicon-clip\";s:7:\"content\";s:5:\"\\e70e\";}i:733;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Clock 5\";s:9:\"classname\";s:16:\".auxicon-clock-5\";s:7:\"content\";s:5:\"\\e70f\";}i:734;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Cloud 6\";s:9:\"classname\";s:16:\".auxicon-cloud-6\";s:7:\"content\";s:5:\"\\e710\";}i:735;O:8:\"stdClass\":3:{s:4:\"name\";s:3:\"Cup\";s:9:\"classname\";s:12:\".auxicon-cup\";s:7:\"content\";s:5:\"\\e711\";}i:736;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Data 1\";s:9:\"classname\";s:15:\".auxicon-data-1\";s:7:\"content\";s:5:\"\\e712\";}i:737;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Diamond 2\";s:9:\"classname\";s:18:\".auxicon-diamond-2\";s:7:\"content\";s:5:\"\\e713\";}i:738;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Display\";s:9:\"classname\";s:16:\".auxicon-display\";s:7:\"content\";s:5:\"\\e714\";}i:739;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Fire\";s:9:\"classname\";s:13:\".auxicon-fire\";s:7:\"content\";s:5:\"\\e716\";}i:740;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Food\";s:9:\"classname\";s:13:\".auxicon-food\";s:7:\"content\";s:5:\"\\e717\";}i:741;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Heart 5\";s:9:\"classname\";s:16:\".auxicon-heart-5\";s:7:\"content\";s:5:\"\\e718\";}i:742;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Key 3\";s:9:\"classname\";s:14:\".auxicon-key-3\";s:7:\"content\";s:5:\"\\e719\";}i:743;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Lab 1\";s:9:\"classname\";s:14:\".auxicon-lab-1\";s:7:\"content\";s:5:\"\\e71a\";}i:744;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Like 1\";s:9:\"classname\";s:15:\".auxicon-like-1\";s:7:\"content\";s:5:\"\\e71b\";}i:745;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Location 2\";s:9:\"classname\";s:19:\".auxicon-location-2\";s:7:\"content\";s:5:\"\\e71c\";}i:746;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Lock 3\";s:9:\"classname\";s:15:\".auxicon-lock-3\";s:7:\"content\";s:5:\"\\e71d\";}i:747;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Mail 3\";s:9:\"classname\";s:15:\".auxicon-mail-3\";s:7:\"content\";s:5:\"\\e71e\";}i:748;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Megaphone 1\";s:9:\"classname\";s:20:\".auxicon-megaphone-1\";s:7:\"content\";s:5:\"\\e71f\";}i:749;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Music 3\";s:9:\"classname\";s:16:\".auxicon-music-3\";s:7:\"content\";s:5:\"\\e720\";}i:750;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"News 2\";s:9:\"classname\";s:15:\".auxicon-news-2\";s:7:\"content\";s:5:\"\\e721\";}i:751;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Note\";s:9:\"classname\";s:13:\".auxicon-note\";s:7:\"content\";s:5:\"\\e722\";}i:752;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Paperplane\";s:9:\"classname\";s:19:\".auxicon-paperplane\";s:7:\"content\";s:5:\"\\e723\";}i:753;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Params\";s:9:\"classname\";s:15:\".auxicon-params\";s:7:\"content\";s:5:\"\\e724\";}i:754;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Pen 3\";s:9:\"classname\";s:14:\".auxicon-pen-3\";s:7:\"content\";s:5:\"\\e725\";}i:755;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Phone 4\";s:9:\"classname\";s:16:\".auxicon-phone-4\";s:7:\"content\";s:5:\"\\e726\";}i:756;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Photo 1\";s:9:\"classname\";s:16:\".auxicon-photo-1\";s:7:\"content\";s:5:\"\\e727\";}i:757;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Search 5\";s:9:\"classname\";s:17:\".auxicon-search-5\";s:7:\"content\";s:5:\"\\e728\";}i:758;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Settings 9\";s:9:\"classname\";s:19:\".auxicon-settings-9\";s:7:\"content\";s:5:\"\\e729\";}i:759;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Shop 2\";s:9:\"classname\";s:15:\".auxicon-shop-2\";s:7:\"content\";s:5:\"\\e72a\";}i:760;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Sound 2\";s:9:\"classname\";s:16:\".auxicon-sound-2\";s:7:\"content\";s:5:\"\\e72b\";}i:761;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Stack\";s:9:\"classname\";s:14:\".auxicon-stack\";s:7:\"content\";s:5:\"\\e72c\";}i:762;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Star 5\";s:9:\"classname\";s:15:\".auxicon-star-5\";s:7:\"content\";s:5:\"\\e72d\";}i:763;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Study\";s:9:\"classname\";s:14:\".auxicon-study\";s:7:\"content\";s:5:\"\\e72e\";}i:764;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"T shirt\";s:9:\"classname\";s:16:\".auxicon-t-shirt\";s:7:\"content\";s:5:\"\\e72f\";}i:765;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Tag 6\";s:9:\"classname\";s:14:\".auxicon-tag-6\";s:7:\"content\";s:5:\"\\e730\";}i:766;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Trash 4\";s:9:\"classname\";s:16:\".auxicon-trash-4\";s:7:\"content\";s:5:\"\\e731\";}i:767;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Truck 3\";s:9:\"classname\";s:16:\".auxicon-truck-3\";s:7:\"content\";s:5:\"\\e732\";}i:768;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Tv 1\";s:9:\"classname\";s:13:\".auxicon-tv-1\";s:7:\"content\";s:5:\"\\e733\";}i:769;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"User 5\";s:9:\"classname\";s:15:\".auxicon-user-5\";s:7:\"content\";s:5:\"\\e734\";}i:770;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Vallet\";s:9:\"classname\";s:15:\".auxicon-vallet\";s:7:\"content\";s:5:\"\\e735\";}i:771;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Video 1\";s:9:\"classname\";s:16:\".auxicon-video-1\";s:7:\"content\";s:5:\"\\e736\";}i:772;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Vynil\";s:9:\"classname\";s:14:\".auxicon-vynil\";s:7:\"content\";s:5:\"\\e737\";}i:773;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"World\";s:9:\"classname\";s:14:\".auxicon-world\";s:7:\"content\";s:5:\"\\e738\";}i:774;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Bag 2\";s:9:\"classname\";s:14:\".auxicon-bag-2\";s:7:\"content\";s:5:\"\\e7d1\";}i:775;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Bicycle 1\";s:9:\"classname\";s:18:\".auxicon-bicycle-1\";s:7:\"content\";s:5:\"\\e7d2\";}i:776;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Bicycle vintage\";s:9:\"classname\";s:24:\".auxicon-bicycle-vintage\";s:7:\"content\";s:5:\"\\e7d3\";}i:777;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Browser empty\";s:9:\"classname\";s:22:\".auxicon-browser-empty\";s:7:\"content\";s:5:\"\\e7d4\";}i:778;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Browser full\";s:9:\"classname\";s:21:\".auxicon-browser-full\";s:7:\"content\";s:5:\"\\e7d5\";}i:779;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Bubble 1 1\";s:9:\"classname\";s:19:\".auxicon-bubble-1-1\";s:7:\"content\";s:5:\"\\e7d6\";}i:780;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Bubble 2 1\";s:9:\"classname\";s:19:\".auxicon-bubble-2-1\";s:7:\"content\";s:5:\"\\e7d7\";}i:781;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Bubble 3 1\";s:9:\"classname\";s:19:\".auxicon-bubble-3-1\";s:7:\"content\";s:5:\"\\e7d8\";}i:782;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Camera 6\";s:9:\"classname\";s:17:\".auxicon-camera-6\";s:7:\"content\";s:5:\"\\e7d9\";}i:783;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Clap board\";s:9:\"classname\";s:19:\".auxicon-clap-board\";s:7:\"content\";s:5:\"\\e7da\";}i:784;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Clipboard 4\";s:9:\"classname\";s:20:\".auxicon-clipboard-4\";s:7:\"content\";s:5:\"\\e7db\";}i:785;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Clock 6\";s:9:\"classname\";s:16:\".auxicon-clock-6\";s:7:\"content\";s:5:\"\\e7dc\";}i:786;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Cloud 7\";s:9:\"classname\";s:16:\".auxicon-cloud-7\";s:7:\"content\";s:5:\"\\e7dd\";}i:787;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Cloudy\";s:9:\"classname\";s:15:\".auxicon-cloudy\";s:7:\"content\";s:5:\"\\e7de\";}i:788;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Envelope 2\";s:9:\"classname\";s:19:\".auxicon-envelope-2\";s:7:\"content\";s:5:\"\\e7df\";}i:789;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"File ai\";s:9:\"classname\";s:16:\".auxicon-file-ai\";s:7:\"content\";s:5:\"\\e7e0\";}i:790;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"File jpg\";s:9:\"classname\";s:17:\".auxicon-file-jpg\";s:7:\"content\";s:5:\"\\e7e1\";}i:791;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"File png\";s:9:\"classname\";s:17:\".auxicon-file-png\";s:7:\"content\";s:5:\"\\e7e2\";}i:792;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"File psd\";s:9:\"classname\";s:17:\".auxicon-file-psd\";s:7:\"content\";s:5:\"\\e7e3\";}i:793;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"File text 1\";s:9:\"classname\";s:20:\".auxicon-file-text-1\";s:7:\"content\";s:5:\"\\e7e4\";}i:794;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Graph 2\";s:9:\"classname\";s:16:\".auxicon-graph-2\";s:7:\"content\";s:5:\"\\e7e5\";}i:795;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Hierarchy 1\";s:9:\"classname\";s:20:\".auxicon-hierarchy-1\";s:7:\"content\";s:5:\"\\e7e7\";}i:796;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Hierarchy 2\";s:9:\"classname\";s:20:\".auxicon-hierarchy-2\";s:7:\"content\";s:5:\"\\e7e8\";}i:797;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Imac\";s:9:\"classname\";s:13:\".auxicon-imac\";s:7:\"content\";s:5:\"\\e7e9\";}i:798;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Ipad 3\";s:9:\"classname\";s:15:\".auxicon-ipad-3\";s:7:\"content\";s:5:\"\\e7ea\";}i:799;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Iphone 1\";s:9:\"classname\";s:17:\".auxicon-iphone-1\";s:7:\"content\";s:5:\"\\e7eb\";}i:800;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Keyboard 3\";s:9:\"classname\";s:19:\".auxicon-keyboard-3\";s:7:\"content\";s:5:\"\\e7ec\";}i:801;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Laptop 2\";s:9:\"classname\";s:17:\".auxicon-laptop-2\";s:7:\"content\";s:5:\"\\e7ed\";}i:802;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Line\";s:9:\"classname\";s:13:\".auxicon-line\";s:7:\"content\";s:5:\"\\e7ee\";}i:803;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"List 4\";s:9:\"classname\";s:15:\".auxicon-list-4\";s:7:\"content\";s:5:\"\\e7ef\";}i:804;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"List thumbnails\";s:9:\"classname\";s:24:\".auxicon-list-thumbnails\";s:7:\"content\";s:5:\"\\e7f0\";}i:805;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Lock 4\";s:9:\"classname\";s:15:\".auxicon-lock-4\";s:7:\"content\";s:5:\"\\e7f1\";}i:806;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Magnifier\";s:9:\"classname\";s:18:\".auxicon-magnifier\";s:7:\"content\";s:5:\"\\e7f2\";}i:807;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Map 5\";s:9:\"classname\";s:14:\".auxicon-map-5\";s:7:\"content\";s:5:\"\\e7f3\";}i:808;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Map pin\";s:9:\"classname\";s:16:\".auxicon-map-pin\";s:7:\"content\";s:5:\"\\e7f4\";}i:809;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Moon 2\";s:9:\"classname\";s:15:\".auxicon-moon-2\";s:7:\"content\";s:5:\"\\e7f5\";}i:810;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Mouse 1\";s:9:\"classname\";s:16:\".auxicon-mouse-1\";s:7:\"content\";s:5:\"\\e7f6\";}i:811;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Pencil 4\";s:9:\"classname\";s:17:\".auxicon-pencil-4\";s:7:\"content\";s:5:\"\\e7f7\";}i:812;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Pencil ruler\";s:9:\"classname\";s:21:\".auxicon-pencil-ruler\";s:7:\"content\";s:5:\"\\e7f8\";}i:813;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Picture 1\";s:9:\"classname\";s:18:\".auxicon-picture-1\";s:7:\"content\";s:5:\"\\e7f9\";}i:814;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Rain\";s:9:\"classname\";s:13:\".auxicon-rain\";s:7:\"content\";s:5:\"\\e7fa\";}i:815;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Ribbon\";s:9:\"classname\";s:15:\".auxicon-ribbon\";s:7:\"content\";s:5:\"\\e7fb\";}i:816;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Shoe\";s:9:\"classname\";s:13:\".auxicon-shoe\";s:7:\"content\";s:5:\"\\e7fc\";}i:817;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Speaker 2\";s:9:\"classname\";s:18:\".auxicon-speaker-2\";s:7:\"content\";s:5:\"\\e7fd\";}i:818;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Speaker off 1\";s:9:\"classname\";s:22:\".auxicon-speaker-off-1\";s:7:\"content\";s:5:\"\\e7fe\";}i:819;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Sun 1\";s:9:\"classname\";s:14:\".auxicon-sun-1\";s:7:\"content\";s:5:\"\\e7ff\";}i:820;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Tape\";s:9:\"classname\";s:13:\".auxicon-tape\";s:7:\"content\";s:5:\"\\e800\";}i:821;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Target 1\";s:9:\"classname\";s:17:\".auxicon-target-1\";s:7:\"content\";s:5:\"\\e801\";}i:822;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Unlock 1\";s:9:\"classname\";s:17:\".auxicon-unlock-1\";s:7:\"content\";s:5:\"\\e802\";}i:823;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Facebook 3\";s:9:\"classname\";s:19:\".auxicon-facebook-3\";s:7:\"content\";s:5:\"\\e0b7\";}i:824;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Notebook\";s:9:\"classname\";s:17:\".auxicon-notebook\";s:7:\"content\";s:5:\"\\e02d\";}i:825;O:8:\"stdClass\":3:{s:4:\"name\";s:22:\"Edit modify streamline\";s:9:\"classname\";s:31:\".auxicon-edit-modify-streamline\";s:7:\"content\";s:5:\"\\e641\";}i:826;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Download 2\";s:9:\"classname\";s:19:\".auxicon-download-2\";s:7:\"content\";s:5:\"\\e053\";}i:827;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Linkedin\";s:9:\"classname\";s:17:\".auxicon-linkedin\";s:7:\"content\";s:5:\"\\e19f\";}i:828;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Facebook\";s:9:\"classname\";s:17:\".auxicon-facebook\";s:7:\"content\";s:5:\"\\e1a0\";}i:829;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Vimeo\";s:9:\"classname\";s:14:\".auxicon-vimeo\";s:7:\"content\";s:5:\"\\e1a1\";}i:830;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Flickr\";s:9:\"classname\";s:15:\".auxicon-flickr\";s:7:\"content\";s:5:\"\\e1a3\";}i:831;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Instagram\";s:9:\"classname\";s:18:\".auxicon-instagram\";s:7:\"content\";s:5:\"\\e1a4\";}i:832;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Tumblr\";s:9:\"classname\";s:15:\".auxicon-tumblr\";s:7:\"content\";s:5:\"\\e1a5\";}i:833;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Behance\";s:9:\"classname\";s:16:\".auxicon-behance\";s:7:\"content\";s:5:\"\\e1a6\";}i:834;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Wordpress\";s:9:\"classname\";s:18:\".auxicon-wordpress\";s:7:\"content\";s:5:\"\\e1a7\";}i:835;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Vimeo 1\";s:9:\"classname\";s:16:\".auxicon-vimeo-1\";s:7:\"content\";s:5:\"\\e1a8\";}i:836;O:8:\"stdClass\":3:{s:4:\"name\";s:3:\"Git\";s:9:\"classname\";s:12:\".auxicon-git\";s:7:\"content\";s:5:\"\\e1a9\";}i:837;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Googleplus\";s:9:\"classname\";s:19:\".auxicon-googleplus\";s:7:\"content\";s:5:\"\\e1aa\";}i:838;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Digg\";s:9:\"classname\";s:13:\".auxicon-digg\";s:7:\"content\";s:5:\"\\e1ab\";}i:839;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Google\";s:9:\"classname\";s:15:\".auxicon-google\";s:7:\"content\";s:5:\"\\e1ac\";}i:840;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Stumbleupon\";s:9:\"classname\";s:20:\".auxicon-stumbleupon\";s:7:\"content\";s:5:\"\\e1ad\";}i:841;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Apple\";s:9:\"classname\";s:14:\".auxicon-apple\";s:7:\"content\";s:5:\"\\e1ae\";}i:842;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Microsoft\";s:9:\"classname\";s:18:\".auxicon-microsoft\";s:7:\"content\";s:5:\"\\e1af\";}i:843;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Android\";s:9:\"classname\";s:16:\".auxicon-android\";s:7:\"content\";s:5:\"\\e1b0\";}i:844;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Dribbble\";s:9:\"classname\";s:17:\".auxicon-dribbble\";s:7:\"content\";s:5:\"\\e1b1\";}i:845;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Steam\";s:9:\"classname\";s:14:\".auxicon-steam\";s:7:\"content\";s:5:\"\\e1b2\";}i:846;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Pinterest\";s:9:\"classname\";s:18:\".auxicon-pinterest\";s:7:\"content\";s:5:\"\\e1b3\";}i:847;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Edge\";s:9:\"classname\";s:13:\".auxicon-edge\";s:7:\"content\";s:5:\"\\e1a2\";}i:848;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Chrome\";s:9:\"classname\";s:15:\".auxicon-chrome\";s:7:\"content\";s:5:\"\\e1b4\";}i:849;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Safari\";s:9:\"classname\";s:15:\".auxicon-safari\";s:7:\"content\";s:5:\"\\e1b5\";}i:850;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Firefox\";s:9:\"classname\";s:16:\".auxicon-firefox\";s:7:\"content\";s:5:\"\\e1b6\";}i:851;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Opera\";s:9:\"classname\";s:14:\".auxicon-opera\";s:7:\"content\";s:5:\"\\e1b7\";}i:852;O:8:\"stdClass\":3:{s:4:\"name\";s:17:\"Internet explorer\";s:9:\"classname\";s:26:\".auxicon-internet-explorer\";s:7:\"content\";s:5:\"\\e1b8\";}i:853;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Wikipedia\";s:9:\"classname\";s:18:\".auxicon-wikipedia\";s:7:\"content\";s:5:\"\\e1b9\";}i:854;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Amazon\";s:9:\"classname\";s:15:\".auxicon-amazon\";s:7:\"content\";s:5:\"\\e1ba\";}i:855;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Lastfm\";s:9:\"classname\";s:15:\".auxicon-lastfm\";s:7:\"content\";s:5:\"\\e1bb\";}i:856;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Delicious\";s:9:\"classname\";s:18:\".auxicon-delicious\";s:7:\"content\";s:5:\"\\e1bc\";}i:857;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Skype\";s:9:\"classname\";s:14:\".auxicon-skype\";s:7:\"content\";s:5:\"\\e1bd\";}i:858;O:8:\"stdClass\":3:{s:4:\"name\";s:3:\"Rss\";s:9:\"classname\";s:12:\".auxicon-rss\";s:7:\"content\";s:5:\"\\e1be\";}i:859;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Twitter\";s:9:\"classname\";s:16:\".auxicon-twitter\";s:7:\"content\";s:5:\"\\e1bf\";}i:860;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Html5\";s:9:\"classname\";s:14:\".auxicon-html5\";s:7:\"content\";s:5:\"\\e1c0\";}i:861;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Css3\";s:9:\"classname\";s:13:\".auxicon-css3\";s:7:\"content\";s:5:\"\\e1c1\";}i:862;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Youtube\";s:9:\"classname\";s:16:\".auxicon-youtube\";s:7:\"content\";s:5:\"\\e1c2\";}i:863;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Dropbox\";s:9:\"classname\";s:16:\".auxicon-dropbox\";s:7:\"content\";s:5:\"\\e1c3\";}i:864;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Twich\";s:9:\"classname\";s:14:\".auxicon-twich\";s:7:\"content\";s:5:\"\\e1c6\";}i:865;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Pocket\";s:9:\"classname\";s:15:\".auxicon-pocket\";s:7:\"content\";s:5:\"\\e1c7\";}i:866;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Spotify\";s:9:\"classname\";s:16:\".auxicon-spotify\";s:7:\"content\";s:5:\"\\e1c4\";}i:867;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Yahoo\";s:9:\"classname\";s:14:\".auxicon-yahoo\";s:7:\"content\";s:5:\"\\e1c8\";}i:868;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Paypal\";s:9:\"classname\";s:15:\".auxicon-paypal\";s:7:\"content\";s:5:\"\\e1c9\";}i:869;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Visa\";s:9:\"classname\";s:13:\".auxicon-visa\";s:7:\"content\";s:5:\"\\e1ca\";}i:870;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Google wallet\";s:9:\"classname\";s:22:\".auxicon-google-wallet\";s:7:\"content\";s:5:\"\\e1cb\";}i:871;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Mastercard\";s:9:\"classname\";s:19:\".auxicon-mastercard\";s:7:\"content\";s:5:\"\\e1cc\";}i:872;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Soundcloud\";s:9:\"classname\";s:19:\".auxicon-soundcloud\";s:7:\"content\";s:5:\"\\e1cd\";}i:873;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Linux\";s:9:\"classname\";s:14:\".auxicon-linux\";s:7:\"content\";s:5:\"\\e1ce\";}i:874;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Github\";s:9:\"classname\";s:15:\".auxicon-github\";s:7:\"content\";s:5:\"\\e1cf\";}i:875;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Search 4\";s:9:\"classname\";s:17:\".auxicon-search-4\";s:7:\"content\";s:5:\"\\e1d0\";}i:876;O:8:\"stdClass\":3:{s:4:\"name\";s:25:\"Check mark circle outline\";s:9:\"classname\";s:34:\".auxicon-check-mark-circle-outline\";s:7:\"content\";s:5:\"\\e1d1\";}i:877;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Question circle\";s:9:\"classname\";s:24:\".auxicon-question-circle\";s:7:\"content\";s:5:\"\\e1d2\";}i:878;O:8:\"stdClass\":3:{s:4:\"name\";s:16:\"Phone classic on\";s:9:\"classname\";s:25:\".auxicon-phone-classic-on\";s:7:\"content\";s:5:\"\\e1d3\";}i:879;O:8:\"stdClass\":3:{s:4:\"name\";s:20:\"Ios browsers outline\";s:9:\"classname\";s:29:\".auxicon-ios-browsers-outline\";s:7:\"content\";s:5:\"\\e1d4\";}i:880;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Social buffer\";s:9:\"classname\";s:22:\".auxicon-social-buffer\";s:7:\"content\";s:5:\"\\e1d5\";}i:881;O:8:\"stdClass\":3:{s:4:\"name\";s:21:\"Social buffer outline\";s:9:\"classname\";s:30:\".auxicon-social-buffer-outline\";s:7:\"content\";s:5:\"\\e1d6\";}i:882;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Search 1\";s:9:\"classname\";s:17:\".auxicon-search-1\";s:7:\"content\";s:5:\"\\e0dd\";}i:883;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Comment\";s:9:\"classname\";s:16:\".auxicon-comment\";s:7:\"content\";s:5:\"\\e1d7\";}i:884;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Like\";s:9:\"classname\";s:13:\".auxicon-like\";s:7:\"content\";s:5:\"\\e1d8\";}i:885;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Share\";s:9:\"classname\";s:14:\".auxicon-share\";s:7:\"content\";s:5:\"\\e1d9\";}i:886;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Rate\";s:9:\"classname\";s:13:\".auxicon-rate\";s:7:\"content\";s:5:\"\\e1da\";}i:887;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Rate outline\";s:9:\"classname\";s:21:\".auxicon-rate-outline\";s:7:\"content\";s:5:\"\\e1dc\";}i:888;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Whatsapp\";s:9:\"classname\";s:17:\".auxicon-whatsapp\";s:7:\"content\";s:5:\"\\e1db\";}i:889;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Stumbleupon 1\";s:9:\"classname\";s:22:\".auxicon-stumbleupon-1\";s:7:\"content\";s:5:\"\\e1dd\";}i:890;O:8:\"stdClass\":3:{s:4:\"name\";s:2:\"Vk\";s:9:\"classname\";s:11:\".auxicon-vk\";s:7:\"content\";s:5:\"\\e1de\";}i:891;O:8:\"stdClass\":3:{s:4:\"name\";s:8:\"Telegram\";s:9:\"classname\";s:17:\".auxicon-telegram\";s:7:\"content\";s:5:\"\\e1df\";}i:892;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Telegram 2\";s:9:\"classname\";s:19:\".auxicon-telegram-2\";s:7:\"content\";s:5:\"\\e1e0\";}i:893;O:8:\"stdClass\":3:{s:4:\"name\";s:19:\"Fontawesome webfont\";s:9:\"classname\";s:28:\".auxicon-fontawesome-webfont\";s:7:\"content\";s:5:\"\\e1c5\";}i:894;O:8:\"stdClass\":3:{s:4:\"name\";s:3:\"Bag\";s:9:\"classname\";s:12:\".auxicon-bag\";s:7:\"content\";s:5:\"\\e1e1\";}i:895;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Chevron right 1\";s:9:\"classname\";s:24:\".auxicon-chevron-right-1\";s:7:\"content\";s:5:\"\\e1e2\";}i:896;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Playback play\";s:9:\"classname\";s:22:\".auxicon-playback-play\";s:7:\"content\";s:5:\"\\e16e\";}i:897;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Lists\";s:9:\"classname\";s:14:\".auxicon-lists\";s:7:\"content\";s:5:\"\\e068\";}i:898;O:8:\"stdClass\":3:{s:4:\"name\";s:23:\"Headset with microphone\";s:9:\"classname\";s:32:\".auxicon-headset-with-microphone\";s:7:\"content\";s:3:\"\\55\";}i:899;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Heart small\";s:9:\"classname\";s:20:\".auxicon-heart-small\";s:7:\"content\";s:5:\"\\e1e3\";}i:900;O:8:\"stdClass\":3:{s:4:\"name\";s:19:\"Heart small outline\";s:9:\"classname\";s:28:\".auxicon-heart-small-outline\";s:7:\"content\";s:5:\"\\e1e4\";}i:901;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Settings 1\";s:9:\"classname\";s:19:\".auxicon-settings-1\";s:7:\"content\";s:3:\"\\3b\";}i:902;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Power\";s:9:\"classname\";s:14:\".auxicon-power\";s:7:\"content\";s:5:\"\\e1e5\";}i:903;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Instagram 1\";s:9:\"classname\";s:20:\".auxicon-instagram-1\";s:7:\"content\";s:5:\"\\e0ca\";}i:904;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Computer imac 2\";s:9:\"classname\";s:24:\".auxicon-computer-imac-2\";s:7:\"content\";s:5:\"\\e1e6\";}i:905;O:8:\"stdClass\":3:{s:4:\"name\";s:21:\"Grid lines streamline\";s:9:\"classname\";s:30:\".auxicon-grid-lines-streamline\";s:7:\"content\";s:5:\"\\e1e7\";}i:906;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Chevron left 1\";s:9:\"classname\";s:23:\".auxicon-chevron-left-1\";s:7:\"content\";s:5:\"\\e1e8\";}i:907;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Chevron down 1\";s:9:\"classname\";s:23:\".auxicon-chevron-down-1\";s:7:\"content\";s:5:\"\\e1e9\";}i:908;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Chevron up 1\";s:9:\"classname\";s:21:\".auxicon-chevron-up-1\";s:7:\"content\";s:5:\"\\e1ea\";}i:909;O:8:\"stdClass\":3:{s:4:\"name\";s:21:\"Ios telephone outline\";s:9:\"classname\";s:30:\".auxicon-ios-telephone-outline\";s:7:\"content\";s:5:\"\\e1eb\";}i:910;O:8:\"stdClass\":3:{s:4:\"name\";s:17:\"Ios clock outline\";s:9:\"classname\";s:26:\".auxicon-ios-clock-outline\";s:7:\"content\";s:5:\"\\e1ec\";}i:911;O:8:\"stdClass\":3:{s:4:\"name\";s:18:\"Ios person outline\";s:9:\"classname\";s:27:\".auxicon-ios-person-outline\";s:7:\"content\";s:5:\"\\e1ed\";}i:912;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Arrow left 1\";s:9:\"classname\";s:21:\".auxicon-arrow-left-1\";s:7:\"content\";s:5:\"\\e1ee\";}i:913;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Arrow right 1\";s:9:\"classname\";s:22:\".auxicon-arrow-right-1\";s:7:\"content\";s:5:\"\\e1ef\";}i:914;O:8:\"stdClass\":3:{s:4:\"name\";s:19:\"Mail letter outline\";s:9:\"classname\";s:28:\".auxicon-mail-letter-outline\";s:7:\"content\";s:5:\"\\e1f0\";}i:915;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Search outline\";s:9:\"classname\";s:23:\".auxicon-search-outline\";s:7:\"content\";s:5:\"\\e1f1\";}i:916;O:8:\"stdClass\":3:{s:4:\"name\";s:16:\"Android favorite\";s:9:\"classname\";s:25:\".auxicon-android-favorite\";s:7:\"content\";s:5:\"\\e1f3\";}i:917;O:8:\"stdClass\":3:{s:4:\"name\";s:24:\"Android favorite outline\";s:9:\"classname\";s:33:\".auxicon-android-favorite-outline\";s:7:\"content\";s:5:\"\\e1f4\";}i:918;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Record\";s:9:\"classname\";s:15:\".auxicon-record\";s:7:\"content\";s:5:\"\\e1f5\";}i:919;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Explore\";s:9:\"classname\";s:16:\".auxicon-explore\";s:7:\"content\";s:5:\"\\e020\";}i:920;O:8:\"stdClass\":3:{s:4:\"name\";s:18:\"Map pin streamline\";s:9:\"classname\";s:27:\".auxicon-map-pin-streamline\";s:7:\"content\";s:5:\"\\e1f2\";}i:921;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Phone 2\";s:9:\"classname\";s:16:\".auxicon-phone-2\";s:7:\"content\";s:5:\"\\e1f6\";}i:922;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Ipad 1\";s:9:\"classname\";s:15:\".auxicon-ipad-1\";s:7:\"content\";s:5:\"\\e1f7\";}i:923;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Plus\";s:9:\"classname\";s:13:\".auxicon-plus\";s:7:\"content\";s:5:\"\\e171\";}i:924;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Streamline sync\";s:9:\"classname\";s:24:\".auxicon-streamline-sync\";s:7:\"content\";s:5:\"\\e1f8\";}i:925;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"User\";s:9:\"classname\";s:13:\".auxicon-user\";s:7:\"content\";s:5:\"\\e00a\";}i:926;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Heart 3\";s:9:\"classname\";s:16:\".auxicon-heart-3\";s:7:\"content\";s:5:\"\\e1f9\";}i:927;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Arrows drag up\";s:9:\"classname\";s:23:\".auxicon-arrows-drag-up\";s:7:\"content\";s:5:\"\\e1fa\";}i:928;O:8:\"stdClass\":3:{s:4:\"name\";s:21:\"Arrows drag up dashed\";s:9:\"classname\";s:30:\".auxicon-arrows-drag-up-dashed\";s:7:\"content\";s:5:\"\\e1fb\";}i:929;O:8:\"stdClass\":3:{s:4:\"name\";s:17:\"Arrows hamburger1\";s:9:\"classname\";s:26:\".auxicon-arrows-hamburger1\";s:7:\"content\";s:5:\"\\e1fc\";}i:930;O:8:\"stdClass\":3:{s:4:\"name\";s:18:\"Arrows hamburger 2\";s:9:\"classname\";s:27:\".auxicon-arrows-hamburger-2\";s:7:\"content\";s:5:\"\\e1fd\";}i:931;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Chevron down 2\";s:9:\"classname\";s:23:\".auxicon-chevron-down-2\";s:7:\"content\";s:5:\"\\e1fe\";}i:932;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Chevron left 2\";s:9:\"classname\";s:23:\".auxicon-chevron-left-2\";s:7:\"content\";s:5:\"\\e1ff\";}i:933;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Chevron up 2\";s:9:\"classname\";s:21:\".auxicon-chevron-up-2\";s:7:\"content\";s:5:\"\\e200\";}i:934;O:8:\"stdClass\":3:{s:4:\"name\";s:5:\"Eye 1\";s:9:\"classname\";s:14:\".auxicon-eye-1\";s:7:\"content\";s:5:\"\\e202\";}i:935;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Close 1\";s:9:\"classname\";s:16:\".auxicon-close-1\";s:7:\"content\";s:5:\"\\e203\";}i:936;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Ios telephone\";s:9:\"classname\";s:22:\".auxicon-ios-telephone\";s:7:\"content\";s:5:\"\\e204\";}i:937;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Ios location\";s:9:\"classname\";s:21:\".auxicon-ios-location\";s:7:\"content\";s:5:\"\\e205\";}i:938;O:8:\"stdClass\":3:{s:4:\"name\";s:21:\"Email mail streamline\";s:9:\"classname\";s:30:\".auxicon-email-mail-streamline\";s:7:\"content\";s:5:\"\\e206\";}i:939;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Reload\";s:9:\"classname\";s:15:\".auxicon-reload\";s:7:\"content\";s:5:\"\\e207\";}i:940;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Link 2\";s:9:\"classname\";s:15:\".auxicon-link-2\";s:7:\"content\";s:5:\"\\e208\";}i:941;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Chevron right 2\";s:9:\"classname\";s:24:\".auxicon-chevron-right-2\";s:7:\"content\";s:5:\"\\e201\";}i:942;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Ios cloudy\";s:9:\"classname\";s:19:\".auxicon-ios-cloudy\";s:7:\"content\";s:5:\"\\e209\";}i:943;O:8:\"stdClass\":3:{s:4:\"name\";s:16:\"Ios thunderstorm\";s:9:\"classname\";s:25:\".auxicon-ios-thunderstorm\";s:7:\"content\";s:5:\"\\e20a\";}i:944;O:8:\"stdClass\":3:{s:4:\"name\";s:16:\"Ios cloudy night\";s:9:\"classname\";s:25:\".auxicon-ios-cloudy-night\";s:7:\"content\";s:5:\"\\e20b\";}i:945;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Ios sunny\";s:9:\"classname\";s:18:\".auxicon-ios-sunny\";s:7:\"content\";s:5:\"\\e20c\";}i:946;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Ios snowy\";s:9:\"classname\";s:18:\".auxicon-ios-snowy\";s:7:\"content\";s:5:\"\\e20d\";}i:947;O:8:\"stdClass\":3:{s:4:\"name\";s:9:\"Ios rainy\";s:9:\"classname\";s:18:\".auxicon-ios-rainy\";s:7:\"content\";s:5:\"\\e20e\";}i:948;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Ios partlysunny\";s:9:\"classname\";s:24:\".auxicon-ios-partlysunny\";s:7:\"content\";s:5:\"\\e20f\";}i:949;O:8:\"stdClass\":3:{s:4:\"name\";s:24:\"Ios thunderstorm outline\";s:9:\"classname\";s:33:\".auxicon-ios-thunderstorm-outline\";s:7:\"content\";s:5:\"\\e210\";}i:950;O:8:\"stdClass\":3:{s:4:\"name\";s:17:\"Ios sunny outline\";s:9:\"classname\";s:26:\".auxicon-ios-sunny-outline\";s:7:\"content\";s:5:\"\\e211\";}i:951;O:8:\"stdClass\":3:{s:4:\"name\";s:18:\"Ios cloudy outline\";s:9:\"classname\";s:27:\".auxicon-ios-cloudy-outline\";s:7:\"content\";s:5:\"\\e212\";}i:952;O:8:\"stdClass\":3:{s:4:\"name\";s:24:\"Ios cloudy night outline\";s:9:\"classname\";s:33:\".auxicon-ios-cloudy-night-outline\";s:7:\"content\";s:5:\"\\e213\";}i:953;O:8:\"stdClass\":3:{s:4:\"name\";s:23:\"Ios partlysunny outline\";s:9:\"classname\";s:32:\".auxicon-ios-partlysunny-outline\";s:7:\"content\";s:5:\"\\e214\";}i:954;O:8:\"stdClass\":3:{s:4:\"name\";s:17:\"Ios rainy outline\";s:9:\"classname\";s:26:\".auxicon-ios-rainy-outline\";s:7:\"content\";s:5:\"\\e215\";}i:955;O:8:\"stdClass\":3:{s:4:\"name\";s:7:\"Heart 6\";s:9:\"classname\";s:16:\".auxicon-heart-6\";s:7:\"content\";s:5:\"\\e216\";}}","off");

INSERT IGNORE INTO `wp_options` VALUES 
("365","_site_transient_timeout_auxin_font_icons_list_auxicon2","1773918554","off"),
("366","_site_transient_auxin_font_icons_list_auxicon2","a:76:{i:0;O:8:\"stdClass\":3:{s:4:\"name\";s:20:\"Arrows anticlockwise\";s:9:\"classname\";s:30:\".auxicon2-arrows-anticlockwise\";s:7:\"content\";s:3:\"\\61\";}i:1;O:8:\"stdClass\":3:{s:4:\"name\";s:19:\"Circle plus outline\";s:9:\"classname\";s:29:\".auxicon2-circle-plus-outline\";s:7:\"content\";s:3:\"\\62\";}i:2;O:8:\"stdClass\":3:{s:4:\"name\";s:21:\"Arrows drag up dashed\";s:9:\"classname\";s:31:\".auxicon2-arrows-drag-up-dashed\";s:7:\"content\";s:3:\"\\63\";}i:3;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Hamburger 2\";s:9:\"classname\";s:21:\".auxicon2-hamburger-2\";s:7:\"content\";s:3:\"\\64\";}i:4;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Hamburger1\";s:9:\"classname\";s:20:\".auxicon2-hamburger1\";s:7:\"content\";s:3:\"\\65\";}i:5;O:8:\"stdClass\":3:{s:4:\"name\";s:23:\"Arrow chevron thin left\";s:9:\"classname\";s:33:\".auxicon2-arrow-chevron-thin-left\";s:7:\"content\";s:3:\"\\66\";}i:6;O:8:\"stdClass\":3:{s:4:\"name\";s:26:\"Arrows left double chevron\";s:9:\"classname\";s:36:\".auxicon2-arrows-left-double-chevron\";s:7:\"content\";s:3:\"\\67\";}i:7;O:8:\"stdClass\":3:{s:4:\"name\";s:27:\"Arrows right double chevron\";s:9:\"classname\";s:37:\".auxicon2-arrows-right-double-chevron\";s:7:\"content\";s:3:\"\\68\";}i:8;O:8:\"stdClass\":3:{s:4:\"name\";s:25:\"Arrows chevron thin right\";s:9:\"classname\";s:35:\".auxicon2-arrows-chevron-thin-right\";s:7:\"content\";s:3:\"\\69\";}i:9;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Close remove 1\";s:9:\"classname\";s:24:\".auxicon2-close-remove-1\";s:7:\"content\";s:3:\"\\6a\";}i:10;O:8:\"stdClass\":3:{s:4:\"name\";s:6:\"Plus 1\";s:9:\"classname\";s:16:\".auxicon2-plus-1\";s:7:\"content\";s:3:\"\\6b\";}i:11;O:8:\"stdClass\":3:{s:4:\"name\";s:22:\"Arrow slim left dashed\";s:9:\"classname\";s:32:\".auxicon2-arrow-slim-left-dashed\";s:7:\"content\";s:3:\"\\6c\";}i:12;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Arrow slim left\";s:9:\"classname\";s:25:\".auxicon2-arrow-slim-left\";s:7:\"content\";s:3:\"\\6d\";}i:13;O:8:\"stdClass\":3:{s:4:\"name\";s:23:\"Arrow slim right dashed\";s:9:\"classname\";s:33:\".auxicon2-arrow-slim-right-dashed\";s:7:\"content\";s:3:\"\\70\";}i:14;O:8:\"stdClass\":3:{s:4:\"name\";s:16:\"Arrow slim right\";s:9:\"classname\";s:26:\".auxicon2-arrow-slim-right\";s:7:\"content\";s:3:\"\\71\";}i:15;O:8:\"stdClass\":3:{s:4:\"name\";s:21:\"Arrow chevron thin up\";s:9:\"classname\";s:31:\".auxicon2-arrow-chevron-thin-up\";s:7:\"content\";s:3:\"\\6e\";}i:16;O:8:\"stdClass\":3:{s:4:\"name\";s:24:\"Arrows up double chevron\";s:9:\"classname\";s:34:\".auxicon2-arrows-up-double-chevron\";s:7:\"content\";s:3:\"\\6f\";}i:17;O:8:\"stdClass\":3:{s:4:\"name\";s:19:\"Square plus outline\";s:9:\"classname\";s:29:\".auxicon2-square-plus-outline\";s:7:\"content\";s:3:\"\\72\";}i:18;O:8:\"stdClass\":3:{s:4:\"name\";s:26:\"Arrows down double chevron\";s:9:\"classname\";s:36:\".auxicon2-arrows-down-double-chevron\";s:7:\"content\";s:3:\"\\73\";}i:19;O:8:\"stdClass\":3:{s:4:\"name\";s:19:\"Arrows chevron down\";s:9:\"classname\";s:29:\".auxicon2-arrows-chevron-down\";s:7:\"content\";s:3:\"\\74\";}i:20;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Basic bookmark\";s:9:\"classname\";s:24:\".auxicon2-basic-bookmark\";s:7:\"content\";s:3:\"\\75\";}i:21;O:8:\"stdClass\":3:{s:4:\"name\";s:18:\"Arrow medium right\";s:9:\"classname\";s:28:\".auxicon2-arrow-medium-right\";s:7:\"content\";s:3:\"\\76\";}i:22;O:8:\"stdClass\":3:{s:4:\"name\";s:17:\"Arrow medium left\";s:9:\"classname\";s:27:\".auxicon2-arrow-medium-left\";s:7:\"content\";s:3:\"\\77\";}i:23;O:8:\"stdClass\":3:{s:4:\"name\";s:23:\"Arrow chevron med right\";s:9:\"classname\";s:33:\".auxicon2-arrow-chevron-med-right\";s:7:\"content\";s:3:\"\\78\";}i:24;O:8:\"stdClass\":3:{s:4:\"name\";s:22:\"Arrow chevron med left\";s:9:\"classname\";s:32:\".auxicon2-arrow-chevron-med-left\";s:7:\"content\";s:3:\"\\79\";}i:25;O:8:\"stdClass\":3:{s:4:\"name\";s:21:\"Arrow chevron fat top\";s:9:\"classname\";s:31:\".auxicon2-arrow-chevron-fat-top\";s:7:\"content\";s:3:\"\\7a\";}i:26;O:8:\"stdClass\":3:{s:4:\"name\";s:22:\"Arrow chevron fat down\";s:9:\"classname\";s:32:\".auxicon2-arrow-chevron-fat-down\";s:7:\"content\";s:3:\"\\41\";}i:27;O:8:\"stdClass\":3:{s:4:\"name\";s:23:\"Arrow chevron fat right\";s:9:\"classname\";s:33:\".auxicon2-arrow-chevron-fat-right\";s:7:\"content\";s:3:\"\\42\";}i:28;O:8:\"stdClass\":3:{s:4:\"name\";s:22:\"Arrow chevron fat left\";s:9:\"classname\";s:32:\".auxicon2-arrow-chevron-fat-left\";s:7:\"content\";s:3:\"\\43\";}i:29;O:8:\"stdClass\":3:{s:4:\"name\";s:22:\"Arrow chevron slim top\";s:9:\"classname\";s:32:\".auxicon2-arrow-chevron-slim-top\";s:7:\"content\";s:3:\"\\44\";}i:30;O:8:\"stdClass\":3:{s:4:\"name\";s:23:\"Arrow chevron slim down\";s:9:\"classname\";s:33:\".auxicon2-arrow-chevron-slim-down\";s:7:\"content\";s:3:\"\\45\";}i:31;O:8:\"stdClass\":3:{s:4:\"name\";s:23:\"Arrow chevron slim left\";s:9:\"classname\";s:33:\".auxicon2-arrow-chevron-slim-left\";s:7:\"content\";s:3:\"\\46\";}i:32;O:8:\"stdClass\":3:{s:4:\"name\";s:24:\"Arrow chevron slim right\";s:9:\"classname\";s:34:\".auxicon2-arrow-chevron-slim-right\";s:7:\"content\";s:3:\"\\47\";}i:33;O:8:\"stdClass\":3:{s:4:\"name\";s:23:\"Arrow chevron pixel top\";s:9:\"classname\";s:33:\".auxicon2-arrow-chevron-pixel-top\";s:7:\"content\";s:3:\"\\48\";}i:34;O:8:\"stdClass\":3:{s:4:\"name\";s:24:\"Arrow chevron pixel down\";s:9:\"classname\";s:34:\".auxicon2-arrow-chevron-pixel-down\";s:7:\"content\";s:3:\"\\49\";}i:35;O:8:\"stdClass\":3:{s:4:\"name\";s:24:\"Arrow chevron pixel left\";s:9:\"classname\";s:34:\".auxicon2-arrow-chevron-pixel-left\";s:7:\"content\";s:3:\"\\4a\";}i:36;O:8:\"stdClass\":3:{s:4:\"name\";s:25:\"Arrow chevron pixel right\";s:9:\"classname\";s:35:\".auxicon2-arrow-chevron-pixel-right\";s:7:\"content\";s:3:\"\\4b\";}i:37;O:8:\"stdClass\":3:{s:4:\"name\";s:25:\"Arrow chevron pixel left2\";s:9:\"classname\";s:35:\".auxicon2-arrow-chevron-pixel-left2\";s:7:\"content\";s:3:\"\\4c\";}i:38;O:8:\"stdClass\":3:{s:4:\"name\";s:19:\"Arrow pixel fat top\";s:9:\"classname\";s:29:\".auxicon2-arrow-pixel-fat-top\";s:7:\"content\";s:3:\"\\4d\";}i:39;O:8:\"stdClass\":3:{s:4:\"name\";s:20:\"Arrow pixel fat down\";s:9:\"classname\";s:30:\".auxicon2-arrow-pixel-fat-down\";s:7:\"content\";s:3:\"\\4e\";}i:40;O:8:\"stdClass\":3:{s:4:\"name\";s:19:\"Arrow line med left\";s:9:\"classname\";s:29:\".auxicon2-arrow-line-med-left\";s:7:\"content\";s:3:\"\\4f\";}i:41;O:8:\"stdClass\":3:{s:4:\"name\";s:20:\"Arrow line med right\";s:9:\"classname\";s:30:\".auxicon2-arrow-line-med-right\";s:7:\"content\";s:3:\"\\50\";}i:42;O:8:\"stdClass\":3:{s:4:\"name\";s:18:\"Arrow line med top\";s:9:\"classname\";s:28:\".auxicon2-arrow-line-med-top\";s:7:\"content\";s:3:\"\\51\";}i:43;O:8:\"stdClass\":3:{s:4:\"name\";s:19:\"Arrow line med down\";s:9:\"classname\";s:29:\".auxicon2-arrow-line-med-down\";s:7:\"content\";s:3:\"\\52\";}i:44;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Arrow line left\";s:9:\"classname\";s:25:\".auxicon2-arrow-line-left\";s:7:\"content\";s:3:\"\\53\";}i:45;O:8:\"stdClass\":3:{s:4:\"name\";s:16:\"Arrow line right\";s:9:\"classname\";s:26:\".auxicon2-arrow-line-right\";s:7:\"content\";s:3:\"\\54\";}i:46;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Arrow line top\";s:9:\"classname\";s:24:\".auxicon2-arrow-line-top\";s:7:\"content\";s:3:\"\\55\";}i:47;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Arrow line down\";s:9:\"classname\";s:25:\".auxicon2-arrow-line-down\";s:7:\"content\";s:3:\"\\56\";}i:48;O:8:\"stdClass\":3:{s:4:\"name\";s:24:\"Arrow chevron pixel top2\";s:9:\"classname\";s:34:\".auxicon2-arrow-chevron-pixel-top2\";s:7:\"content\";s:3:\"\\57\";}i:49;O:8:\"stdClass\":3:{s:4:\"name\";s:25:\"Arrow chevron pixel down2\";s:9:\"classname\";s:35:\".auxicon2-arrow-chevron-pixel-down2\";s:7:\"content\";s:3:\"\\58\";}i:50;O:8:\"stdClass\":3:{s:4:\"name\";s:26:\"Arrow chevron pixel right2\";s:9:\"classname\";s:36:\".auxicon2-arrow-chevron-pixel-right2\";s:7:\"content\";s:3:\"\\59\";}i:51;O:8:\"stdClass\":3:{s:4:\"name\";s:20:\"Arrow pixel fat left\";s:9:\"classname\";s:30:\".auxicon2-arrow-pixel-fat-left\";s:7:\"content\";s:3:\"\\5a\";}i:52;O:8:\"stdClass\":3:{s:4:\"name\";s:21:\"Arrow pixel fat right\";s:9:\"classname\";s:31:\".auxicon2-arrow-pixel-fat-right\";s:7:\"content\";s:3:\"\\30\";}i:53;O:8:\"stdClass\":3:{s:4:\"name\";s:21:\"Play outline triangle\";s:9:\"classname\";s:31:\".auxicon2-play-outline-triangle\";s:7:\"content\";s:3:\"\\31\";}i:54;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Arrow thin up\";s:9:\"classname\";s:23:\".auxicon2-arrow-thin-up\";s:7:\"content\";s:3:\"\\33\";}i:55;O:8:\"stdClass\":3:{s:4:\"name\";s:16:\"Arrow thin right\";s:9:\"classname\";s:26:\".auxicon2-arrow-thin-right\";s:7:\"content\";s:3:\"\\34\";}i:56;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Arrow thin left\";s:9:\"classname\";s:25:\".auxicon2-arrow-thin-left\";s:7:\"content\";s:3:\"\\35\";}i:57;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Arrow thin down\";s:9:\"classname\";s:25:\".auxicon2-arrow-thin-down\";s:7:\"content\";s:3:\"\\36\";}i:58;O:8:\"stdClass\":3:{s:4:\"name\";s:25:\"Arrow chevron small right\";s:9:\"classname\";s:35:\".auxicon2-arrow-chevron-small-right\";s:7:\"content\";s:3:\"\\37\";}i:59;O:8:\"stdClass\":3:{s:4:\"name\";s:24:\"Arrow chevron small left\";s:9:\"classname\";s:34:\".auxicon2-arrow-chevron-small-left\";s:7:\"content\";s:3:\"\\38\";}i:60;O:8:\"stdClass\":3:{s:4:\"name\";s:24:\"Arrow chevron small down\";s:9:\"classname\";s:34:\".auxicon2-arrow-chevron-small-down\";s:7:\"content\";s:3:\"\\21\";}i:61;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Play triangle\";s:9:\"classname\";s:23:\".auxicon2-play-triangle\";s:7:\"content\";s:3:\"\\23\";}i:62;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Play triangle 1\";s:9:\"classname\";s:25:\".auxicon2-play-triangle-1\";s:7:\"content\";s:3:\"\\24\";}i:63;O:8:\"stdClass\":3:{s:4:\"name\";s:15:\"Play triangle 2\";s:9:\"classname\";s:25:\".auxicon2-play-triangle-2\";s:7:\"content\";s:3:\"\\25\";}i:64;O:8:\"stdClass\":3:{s:4:\"name\";s:14:\"Arrow backward\";s:9:\"classname\";s:24:\".auxicon2-arrow-backward\";s:7:\"content\";s:3:\"\\26\";}i:65;O:8:\"stdClass\":3:{s:4:\"name\";s:10:\"Check mark\";s:9:\"classname\";s:20:\".auxicon2-check-mark\";s:7:\"content\";s:3:\"\\27\";}i:66;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Check mark 1\";s:9:\"classname\";s:22:\".auxicon2-check-mark-1\";s:7:\"content\";s:3:\"\\28\";}i:67;O:8:\"stdClass\":3:{s:4:\"name\";s:12:\"Code working\";s:9:\"classname\";s:22:\".auxicon2-code-working\";s:7:\"content\";s:3:\"\\29\";}i:68;O:8:\"stdClass\":3:{s:4:\"name\";s:4:\"Code\";s:9:\"classname\";s:14:\".auxicon2-code\";s:7:\"content\";s:3:\"\\2a\";}i:69;O:8:\"stdClass\":3:{s:4:\"name\";s:21:\"Circle plus outline 1\";s:9:\"classname\";s:31:\".auxicon2-circle-plus-outline-1\";s:7:\"content\";s:3:\"\\2e\";}i:70;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Plus circle\";s:9:\"classname\";s:21:\".auxicon2-plus-circle\";s:7:\"content\";s:3:\"\\2f\";}i:71;O:8:\"stdClass\":3:{s:4:\"name\";s:11:\"Hamburger 3\";s:9:\"classname\";s:21:\".auxicon2-hamburger-3\";s:7:\"content\";s:3:\"\\32\";}i:72;O:8:\"stdClass\":3:{s:4:\"name\";s:18:\"Arrow circle right\";s:9:\"classname\";s:28:\".auxicon2-arrow-circle-right\";s:7:\"content\";s:3:\"\\39\";}i:73;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Flower Design\";s:9:\"classname\";s:23:\".auxicon2-flower-design\";s:7:\"content\";s:3:\"\\22\";}i:74;O:8:\"stdClass\":3:{s:4:\"name\";s:18:\"Check mark Circled\";s:9:\"classname\";s:27:\".auxicon2-checkmark-circled\";s:7:\"content\";s:3:\"\\2b\";}i:75;O:8:\"stdClass\":3:{s:4:\"name\";s:13:\"Close Circled\";s:9:\"classname\";s:23:\".auxicon2-close-circled\";s:7:\"content\";s:3:\"\\2c\";}}","off"),
("369","_site_transient_wp_plugin_dependencies_plugin_data","a:2:{s:14:\"auxin-elements\";a:35:{s:4:\"name\";s:45:\"Shortcodes and extra features for Phlox theme\";s:4:\"slug\";s:14:\"auxin-elements\";s:7:\"version\";s:7:\"2.17.15\";s:6:\"author\";s:59:\"<a href=\"https://profiles.wordpress.org/averta/\">averta</a>\";s:14:\"author_profile\";s:38:\"https://profiles.wordpress.org/averta/\";s:12:\"contributors\";a:2:{s:6:\"averta\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/averta/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/2520cf699d4831304bd81f527a47fca986241371b11ac7caef8a0d4e8b39c122?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:6:\"averta\";}s:14:\"averta_support\";a:3:{s:7:\"profile\";s:46:\"https://profiles.wordpress.org/averta_support/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/a766eb909746e2820bb2320afded25b389c0b0b2652c7782c183fd6ed0b16024?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"averta support\";}}s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"6.9.1\";s:12:\"requires_php\";s:3:\"7.0\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:34;s:7:\"ratings\";a:5:{i:5;i:1;i:4;i:0;i:3;i:0;i:2;i:0;i:1;i:5;}s:11:\"num_ratings\";i:6;s:11:\"support_url\";s:52:\"https://wordpress.org/support/plugin/auxin-elements/\";s:15:\"support_threads\";i:2;s:24:\"support_threads_resolved\";i:0;s:15:\"active_installs\";i:90000;s:12:\"last_updated\";s:22:\"2026-01-24 11:55am GMT\";s:5:\"added\";s:10:\"2016-08-30\";s:8:\"homepage\";s:45:\"https://wordpress.org/plugins/auxin-elements/\";s:8:\"sections\";a:6:{s:11:\"description\";s:4747:\"<h4>Overview</h4>\n<p>This plugin adds plenty of premium functionalities to Phlox theme, such as one-click demo importer, plugin manager, new shortcodes, widgets, page builder elements as well as extra theme options to extend the functionality of that theme.</p>\n<blockquote>\n<p><a href=\"http://phlox.pro\" title=\"Live demo of Phlox Theme\" rel=\"nofollow ugc\">Demo on Phlox Theme</a> | <a href=\"https://docs.phlox.pro/?utm_source=wporg-auxin-elements&amp;utm_medium=wporg&amp;utm_content=auxin-elements-doc&amp;utm_term=documentation\" title=\"Phlox Core Elements documentation\" rel=\"nofollow ugc\">Documentation</a> | <a href=\"https://www.youtube.com/playlist?list=PL7X-1Jmy1jcdekHe6adxB81SBcrHOmLRS\" title=\"Watch all video tutorials\" rel=\"nofollow ugc\">Video tutorials</a> | <a href=\"http://help.averta.net/?utm_source=wporg-auxin-elements&amp;utm_medium=wporg&amp;utm_content=auxin-elements-supp&amp;utm_term=support\" title=\"Free support\" rel=\"nofollow ugc\">Support forum</a></p>\n</blockquote>\n<h4>Features</h4>\n<ul>\n<li>Elementor Page builder support (27 Exclusive Elements)</li>\n<li>Page builder Elements</li>\n<li>31 Exclusive Shortcodes</li>\n<li>Auxin Widgets</li>\n<li>Login page customization</li>\n<li>Custom CSS and Javascript fields</li>\n<li>Header layout and image customization</li>\n<li>Mega Menu</li>\n<li>Fullscreen Menu</li>\n<li>Menu Skins</li>\n<li>Various Blog Page templates</li>\n<li>Sticky Header</li>\n<li>Sticky Footer</li>\n<li>Fully Responsive</li>\n<li>Cross Browser IE8+ and Other Modern Browsers</li>\n</ul>\n<h4>Some demo sites by Phlox theme</h4>\n<ul>\n<li><a href=\"http://demo.phlox.pro/portfolio-minimal/?utm_source=wporg-auxin-elements&amp;utm_medium=wporg&amp;utm_campaign=wporg-profile&amp;utm_term=25\" rel=\"nofollow ugc\">Minimal Portfolio</a></li>\n<li><a href=\"http://demo.phlox.pro/free-shop/?utm_source=wporg-auxin-elements&amp;utm_medium=wporg&amp;utm_campaign=wporg-profile&amp;utm_term=29\" rel=\"nofollow ugc\">Modern Shop</a></li>\n<li><a href=\"http://demo.phlox.pro/realstate/?utm_source=wporg-auxin-elements&amp;utm_medium=wporg&amp;utm_campaign=wporg-profile&amp;utm_term=44\" rel=\"nofollow ugc\">Real State</a></li>\n<li><a href=\"http://demo.phlox.pro/architect/?utm_source=wporg-auxin-elements&amp;utm_medium=wporg&amp;utm_campaign=wporg-profile&amp;utm_term=41\" rel=\"nofollow ugc\">The Architect</a></li>\n<li><a href=\"http://demo.phlox.pro/minimal-photography/?utm_source=wporg-auxin-elements&amp;utm_medium=wporg&amp;utm_campaign=wporg-profile&amp;utm_term=28\" rel=\"nofollow ugc\">Minimal Photography</a></li>\n<li><a href=\"http://demo.phlox.pro/journey/?utm_source=wporg-auxin-elements&amp;utm_medium=wporg&amp;utm_campaign=wporg-profile&amp;utm_term=6\" rel=\"nofollow ugc\">Journey Blog</a></li>\n<li><a href=\"http://demo.phlox.pro/classic-blog/?utm_source=wporg-auxin-elements&amp;utm_medium=wporg&amp;utm_campaign=wporg-profile&amp;utm_term=7\" rel=\"nofollow ugc\">Classic Blog</a></li>\n<li><a href=\"http://demo.phlox.pro/portfolio/vivid/?utm_source=wporg-auxin-elements&amp;utm_medium=wporg&amp;utm_campaign=wporg-profile&amp;utm_term=32\" rel=\"nofollow ugc\">Portfolio Vivid</a></li>\n<li><a href=\"http://demo.phlox.pro/portfolio/?utm_source=wporg-auxin-elements&amp;utm_medium=wporg&amp;utm_campaign=wporg-profile&amp;utm_term=10\" rel=\"nofollow ugc\">Classic Portfolio</a></li>\n<li><a href=\"http://demo.phlox.pro/food/?utm_source=wporg-auxin-elements&amp;utm_medium=wporg&amp;utm_campaign=wporg-profile&amp;utm_term=2\" rel=\"nofollow ugc\">Food Blog</a></li>\n<li><a href=\"http://demo.phlox.pro/default/?utm_source=wporg-auxin-elements&amp;utm_medium=wporg&amp;utm_campaign=wporg-profile&amp;utm_term=8\" rel=\"nofollow ugc\">Default</a></li>\n<li><a href=\"http://demo.phlox.pro/coming-soon-1/?utm_source=wporg-auxin-elements&amp;utm_medium=wporg&amp;utm_campaign=wporg-profile&amp;utm_term=37\" rel=\"nofollow ugc\">Coming Soon Red</a></li>\n<li><a href=\"http://demo.phlox.pro/coming-soon-2/?utm_source=wporg-auxin-elements&amp;utm_medium=wporg&amp;utm_campaign=wporg-profile&amp;utm_term=38\" rel=\"nofollow ugc\">Coming Soon Galaxy</a></li>\n</ul>\n<h4>Compatible Browsers</h4>\n<ul>\n<li>IE9+</li>\n<li>Firefox</li>\n<li>Safari</li>\n<li>Opera</li>\n<li>Chrome</li>\n<li>iOS browser</li>\n<li>Android browser</li>\n</ul>\n<h4>Documentations</h4>\n<p>If you have any question about working with « Phlox Core Elements », you can take a look at <a href=\"https://docs.phlox.pro/?utm_source=wporg-auxin-elements&amp;utm_medium=wporg&amp;utm_content=auxin-elements-doc&amp;utm_term=documentation\" rel=\"nofollow ugc\">online documentations</a></p>\n<h4>Translation</h4>\n<p>You can start translating this plugin from here: <a href=\"https://translate.wordpress.org/projects/wp-plugins/auxin-elements\" rel=\"nofollow ugc\">online translation service</a>.</p>\n\";s:12:\"installation\";s:1665:\"<h4>Minimum Requirements</h4>\n<ul>\n<li>WordPress 4.6 or greater</li>\n<li>PHP version 5.6.0 or greater</li>\n<li>MySQL version 5.0 or greater</li>\n</ul>\n<p><strong>This plugin works the best in <a href=\"http://phlox.pro/\" rel=\"nofollow ugc\">Phlox Theme</a></strong></p>\n<h4>Automatic installation (easiest way)</h4>\n<p>To do an automatic install of Phlox Core Elements, log in to your WordPress dashboard, navigate to the Plugins menu and click Add New.</p>\n<p>In the search field type « Phlox Core Elements » and click Search Plugins. Once you have found it you can install it by simply clicking « Install Now ».</p>\n<h4>Manual installation</h4>\n<p><strong>Uploading in WordPress Dashboard</strong></p>\n<ol>\n<li>Download <code>auxin-elements.zip</code></li>\n<li>Navigate to the &lsquo;Add New&rsquo; in the plugins dashboard</li>\n<li>Navigate to the &lsquo;Upload&rsquo; area</li>\n<li>Select <code>auxin-elements.zip</code> from your computer</li>\n<li>Click &lsquo;Install Now&rsquo;</li>\n<li>Activate the plugin in the Plugin dashboard</li>\n</ol>\n<p><strong>Using FTP</strong></p>\n<ol>\n<li>Download <code>auxin-elements.zip</code></li>\n<li>Extract the <code>auxin-elements</code> directory to your computer</li>\n<li>Upload the <code>auxin-elements</code> directory to the <code>/wp-content/plugins/</code> directory</li>\n<li>Activate the plugin in the Plugin dashboard</li>\n</ol>\n<p>The WordPress codex contains <a href=\"https://codex.wordpress.org/Managing_Plugins#Manual_Plugin_Installation\" rel=\"nofollow ugc\">instructions on how to install a WordPress plugin</a>.</p>\n<h4>Updating</h4>\n<p>You can use automatic update to update the plugin safely.</p>\n\";s:3:\"faq\";s:1021:\"\n<dt id=\"where%20can%20i%20find%20phlox%20core%20elements%20documentation%20and%20user%20guides\">\nWhere can I find Phlox Core Elements documentation and user guides\n</h4>\n<p>\n<p>If you have any question about working with « Phlox Core Elements », you can take a look at <a href=\"https://docs.phlox.pro/?utm_source=wporg-auxin-elements&amp;utm_medium=wporg&amp;utm_content=auxin-elements-doc&amp;utm_term=documentation\" rel=\"nofollow ugc\">online documentations</a></p>\n<p>If you get stuck you can <a href=\"http://help.averta.net/\" rel=\"nofollow ugc\">ask your question here</a>.</p>\n</p>\n<dt id=\"will%20phlox%20core%20elements%20work%20with%20my%20theme%3F\">\nWill Phlox Core Elements work with my theme?\n</h4>\n<p>\n<p>No, Phlox Core Element only works on <a href=\"http://phlox.pro/\" rel=\"nofollow ugc\">Phlox Theme</a></p>\n</p>\n<dt id=\"where%20can%20i%20report%20bugs%3F\">\nWhere can I report bugs?\n</h4>\n<p>\n<p>Bugs can be reported in our <a href=\"https://docs.phlox.pro\" rel=\"nofollow ugc\">support forums</a>.</p>\n</p>\n\n\";s:9:\"changelog\";s:17185:\"<h4>Version 2.17.15 / (24.01.2026)</h4>\n<ul>\n<li>[Fix]: An issue with choosing tag type in Elementor « modern heading » element fixed.</li>\n</ul>\n<h4>Version 2.17.13 / (27.12.2025)</h4>\n<ul>\n<li>[Improvement]: Improved the import of sliders while importing a demo.</li>\n</ul>\n<h4>Version 2.17.12 / (31.08.2025)</h4>\n<ul>\n<li>[Improvement]: Style generation improvement for footer and header sections.</li>\n</ul>\n<h4>Version 2.17.10 / (21.07.2025)</h4>\n<ul>\n<li>[Improvement]: Compatibility for Elementor 3.31 added.</li>\n</ul>\n<h4>Version 2.17.9 / (15.07.2025)</h4>\n<ul>\n<li>[Fix]: Fixed an issue with cropped image size on search result page.</li>\n</ul>\n<h4>Version 2.17.8 / (07.06.2025)</h4>\n<ul>\n<li>[Fix]: Fixed missing GIF placeholder causing 404 errors.</li>\n<li>[Fix]: Fixed accordion element title color not applying correctly.</li>\n<li>[Fix]: Fixed issue with importing popup template by Depicter.</li>\n</ul>\n<h4>Version 2.17.6 / (13.04.2025)</h4>\n<ul>\n<li>[Improvement]: Security improvements applied.</li>\n</ul>\n<h4>Version 2.17.0 / (07.02.2025)</h4>\n<ul>\n<li>[Improvement]: Minor security improvements applied.</li>\n</ul>\n<h4>Version 2.17.0 / (12.12.2024)</h4>\n<ul>\n<li>[Improvement]: Compatibility with Elementor 3.25.0 applied.</li>\n</ul>\n<h4>Version 2.16.4 / (02.10.2024)</h4>\n<ul>\n<li>[Improvement]: Minor security improvements applied.</li>\n</ul>\n<h4>Version 2.16.0 / (16.06.2024)</h4>\n<ul>\n<li>[Improvement]: Compatibility with latest version of WooCommerce applied.</li>\n</ul>\n<h4>Version 2.15.9 / (19.05.2024)</h4>\n<ul>\n<li>[Improvement]: Security improvements applied.</li>\n</ul>\n<h4>Version 2.15.0 / (23.11.2023)</h4>\n<ul>\n<li>[Improvement]: Improvements applied for Elementor.</li>\n<li>[Fix]: Better compatibility for WordPress 6.4.0.</li>\n</ul>\n<h4>Version 2.10.8 / (01.12.2022)</h4>\n<ul>\n<li>[Improvement]: Improvements applied to customizer options importer.</li>\n</ul>\n<h4>Version 2.10.5 / (11.10.2022)</h4>\n<ul>\n<li>[Fix]: An issue with Google map element fixed.</li>\n<li>[Improvement]: Some improvements applied to demo importer.</li>\n</ul>\n<h4>Version 2.10.1 / (22.08.2022)</h4>\n<ul>\n<li>[Fix]: An issue with import of background image for Depicter slider fixed.</li>\n<li>[Fix]: An issue with some notices while saving a page with Elementor fixed.</li>\n</ul>\n<h4>Version 2.9.5 / (24.04.2022)</h4>\n<ul>\n<li>[New]: Copy animation button added to Elementor context menu to copy and paste animations across elements.</li>\n<li>[Fix]: Deprecated notices of new version of Elementor fixed.</li>\n</ul>\n<h4>Version 2.9.4 / (23.01.2022)</h4>\n<ul>\n<li>[Fix]: An issue while creating a translation with Polylang plugin fixed.</li>\n</ul>\n<h4>Version 2.8.0 / (28.06.2021)</h4>\n<ul>\n<li>[New]: Integrating « Ti Wishlist plugin » for better wishlist features in shops.</li>\n<li>[New]: Integrating Elementor global colors in customizer for faster preview and customization experience.</li>\n<li>[New]: Adding dynamic tag for URL controller for linking to « Login » and « Singup » pages</li>\n</ul>\n<h4>Version 2.7.10 / (15.03.2021)</h4>\n<ul>\n<li>[Fix]: An issue with importing icons fixed in demo importer.</li>\n<li>[Improvement]: Improvements for shopping cart applied.</li>\n</ul>\n<h4>Version 2.6.14 / (09.09.2020)</h4>\n<ul>\n<li>[New]: New options for recent post elements added.</li>\n<li>[Fix]: Minor bug fixes and performance improvements.</li>\n</ul>\n<h4>Version 2.6.0 / (11.05.2020)</h4>\n<ul>\n<li>[New]: New option for changing the character limit of last breadcrumb text added.</li>\n<li>[Improvement]: Improvements for ajax add to cart applied.</li>\n<li>[Improvement]: Improvements for demo importer applied.</li>\n<li>[Fix]: A minor bug while using WordPress widgets in Elementor fixed.</li>\n</ul>\n<h4>Version 2.5.0 / (09.03.2020)</h4>\n<ul>\n<li>[Improvement]: Instagram link for staff Element added.</li>\n<li>[New]: Inline SVG option for Infobox element added.</li>\n<li>[Improvement]: Improvements in dark mode style of controllers for Elementor applied.</li>\n</ul>\n<h4>Version 2.4.18 / (03.02.2020)</h4>\n<ul>\n<li>[Improvement]: Some improvements for modern heading element applied.</li>\n<li>[Improvement]: Improvements for dark mode styles in Elementor panel applied.</li>\n</ul>\n<h4>Version 2.4.16 / (15.01.2020)</h4>\n<ul>\n<li>[Improvement]: Some improvements for testimonial element applied.</li>\n</ul>\n<h4>Version 2.4.12 / (01.11.2019)</h4>\n<ul>\n<li>[Improvement]: Some improvements for button element applied.</li>\n</ul>\n<h4>Version 2.4.11 / (03.10.2019)</h4>\n<ul>\n<li>[Fix]: An issue with mega menu fixed.</li>\n</ul>\n<h4>Version 2.4.8 / (25.08.2019)</h4>\n<ul>\n<li>[Improvement]: An issue while installing some bundled plugins fixed.</li>\n</ul>\n<h4>Version 2.4.7 / (01.08.2019)</h4>\n<ul>\n<li>[Improvement]: Improvements in the layout of templates kit.</li>\n</ul>\n<h4>Version 2.4.6 / (17.07.2019)</h4>\n<ul>\n<li>[Improvement]: Some style improvements in info box element applied.</li>\n<li>[Fix]: Fix an issue with genral headings typography fixed.</li>\n</ul>\n<h4>Version 2.4.4 / (11.06.2019)</h4>\n<ul>\n<li>[New]: Introducing single page builder.</li>\n<li>[Fix]: Minor bug fixes and performance improvements.</li>\n</ul>\n<h4>Version 2.4.2 / (05.05.2019)</h4>\n<ul>\n<li>[New]: Export and import options added to customizer.</li>\n<li>[Improvement]: Improvements in accordion element.</li>\n</ul>\n<h4>Version 2.4.1 / (30.04.2019)</h4>\n<ul>\n<li>[Fix]: An issue with importing some menu labels fixed.</li>\n<li>[Improvement]: Improvements in Phlox shop applied.</li>\n</ul>\n<h4>Version 2.3.11 / (03.01.2019)</h4>\n<ul>\n<li>[Improvement]: Changing the google analytic tracking option to tracking ID option.</li>\n<li>[New]: Addig new options for background and color hover effect for recent posts element.</li>\n<li>[Fix]: An issue with post formats fixed.</li>\n</ul>\n<h4>Version 2.3.7 / (06.01.2019)</h4>\n<ul>\n<li>[Fix]: New option for changing the border color of header section added to page options.</li>\n</ul>\n<h4>Version 2.3.6 / (27.12.2018)</h4>\n<ul>\n<li>[Fix]: Fixing an issue on gmap while zoom with scroll option is enabled.</li>\n<li>[New]: Adding preload option to post elements.</li>\n<li>[New]: Adding new preload preview options for image element.</li>\n</ul>\n<h4>Version 2.3.0 / (19.11.2018)</h4>\n<ul>\n<li>[Fix]: Fixing some undefined variables.</li>\n<li>[New]: Introducing Templates Kit Library.</li>\n<li>[New]: New preload options added to advanced image element, plus, adding max width and height options.</li>\n<li>[Fix]: Fixing an issue with lightbox features in image element.</li>\n<li>[Improvement]: Improvement in Info Box Element.</li>\n<li>[New]: Adding background hover options for Info Box Element.</li>\n<li>[Improvement]: Improvement in retrieving and displaying the list of demos applied.</li>\n<li>[New]: New top header options added to page options.</li>\n</ul>\n<h4>Version 2.2.22 / (16.09.2018)</h4>\n<ul>\n<li>[Fix]: Minor bugs fixed.</li>\n</ul>\n<h4>Version 2.2.21 / (02.09.2018)</h4>\n<ul>\n<li>[Fix]: Minor bugs fixed.</li>\n</ul>\n<h4>Version 2.2.20 / (23.08.2018)</h4>\n<ul>\n<li>[Fix]: Fixing some PHP notices while Elementor Pro was activated for the first time.</li>\n</ul>\n<h4>Version 2.2.18 / (20.08.2018)</h4>\n<ul>\n<li>[Fix]: Minor bugs fixed.</li>\n</ul>\n<h4>Version 2.2.17 / (15.08.2018)</h4>\n<ul>\n<li>[Fix]: Minor bugs fixed.</li>\n</ul>\n<h4>Version 2.2.16 / (09.08.2018)</h4>\n<ul>\n<li>[Fix]: An issue with importer fixed.</li>\n</ul>\n<h4>Version 2.2.13 / (31.07.2018)</h4>\n<ul>\n<li>[Improvement]: Improvement for Elementor page builder applied.</li>\n</ul>\n<h4>Version 2.2.12 / (21.07.2018)</h4>\n<ul>\n<li>[New]: Adding Custom CSS field to all Elementor elements.</li>\n<li>[New]: Adding video tutorials to Phlox dashboard.</li>\n</ul>\n<h4>Version 2.2.9 / (09.07.2018)</h4>\n<ul>\n<li>[Improvement]: Improvement in admin dashboard for displaying the latest changes.</li>\n<li>[Fix]: Some minor bugs fixed.</li>\n</ul>\n<h4>Version 2.2.8 / (05.07.2018)</h4>\n<ul>\n<li>[New]: Adding Custom CSS field to all Elementor elements.</li>\n<li>[New]: Adding video tutorials to Phlox dashboard.</li>\n<li>[Improvement]: Improvement in Phlox dashboard and demo importer.</li>\n<li>[Improvement]: Now you can filter the recommended plugins in Phlox dashboard.</li>\n<li>[Improvement]: Better plugin dependency management.</li>\n</ul>\n<h4>Version 2.2.7 / (27.06.2018)</h4>\n<ul>\n<li>[New]: Introducing brand new demo importer.</li>\n<li>[Improvement]: Improvement in responsive images.</li>\n<li>[Improvement]: Improvement in preloading images which result in faster page loading speed.</li>\n<li>[Fix]: An issue with Gallery element fixed.</li>\n<li>[Fix]: Minor bugs fixed.</li>\n</ul>\n<h4>Version 2.2.3 / (14.06.2018)</h4>\n<ul>\n<li>[New]: New elements « Modern Heading » and « Mailchimp » for Elementor page builder added.</li>\n<li>[Fix]: Minor bugs fixed.</li>\n</ul>\n<h4>Version 2.2.1 / (05.06.2018)</h4>\n<ul>\n<li>[New]: New element « Flexible List » for Elementor page builder added.</li>\n<li>[Fix]: An issue in SiteOrigin Text element fixed.</li>\n</ul>\n<h4>Version 2.2.0 / (31.05.2018)</h4>\n<ul>\n<li>[New]: Two new elements for Elementor page builder added (Accordion and Tabs).</li>\n<li>[Improvement]: Improvement in testimonial and staff elements for Elementor page builder.</li>\n</ul>\n<h4>Version 2.1.9 / (26.05.2018)</h4>\n<ul>\n<li>[New]: Three new elements for Elementor page builder added (Blockquote, Testimonial and Slider).</li>\n</ul>\n<h4>Version 2.1.8 / (24.05.2018)</h4>\n<ul>\n<li>[New]: Two new elements for Elementor page builder added (video and audio).</li>\n</ul>\n<h4>Version 2.1.7 / (23.05.2018)</h4>\n<ul>\n<li>[New]: 10 new elements for Elementor page builder added.</li>\n<li>[Improvement]: Under the hood improvements.</li>\n</ul>\n<h4>Version 2.1.6 / (16.05.2018)</h4>\n<ul>\n<li>[Improvement]: Improvement in image preloading.</li>\n<li>[Improvement]: Under the hood improvements.</li>\n</ul>\n<h4>Version 2.1.1 / (09.04.2018)</h4>\n<ul>\n<li>[Fix]: Bug fix and improvements for setup wizard.</li>\n<li>[New]: Introducing Recent Product Element for Woocommerce.</li>\n<li>[Improvement]: Make recent portfolios element compatible with ajax loadmore.</li>\n</ul>\n<h4>Version 2.0.9 / (13.03.2018)</h4>\n<ul>\n<li>[New]: Adding an option for marker icon in gmap element.</li>\n<li>[Fix]: Fixing a fatal error while saving the post with wordpress-seo enabled.</li>\n<li>[New]: Added star rating to testimonial element.</li>\n<li>[New]: Add a new meta option for disabling the header logo in a page.</li>\n<li>[Improvement]: Adding animation tab and options to Visual Composer.</li>\n<li>[Improvement]: Improvement in subtitle option in recent posts element.</li>\n</ul>\n<h4>Version 2.0.6 / (17.02.2018)</h4>\n<ul>\n<li>[Fix]: Fixed an issue with post slider that excludes the first blog post.</li>\n<li>[Fix]: The warning message in timeline and masonry blog layout fixed.</li>\n<li>[New]: Adding lazyload option for image element</li>\n</ul>\n<h4>Version 2.0.5 / (13.02.2018)</h4>\n<ul>\n<li>[New]: New options in permalink page for changing the default slug of taxonomies.</li>\n<li>[Fix]: A PHP warning in search page fixed.</li>\n<li>[New]: Adding some hooks to replace custom logo images on pages if custom logo was specified</li>\n<li>[New]: New Metafields For Header and footer options.</li>\n</ul>\n<h4>Version 2.0.0 / (23.01.2018)</h4>\n<ul>\n<li>[Improvement]: Improvement in setup wizard.</li>\n<li>[Improvement]: Optimization, improvement and new size options in image element.</li>\n<li>[Improvement]: Improvement in timeline element.</li>\n<li>[Improvement]: Improvement in custom post types.</li>\n<li>[Improvement]: Improvement in permalink options.</li>\n<li>[Improvement]: Adding visualization to testimonial templates.</li>\n<li>[Improvement]: Improvement in carousel elements.</li>\n<li>[Improvement]: A verification for WP image sizes added to ensure image size ratio is the same.</li>\n<li>[New]: New feature for switching the website to maintenance mode.</li>\n<li>[Fix]: The query monitor report on VC front end editor disabled.</li>\n<li>[New]: Custom search functionality and options added.</li>\n<li>[New]: Added options and functionality for custom 404 page.</li>\n</ul>\n<h4>Version 1.7.2 / (02.12.2017)</h4>\n<ul>\n<li>[New]: Secondary and optional logo image added for sticky header.</li>\n<li>[New]: Adding new option for header background color while header is sticky.</li>\n<li>[New]: Install plugins tab added to phlox welcome page.</li>\n<li>[New]: New element « Recent Post Tile Carousel » added.</li>\n<li>[New]: Link to setup wizard added to &lsquo;quick access&rsquo; section in admin footer.</li>\n<li>[Improvement]: The dropdown control for categories in SiteOrigin Page Builder improved.</li>\n<li>[Improvement]: Add video length markup in the custom playlist.</li>\n<li>[Fix]: An issue with « Instagram feed » widget fixed.</li>\n<li>[Fix]: An issue with GMap widget fixed.</li>\n</ul>\n<h4>Version 1.7.0 / (14.11.2017)</h4>\n<ul>\n<li>[Fix]: An issue with recent post elements on single post page fixed.</li>\n<li>[Fix]: Live preview for header action buttons while editing in customizer.</li>\n<li>[New]: Add new functionalities to WordPress video playlist.</li>\n<li>[New]: Tiny size is added to the divider element.</li>\n<li>[Fix]: An issue with missing date and time in recent post slider fixed.</li>\n<li>[Fix]: Tabs and accordion elements are removed from widgets list.</li>\n<li>[Fix]: A typo in testimonial name fixed.</li>\n<li>[Improvement]: Default load more type for recent grid element changed.</li>\n</ul>\n<h4>Version 1.6.4 / (1.11.2017)</h4>\n<ul>\n<li>[Improvement]: Major improvements for page title setting were applied.</li>\n<li>[Improvement]: Several improvements for setup wizard were applied.</li>\n</ul>\n<h4>Version 1.6.2 / (23.10.2017)</h4>\n<ul>\n<li>[Improvement]: Improvement and bug fix for setup wizard.</li>\n</ul>\n<h4>Version 1.6.0 / (11.10.2017)</h4>\n<ul>\n<li>[New]: Introducing setup Wizard for importing demo content and installing recommended plugins.</li>\n<li>[New]: New Testimonial Widget added</li>\n</ul>\n<h4>Version 1.5.2 / (18.09.2017)</h4>\n<ul>\n<li>[New]: Load more option and button for blog elements.</li>\n<li>[Fix]: Fixing the category field option in blog elements.</li>\n</ul>\n<h4>Version 1.5.0 / (29.08.2017)</h4>\n<ul>\n<li>[Fix]: Addressed a conflict with popup-maker plugin.</li>\n<li>[Fix]: Some minor bugs in Text Element fixed.</li>\n<li>[Improvement]: Under the hood improvements for recent post grid element.</li>\n<li>[New]: New animated loop loading for gallery added.</li>\n</ul>\n<h4>Version 1.4.2 / (10.08.2017)</h4>\n<ul>\n<li>[New]: Changelog section added to welcome page</li>\n<li>[Improvement]: Some improvements in custom permalink structures for Phlox themes</li>\n</ul>\n<h4>Version 1.4.1 / (06.08.2017)</h4>\n<ul>\n<li>[Improvement]: Custom CSS and JavaScript fields added to pages</li>\n</ul>\n<h4>Version 1.4.0 / (02.08.2017)</h4>\n<ul>\n<li>[Improvement]: Applying some changes based on latest changes in auxin framework</li>\n</ul>\n<h4>Version 1.3.10 / (21.06.2017)</h4>\n<ul>\n<li>[Improvement]: New changes for auxin framework applied</li>\n</ul>\n<h4>Version 1.3.2 / (15.01.2017)</h4>\n<ul>\n<li>[Improvement]: New option for defining google map api key added</li>\n</ul>\n<h4>Version 1.3.2 / (08.01.2017)</h4>\n<ul>\n<li>[New]: Introducing Before after slider element to show comparison between two images.</li>\n<li>[New]: New slider element « touch image slider » added, now you can insert any image as a slider in any page via page builder</li>\n<li>[New]: Introducing tiles layout for auxin gallery element</li>\n<li>[Improvement]: The latest post slider and grid carousel improved.</li>\n<li>[Improvement]: The Recent grid blog element improved.</li>\n<li>[Improvement]: Column option for grid and masonry elements.</li>\n<li>[Improvement]: The functionality of lightbox in image element lightbox improved</li>\n<li>[Fix]: Minor bugs fixed.</li>\n</ul>\n<h4>Version 1.3.1 / (20.12.2016)</h4>\n<ul>\n<li>[Improvement]: New styles and options added to code element</li>\n<li>[Improvement]: Adding responsive options to row and column shortcodes</li>\n<li>[fix]: icon_size attribute added to text shortcode handler</li>\n<li>[Fix]: Fixed an issue that result in malfunction for gallery</li>\n</ul>\n<h4>Version 1.3.0 / (1.12.2016)</h4>\n<ul>\n<li>[Improvement]: Improved image sizes in recent posts elements</li>\n<li>[Improvement]: For responsiveness of grid table element</li>\n<li>[New]: adding hover effect option for grid table layout</li>\n<li>[New]: New options and styles for Text element added</li>\n<li>[New]: New options and layout for recent grid post element added</li>\n<li>[Improvement]: Improvement in title bar</li>\n<li>[New]: Persian translation added</li>\n</ul>\n<h4>Version 1.2.0 / (9.11.2016)</h4>\n<ul>\n<li>[New]: Introducing masonry layout for blog</li>\n</ul>\n<h4>Version 1.1.0 / (22.10.2016)</h4>\n<ul>\n<li>[New]: Introducing blog timeline view</li>\n</ul>\n<h4>Version 1.0.9 / (6.10.2016)</h4>\n<ul>\n<li>[New]: New shortcodes and widgets added</li>\n</ul>\n<h4>Version 1.0.6 / (19.9.2016)</h4>\n<ul>\n<li>[New]: New features added</li>\n</ul>\n<h4>Version 1.0.3 / (31.8.2016)</h4>\n<ul>\n<li>[Update]: Description in profile page updated</li>\n</ul>\n<h4>Version 1.0.0 / (30.8.2016)</h4>\n<ul>\n<li>Initial release</li>\n</ul>\n\";s:11:\"screenshots\";s:2273:\"<ol><li><a href=\"https://ps.w.org/auxin-elements/assets/screenshot-1.png?rev=1486570\"><img src=\"https://ps.w.org/auxin-elements/assets/screenshot-1.png?rev=1486570\" alt=\"Front end widgets\"></a><p>Front end widgets</p></li><li><a href=\"https://ps.w.org/auxin-elements/assets/screenshot-2.jpg?rev=1486570\"><img src=\"https://ps.w.org/auxin-elements/assets/screenshot-2.jpg?rev=1486570\" alt=\"Sample of using elements on the page\"></a><p>Sample of using elements on the page</p></li><li><a href=\"https://ps.w.org/auxin-elements/assets/screenshot-3.png?rev=1486570\"><img src=\"https://ps.w.org/auxin-elements/assets/screenshot-3.png?rev=1486570\" alt=\"Some of these elements on the footer\"></a><p>Some of these elements on the footer</p></li><li><a href=\"https://ps.w.org/auxin-elements/assets/screenshot-4.png?rev=1486570\"><img src=\"https://ps.w.org/auxin-elements/assets/screenshot-4.png?rev=1486570\" alt=\"Some Dropcap elements styles\"></a><p>Some Dropcap elements styles</p></li><li><a href=\"https://ps.w.org/auxin-elements/assets/screenshot-5.png?rev=1486570\"><img src=\"https://ps.w.org/auxin-elements/assets/screenshot-5.png?rev=1486570\" alt=\"User friendly back end elements options\"></a><p>User friendly back end elements options</p></li><li><a href=\"https://ps.w.org/auxin-elements/assets/screenshot-6.png?rev=1486570\"><img src=\"https://ps.w.org/auxin-elements/assets/screenshot-6.png?rev=1486570\" alt=\"List of elements on the page to choose from\"></a><p>List of elements on the page to choose from</p></li><li><a href=\"https://ps.w.org/auxin-elements/assets/screenshot-7.png?rev=1486570\"><img src=\"https://ps.w.org/auxin-elements/assets/screenshot-7.png?rev=1486570\" alt=\"List of widgets to choose from\"></a><p>List of widgets to choose from</p></li><li><a href=\"https://ps.w.org/auxin-elements/assets/screenshot-8.png?rev=1486570\"><img src=\"https://ps.w.org/auxin-elements/assets/screenshot-8.png?rev=1486570\" alt=\"One click shortcode elements with its options\"></a><p>One click shortcode elements with its options</p></li><li><a href=\"https://ps.w.org/auxin-elements/assets/screenshot-9.png?rev=1486570\"><img src=\"https://ps.w.org/auxin-elements/assets/screenshot-9.png?rev=1486570\" alt=\"User friendly editing elements\"></a><p>User friendly editing elements</p></li></ol>\";s:7:\"reviews\";s:9504:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">damages my website</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/johnjmg/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/9b5ff84e5479d9e18f80f2c1fd9a3b836e53f5131036b42e9379d53226c8a1e8?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/9b5ff84e5479d9e18f80f2c1fd9a3b836e53f5131036b42e9379d53226c8a1e8?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/johnjmg/\" class=\"reviewer-name\">johnjmg</a> le <span class=\"review-date\">juillet 16, 2024</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>damages my website</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">fatal error</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/giuliopanda/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/297dee0b57bcb468be3e30405ae68ca8baa272a04bc19d2780989fff457e5a74?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/297dee0b57bcb468be3e30405ae68ca8baa272a04bc19d2780989fff457e5a74?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/giuliopanda/\" class=\"reviewer-name\">giuliopanda</a> le <span class=\"review-date\">mars 3, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>The theme stopped working overnight giving the error: fatal error: function auxin_kses doesn\'t exist.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Buggiest Plugin EVER</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/neomundi/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/f7bd42f568a3072330e28b0078a55abcb7fb818a41d534e0944dcbc804258e39?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/f7bd42f568a3072330e28b0078a55abcb7fb818a41d534e0944dcbc804258e39?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/neomundi/\" class=\"reviewer-name\">neomundi</a> le <span class=\"review-date\">juin 27, 2022</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Always breaks my shop about monthly. DO NOT BUY ANY THEM WITH THIS PLUGIN.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Everything works great!</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/artgali/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/79c91fbf8d0a43aa78a3e5eb449cd6ed56b7339348456c0b1fc6a921c13c3815?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/79c91fbf8d0a43aa78a3e5eb449cd6ed56b7339348456c0b1fc6a921c13c3815?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/artgali/\" class=\"reviewer-name\">artgali</a> le <span class=\"review-date\">avril 24, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">I saw there were some negative reviews and just want to give my two cents here. I have built a website with the Phlox theme and elements and I am very happy with it. I never have any issues in my nearly one year of using the plugins or theme. There are never any copatibility issues with other plugins either.\n\nFrequent updates and fast, Averta makes sure the theme works with latest Wordpress changes in matter of hours/days!\nThey are an excellent developer that has made an excellent theme!\n</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Buggy plugin</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/millionary/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/acd5404e26788c4ed5b03eabccd5521783704d0def776d2ed4627b6a6a18c054?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/acd5404e26788c4ed5b03eabccd5521783704d0def776d2ed4627b6a6a18c054?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/millionary/\" class=\"reviewer-name\">millionary</a> le <span class=\"review-date\">avril 15, 2020</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">This issue makes it unusable, and apparently nobody even cares to answer or give information in the issue:\nhttps://wordpress.org/support/topic/missing-auxin_general_post_types_category_slug-leads-to-php-fatal-error/#post-12679183</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Breaks my new site running 5.3.2</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/johncarteroz/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/b1604ab6b992aac70ff8989b8c5293a1e7538dd01d36fd518c99a91bb42e6d61?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/b1604ab6b992aac70ff8989b8c5293a1e7538dd01d36fd518c99a91bb42e6d61?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/johncarteroz/\" class=\"reviewer-name\">johncarteroz</a> le <span class=\"review-date\">mars 22, 2020</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Well, I have used the phlox core plugin before but this time round, it simply breaks my admin and I need to remove the plugin via FTP.\n\nI am raising a support ticket and will revise my review when resolved.\n\n***** UPDATE *****\nWell, another site and this time it breaks my Theme. (PhLox) config (it simply will not load any theme options).\n\nClearly I need theme options more than a few widgets...\n\nI de-activate, theme customisation works... I activate it... the theme breaks.\n\ntoo tired to wait for a solution...\n\nSeems to be very buggy!!!</div>\n</div>\n\";}s:17:\"short_description\";s:90:\"Powerful and comprehensive plugin that extends the functionality of Phlox Elementor theme.\";s:13:\"download_link\";s:65:\"https://downloads.wordpress.org/plugin/auxin-elements.2.17.15.zip\";s:14:\"upgrade_notice\";a:0:{}s:11:\"screenshots\";a:9:{i:1;a:2:{s:3:\"src\";s:67:\"https://ps.w.org/auxin-elements/assets/screenshot-1.png?rev=1486570\";s:7:\"caption\";s:17:\"Front end widgets\";}i:2;a:2:{s:3:\"src\";s:67:\"https://ps.w.org/auxin-elements/assets/screenshot-2.jpg?rev=1486570\";s:7:\"caption\";s:36:\"Sample of using elements on the page\";}i:3;a:2:{s:3:\"src\";s:67:\"https://ps.w.org/auxin-elements/assets/screenshot-3.png?rev=1486570\";s:7:\"caption\";s:36:\"Some of these elements on the footer\";}i:4;a:2:{s:3:\"src\";s:67:\"https://ps.w.org/auxin-elements/assets/screenshot-4.png?rev=1486570\";s:7:\"caption\";s:28:\"Some Dropcap elements styles\";}i:5;a:2:{s:3:\"src\";s:67:\"https://ps.w.org/auxin-elements/assets/screenshot-5.png?rev=1486570\";s:7:\"caption\";s:39:\"User friendly back end elements options\";}i:6;a:2:{s:3:\"src\";s:67:\"https://ps.w.org/auxin-elements/assets/screenshot-6.png?rev=1486570\";s:7:\"caption\";s:43:\"List of elements on the page to choose from\";}i:7;a:2:{s:3:\"src\";s:67:\"https://ps.w.org/auxin-elements/assets/screenshot-7.png?rev=1486570\";s:7:\"caption\";s:30:\"List of widgets to choose from\";}i:8;a:2:{s:3:\"src\";s:67:\"https://ps.w.org/auxin-elements/assets/screenshot-8.png?rev=1486570\";s:7:\"caption\";s:45:\"One click shortcode elements with its options\";}i:9;a:2:{s:3:\"src\";s:67:\"https://ps.w.org/auxin-elements/assets/screenshot-9.png?rev=1486570\";s:7:\"caption\";s:30:\"User friendly editing elements\";}}s:4:\"tags\";a:5:{s:5:\"auxin\";s:5:\"auxin\";s:6:\"averta\";s:6:\"averta\";s:9:\"elementor\";s:9:\"elementor\";s:9:\"fullwidth\";s:9:\"fullwidth\";s:5:\"phlox\";s:5:\"phlox\";}s:8:\"versions\";a:144:{s:5:\"1.0.0\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.1.0.0.zip\";s:5:\"1.0.1\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.1.0.1.zip\";s:5:\"1.0.2\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.1.0.2.zip\";s:5:\"1.0.3\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.1.0.3.zip\";s:5:\"1.0.6\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.1.0.6.zip\";s:5:\"1.0.9\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.1.0.9.zip\";s:5:\"1.1.0\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.1.1.0.zip\";s:5:\"1.3.0\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.1.3.0.zip\";s:5:\"1.3.1\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.1.3.1.zip\";s:6:\"1.3.10\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.1.3.10.zip\";s:6:\"1.3.14\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.1.3.14.zip\";s:5:\"1.3.2\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.1.3.2.zip\";s:5:\"1.3.3\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.1.3.3.zip\";s:5:\"1.3.6\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.1.3.6.zip\";s:5:\"1.4.0\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.1.4.0.zip\";s:5:\"1.4.1\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.1.4.1.zip\";s:5:\"1.4.2\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.1.4.2.zip\";s:5:\"1.5.0\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.1.5.0.zip\";s:5:\"1.5.2\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.1.5.2.zip\";s:5:\"1.6.0\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.1.6.0.zip\";s:5:\"1.6.2\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.1.6.2.zip\";s:5:\"1.6.4\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.1.6.4.zip\";s:5:\"1.7.0\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.1.7.0.zip\";s:5:\"1.7.2\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.1.7.2.zip\";s:6:\"2.10.0\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.10.0.zip\";s:6:\"2.10.1\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.10.1.zip\";s:6:\"2.10.3\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.10.3.zip\";s:6:\"2.10.5\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.10.5.zip\";s:6:\"2.10.7\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.10.7.zip\";s:6:\"2.10.8\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.10.8.zip\";s:6:\"2.10.9\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.10.9.zip\";s:6:\"2.11.0\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.11.0.zip\";s:6:\"2.11.1\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.11.1.zip\";s:6:\"2.11.2\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.11.2.zip\";s:6:\"2.12.0\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.12.0.zip\";s:6:\"2.14.0\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.14.0.zip\";s:6:\"2.15.0\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.15.0.zip\";s:6:\"2.15.2\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.15.2.zip\";s:6:\"2.15.4\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.15.4.zip\";s:6:\"2.15.5\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.15.5.zip\";s:6:\"2.15.6\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.15.6.zip\";s:6:\"2.15.7\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.15.7.zip\";s:6:\"2.15.8\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.15.8.zip\";s:6:\"2.15.9\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.15.9.zip\";s:6:\"2.16.0\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.16.0.zip\";s:6:\"2.16.1\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.16.1.zip\";s:6:\"2.16.2\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.16.2.zip\";s:6:\"2.16.3\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.16.3.zip\";s:6:\"2.16.4\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.16.4.zip\";s:6:\"2.17.0\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.17.0.zip\";s:6:\"2.17.1\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.17.1.zip\";s:7:\"2.17.12\";s:65:\"https://downloads.wordpress.org/plugin/auxin-elements.2.17.12.zip\";s:7:\"2.17.13\";s:65:\"https://downloads.wordpress.org/plugin/auxin-elements.2.17.13.zip\";s:7:\"2.17.14\";s:65:\"https://downloads.wordpress.org/plugin/auxin-elements.2.17.14.zip\";s:7:\"2.17.15\";s:65:\"https://downloads.wordpress.org/plugin/auxin-elements.2.17.15.zip\";s:6:\"2.17.2\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.17.2.zip\";s:6:\"2.17.3\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.17.3.zip\";s:6:\"2.17.4\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.17.4.zip\";s:6:\"2.17.5\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.17.5.zip\";s:6:\"2.17.6\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.17.6.zip\";s:6:\"2.17.8\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.17.8.zip\";s:6:\"2.17.9\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.17.9.zip\";s:6:\"2.4.12\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.4.12.zip\";s:6:\"2.4.13\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.4.13.zip\";s:6:\"2.4.14\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.4.14.zip\";s:6:\"2.4.16\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.4.16.zip\";s:6:\"2.4.18\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.4.18.zip\";s:6:\"2.4.19\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.4.19.zip\";s:5:\"2.4.9\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.4.9.zip\";s:5:\"2.5.0\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.5.0.zip\";s:5:\"2.5.1\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.5.1.zip\";s:6:\"2.5.10\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.5.10.zip\";s:6:\"2.5.11\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.5.11.zip\";s:6:\"2.5.12\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.5.12.zip\";s:6:\"2.5.13\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.5.13.zip\";s:6:\"2.5.14\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.5.14.zip\";s:6:\"2.5.15\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.5.15.zip\";s:6:\"2.5.16\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.5.16.zip\";s:6:\"2.5.17\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.5.17.zip\";s:6:\"2.5.19\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.5.19.zip\";s:5:\"2.5.2\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.5.2.zip\";s:6:\"2.5.20\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.5.20.zip\";s:5:\"2.5.3\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.5.3.zip\";s:5:\"2.5.7\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.5.7.zip\";s:5:\"2.5.8\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.5.8.zip\";s:5:\"2.5.9\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.5.9.zip\";s:5:\"2.6.0\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.6.0.zip\";s:5:\"2.6.1\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.6.1.zip\";s:6:\"2.6.10\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.6.10.zip\";s:6:\"2.6.12\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.6.12.zip\";s:6:\"2.6.13\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.6.13.zip\";s:6:\"2.6.14\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.6.14.zip\";s:6:\"2.6.15\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.6.15.zip\";s:6:\"2.6.16\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.6.16.zip\";s:6:\"2.6.17\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.6.17.zip\";s:6:\"2.6.19\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.6.19.zip\";s:5:\"2.6.2\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.6.2.zip\";s:6:\"2.6.20\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.6.20.zip\";s:5:\"2.6.4\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.6.4.zip\";s:5:\"2.6.5\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.6.5.zip\";s:5:\"2.6.7\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.6.7.zip\";s:5:\"2.7.0\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.7.0.zip\";s:5:\"2.7.1\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.7.1.zip\";s:6:\"2.7.10\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.7.10.zip\";s:6:\"2.7.11\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.7.11.zip\";s:6:\"2.7.12\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.7.12.zip\";s:6:\"2.7.13\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.7.13.zip\";s:6:\"2.7.14\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.7.14.zip\";s:5:\"2.7.2\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.7.2.zip\";s:5:\"2.7.3\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.7.3.zip\";s:5:\"2.7.4\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.7.4.zip\";s:5:\"2.7.5\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.7.5.zip\";s:5:\"2.7.6\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.7.6.zip\";s:5:\"2.7.7\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.7.7.zip\";s:5:\"2.7.8\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.7.8.zip\";s:5:\"2.7.9\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.7.9.zip\";s:5:\"2.8.0\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.8.0.zip\";s:5:\"2.8.1\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.8.1.zip\";s:5:\"2.8.2\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.8.2.zip\";s:5:\"2.8.3\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.8.3.zip\";s:5:\"2.8.4\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.8.4.zip\";s:5:\"2.8.5\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.8.5.zip\";s:5:\"2.8.6\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.8.6.zip\";s:5:\"2.8.7\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.8.7.zip\";s:5:\"2.8.9\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.8.9.zip\";s:5:\"2.9.0\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.9.0.zip\";s:6:\"2.9.12\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.9.12.zip\";s:6:\"2.9.14\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.9.14.zip\";s:6:\"2.9.15\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.9.15.zip\";s:6:\"2.9.16\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.9.16.zip\";s:6:\"2.9.17\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.9.17.zip\";s:6:\"2.9.18\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.9.18.zip\";s:6:\"2.9.19\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.9.19.zip\";s:5:\"2.9.2\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.9.2.zip\";s:6:\"2.9.20\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.9.20.zip\";s:6:\"2.9.21\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.9.21.zip\";s:6:\"2.9.22\";s:64:\"https://downloads.wordpress.org/plugin/auxin-elements.2.9.22.zip\";s:5:\"2.9.3\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.9.3.zip\";s:5:\"2.9.4\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.9.4.zip\";s:5:\"2.9.5\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.9.5.zip\";s:5:\"2.9.6\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.9.6.zip\";s:5:\"2.9.7\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.9.7.zip\";s:5:\"2.9.8\";s:63:\"https://downloads.wordpress.org/plugin/auxin-elements.2.9.8.zip\";s:5:\"trunk\";s:57:\"https://downloads.wordpress.org/plugin/auxin-elements.zip\";}s:14:\"business_model\";b:0;s:14:\"repository_url\";s:0:\"\";s:22:\"commercial_support_url\";s:0:\"\";s:11:\"donate_link\";s:87:\"http://phlox.pro/go/?utm_medium=donate-phlox&ref=averta&utm_source=wporg-auxin-elements\";s:7:\"banners\";a:2:{s:3:\"low\";s:69:\"https://ps.w.org/auxin-elements/assets/banner-772x250.png?rev=1486570\";s:4:\"high\";s:70:\"https://ps.w.org/auxin-elements/assets/banner-1544x500.png?rev=1486570\";}s:5:\"icons\";a:2:{s:2:\"1x\";s:67:\"https://ps.w.org/auxin-elements/assets/icon-128x128.png?rev=1486570\";s:2:\"2x\";s:67:\"https://ps.w.org/auxin-elements/assets/icon-256x256.png?rev=1486570\";}s:12:\"preview_link\";s:0:\"\";s:4:\"Name\";s:45:\"Shortcodes and extra features for Phlox theme\";}s:11:\"woocommerce\";a:35:{s:4:\"name\";s:11:\"WooCommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:7:\"version\";s:6:\"10.5.2\";s:6:\"author\";s:67:\"<a href=\"https://profiles.wordpress.org/automattic/\">Automattic</a>\";s:14:\"author_profile\";s:42:\"https://profiles.wordpress.org/automattic/\";s:12:\"contributors\";a:50:{s:10:\"automattic\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/automattic/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/73edc627541112a447e978843cf72f516bdbf6350e7cbac10016c71ab1b8c8a1?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:10:\"Automattic\";}s:11:\"woocommerce\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/woocommerce/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/c7781a3c13bcc86b57064b9539ec22da52fd5ef1902fbc020d0a4a8595b14ea0?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"WooCommerce\";}s:10:\"mikejolley\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/mikejolley/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/8295774fc174b6a5b9bd960709949f4de88cd0b8708d711dc5b6676693d41432?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Mike Jolley\";}s:11:\"jameskoster\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/jameskoster/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/94b5473c03a46cb204f0a868dfe65f8199ef483242814ec1bcaf6770ba90d203?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"James Koster\";}s:14:\"claudiosanches\";a:3:{s:7:\"profile\";s:46:\"https://profiles.wordpress.org/claudiosanches/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/ac91c7d73bb4501567ab3790755bf001d53dac8d1f4311a2480a5fb62dfb180c?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:15:\"Claudio Sanches\";}s:13:\"rodrigosprimo\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/rodrigosprimo/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/1dc85457417601db220b14e7fa96c842700fbd1cceecd21d65306c26fffb92cc?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Rodrigo Primo\";}s:15:\"peterfabian1000\";a:3:{s:7:\"profile\";s:47:\"https://profiles.wordpress.org/peterfabian1000/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/c25372df076206b9fe44dddd7ec6af6ba427d3fe2a457fa301fcb9cf90b23ddd?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"Peter Fabian\";}s:7:\"vedjain\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/vedjain/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/eb19da24784b2f86d310a213b60c903b0a5464a6c725cf5fcabfd274383337c4?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:19:\"Vedanshu - Urumi.AI\";}s:8:\"jamosova\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/jamosova/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/73f150b0172cbb319293e372b3b20f4b78f0d5fbe70558318f69aad70908e95a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Julia Amosova\";}s:16:\"obliviousharmony\";a:3:{s:7:\"profile\";s:48:\"https://profiles.wordpress.org/obliviousharmony/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/67851e0deeb2c6a7a4c238cf45c0e9694a919e2c5e02706c5852e67c4ad279c9?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:16:\"obliviousharmony\";}s:9:\"konamiman\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/konamiman/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/ee97f225bf5be24cd3c3b04990b9fc3dfc67a2c9aaea418ec2bdd32e164ed9b1?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:23:\"Néstor Soriano Vilchez\";}s:8:\"sadowski\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/sadowski/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/cee318a6ec06e747df7f70f274da4e0cf4adba60c59e12d660d0f5a6ba78658a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:8:\"sadowski\";}s:8:\"wpmuguru\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/wpmuguru/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/23afb25faac780cb6ec9533b2ac9e5daedf7a1faf444b41db471b9529701f87e?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Ron Rennick\";}s:5:\"royho\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/royho/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/1beda14f19fa93030ba2c66359dc270286820af6c667cdfeb4e87833c747f3a0?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"royho\";}s:13:\"barryhughes-1\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/barryhughes-1/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/6ce0f4afb77f8d32da9c43e9a39c84fcfb3ed0e9cac24f440c46a151946cdec8?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"Barry\";}s:12:\"claudiulodro\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/claudiulodro/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/34a74527d3859bd9fb0b477cd80c9f78b3610259a251c32a31023ead285ac124?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:19:\"Claudiu Lodromanean\";}s:12:\"tiagonoronha\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/tiagonoronha/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/0352cd451932c8a2ab15b8457933e6d90cc919bbf23db63e3bc35ee41d56577e?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Tiago Noronha\";}s:6:\"ryelle\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/ryelle/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/6d860975d8bd4b166268bba8da8c1ea0e861a7d7f4ef0aee52fa727fc69e12b2?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:17:\"Kelly Choyce-Dwan\";}s:10:\"levinmedia\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/levinmedia/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/657d301b3683f02c75e4b2363681518e94485770056cc51526f19818884ba6aa?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:10:\"levinmedia\";}s:7:\"aljullu\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/aljullu/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/784f29a6d06799d1d40adc32b115da932cd1ee2b22d91cd8597e9fe6e4ee1420?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:21:\"Albert Juhé Lluveras\";}s:6:\"nerrad\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/nerrad/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/1bd692736861bd20949789e4a3d922736480efcacb0e44041616c5a79eaa54c0?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:22:\"Darren Ethier (nerrad)\";}s:10:\"joshuawold\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/joshuawold/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/f98224d78e12fcc0e9686dbf15f8c37b1967835212f25a92fceb6caafdc5b08d?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Joshua Wold\";}s:13:\"assassinateur\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/assassinateur/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/0850998ce28d445575c78a6405382fd8418569c761304c10c0d5df85453116c0?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"Nadir Seghir\";}s:7:\"haszari\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/haszari/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/5478c55437f47714a4dae1016cf521e803dfc4633ce5781b2f24d749d1623f69?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Rua Haszard\";}s:10:\"mppfeiffer\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/mppfeiffer/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/0fe64f1ef1e4abe1825653bcb17113a4a14c755f5b6f77d2f27494fe349d7081?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:19:\"Michael P. Pfeiffer\";}s:10:\"nielslange\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/nielslange/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/0894ec0d7e5d70306a16431b36249b1928cad88a572de9b5211a54d75ad5d77a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Niels Lange\";}s:9:\"ralucastn\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/ralucastn/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/e65d79886499f47ee368495f5016117deef427d5abca9d3ed76c4bfaa42e7c0a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:6:\"Raluca\";}s:11:\"tjcafferkey\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/tjcafferkey/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/23d134901eef453e721759c9d84810f5748a84fc8681ed230c7d78e53583c77a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"tjcafferkey\";}s:13:\"danielwrobert\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/danielwrobert/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/f1f823ffbe2a6adb7f94c6998079fd6ae6636d3b6272dd8c54385783360e2cf8?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"danielwrobert\";}s:19:\"patriciahillebrandt\";a:3:{s:7:\"profile\";s:51:\"https://profiles.wordpress.org/patriciahillebrandt/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/13f5707fad9a68e5cf9c3c0ebb9c7179c862dcb279c761d20c9b40bd2fff9f4a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:19:\"patriciahillebrandt\";}s:7:\"albarin\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/albarin/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/0dd150b60949026a3c34f49d40089e3a8cf97dc331e2f5b27e805ffd34648e22?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:7:\"albarin\";}s:10:\"dinhtungdu\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/dinhtungdu/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/07e79c32b1abba868f8c5e3ee0c85b9150c74e2c2a946088a268e6be486d9114?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:7:\"Tung Du\";}s:10:\"imanish003\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/imanish003/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/59ff646ede2dd6475f24762ac21ee2afd7d72fdcade7b9d2915cf1c3c2d984a2?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"Manish Menaria\";}s:12:\"karolmanijak\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/karolmanijak/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/42305d7047ca11d494b1912d687266a50edd05954fdec22e61ab1fe63cf2df6b?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Karol Manijak\";}s:13:\"sunyatasattva\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/sunyatasattva/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/73ce316f9775441698b601e6902728a80837f7fd6df0846e3c5a82448dce447c?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:20:\"sunyatasattva (a11n)\";}s:13:\"alexandrelara\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/alexandrelara/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/1c0c71a072f798066e4661395461e73e0fb6692eaddcced2a0e457ef01a458e8?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"Alexandre Lara\";}s:7:\"gigitux\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/gigitux/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/2dcd003f15403180364c56b093b48e6edca9a88c8f1470b965b87fc230c66d7f?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Luigi Teschio\";}s:12:\"danieldudzic\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/danieldudzic/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/b689767c4b308b8f5910cef3a2f44c2acdadcb3b63326b0d5c865d2c208c668e?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"danieldudzic\";}s:11:\"samueljseay\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/samueljseay/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/4c4a5e8fd5b99749ed9ac735c31d0370254356e40feea46bcf51b2b607f8ab0e?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:3:\"Sam\";}s:12:\"alexflorisca\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/alexflorisca/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/b68615471f527e6224909ce0726dda68b074e6cbcf89e0d4b5ecc483a96557ca?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Alex Florisca\";}s:5:\"opr18\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/opr18/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/e083a0759b8ea01b11c1f154a3087ddfaf65a93011cf97a85fdbfc0cda709538?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"opr18\";}s:12:\"tarunvijwani\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/tarunvijwani/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/fa4a4b2688afb8d238bb035f31fda4d07dabd67ccf41576276e5eb084463d617?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"tarunvijwani\";}s:12:\"pauloarromba\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/pauloarromba/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/ab6034aa12c0e53f21978df9e470f161f06810d814082cbe3ab74450f0618818?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Paulo Arromba\";}s:9:\"saadtarhi\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/saadtarhi/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/f4fd0df69b8c7bf3a3e6526df3b42c3854de544904ef825bfd549afc9829f645?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:7:\"Saad T.\";}s:4:\"bor0\";a:3:{s:7:\"profile\";s:36:\"https://profiles.wordpress.org/bor0/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/787d8ea71701ced680cd80411d656c20e0e600be5d34f6ce3478143d43dc9fd9?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:16:\"Boro Sitnikovski\";}s:5:\"kloon\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/kloon/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/c7c708f5b0957714ab48e00220b0f74acccb43b70fa0d4b5ee091d59951ae751?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:17:\"Gerhard Potgieter\";}s:12:\"coreymckrill\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/coreymckrill/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/9cc64cf0f650f165ac55f1294105259f82f2b72c4c24903a79af6d6cd1ad2a9a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Corey McKrill\";}s:12:\"jorgeatorres\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/jorgeatorres/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/33d6a063c7411775135383c5bae6cd4e45d094b72ec062c96ceafca5e2a4956f?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:15:\"Jorge A. Torres\";}s:10:\"leifsinger\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/leifsinger/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/8107603a6bbc5ff73e07e2450f260335af41a5adb2cccd80cba20cdd28b96651?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Leif Singer\";}s:9:\"neosinner\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/neosinner/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/68b52d53a3c6dd39841f697853a1965057c6f3aeb9e89f7d960d1921ffa90d29?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Ján Mikláš\";}}s:8:\"requires\";s:3:\"6.8\";s:6:\"tested\";s:5:\"6.9.1\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:90;s:7:\"ratings\";a:5:{i:5;i:3919;i:4;i:193;i:3;i:104;i:2;i:108;i:1;i:406;}s:11:\"num_ratings\";i:4730;s:11:\"support_url\";s:49:\"https://wordpress.org/support/plugin/woocommerce/\";s:15:\"support_threads\";i:402;s:24:\"support_threads_resolved\";i:296;s:15:\"active_installs\";i:7000000;s:12:\"last_updated\";s:21:\"2026-02-13 2:51pm GMT\";s:5:\"added\";s:10:\"2011-09-27\";s:8:\"homepage\";s:24:\"https://woocommerce.com/\";s:8:\"sections\";a:6:{s:11:\"description\";s:14078:\"<p><a href=\"https://woocommerce.com/woocommerce/\" rel=\"nofollow ugc\">WooCommerce</a> est la plateforme d’eCommerce open-source pour WordPress.</p>\n<p>Notre plateforme centrale est gratuite, flexible et amplifiée par une communauté mondiale. La liberté de son caractère open-source signifie que vous conservez à jamais la pleine propriété du contenu et des données de votre boutique.</p>\n<p>Que vous lanciez une activité, basculiez un magasin physique en ligne ou développiez des sites pour vos clients, WooCommerce permet d’obtenir une boutique qui allie puissamment contenu et commerce.</p>\n<ul>\n<li><strong>Créez des devantures belles et attractives</strong> avec des <a href=\"https://woocommerce.com/product-category/themes/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">thèmes</a> adaptés à votre marque et votre secteur.</li>\n<li><strong>Augmentez vos revenus</strong> grâce à une <a href=\"https://woocommerce.com/checkout-blocks/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">expérience de panier d’achat</a> optimisée qui favorise les conversions.</li>\n<li><strong>Personnalisez les pages de produits en quelques minutes</strong> à l’aide de <a href=\"https://woocommerce.com/document/woocommerce-blocks/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">blocs de produits</a> modulaires.</li>\n<li>Présentez des produits physiques et numériques, des variantes de produits, des configurations personnalisées, des téléchargements instantanés et des articles affiliés.</li>\n<li>Vendez des <a href=\"https://woocommerce.com/products/woocommerce-subscriptions/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">abonnements</a>, des <a href=\"https://woocommerce.com/products/woocommerce-bookings/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">réservations</a> ou des <a href=\"https://woocommerce.com/products/woocommerce-memberships/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">adhésions</a> grâce à nos extensions approuvées par les développeurs.</li>\n<li><strong>Monter en haut des résultats de recherche</strong> en tirant parti des <a href=\"https://www.searchenginejournal.com/wordpress-best-cms-seo/\" rel=\"nofollow ugc\">qualités SEO de WordPress</a>.</li>\n<li><strong>Créez sur une plateforme qui évolue.</strong> Obtenez une solution d’eCommerce flexible pour les <a href=\"https://woocommerce.com/high-volume-stores/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">boutiques à volume élevé</a>.</li>\n</ul>\n<h4>TOUS LES OUTILS DONT VOUS AVEZ BESOIN POUR VENDRE</h4>\n<p>Les outils et intégrations populaires facilitent la gestion de votre activité. De nombreux services peuvent être ajoutés gratuitement d’un seul clic avec <a href=\"https://woocommerce.com/document/woocommerce-setup-wizard/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">l’assistant de configuration</a> facultatif.</p>\n<ul>\n<li><strong>Choisissez comment vous souhaitez recevoir vos paiements</strong>. Gérez facilement et confortablement les paiements depuis votre boutique avec <a href=\"https://woocommerce.com/payments/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooPayments</a> (Disponible aux États-Unis, au Royaume-Uni, en Irlande, en Australie, en Nouvelle-Zélande, au Canada, en Espagne, en France, en Allemagne et en Italie). Acceptez en toute sécurité les cartes de crédit, les portefeuilles mobiles, les transferts bancaires et les espèces grâce à <a href=\"https://woocommerce.com/product-category/woocommerce-extensions/payment-gateways/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">plus de 100 passerelles de paiement</a> dont <a href=\"https://woocommerce.com/products/stripe/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Stripe</a>, <a href=\"https://woocommerce.com/products/woocommerce-gateway-paypal-checkout/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">PayPal</a> et <a href=\"https://woocommerce.com/products/square/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Square</a>.</li>\n<li><strong>Configurez vos options de livraison</strong>. Imprimez des étiquettes USPS directement à partir de votre tableau de bord et planifiez un retrait avec <a href=\"https://woocommerce.com/products/shipping/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce Shipping</a> (États-Unis uniquement). Connectez-vous avec des <a href=\"https://woocommerce.com/product-category/woocommerce-extensions/shipping-methods/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">transporteurs connus</a> comme UPS et FedEx, ainsi qu’une grande variété de solutions de livraison, d’inventaire et de traitement des commandes pour votre région.</li>\n<li><strong>Simplifiez les taxes sur les ventes</strong>. Ajoutez <a href=\"https://woocommerce.com/products/tax/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce Tax</a> ou des <a href=\"https://woocommerce.com/product-category/woocommerce-extensions/tax?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">services intégrés similaires</a> pour faire des calculs automatisés une réalité.</li>\n</ul>\n<h4>Développez votre activité, ajoutez des fonctionnalités et surveillez votre boutique où que vous soyez</h4>\n<p>WooCommerce signifie activité. Gardez un œil sur les indicateurs de performance les plus importants pour vous grâce à un tableau de bord central puissant et flexible intégré à WooCommerce.</p>\n<p>Élargissez votre audience sur les canaux marketing et sociaux avec les intégrations <a href=\"https://woocommerce.com/products/google-ads/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Google Ads</a>, <a href=\"https://woocommerce.com/products/hubspot-for-woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">HubSpot</a>, <a href=\"https://woocommerce.com/products/mailchimp-for-woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Mailchimp</a> et <a href=\"https://woocommerce.com/products/facebook/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Facebook</a>. Vous pouvez consulter le <a href=\"https://woocommerce.com/document/marketing-hub/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Marketing Hub</a> dans le tableau de bord pour trouver de nouvelles idées et des astuces pour vous aider à prospérer.</p>\n<p>Améliorez les fonctionnalités de votre boutique grâce à des centaines d’extensions gratuites et payantes sur <a href=\"https://woocommerce.com/products/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce Marketplace</a>. Nos développeurs <a href=\"https://woocommerce.com/document/marketplace-overview/#section-6?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">vérifient chaque nouvelle extension</a> et examinent régulièrement les extensions existantes pour maintenir les normes de qualité du marché. Nous sommes activement <a href=\"https://woocommerce.com/document/marketplace-overview/#section-2?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">à la recherche de produits qui aident les créateurs de boutique à en faire des boutiques prospères</a>.</p>\n<p>Gérez votre boutique depuis n’importe quel endroit avec <a href=\"https://woocommerce.com/mobile/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">l’application mobile</a> WooCommerce (sur Android et iOS). Spoiler alert : restez à l’affût du son légèrement addictif de la notification qui retentit à chaque vente.</p>\n<h4>Détenez et contrôlez les données de votre boutique à vie</h4>\n<p>Avec <a href=\"https://woocommerce.com/woocommerce/\" rel=\"nofollow ugc\">WooCommerce</a>, vos données vous appartiennent. Toujours.</p>\n<p>Si vous optez pour partager <a href=\"https://woocommerce.com/usage-tracking/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">les données d’utilisation</a> avec nous, vous avez l’assurance que celles-ci seront anonymisées et conservées en toute sécurité. Vous pouvez changer d’avis à tout moment sans que cela n’ait la moindre incidence sur votre boutique.</p>\n<p>Contrairement aux solutions d’eCommerce hébergées, les données des boutiques WooCommerce sont pérennes. Vous pouvez exporter l’intégralité de votre contenu et transférer votre site vers la plateforme de votre choix. Aucune restriction.</p>\n<h4>Pourquoi les développeurs choisissent (et aiment) WooCommerce</h4>\n<p>Les développeurs peuvent utiliser <a href=\"https://woocommerce.com/woocommerce/\" rel=\"nofollow ugc\">WooCommerce</a> pour créer, personnaliser et adapter une boutique en fonction des spécifications exactes du client tout en y apportant des améliorations par le biais d’extensions ou de solutions personnalisées.</p>\n<ul>\n<li>Exploitez les <a href=\"https://woocommerce.com/document/introduction-to-hooks-actions-and-filters/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">crochets d’action et les filtres</a> pour modifier ou créer des fonctionnalités.</li>\n<li>Intégrez pratiquement n’importe quel service à l’aide d’une <a href=\"https://developer.woocommerce.com/docs/getting-started-with-the-woocommerce-rest-api/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">API REST</a> robuste et des webhooks.</li>\n<li>Concevez et créez des blocs de contenu personnalisés avec React.</li>\n<li><a href=\"https://developer.woocommerce.com/docs/category/extension-development/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Inspectez et modifiez</a> tous les aspects du code principal de l’extension.</li>\n<li>Accélérez le développement avec une <a href=\"https://developer.woocommerce.com/docs/category/wc-cli/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">CLI</a> rapide comme l’éclair.</li>\n</ul>\n<p>La plateforme centrale fait l’objet de tests rigoureux et fréquents. Ils sont exécutés par une équipe de développement dédiée qui travaillent sur différents fuseaux horaires. La documentation complète est mise à jour à chaque version afin de vous apporter les outils requis pour créer en tout point la boutique dont vous avez besoin.</p>\n<h4>Rejoignez notre communauté internationale grandissante</h4>\n<p>WooCommerce compte une communauté importante et passionnée qui contribue à la réussite des commerçants et qui s’agrandit rapidement.</p>\n<p>Il y a des <a href=\"https://woocommerce.com/meetups/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">rencontres WooCommerce</a> à travers le monde, auxquelles vous pouvez assister gratuitement ; vous pouvez même vous impliquer dans leur organisation. Ces événements sont excellents pour apprendre des expériences de chacun, partager votre expertise et rencontrer des personnes qui pensent comme vous.</p>\n<p>WooCommerce participe également régulièrement aux WordCamps organisés dans le monde entier. Nous serions ravis de vous rencontrer.</p>\n<h4>Contribution et traduction</h4>\n<p>WooCommerce est développé et pris en charge par Automattic, les créateurs de WordPress.com et Jetpack. Nous avons également des centaines de contributeurs indépendants, et il y a toujours de la place pour plus. Dirigez-vous vers le <a href=\"https://github.com/woocommerce/woocommerce?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Dépôt WooCommerce GitHub</a> pour découvrir comment vous pouvez participer.</p>\n<p>WooCommerce est traduit en plusieurs langues, dont le danois, l’ukrainien et le persan. Aidez à localiser encore plus WooCommerce en ajoutant vos paramètres régionaux &#8211; visitez <a href=\"https://translate.wordpress.org/projects/wp-plugins/woocommerce/?utm_medium=referral&#038;utm_source=wordpress.org&#038;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">translate.wordpress.org</a>.</p>\n<h4>Connexion à WooCommerce.com</h4>\n<p>Vous pouvez connecter votre boutique à <a href=\"https://woocommerce.com/\" rel=\"nofollow ugc\">WooCommerce.com</a> pour gérer vos abonnements à WooCommerce Marketplace et recevoir des mises à jour produit sans quitter WordPress Admin. La connexion permet également l’installation des produits achetés depuis WooCommerce.com et rationalise l’accès à l’assistance technique. Si vous désirez savoir quelles sont les données collectées et l’utilisation qui en est faite, veuillez consulter notre <a href=\"https://automattic.com/privacy/\" rel=\"nofollow ugc\">politique de confidentialité</a>.</p>\n\";s:12:\"installation\";s:2921:\"<h4>Configuration minimale</h4>\n<ul>\n<li>PHP 7.4 ou supérieur est requis (PHP 8.0 ou supérieur est recommandé)</li>\n<li>MySQL 5.5.5 ou supérieur, OU MariaDB version 10.1 ou supérieure, est obligatoire</li>\n<li>WordPress 6.8 ou version supérieure</li>\n<li>(Recommended) WordPress <a href=\"https://woocommerce.com/document/increasing-the-wordpress-memory-limit/\" rel=\"nofollow ugc\">memory limit</a> of 256 MB or greater.</li>\n<li>(Recommended) <a href=\"https://woocommerce.com/document/ssl-and-https/\" rel=\"nofollow ugc\">HTTPS</a> support.</li>\n</ul>\n<h4>Installation automatique</h4>\n<p>L’installation automatique est l’option la plus simple, car WordPress gère le transfert des fichiers sans que vous n’ayez à quitter votre navigateur. Pour effectuer une installation automatique de WooCommerce, connectez-vous à votre tableau de bord WordPress, accédez au menu « Extensions » et cliquez sur « Ajouter ».</p>\n<p>Dans le champ de recherche, saisissez « WooCommerce », puis cliquez sur « Rechercher des extensions ». Une fois que vous l’avez trouvée, vous pouvez voir les détails la concernant comme la version intermédiaire, l’évaluation et la description. Mais surtout, vous pouvez l’installer en cliquant simplement sur « Installer maintenant ». WordPress s’occupera alors de la suite.</p>\n<h4>Installation manuelle</h4>\n<p>La méthode d’installation manuelle consiste à télécharger l’extension WooCommerce et à la téléverser sur votre serveur Web via votre application FTP préférée. Le codex de WordPress contient <a href=\"https://wordpress.org/support/article/managing-plugins/#manual-plugin-installation\" rel=\"ugc\">des instructions pour se faire ici</a>.</p>\n<h4>Mise à jour</h4>\n<p>Les mises à jour automatiques ne devraient pas poser de problème, mais nous vous recommandons tout de même de sauvegarder votre site.</p>\n<p>Si par malchance vous recontrez des problèmes avec les pages de la boutique / catégorie après une mise à jour, il vous suffit de regénérer les permaliens en allant sur  WordPress &gt; Réglages &gt; Permaliens puis en cliquant sur « sauvegarder. » Cela devrait régler ces problèmes.</p>\n<h4>Exemple de données</h4>\n<p>WooCommerce s’accompagne d’échantillons de données que vous pouvez utiliser pour voir à quoi ressemblent les produits ; importez sample_products.xml via l’<a href=\"https://wordpress.org/plugins/wordpress-importer/\" rel=\"ugc\">importateur WordPress</a>. Vous pouvez également utiliser l’<a href=\"https://woocommerce.com/document/product-csv-importer-exporter/?utm_source=wp%20org%20repo%20listing&amp;utm_content=3.6\" rel=\"nofollow ugc\">importateur de CSV</a> ou notre <a href=\"https://woocommerce.com/products/product-csv-import-suite/?utm_source=wp%20org%20repo%20listing&amp;utm_content=3.6\" rel=\"nofollow ugc\">extension CSV Import Suite</a> pour importer sample_products.csv</p>\n\";s:3:\"faq\";s:8726:\"\n<dt id=\"where%20can%20i%20find%20woocommerce%20documentation%20and%20user%20guides%3F\">\nOù puis-je trouver de la documentation et des guides de l&rsquo;utilisateur pour l&rsquo;extension WooCommerce&nbsp;?\n</h4>\n<p>\n<p>Si vous désirez une aide à propos de la configuration de WooCommerce, veuillez consulter le guide <a href=\"https://woocommerce.com/documentation/plugins/woocommerce/getting-started/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Premier pas</a> et le <a href=\"https://woocommerce.com/guides/new-store/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">guide pour le nouveau propriétaire de boutique WooCommerce</a>.</p>\n<p>Pour créer une extension ou un thème WooCommerce, consultez notre <a href=\"https://github.com/woocommerce/woocommerce/tree/trunk/docs\" rel=\"nofollow ugc\">documentation</a>, ainsi que les <a href=\"https://github.com/woocommerce/woocommerce/blob/trunk/docs/extension-development/extension-development-best-practices.md\" rel=\"nofollow ugc\">Bonnes pratiques pour les développeurs d’extensions</a>.</p>\n</p>\n<dt id=\"where%20can%20i%20get%20help%20or%20talk%20to%20other%20users%20about%20woocommerce%20core%3F\">\nOù puis-je trouver de l’aide ou discuter avec d’autres utilisateurs à propos de WooCommerce Core ?\n</h4>\n<p>\n<p>Si ça coince, vous pouvez demander de l’aide sur <a href=\"https://wordpress.org/support/plugin/woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"ugc\">le forum d’assistance WooCommerce</a> en suivant <a href=\"https://wordpress.org/support/topic/guide-to-the-woocommerce-forum/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"ugc\">ces directives</a>, poster sur le <a href=\"https://woocommerce.com/community-slack/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Slack de la communauté WooCommerce</a>, ou publier sur le <a href=\"https://www.facebook.com/groups/advanced.woocommerce?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">groupe de la communauté WooCommerce</a> sur Facebook.</p>\n</p>\n<dt id=\"where%20can%20i%20get%20help%20for%20extensions%20i%20have%20purchased%20from%20the%20woocommerce%20marketplace%3F\">\nOù puis-je trouver de l’aide concernant les extensions que j’ai achetées sur WooCommerce Marketplace ?\n</h4>\n<p>\n<p>Pour toute assistance concernant les extensions payantes de WooCommerce Marketplace : commencez par consulter notre <a href=\"https://woocommerce.com/document/woocommerce-self-service-guide/\" rel=\"nofollow ugc\">guide de résolution de problème en libre-service</a>. Si le problème persiste, veuillez ouvrir un ticket d’assistance via <a href=\"https://woocommerce.com/my-account/create-a-ticket/\" rel=\"nofollow ugc\">notre service d’assistance</a>. Nos Happiness Engineers dévoués vous répondront dans les 24 heures.</p>\n</p>\n<dt id=\"i%E2%80%99m%20having%20trouble%20logging%20in%20to%20woocommerce.com%20%E2%80%93%20what%20now%3F\">\nJ’ai des problèmes de connexion à WooCommerce.com. Que dois-je faire ?\n</h4>\n<p>\n<p>Tout d’abord, résolvez les problèmes de connexion courants à l’aide de ce <a href=\"https://woocommerce.com/document/log-into-woocommerce-com-with-wordpress-com/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">guide étape par étape</a> utile. Cela ne fonctionne toujours pas ? <a href=\"https://woocommerce.com/contact-us/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Contactez-nous</a>.</p>\n</p>\n<dt id=\"will%20woocommerce%20work%20with%20my%20theme%3F\">\nEst-ce que WooCommerce fonctionnera avec mon thème ?\n</h4>\n<p>\n<p>Oui ! WooCommerce est compatible avec tous les thèmes mais quelques adaptations stylistiques supplémentaires peuvent être nécessaires. Si vous cherchez un thème qui s’intègre parfaitement à WooCommerce, nous recommandons <a href=\"https://woocommerce.com/storefront/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Storefront</a>.</p>\n</p>\n<dt id=\"how%20do%20i%20update%20woocommerce%3F\">\nComment puis-je mettre à jour WooCommerce ?\n</h4>\n<p>\n<p>Nous disposons d’un guide détaillé intitulé <a href=\"https://woocommerce.com/document/how-to-update-woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Comment mettre à jour WooCommerce</a>.</p>\n</p>\n<dt id=\"my%20site%20broke%20%E2%80%93%20what%20do%20i%20do%3F\">\nMon site ne fonctionne plus. Que dois-je faire ?\n</h4>\n<p>\n<p>Commencez par diagnostiquer le problème à l’aide de notre <a href=\"https://woocommerce.com/documentation/get-help/troubleshooting-get-help/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">guide de résolution de problème</a>.</p>\n<p>Si l’erreur est apparue après la mise à jour d’un thème ou d’une extension, des problèmes de compatibilité peuvent exister entre ce thème/cette extension et WooCommerce. Si le problème est apparu après la mise à jour de WooCommerce, un conflit peut exister entre WooCommerce et un thème ou une extension obsolète.</p>\n<p>Quoi qu’il en soit, nous recommandons de procéder à un test de conflits à l’aide de <a href=\"https://woocommerce.com/document/troubleshooting-using-health-check/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Health Check</a> (ce qui vous permet de désactiver les thèmes et les extensions sans affecter vos visiteurs) ou de résoudre le problème à l’aide du <a href=\"https://woocommerce.com/document/how-to-test-for-conflicts/#section-3?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">site de préproduction</a>.</p>\n</p>\n<dt id=\"where%20can%20i%20report%20bugs%3F\">\nOù puis-je signaler des bugs ?\n</h4>\n<p>\n<p>Signaler des bogues sur <a href=\"https://github.com/woocommerce/woocommerce/issues?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Dépôt WooCommerce GitHub</a>. Vous pouvez également nous en informer via notre support &#8211; assurez-vous de rechercher les forums pour confirmer que l’erreur n’a pas déjà été signalée.</p>\n</p>\n<dt id=\"where%20can%20i%20request%20new%20features%2C%20themes%2C%20and%20extensions%3F\">\nOù puis-je demander de nouvelles fonctionnalités, des thèmes et des extensions ?\n</h4>\n<p>\n<p>Demandez de nouvelles fonctionnalités et extensions, et votez pour les suggestions existantes sur notre <a href=\"https://woocommerce.com/feature-requests/woocommerce?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">tableau de demande de fonctionnalité</a> officiel. Nos équipes Produits consultent régulièrement les demandes, qui leur sont d’un soutien précieux pour la planification des produits.</p>\n</p>\n<dt id=\"woocommerce%20is%20awesome%21%20can%20i%20contribute%3F\">\nWooCommerce est génial ? Puis-je y contribuer ?\n</h4>\n<p>\n<p>Rejoignez notre <a href=\"https://github.com/woocommerce/woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">dépôt GitHub</a> et suivez le <a href=\"https://woocommerce.wordpress.com/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">blog de développement</a> pour rester informé de tout ce qui se passe dans le projet.</p>\n</p>\n<dt id=\"where%20can%20i%20find%20rest%20api%20documentation%3F\">\nOù puis-je trouver la documentation pour l’API Rest ?\n</h4>\n<p>\n<p>Une <a href=\"https://woocommerce.github.io/woocommerce-rest-api-docs/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">documentation complète de l’API REST WooCommerce</a> est disponible sur GitHub.</p>\n</p>\n<dt id=\"my%20question%20is%20not%20listed%20here.%20where%20can%20i%20find%20more%20answers%3F\">\nMa question n’apparaît pas dans la liste. Où puis-je trouver d’autres réponses ?\n</h4>\n<p>\n<p>Consultez les <a href=\"https://woocommerce.com/document/frequently-asked-questions/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">questions les plus fréquentes</a> pour en savoir plus.</p>\n</p>\n\n\";s:9:\"changelog\";s:442:\"<h4>10.5.2 2026-02-13</h4>\n<p><strong>WooCommerce</strong></p>\n<ul>\n<li>Fix &#8211; Fix variable products add-to-cart button appearing disabled in some stores <a href=\"https://github.com/woocommerce/woocommerce/pull/63262\" rel=\"nofollow ugc\">#63262</a></li>\n</ul>\n<p><a href=\"https://raw.githubusercontent.com/woocommerce/woocommerce/trunk/changelog.txt\" rel=\"nofollow ugc\">Voir le journal des modifications pour toutes les versions</a>.</p>\n\";s:11:\"screenshots\";s:1035:\"<ol><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-1.png?rev=3234504\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-1.png?rev=3234504\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-2.png?rev=3234504\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-2.png?rev=3234504\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-3.png?rev=3234504\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-3.png?rev=3234504\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-4.png?rev=3235205\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-4.png?rev=3235205\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-5.png?rev=3234504\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-5.png?rev=3234504\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-6.png?rev=3234504\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-6.png?rev=3234504\" alt=\"\"></a></li></ol>\";s:7:\"reviews\";s:16031:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Great woocomerce</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/autoflexeu/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/03d2e1b43333755381ef1292719f20956619ef56af7f2894dacfa4767669158a?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/03d2e1b43333755381ef1292719f20956619ef56af7f2894dacfa4767669158a?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/autoflexeu/\" class=\"reviewer-name\">autoflexeu</a> le <span class=\"review-date\">février 17, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Great woocomerce i like it</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Excellent Customer Service and Technical Support!</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/thelastbestwest/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/656945a6d534710a4c34249877fc5001a016c241835330f4930e12dbba8db1cb?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/656945a6d534710a4c34249877fc5001a016c241835330f4930e12dbba8db1cb?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/thelastbestwest/\" class=\"reviewer-name\">thelastbestwest</a> le <span class=\"review-date\">février 12, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>We\'ve used WooCommerce for many years and it works so well we rarely need support.  An update this past week, however, changed that.  our checkout process was broken and the support team at WooCommerce stepped up almost immediately with troubleshooting steps and potential solutions.  It turned out our Theme was interfering with the WooCommerce process.  The Theme patch was applied and that resolved everything.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Many thanks to the WooCommerce wonderful support team for their prompt attention to this. </p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Prompt reply and helpful insights</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/scudyscud/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/e5a12b1d2ad8ab1cac1e43c84ff189795ccc646dfa67ea1a4bd323fc30ff4a9b?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/e5a12b1d2ad8ab1cac1e43c84ff189795ccc646dfa67ea1a4bd323fc30ff4a9b?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/scudyscud/\" class=\"reviewer-name\">scudyscud</a> le <span class=\"review-date\">février 12, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>With the assistance of WC techies I have managed to solve a weird pagination problem.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Super rapidos</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/ivansabinacapital/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/6c239f4d576ee04814edf944495c9404fd043151244fafa86a250a89b5e8a8e8?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/6c239f4d576ee04814edf944495c9404fd043151244fafa86a250a89b5e8a8e8?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/ivansabinacapital/\" class=\"reviewer-name\">ivansabinacapital</a> le <span class=\"review-date\">février 11, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>No me han solucionado el problema porque no era con Wocommerce pero gracias a ellos he descubierto que es lo que estaba causando los errores en mi web </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>un saludo </p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Great Help</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/johnhedouglas/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/cfaa00aae45dbd0f6e54386a16edf3f47189e742f96c811f64a902414a7886b7?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/cfaa00aae45dbd0f6e54386a16edf3f47189e742f96c811f64a902414a7886b7?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/johnhedouglas/\" class=\"reviewer-name\">johnhedouglas</a> le <span class=\"review-date\">février 11, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>The assistance i recieved from WordPress forum was excellent thank you very much </p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Thumbs up!</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/sillystreethearts/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/8714097c880b3c08745fa242a3343987fe48c4e04f3481b352c2f198a404e1db?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/8714097c880b3c08745fa242a3343987fe48c4e04f3481b352c2f198a404e1db?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/sillystreethearts/\" class=\"reviewer-name\">sillystreethearts</a> le <span class=\"review-date\">février 10, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Very fast ánd friendly support for someone who is not very technical. Thanks for the tips and advice! </p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Very Helpful</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/1839lab/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/b4f05141fbc265f8d102f7fa21b360902fd4261223c257799adbbe2b6700bc05?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/b4f05141fbc265f8d102f7fa21b360902fd4261223c257799adbbe2b6700bc05?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/1839lab/\" class=\"reviewer-name\">1839lab</a> le <span class=\"review-date\">février 9, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Quick and effective answers that help you solve the problem.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">The only e-commerce solution I need</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/champdor/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/38ed107dd227aec2ac3eeda27530d251cee289bf42b67c00cee98e1c013b5284?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/38ed107dd227aec2ac3eeda27530d251cee289bf42b67c00cee98e1c013b5284?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/champdor/\" class=\"reviewer-name\">champdor</a> le <span class=\"review-date\">février 7, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Over the years I worked magic with Woo. All kinds of e-commerce sites and some funky ones: ambassador (peer-to-peer) donation sites, pizza ordering site without 3rd party plugins but my custom code, or weekly menu ordering site similarly with custom code.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>All my codes and custom functions work with classic shortcodes since I find modifying block Checkout unnecessary difficult or impossible. And most of the times blocks are not that extensible for special purposes or markets. So I hope either block Checkout dies (not likely) or customization becomes easier.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>And I appreciate all the hard work going into this system. I just read through the changeog for 10.5.<br />You rock!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Fast support</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/durino666/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/a2fa54cc2c290a3f8a79f30bc4799c00188426ab3c100546f83293972edaad57?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/a2fa54cc2c290a3f8a79f30bc4799c00188426ab3c100546f83293972edaad57?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/durino666/\" class=\"reviewer-name\">durino666</a> le <span class=\"review-date\">février 5, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Quick response, behavior explained...</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Flexible and free</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/valdeks/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/3ef2e4fc76da5a3a99dbd8747e40d2c91cd3bccfef89dd9c3cc50cd964cb8a84?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/3ef2e4fc76da5a3a99dbd8747e40d2c91cd3bccfef89dd9c3cc50cd964cb8a84?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/valdeks/\" class=\"reviewer-name\">valdeks</a> le <span class=\"review-date\">février 3, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I have run my WooCommerce shop for 5 years now and it is the most suitable for a small business. Plenty of plugins to customize configuration and much of them can use completely free.</p>\n<!-- /wp:paragraph --></div>\n</div>\n\";}s:17:\"short_description\";s:227:\"Tout ce dont vous avez besoin pour créer une boutique en ligne en quelques jours et la faire prospérer des années. Woo vous accompagne, de votre toute première vente au développement colossal de votre chiffre d’affaires.\";s:13:\"download_link\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.5.2.zip\";s:14:\"upgrade_notice\";a:0:{}s:11:\"screenshots\";a:6:{i:1;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-1.png?rev=3234504\";s:7:\"caption\";s:0:\"\";}i:2;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-2.png?rev=3234504\";s:7:\"caption\";s:0:\"\";}i:3;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-3.png?rev=3234504\";s:7:\"caption\";s:0:\"\";}i:4;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-4.png?rev=3235205\";s:7:\"caption\";s:0:\"\";}i:5;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-5.png?rev=3234504\";s:7:\"caption\";s:0:\"\";}i:6;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-6.png?rev=3234504\";s:7:\"caption\";s:0:\"\";}}s:4:\"tags\";a:5:{s:9:\"ecommerce\";s:9:\"ecommerce\";s:12:\"online-store\";s:12:\"online store\";s:11:\"sell-online\";s:11:\"sell online\";s:4:\"shop\";s:4:\"shop\";s:13:\"shopping-cart\";s:13:\"shopping cart\";}s:8:\"versions\";a:561:{s:6:\"10.0.0\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.0.0.zip\";s:11:\"10.0.0-rc.1\";s:66:\"https://downloads.wordpress.org/plugin/woocommerce.10.0.0-rc.1.zip\";s:11:\"10.0.0-rc.2\";s:66:\"https://downloads.wordpress.org/plugin/woocommerce.10.0.0-rc.2.zip\";s:6:\"10.0.1\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.0.1.zip\";s:6:\"10.0.2\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.0.2.zip\";s:6:\"10.0.3\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.0.3.zip\";s:6:\"10.0.4\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.0.4.zip\";s:6:\"10.0.5\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.0.5.zip\";s:6:\"10.1.0\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.1.0.zip\";s:11:\"10.1.0-rc.1\";s:66:\"https://downloads.wordpress.org/plugin/woocommerce.10.1.0-rc.1.zip\";s:11:\"10.1.0-rc.2\";s:66:\"https://downloads.wordpress.org/plugin/woocommerce.10.1.0-rc.2.zip\";s:11:\"10.1.0-rc.3\";s:66:\"https://downloads.wordpress.org/plugin/woocommerce.10.1.0-rc.3.zip\";s:11:\"10.1.0-rc.4\";s:66:\"https://downloads.wordpress.org/plugin/woocommerce.10.1.0-rc.4.zip\";s:6:\"10.1.1\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.1.1.zip\";s:6:\"10.1.2\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.1.2.zip\";s:6:\"10.1.3\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.1.3.zip\";s:6:\"10.2.0\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.2.0.zip\";s:13:\"10.2.0-beta.1\";s:68:\"https://downloads.wordpress.org/plugin/woocommerce.10.2.0-beta.1.zip\";s:13:\"10.2.0-beta.2\";s:68:\"https://downloads.wordpress.org/plugin/woocommerce.10.2.0-beta.2.zip\";s:11:\"10.2.0-rc.1\";s:66:\"https://downloads.wordpress.org/plugin/woocommerce.10.2.0-rc.1.zip\";s:6:\"10.2.1\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.2.1.zip\";s:6:\"10.2.2\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.2.2.zip\";s:6:\"10.2.3\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.2.3.zip\";s:6:\"10.3.0\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.3.0.zip\";s:13:\"10.3.0-beta.1\";s:68:\"https://downloads.wordpress.org/plugin/woocommerce.10.3.0-beta.1.zip\";s:13:\"10.3.0-beta.2\";s:68:\"https://downloads.wordpress.org/plugin/woocommerce.10.3.0-beta.2.zip\";s:11:\"10.3.0-rc.1\";s:66:\"https://downloads.wordpress.org/plugin/woocommerce.10.3.0-rc.1.zip\";s:11:\"10.3.0-rc.2\";s:66:\"https://downloads.wordpress.org/plugin/woocommerce.10.3.0-rc.2.zip\";s:6:\"10.3.1\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.3.1.zip\";s:6:\"10.3.2\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.3.2.zip\";s:6:\"10.3.3\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.3.3.zip\";s:6:\"10.3.4\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.3.4.zip\";s:6:\"10.3.5\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.3.5.zip\";s:6:\"10.3.6\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.3.6.zip\";s:6:\"10.3.7\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.3.7.zip\";s:6:\"10.4.0\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.4.0.zip\";s:13:\"10.4.0-beta.1\";s:68:\"https://downloads.wordpress.org/plugin/woocommerce.10.4.0-beta.1.zip\";s:13:\"10.4.0-beta.2\";s:68:\"https://downloads.wordpress.org/plugin/woocommerce.10.4.0-beta.2.zip\";s:11:\"10.4.0-rc.1\";s:66:\"https://downloads.wordpress.org/plugin/woocommerce.10.4.0-rc.1.zip\";s:6:\"10.4.1\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.4.1.zip\";s:6:\"10.4.2\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.4.2.zip\";s:6:\"10.4.3\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.4.3.zip\";s:6:\"10.5.0\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.5.0.zip\";s:13:\"10.5.0-beta.1\";s:68:\"https://downloads.wordpress.org/plugin/woocommerce.10.5.0-beta.1.zip\";s:13:\"10.5.0-beta.2\";s:68:\"https://downloads.wordpress.org/plugin/woocommerce.10.5.0-beta.2.zip\";s:11:\"10.5.0-rc.1\";s:66:\"https://downloads.wordpress.org/plugin/woocommerce.10.5.0-rc.1.zip\";s:11:\"10.5.0-rc.2\";s:66:\"https://downloads.wordpress.org/plugin/woocommerce.10.5.0-rc.2.zip\";s:11:\"10.5.0-rc.3\";s:66:\"https://downloads.wordpress.org/plugin/woocommerce.10.5.0-rc.3.zip\";s:6:\"10.5.1\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.5.1.zip\";s:6:\"10.5.2\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.5.2.zip\";s:5:\"3.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.0.zip\";s:5:\"3.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.1.zip\";s:5:\"3.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.2.zip\";s:5:\"3.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.3.zip\";s:5:\"3.0.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.4.zip\";s:5:\"3.0.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.5.zip\";s:5:\"3.0.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.6.zip\";s:5:\"3.0.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.7.zip\";s:5:\"3.0.8\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.8.zip\";s:5:\"3.0.9\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.9.zip\";s:5:\"3.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.1.0.zip\";s:5:\"3.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.1.1.zip\";s:5:\"3.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.1.2.zip\";s:5:\"3.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.0.zip\";s:5:\"3.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.1.zip\";s:5:\"3.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.2.zip\";s:5:\"3.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.3.zip\";s:5:\"3.2.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.4.zip\";s:5:\"3.2.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.5.zip\";s:5:\"3.2.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.6.zip\";s:5:\"3.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.0.zip\";s:5:\"3.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.1.zip\";s:5:\"3.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.2.zip\";s:10:\"3.3.2-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.2-rc.1.zip\";s:5:\"3.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.3.zip\";s:5:\"3.3.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.4.zip\";s:5:\"3.3.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.5.zip\";s:5:\"3.3.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.6.zip\";s:5:\"3.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.0.zip\";s:12:\"3.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.0-beta.1.zip\";s:10:\"3.4.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.0-rc.2.zip\";s:5:\"3.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.1.zip\";s:5:\"3.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.2.zip\";s:5:\"3.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.3.zip\";s:5:\"3.4.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.4.zip\";s:5:\"3.4.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.5.zip\";s:5:\"3.4.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.6.zip\";s:5:\"3.4.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.7.zip\";s:5:\"3.4.8\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.8.zip\";s:5:\"3.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0.zip\";s:12:\"3.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0-beta.1.zip\";s:10:\"3.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0-rc.1.zip\";s:10:\"3.5.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0-rc.2.zip\";s:5:\"3.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.1.zip\";s:6:\"3.5.10\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.10.zip\";s:5:\"3.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.2.zip\";s:5:\"3.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.3.zip\";s:5:\"3.5.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.4.zip\";s:5:\"3.5.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.5.zip\";s:5:\"3.5.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.6.zip\";s:5:\"3.5.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.7.zip\";s:5:\"3.5.8\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.8.zip\";s:5:\"3.5.9\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.9.zip\";s:5:\"3.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0.zip\";s:12:\"3.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-beta.1.zip\";s:10:\"3.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-rc.1.zip\";s:10:\"3.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-rc.2.zip\";s:10:\"3.6.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-rc.3.zip\";s:5:\"3.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.1.zip\";s:5:\"3.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.2.zip\";s:5:\"3.6.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.3.zip\";s:5:\"3.6.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.4.zip\";s:5:\"3.6.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.5.zip\";s:5:\"3.6.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.6.zip\";s:5:\"3.6.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.7.zip\";s:5:\"3.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0.zip\";s:12:\"3.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0-beta.1.zip\";s:10:\"3.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0-rc.1.zip\";s:10:\"3.7.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0-rc.2.zip\";s:5:\"3.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.1.zip\";s:5:\"3.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.2.zip\";s:5:\"3.7.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.3.zip\";s:5:\"3.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0.zip\";s:12:\"3.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0-beta.1.zip\";s:10:\"3.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0-rc.1.zip\";s:10:\"3.8.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0-rc.2.zip\";s:5:\"3.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.1.zip\";s:5:\"3.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.2.zip\";s:5:\"3.8.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.3.zip\";s:5:\"3.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0.zip\";s:12:\"3.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-beta.1.zip\";s:12:\"3.9.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-beta.2.zip\";s:10:\"3.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.1.zip\";s:10:\"3.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.2.zip\";s:10:\"3.9.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.3.zip\";s:10:\"3.9.0-rc.4\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.4.zip\";s:5:\"3.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.1.zip\";s:5:\"3.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.2.zip\";s:5:\"3.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.3.zip\";s:5:\"3.9.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.4.zip\";s:5:\"3.9.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.5.zip\";s:5:\"4.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0.zip\";s:12:\"4.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0-beta.1.zip\";s:10:\"4.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0-rc.1.zip\";s:10:\"4.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0-rc.2.zip\";s:5:\"4.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.1.zip\";s:5:\"4.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.2.zip\";s:5:\"4.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.3.zip\";s:5:\"4.0.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.4.zip\";s:5:\"4.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0.zip\";s:12:\"4.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-beta.1.zip\";s:12:\"4.1.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-beta.2.zip\";s:10:\"4.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-rc.1.zip\";s:10:\"4.1.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-rc.2.zip\";s:5:\"4.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.1.zip\";s:5:\"4.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.2.zip\";s:5:\"4.1.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.3.zip\";s:5:\"4.1.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.4.zip\";s:5:\"4.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0.zip\";s:10:\"4.2.0-RC.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0-RC.1.zip\";s:10:\"4.2.0-RC.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0-RC.2.zip\";s:12:\"4.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0-beta.1.zip\";s:5:\"4.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.1.zip\";s:5:\"4.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.2.zip\";s:5:\"4.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.3.zip\";s:5:\"4.2.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.4.zip\";s:5:\"4.2.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.5.zip\";s:5:\"4.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0.zip\";s:12:\"4.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-beta.1.zip\";s:10:\"4.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-rc.1.zip\";s:10:\"4.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-rc.2.zip\";s:10:\"4.3.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-rc.3.zip\";s:5:\"4.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.1.zip\";s:5:\"4.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.2.zip\";s:5:\"4.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.3.zip\";s:5:\"4.3.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.4.zip\";s:5:\"4.3.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.5.zip\";s:5:\"4.3.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.6.zip\";s:5:\"4.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.0.zip\";s:12:\"4.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.0-beta.1.zip\";s:10:\"4.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.0-rc.1.zip\";s:5:\"4.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.1.zip\";s:5:\"4.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.2.zip\";s:5:\"4.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.3.zip\";s:5:\"4.4.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.4.zip\";s:5:\"4.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0.zip\";s:12:\"4.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0-beta.1.zip\";s:10:\"4.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0-rc.1.zip\";s:10:\"4.5.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0-rc.3.zip\";s:5:\"4.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.1.zip\";s:5:\"4.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.2.zip\";s:5:\"4.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.3.zip\";s:5:\"4.5.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.4.zip\";s:5:\"4.5.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.5.zip\";s:5:\"4.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.0.zip\";s:12:\"4.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.0-beta.1.zip\";s:10:\"4.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.0-rc.1.zip\";s:5:\"4.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.1.zip\";s:5:\"4.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.2.zip\";s:5:\"4.6.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.3.zip\";s:5:\"4.6.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.4.zip\";s:5:\"4.6.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.5.zip\";s:5:\"4.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0.zip\";s:12:\"4.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0-beta.1.zip\";s:12:\"4.7.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0-beta.2.zip\";s:10:\"4.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0-rc.1.zip\";s:5:\"4.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.1.zip\";s:12:\"4.7.1-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.1-beta.1.zip\";s:5:\"4.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.2.zip\";s:5:\"4.7.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.3.zip\";s:5:\"4.7.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.4.zip\";s:5:\"4.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0.zip\";s:12:\"4.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0-beta.1.zip\";s:10:\"4.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0-rc.1.zip\";s:10:\"4.8.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0-rc.2.zip\";s:5:\"4.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.1.zip\";s:5:\"4.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.2.zip\";s:5:\"4.8.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.3.zip\";s:5:\"4.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0.zip\";s:12:\"4.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0-beta.1.zip\";s:10:\"4.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0-rc.1.zip\";s:10:\"4.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0-rc.2.zip\";s:5:\"4.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.1.zip\";s:5:\"4.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.2.zip\";s:5:\"4.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.3.zip\";s:5:\"4.9.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.4.zip\";s:5:\"4.9.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.5.zip\";s:5:\"5.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0.zip\";s:12:\"5.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-beta.1.zip\";s:12:\"5.0.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-beta.2.zip\";s:10:\"5.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-rc.1.zip\";s:10:\"5.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-rc.2.zip\";s:10:\"5.0.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-rc.3.zip\";s:5:\"5.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.1.zip\";s:5:\"5.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.2.zip\";s:5:\"5.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.3.zip\";s:5:\"5.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.0.zip\";s:12:\"5.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.0-beta.1.zip\";s:10:\"5.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.0-rc.1.zip\";s:5:\"5.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.1.zip\";s:5:\"5.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.2.zip\";s:5:\"5.1.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.3.zip\";s:5:\"5.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0.zip\";s:12:\"5.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0-beta.1.zip\";s:10:\"5.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0-rc.1.zip\";s:10:\"5.2.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0-rc.2.zip\";s:5:\"5.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.1.zip\";s:5:\"5.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.2.zip\";s:5:\"5.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.3.zip\";s:5:\"5.2.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.4.zip\";s:5:\"5.2.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.5.zip\";s:5:\"5.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0.zip\";s:12:\"5.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0-beta.1.zip\";s:10:\"5.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0-rc.1.zip\";s:10:\"5.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0-rc.2.zip\";s:5:\"5.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.1.zip\";s:5:\"5.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.2.zip\";s:5:\"5.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.3.zip\";s:5:\"5.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.0.zip\";s:12:\"5.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.0-beta.1.zip\";s:10:\"5.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.0-rc.1.zip\";s:5:\"5.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.1.zip\";s:5:\"5.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.2.zip\";s:5:\"5.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.3.zip\";s:5:\"5.4.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.4.zip\";s:5:\"5.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0.zip\";s:12:\"5.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0-beta.1.zip\";s:10:\"5.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0-rc.1.zip\";s:10:\"5.5.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0-rc.2.zip\";s:5:\"5.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.1.zip\";s:5:\"5.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.2.zip\";s:5:\"5.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.3.zip\";s:5:\"5.5.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.4.zip\";s:5:\"5.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0.zip\";s:12:\"5.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0-beta.1.zip\";s:10:\"5.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0-rc.1.zip\";s:10:\"5.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0-rc.2.zip\";s:5:\"5.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.1.zip\";s:5:\"5.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.2.zip\";s:5:\"5.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.0.zip\";s:12:\"5.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.0-beta.1.zip\";s:10:\"5.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.0-rc.1.zip\";s:5:\"5.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.1.zip\";s:5:\"5.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.2.zip\";s:5:\"5.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0.zip\";s:12:\"5.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0-beta.1.zip\";s:12:\"5.8.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0-beta.2.zip\";s:10:\"5.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0-rc.1.zip\";s:5:\"5.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.1.zip\";s:5:\"5.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0.zip\";s:12:\"5.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0-beta.1.zip\";s:10:\"5.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0-rc.1.zip\";s:10:\"5.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0-rc.2.zip\";s:5:\"5.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.1.zip\";s:5:\"6.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.0.0.zip\";s:12:\"6.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.0.0-beta.1.zip\";s:10:\"6.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.0.0-rc.1.zip\";s:5:\"6.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.0.1.zip\";s:5:\"6.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.0.zip\";s:12:\"6.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.0-beta.1.zip\";s:10:\"6.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.0-rc.1.zip\";s:10:\"6.1.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.0-rc.2.zip\";s:5:\"6.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.1.zip\";s:5:\"6.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.2.zip\";s:5:\"6.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.0.zip\";s:12:\"6.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.0-beta.1.zip\";s:10:\"6.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.0-rc.1.zip\";s:10:\"6.2.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.0-rc.2.zip\";s:5:\"6.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.1.zip\";s:5:\"6.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.2.zip\";s:5:\"6.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.0.zip\";s:12:\"6.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.0-beta.1.zip\";s:10:\"6.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.0-rc.1.zip\";s:10:\"6.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.0-rc.2.zip\";s:5:\"6.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.1.zip\";s:5:\"6.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.4.0.zip\";s:12:\"6.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.4.0-beta.1.zip\";s:10:\"6.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.4.0-rc.1.zip\";s:5:\"6.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.4.1.zip\";s:5:\"6.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.0.zip\";s:12:\"6.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.0-beta.1.zip\";s:10:\"6.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.0-rc.1.zip\";s:10:\"6.5.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.0-rc.2.zip\";s:5:\"6.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.1.zip\";s:5:\"6.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.0.zip\";s:12:\"6.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.0-beta.1.zip\";s:10:\"6.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.0-rc.1.zip\";s:10:\"6.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.0-rc.2.zip\";s:5:\"6.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.1.zip\";s:5:\"6.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.7.0.zip\";s:12:\"6.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.7.0-beta.1.zip\";s:12:\"6.7.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.7.0-beta.2.zip\";s:10:\"6.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.7.0-rc.1.zip\";s:5:\"6.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.0.zip\";s:12:\"6.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.0-beta.1.zip\";s:12:\"6.8.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.0-beta.2.zip\";s:10:\"6.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.0-rc.1.zip\";s:5:\"6.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.1.zip\";s:5:\"6.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.2.zip\";s:5:\"6.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.0.zip\";s:12:\"6.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.0-beta.1.zip\";s:12:\"6.9.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.0-beta.2.zip\";s:10:\"6.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.0-rc.1.zip\";s:5:\"6.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.1.zip\";s:5:\"6.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.2.zip\";s:5:\"6.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.3.zip\";s:5:\"6.9.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.4.zip\";s:5:\"7.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0.zip\";s:12:\"7.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-beta.1.zip\";s:12:\"7.0.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-beta.2.zip\";s:12:\"7.0.0-beta.3\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-beta.3.zip\";s:10:\"7.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-rc.1.zip\";s:10:\"7.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-rc.2.zip\";s:5:\"7.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.1.zip\";s:5:\"7.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0.zip\";s:12:\"7.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0-beta.1.zip\";s:12:\"7.1.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0-beta.2.zip\";s:10:\"7.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0-rc.1.zip\";s:10:\"7.1.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0-rc.2.zip\";s:5:\"7.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.1.zip\";s:5:\"7.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0.zip\";s:12:\"7.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0-beta.1.zip\";s:12:\"7.2.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0-beta.2.zip\";s:10:\"7.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0-rc.1.zip\";s:10:\"7.2.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0-rc.2.zip\";s:5:\"7.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.1.zip\";s:5:\"7.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.2.zip\";s:5:\"7.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.3.zip\";s:5:\"7.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0.zip\";s:12:\"7.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0-beta.1.zip\";s:12:\"7.3.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0-beta.2.zip\";s:10:\"7.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0-rc.1.zip\";s:10:\"7.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0-rc.2.zip\";s:5:\"7.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0.zip\";s:12:\"7.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0-beta.1.zip\";s:12:\"7.4.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0-beta.2.zip\";s:10:\"7.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0-rc.1.zip\";s:10:\"7.4.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0-rc.2.zip\";s:5:\"7.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.1.zip\";s:5:\"7.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.0.zip\";s:12:\"7.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.0-beta.1.zip\";s:12:\"7.5.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.0-beta.2.zip\";s:10:\"7.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.0-rc.1.zip\";s:5:\"7.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.1.zip\";s:5:\"7.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0.zip\";s:12:\"7.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-beta.1.zip\";s:12:\"7.6.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-beta.2.zip\";s:10:\"7.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-rc.1.zip\";s:10:\"7.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-rc.2.zip\";s:10:\"7.6.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-rc.3.zip\";s:5:\"7.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.1.zip\";s:5:\"7.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.0.zip\";s:12:\"7.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.0-beta.1.zip\";s:12:\"7.7.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.0-beta.2.zip\";s:10:\"7.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.0-rc.1.zip\";s:5:\"7.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.1.zip\";s:5:\"7.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.2.zip\";s:5:\"7.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0.zip\";s:12:\"7.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0-beta.1.zip\";s:12:\"7.8.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0-beta.2.zip\";s:10:\"7.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0-rc.1.zip\";s:10:\"7.8.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0-rc.2.zip\";s:5:\"7.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.1.zip\";s:5:\"7.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.2.zip\";s:5:\"7.8.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.3.zip\";s:5:\"7.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0.zip\";s:12:\"7.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0-beta.1.zip\";s:12:\"7.9.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0-beta.2.zip\";s:10:\"7.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0-rc.2.zip\";s:10:\"7.9.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0-rc.3.zip\";s:5:\"7.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.1.zip\";s:5:\"8.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0.zip\";s:12:\"8.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0-beta.1.zip\";s:12:\"8.0.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0-beta.2.zip\";s:10:\"8.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0-rc.1.zip\";s:10:\"8.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0-rc.2.zip\";s:5:\"8.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.1.zip\";s:5:\"8.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.2.zip\";s:5:\"8.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.3.zip\";s:5:\"8.0.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.4.zip\";s:5:\"8.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.0.zip\";s:12:\"8.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.0-beta.1.zip\";s:10:\"8.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.0-rc.1.zip\";s:10:\"8.1.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.0-rc.2.zip\";s:5:\"8.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.1.zip\";s:5:\"8.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.2.zip\";s:5:\"8.1.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.3.zip\";s:5:\"8.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.0.zip\";s:12:\"8.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.0-beta.1.zip\";s:10:\"8.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.0-rc.1.zip\";s:10:\"8.2.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.0-rc.2.zip\";s:5:\"8.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.1.zip\";s:5:\"8.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.2.zip\";s:5:\"8.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.3.zip\";s:5:\"8.2.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.4.zip\";s:5:\"8.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.0.zip\";s:12:\"8.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.0-beta.1.zip\";s:10:\"8.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.0-rc.1.zip\";s:10:\"8.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.0-rc.2.zip\";s:5:\"8.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.1.zip\";s:5:\"8.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.2.zip\";s:5:\"8.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.3.zip\";s:5:\"8.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.4.0.zip\";s:12:\"8.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.4.0-beta.1.zip\";s:10:\"8.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.4.0-rc.1.zip\";s:5:\"8.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.4.1.zip\";s:5:\"8.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.4.2.zip\";s:5:\"8.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.0.zip\";s:12:\"8.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.0-beta.1.zip\";s:10:\"8.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.0-rc.1.zip\";s:5:\"8.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.1.zip\";s:5:\"8.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.2.zip\";s:5:\"8.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.3.zip\";s:5:\"8.5.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.4.zip\";s:5:\"8.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.0.zip\";s:12:\"8.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.0-beta.1.zip\";s:10:\"8.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.0-rc.1.zip\";s:5:\"8.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.1.zip\";s:5:\"8.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.2.zip\";s:5:\"8.6.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.3.zip\";s:5:\"8.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.0.zip\";s:12:\"8.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.0-beta.1.zip\";s:12:\"8.7.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.0-beta.2.zip\";s:10:\"8.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.0-rc.1.zip\";s:5:\"8.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.1.zip\";s:5:\"8.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.2.zip\";s:5:\"8.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.0.zip\";s:12:\"8.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.0-beta.1.zip\";s:10:\"8.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.0-rc.1.zip\";s:5:\"8.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.1.zip\";s:5:\"8.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.2.zip\";s:5:\"8.8.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.3.zip\";s:5:\"8.8.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.4.zip\";s:5:\"8.8.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.5.zip\";s:5:\"8.8.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.6.zip\";s:5:\"8.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.0.zip\";s:12:\"8.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.0-beta.1.zip\";s:10:\"8.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.0-rc.1.zip\";s:5:\"8.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.1.zip\";s:5:\"8.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.2.zip\";s:5:\"8.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.3.zip\";s:5:\"8.9.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.4.zip\";s:5:\"9.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.0.zip\";s:12:\"9.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.0-beta.1.zip\";s:12:\"9.0.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.0-beta.2.zip\";s:10:\"9.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.0-rc.1.zip\";s:5:\"9.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.1.zip\";s:5:\"9.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.2.zip\";s:5:\"9.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.3.zip\";s:5:\"9.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.0.zip\";s:12:\"9.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.0-beta.1.zip\";s:10:\"9.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.0-rc.1.zip\";s:5:\"9.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.1.zip\";s:5:\"9.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.2.zip\";s:5:\"9.1.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.3.zip\";s:5:\"9.1.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.4.zip\";s:5:\"9.1.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.5.zip\";s:5:\"9.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.0.zip\";s:12:\"9.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.0-beta.1.zip\";s:10:\"9.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.0-rc.1.zip\";s:5:\"9.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.1.zip\";s:5:\"9.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.2.zip\";s:5:\"9.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.3.zip\";s:5:\"9.2.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.4.zip\";s:5:\"9.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.0.zip\";s:12:\"9.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.0-beta.1.zip\";s:10:\"9.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.0-rc.1.zip\";s:5:\"9.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.1.zip\";s:5:\"9.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.2.zip\";s:5:\"9.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.3.zip\";s:5:\"9.3.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.4.zip\";s:5:\"9.3.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.5.zip\";s:5:\"9.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0.zip\";s:12:\"9.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-beta.1.zip\";s:12:\"9.4.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-beta.2.zip\";s:10:\"9.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-rc.1.zip\";s:10:\"9.4.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-rc.2.zip\";s:10:\"9.4.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-rc.3.zip\";s:10:\"9.4.0-rc.4\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-rc.4.zip\";s:5:\"9.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.1.zip\";s:5:\"9.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.2.zip\";s:5:\"9.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.3.zip\";s:5:\"9.4.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.4.zip\";s:5:\"9.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.0.zip\";s:12:\"9.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.0-beta.1.zip\";s:12:\"9.5.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.0-beta.2.zip\";s:10:\"9.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.0-rc.1.zip\";s:5:\"9.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.1.zip\";s:5:\"9.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.2.zip\";s:5:\"9.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.3.zip\";s:5:\"9.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.6.0.zip\";s:12:\"9.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.6.0-beta.1.zip\";s:12:\"9.6.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.6.0-beta.2.zip\";s:10:\"9.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.6.0-rc.1.zip\";s:5:\"9.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.6.1.zip\";s:5:\"9.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.6.2.zip\";s:5:\"9.6.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.6.3.zip\";s:5:\"9.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.7.0.zip\";s:12:\"9.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.7.0-beta.1.zip\";s:10:\"9.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.7.0-rc.1.zip\";s:5:\"9.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.7.1.zip\";s:5:\"9.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.7.2.zip\";s:5:\"9.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.0.zip\";s:12:\"9.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.0-beta.1.zip\";s:10:\"9.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.0-rc.1.zip\";s:5:\"9.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.1.zip\";s:5:\"9.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.2.zip\";s:5:\"9.8.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.3.zip\";s:5:\"9.8.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.4.zip\";s:5:\"9.8.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.5.zip\";s:5:\"9.8.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.6.zip\";s:5:\"9.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.0.zip\";s:12:\"9.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.0-beta.1.zip\";s:10:\"9.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.0-rc.1.zip\";s:5:\"9.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.1.zip\";s:5:\"9.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.2.zip\";s:5:\"9.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.3.zip\";s:5:\"9.9.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.4.zip\";s:5:\"9.9.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.5.zip\";s:5:\"9.9.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.6.zip\";s:5:\"trunk\";s:54:\"https://downloads.wordpress.org/plugin/woocommerce.zip\";}s:14:\"business_model\";s:10:\"commercial\";s:14:\"repository_url\";s:0:\"\";s:22:\"commercial_support_url\";s:0:\"\";s:11:\"donate_link\";s:0:\"\";s:7:\"banners\";a:2:{s:3:\"low\";s:66:\"https://ps.w.org/woocommerce/assets/banner-772x250.png?rev=3234504\";s:4:\"high\";s:67:\"https://ps.w.org/woocommerce/assets/banner-1544x500.png?rev=3234504\";}s:5:\"icons\";a:2:{s:2:\"1x\";s:56:\"https://ps.w.org/woocommerce/assets/icon.svg?rev=3234504\";s:3:\"svg\";s:56:\"https://ps.w.org/woocommerce/assets/icon.svg?rev=3234504\";}s:12:\"preview_link\";s:0:\"\";s:4:\"Name\";s:11:\"WooCommerce\";}}","off");

INSERT IGNORE INTO `wp_options` VALUES 
("372","recently_activated","a:2:{s:35:\"litespeed-cache/litespeed-cache.php\";i:1771420655;s:23:\"loco-translate/loco.php\";i:1771410733;}","off"),
("373","_transient_auxin_maybe_flush_autoptimize_cache","172800","on"),
("374","rp4wp_do_install","0","off"),
("377","_transient_timeout_auxin_auxin-elements_version","1773918562","off"),
("378","_transient_auxin_auxin-elements_version","2.17.15","off"),
("379","_transient_timeout_element-pack-notice-id-license-issue","1802863679","off"),
("380","_transient_element-pack-notice-id-license-issue","1","off"),
("381","medium_crop","1","auto"),
("382","medium_large_crop","1","auto"),
("383","large_crop","1","auto"),
("384","_transient_auxin_update_plugins","O:8:\"stdClass\":2:{s:12:\"last_checked\";i:1771427499;s:7:\"checked\";a:4:{s:29:\"masterslider/masterslider.php\";s:6:\"3.7.12\";s:33:\"auxin-elements/auxin-elements.php\";s:7:\"2.17.15\";s:35:\"auxin-pro-tools/auxin-pro-tools.php\";s:5:\"1.9.7\";s:25:\"auxin-shop/auxin-shop.php\";s:5:\"2.1.7\";}}","on"),
("385","envato_purchase_code_3909293","a:1:{s:5:\"token\";s:9:\"activated\";}","off"),
("386","phlox-pro_license_update","1","off"),
("387","_transient_auxin_update_themes","O:8:\"stdClass\":2:{s:12:\"last_checked\";i:1771427501;s:8:\"response\";a:1:{s:9:\"phlox-pro\";a:3:{s:4:\"slug\";s:9:\"phlox-pro\";s:7:\"version\";s:7:\"5.17.12\";s:7:\"package\";s:22:\"AUXIN_GET_DOWNLOAD_URL\";}}}","on"),
("401","elementor_active_kit","160","auto"),
("402","elementor_font_display","auto","auto"),
("405","elementor_disable_color_schemes","","auto"),
("406","elementor_disable_typography_schemes","","auto"),
("407","elementor_page_title_selector",".page-title","auto"),
("408","elementor_allow_svg","1","auto"),
("409","_transient_timeout_auxin_has_checked_to_disable_default_elementor_colors_fonts","1772965029","off"),
("410","_transient_auxin_has_checked_to_disable_default_elementor_colors_fonts","5.9.1","off"),
("411","elementor_landing_pages_activation","0","auto"),
("412","elementor_checklist","{\"last_opened_timestamp\":null,\"first_closed_checklist_in_editor\":false,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"should_open_in_editor\":false}","auto"),
("413","elementor_version","3.35.4","auto"),
("414","elementor_install_history","a:4:{s:5:\"3.0.5\";i:1599025263;s:5:\"3.4.4\";i:1632042946;s:6:\"3.10.1\";i:1674374039;s:6:\"3.23.4\";i:1725785943;}","auto"),
("415","elementor_events_db_version","1.0.0","off"),
("416","_elementor_ab_testing_data","a:2:{s:7:\"timeout\";i:1771411971;s:5:\"value\";s:273:\"[{\"coreOnboarding\":{\"emphasizeConnectBenefits101\":true,\"embedConnectInOnboarding102\":false,\"onboardingStartsWithLogin103\":false,\"offerThemeChoicesHelloBiz201\":false,\"emphasizeThemeValueAudience202\":false,\"updateCopyVisuals401\":false,\"reduceHierarchyBlankOption402\":false}}]\";}","off"),
("417","_transient_timeout_auxin_has_elementor_header_template_ported","1802862594","off"),
("418","_transient_auxin_has_elementor_header_template_ported","5.17.7","off"),
("419","_transient_timeout_auxin_has_elementor_footer_template_ported","1802862594","off"),
("420","_transient_auxin_has_elementor_footer_template_ported","5.17.7","off"),
("421","elementor_connect_site_key","d1b732460f7c575c6b3b15ca8fcdda81","auto"),
("422","elementor_remote_info_feed_data","a:3:{i:0;a:5:{s:5:\"title\";s:59:\"The atomic foundation of version 4 is ready for real sites!\";s:7:\"excerpt\";s:296:\"The alpha phase is complete. Version 4 is now in beta, and the atomic foundation is ready to be used on real sites! This is the final step before the official release of version 4.0, activating the new features automatically on new sites, and becoming the default editing experience in Elementor.\";s:7:\"created\";i:1770651621;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:113:\"https://elementor.com/blog/editor-4-beta/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:79:\"Introducing Elementor 3.33: Variables Manager, Custom CSS, Blend Modes, & more!\";s:7:\"excerpt\";s:340:\"Elementor 3.33 builds on the foundation of Editor V4, continuing our mission to create a faster, more scalable, and more intuitive design experience for Web Creators. With the addition of the Variables Manager, element-level Custom CSS, Background Clipping, and Blend Modes, designers have more creative precision and consistency than ever.\";s:7:\"created\";i:1762944115;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:145:\"https://elementor.com/blog/elementor-333-v4-variables-manager-custom-css/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:76:\"Introducing Elementor 3.32: Transitions, Transform, Size Variables, and More\";s:7:\"excerpt\";s:250:\"Elementor 3.32 is here, accelerating Editor V4 Alpha with transform controls and layered transitions, system-wide Size Variables and streamlined class management. This release empowers you to build more consistent, dynamic, and professional websites.\";s:7:\"created\";i:1759243152;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:138:\"https://elementor.com/blog/elementor-332-v4-transform-transitions/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}","off"),
("425","phlox-pro_theme_options","a:664:{s:24:\"typography_html_template\";s:0:\"\";s:27:\"global_colors_html_template\";s:0:\"\";s:17:\"site_wrapper_size\";s:4:\"full\";s:21:\"site_max_width_layout\";s:5:\"s-fhd\";s:40:\"site_override_elementor_max_width_layout\";b:0;s:15:\"body_typography\";s:212:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Montserrat:100,200,300,regular,500,600,700,800,900,100italic,200italic,300italic,italic,500italic,600italic,700italic,800italic,900italic\",\"type\":\"gFont\"}}}}\";s:19:\"general_heading_all\";s:0:\"\";s:18:\"general_heading_h1\";s:430:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Playfair Display:regular,500,600,700,800,900,italic,500italic,600italic,700italic,800italic,900italic\",\"type\":\"gFont\"},\"color\":\"\",\"font-size-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}},\"font-weight\":\"\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:18:\"general_heading_h2\";s:430:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Playfair Display:regular,500,600,700,800,900,italic,500italic,600italic,700italic,800italic,900italic\",\"type\":\"gFont\"},\"color\":\"\",\"font-size-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}},\"font-weight\":\"\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:18:\"general_heading_h3\";s:415:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Playfair Display:regular,500,600,700,800,900,italic,500italic,600italic,700italic,800italic,900italic\",\"type\":\"gFont\"},\"color\":\"\",\"font-size\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}},\"font-weight\":\"\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}},\"letter-spacing\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:18:\"general_heading_h4\";s:430:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Playfair Display:regular,500,600,700,800,900,italic,500italic,600italic,700italic,800italic,900italic\",\"type\":\"gFont\"},\"color\":\"\",\"font-size-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}},\"font-weight\":\"\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:18:\"general_heading_h5\";s:466:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Montserrat:100,200,300,regular,500,600,700,800,900,100italic,200italic,300italic,italic,500italic,600italic,700italic,800italic,900italic\",\"type\":\"gFont\"},\"color\":\"\",\"font-size-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}},\"font-weight\":\"\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:17:\"header_logo_width\";s:2:\"80\";s:27:\"header_logo_max_height_type\";s:4:\"auto\";s:22:\"header_logo_max_height\";s:2:\"85\";s:25:\"page_animation_nav_enable\";s:0:\"\";s:23:\"page_animation_nav_type\";s:4:\"fade\";s:19:\"page_preload_enable\";s:0:\"\";s:27:\"page_preload_custom_loading\";s:0:\"\";s:26:\"page_preload_loading_image\";s:0:\"\";s:25:\"page_preload_prgoress_bar\";s:1:\"1\";s:34:\"page_preload_prgoress_bar_position\";s:3:\"top\";s:31:\"page_preload_prgoress_bar_color\";s:0:\"\";s:31:\"page_preload_page_overlay_color\";s:0:\"\";s:23:\"elementor_color_primary\";s:7:\"#1359B6\";s:25:\"elementor_color_secondary\";s:7:\"#AAAAAA\";s:20:\"elementor_color_text\";s:7:\"#3D3D3D\";s:22:\"elementor_color_accent\";s:7:\"#D3D3D3\";s:39:\"elementor_global_custom_colors_repeater\";s:0:\"\";s:31:\"use_legacy_featured_colors_info\";s:0:\"\";s:26:\"use_legacy_featured_colors\";s:0:\"\";s:21:\"site_featured_color_1\";s:7:\"#1359b6\";s:21:\"site_featured_color_2\";s:7:\"#222222\";s:21:\"site_featured_color_3\";s:7:\"#c4c4c4\";s:21:\"site_featured_color_4\";s:7:\"#3d3d3d\";s:21:\"site_featured_color_5\";s:7:\"#f9f9f9\";s:21:\"site_featured_color_6\";s:7:\"#aaaaaa\";s:21:\"site_featured_color_7\";s:7:\"#d3d3d3\";s:21:\"site_featured_color_8\";s:7:\"#e74c3c\";s:25:\"site_body_background_show\";s:0:\"\";s:26:\"site_body_background_color\";s:0:\"\";s:28:\"site_body_background_pattern\";s:0:\"\";s:26:\"site_body_background_image\";s:0:\"\";s:25:\"site_body_background_size\";s:4:\"auto\";s:27:\"site_body_background_repeat\";s:9:\"no-repeat\";s:29:\"site_body_background_position\";s:8:\"left top\";s:27:\"site_body_background_attach\";s:6:\"scroll\";s:29:\"site_content_background_color\";s:0:\"\";s:15:\"site_frame_show\";s:0:\"\";s:27:\"site_frame_background_color\";s:7:\"#111111\";s:24:\"global_video_player_skin\";s:4:\"dark\";s:24:\"global_audio_player_skin\";s:4:\"dark\";s:23:\"archive_pagination_skin\";s:10:\"aux-square\";s:34:\"archive_pagination_skin_typography\";s:0:\"\";s:41:\"archive_pagination_skin_active_typography\";s:0:\"\";s:44:\"archive_pagination_skin_next_prev_typography\";s:0:\"\";s:33:\"site_mobile_browser_toolbar_color\";s:29:\"var(--e-global-color-primary)\";s:20:\"comment_forms_inputs\";a:2:{i:0;s:5:\"email\";i:1;s:6:\"author\";}s:18:\"comment_forms_skin\";s:6:\"modern\";s:19:\"comment_forms_label\";s:0:\"\";s:24:\"comment_forms_label_typo\";s:495:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"var(--e-global-color-text)\",\"font-size-resp\":{\"desktop\":{\"value\":16,\"unit\":\"px\"}},\"font-weight\":\"500\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":23,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:20:\"comment_forms_layout\";s:7:\"default\";s:26:\"comment_forms_replay_title\";s:13:\"Add a Comment\";s:31:\"comment_forms_replay_title_typo\";s:495:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"var(--e-global-color-text)\",\"font-size-resp\":{\"desktop\":{\"value\":16,\"unit\":\"px\"}},\"font-weight\":\"500\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":23,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:19:\"comment_forms_notes\";s:70:\"Your email address will not be published. Required fields are marked *\";s:24:\"comment_forms_notes_typo\";s:495:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"var(--e-global-color-text)\",\"font-size-resp\":{\"desktop\":{\"value\":16,\"unit\":\"px\"}},\"font-weight\":\"400\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":23,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:33:\"comment_forms_response_title_typo\";s:417:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Playfair Display:regular,italic,700,700italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"var(--e-global-color-text)\",\"font-size-resp\":{\"desktop\":{\"value\":21,\"unit\":\"px\"}},\"font-weight\":\"400\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":30,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:25:\"comment_forms_button_typo\";s:484:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Poppins:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"rgb(255, 255, 255)\",\"font-size-resp\":{\"desktop\":{\"value\":14,\"unit\":\"px\"}},\"font-weight\":\"600\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":20,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:30:\"comment_forms_placeholder_typo\";s:0:\"\";s:19:\"comment_author_typo\";s:495:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"var(--e-global-color-text)\",\"font-size-resp\":{\"desktop\":{\"value\":16,\"unit\":\"px\"}},\"font-weight\":\"600\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":19,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:17:\"comment_info_typo\";s:509:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"var(--e-global-color-secondary)\",\"font-size-resp\":{\"desktop\":{\"value\":14,\"unit\":\"px\"}},\"font-weight\":\"500\",\"text-transform\":\"uppercase\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":19,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:20:\"comment_content_typo\";s:495:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"var(--e-global-color-text)\",\"font-size-resp\":{\"desktop\":{\"value\":16,\"unit\":\"px\"}},\"font-weight\":\"500\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":23,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:38:\"sidebar_common_widget_title_typography\";s:0:\"\";s:39:\"sidebar_primary_widget_title_typography\";s:0:\"\";s:41:\"sidebar_secondary_widget_title_typography\";s:0:\"\";s:25:\"sidebar_global_typography\";s:0:\"\";s:24:\"sidebar_widget_togglable\";s:0:\"\";s:29:\"sidebar_widget_expand_on_init\";s:1:\"1\";s:23:\"sidebar_custom_dropdown\";s:4:\"none\";s:35:\"site_elementor_header_edit_template\";s:3:\"159\";s:30:\"site_elementor_header_template\";s:3:\"159\";s:39:\"site_elementor_header_templates_library\";s:0:\"\";s:22:\"site_header_use_legacy\";b:0;s:19:\"site_overlay_header\";b:1;s:22:\"site_header_top_sticky\";b:0;s:19:\"sticky_header_color\";s:7:\"#FFFFFF\";s:35:\"site_header_container_scaled_height\";s:2:\"80\";s:17:\"site_header_info3\";s:0:\"\";s:30:\"site_header_section_use_legacy\";b:0;s:22:\"site_header_top_layout\";s:21:\"horizontal-menu-right\";s:17:\"site_header_width\";s:9:\"semi-full\";s:28:\"site_header_container_height\";s:2:\"66\";s:25:\"site_header_search_button\";b:1;s:24:\"site_header_social_icons\";s:0:\"\";s:20:\"site_header_msg_text\";s:0:\"\";s:29:\"site_header_social_icons_size\";s:5:\"small\";s:16:\"show_header_logo\";s:1:\"1\";s:16:\"show_header_cart\";b:1;s:16:\"header_cart_type\";s:8:\"dropdown\";s:21:\"site_header_card_mode\";b:0;s:16:\"header_cart_icon\";s:22:\"auxicon-shopping-bag-4\";s:21:\"site_header_cart_text\";s:15:\"Shopping Basket\";s:26:\"site_header_cart_animation\";b:1;s:25:\"header_cart_dropdown_skin\";s:5:\"light\";s:30:\"header_cart_dropdown_action_on\";s:5:\"click\";s:31:\"header_cart_dropdown_total_text\";s:9:\"SUB TOTAL\";s:21:\"show_header_myaccount\";s:0:\"\";s:20:\"show_header_wishlist\";s:0:\"\";s:25:\"site_header_border_bottom\";b:1;s:21:\"site_header_animation\";s:0:\"\";s:27:\"site_header_animation_delay\";s:0:\"\";s:31:\"site_transparent_header_bgcolor\";s:22:\"rgba(255, 255, 255, 0)\";s:24:\"site_header_color_scheme\";s:4:\"dark\";s:31:\"site_header_sticky_color_scheme\";s:4:\"dark\";s:26:\"site_header_logo_can_scale\";s:1:\"1\";s:35:\"site_vertical_menu_background_color\";s:4:\"#FFF\";s:33:\"site_header_navigation_use_legacy\";b:0;s:31:\"site_header_navigation_sub_skin\";s:7:\"classic\";s:32:\"site_vertical_header_items_align\";s:4:\"left\";s:40:\"site_vertical_header_navigation_sub_skin\";s:7:\"classic\";s:33:\"site_header_navigation_sub_effect\";s:0:\"\";s:37:\"site_header_navigation_with_indicator\";b:0;s:36:\"site_header_navigation_with_splitter\";b:0;s:33:\"site_vertical_menu_footer_display\";s:1:\"1\";s:34:\"site_vertical_header_search_border\";s:1:\"1\";s:28:\"site_vertical_menu_copyright\";s:1:\"1\";s:35:\"site_header_navigation_sub_location\";s:12:\"below-header\";s:34:\"site_header_navigation_item_height\";s:2:\"60\";s:37:\"site_mobile_header_section_use_legacy\";b:0;s:38:\"site_mobile_header_toggle_button_color\";s:7:\"#3d3d3d\";s:38:\"site_mobile_header_toggle_button_style\";s:14:\"aux-lite-small\";s:32:\"site_header_mobile_menu_position\";s:10:\"toggle-bar\";s:38:\"site_menu_full_screen_background_color\";s:25:\"rgba(255, 255, 255, 0.95)\";s:26:\"site_menu_full_screen_skin\";s:0:\"\";s:31:\"site_header_fullscreen_template\";s:6:\"center\";s:38:\"site_menu_full_screen_background_image\";s:0:\"\";s:32:\"site_header_fullscreen_indicator\";s:1:\"1\";s:43:\"site_header_mobile_menu_offcanvas_alignment\";s:4:\"left\";s:28:\"site_header_mobile_menu_type\";s:6:\"toggle\";s:33:\"site_topheader_section_use_legacy\";b:0;s:14:\"show_topheader\";s:0:\"\";s:22:\"site_top_header_layout\";s:10:\"topheader1\";s:19:\"show_topheader_cart\";s:0:\"\";s:17:\"product_cart_icon\";s:25:\"auxicon-shopping-cart-1-1\";s:26:\"product_cart_dropdown_skin\";s:5:\"light\";s:31:\"product_cart_dropdown_action_on\";s:5:\"hover\";s:30:\"top_header_navigation_sub_skin\";s:7:\"classic\";s:32:\"site_top_header_background_color\";s:7:\"#FFFFFF\";s:35:\"site_top_header_background_gradient\";s:0:\"\";s:17:\"topheader_message\";s:0:\"\";s:27:\"topheader_secondary_message\";s:0:\"\";s:35:\"site_full_screen_section_use_legacy\";b:0;s:41:\"site_header_typography_section_use_legacy\";b:0;s:27:\"header_main_menu_typography\";s:387:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"rgb(61, 61, 61)\",\"font-size\":{\"desktop\":{\"value\":14,\"unit\":\"px\"}},\"font-weight\":\"500\",\"line-height\":{\"desktop\":{\"value\":18,\"unit\":\"px\"}},\"text-transform\":\"uppercase\"}}}\";s:25:\"header_submenu_typography\";s:34:\"{\"typography-hover\":{\"normal\":{}}}\";s:34:\"header_menu_active_item_typography\";s:34:\"{\"typography-hover\":{\"normal\":{}}}\";s:21:\"site_title_typography\";s:442:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Poppins:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"rgb(61, 61, 61)\",\"font-size\":{\"desktop\":{\"value\":18.6,\"unit\":\"px\"}},\"font-weight\":\"600\",\"line-height\":{\"desktop\":{\"value\":27,\"unit\":\"px\"}},\"text-transform\":\"uppercase\",\"font-size-resp\":{\"desktop\":{\"value\":18.6,\"unit\":\"px\"}}}}}\";s:27:\"site_description_typography\";s:0:\"\";s:48:\"site_header_topbar_typography_section_use_legacy\";b:0;s:30:\"topheader_main_menu_typography\";s:0:\"\";s:28:\"topheader_message_typography\";s:0:\"\";s:38:\"topheader_secondary_message_typography\";s:0:\"\";s:22:\"socials_hide_on_tablet\";s:1:\"1\";s:21:\"socials_hide_on_phone\";s:1:\"1\";s:19:\"socials_brand_color\";s:0:\"\";s:25:\"socials_brand_color_hover\";s:0:\"\";s:26:\"socials_brand_color_custom\";s:0:\"\";s:8:\"facebook\";s:19:\"http://facebook.com\";s:7:\"twitter\";s:18:\"http://Twitter.com\";s:8:\"dribbble\";s:0:\"\";s:7:\"youtube\";s:0:\"\";s:5:\"vimeo\";s:0:\"\";s:6:\"flickr\";s:0:\"\";s:4:\"digg\";s:0:\"\";s:11:\"stumbleupon\";s:0:\"\";s:6:\"lastfm\";s:0:\"\";s:9:\"delicious\";s:0:\"\";s:5:\"skype\";s:0:\"\";s:8:\"linkedin\";s:19:\"http://LinkedIn.com\";s:6:\"tumblr\";s:0:\"\";s:9:\"pinterest\";s:0:\"\";s:9:\"instagram\";s:0:\"\";s:2:\"vk\";s:0:\"\";s:8:\"telegram\";s:0:\"\";s:3:\"rss\";s:0:\"\";s:28:\"post_single_sidebar_position\";s:10:\"no-sidebar\";s:30:\"post_single_sidebar_decoration\";s:6:\"border\";s:26:\"post_single_featured_color\";s:7:\"#1bb0ce\";s:21:\"post_max_width_layout\";s:2:\"hd\";s:25:\"post_single_content_style\";s:6:\"simple\";s:28:\"post_show_content_top_margin\";s:1:\"1\";s:22:\"show_post_single_media\";s:1:\"1\";s:22:\"post_single_image_size\";s:0:\"\";s:35:\"post_single_image_keep_aspect_ratio\";s:0:\"\";s:26:\"show_post_single_meta_info\";b:1;s:19:\"post_meta_date_show\";s:1:\"1\";s:21:\"post_meta_author_show\";s:1:\"1\";s:23:\"post_meta_comments_show\";b:0;s:25:\"post_meta_categories_show\";b:0;s:29:\"show_post_single_tags_section\";s:1:\"1\";s:27:\"show_blog_post_share_button\";s:1:\"1\";s:27:\"blog_post_share_button_type\";s:4:\"icon\";s:27:\"blog_post_share_button_icon\";s:13:\"auxicon-share\";s:33:\"blog_post_share_button_icon_color\";s:0:\"\";s:39:\"blog_post_share_button_icon_hover_color\";s:0:\"\";s:32:\"blog_post_share_button_icon_size\";s:0:\"\";s:29:\"blog_post_share_button_margin\";s:0:\"\";s:24:\"show_blog_author_section\";s:0:\"\";s:29:\"show_blog_author_section_text\";s:1:\"1\";s:31:\"show_blog_author_section_social\";s:1:\"1\";s:30:\"show_post_single_next_prev_nav\";b:0;s:30:\"post_single_next_prev_nav_skin\";s:7:\"minimal\";s:30:\"comment_cookie_consent_enabled\";s:1:\"1\";s:19:\"comment_avatar_size\";s:2:\"60\";s:19:\"post_title_bar_show\";s:0:\"\";s:21:\"post_title_bar_preset\";s:14:\"normal_title_1\";s:31:\"post_title_bar_enable_customize\";s:0:\"\";s:33:\"post_title_bar_content_width_type\";s:5:\"boxed\";s:37:\"post_title_bar_content_section_height\";s:4:\"auto\";s:29:\"post_title_bar_vertical_align\";s:0:\"\";s:27:\"post_title_bar_scroll_arrow\";s:0:\"\";s:25:\"post_title_bar_title_show\";s:1:\"1\";s:31:\"post_title_bar_heading_bordered\";s:0:\"\";s:28:\"post_title_bar_heading_boxed\";s:0:\"\";s:31:\"post_title_bar_heading_bg_color\";s:0:\"\";s:27:\"post_title_bar_meta_enabled\";s:0:\"\";s:28:\"post_title_bar_bread_enabled\";s:1:\"1\";s:29:\"post_title_bar_bread_bordered\";s:0:\"\";s:30:\"post_title_bar_bread_sep_style\";s:0:\"\";s:25:\"post_title_bar_text_align\";s:4:\"left\";s:28:\"post_title_bar_overlay_color\";s:0:\"\";s:30:\"post_title_bar_overlay_pattern\";s:4:\"none\";s:38:\"post_title_bar_overlay_pattern_opacity\";s:4:\"0.15\";s:26:\"post_title_bar_color_style\";s:4:\"dark\";s:22:\"post_title_bar_bg_show\";s:0:\"\";s:26:\"post_title_bar_bg_parallax\";s:0:\"\";s:23:\"post_title_bar_bg_color\";s:0:\"\";s:22:\"post_title_bar_bg_size\";s:4:\"auto\";s:23:\"post_title_bar_bg_image\";s:0:\"\";s:27:\"post_title_bar_bg_video_mp4\";s:0:\"\";s:27:\"post_title_bar_bg_video_ogg\";s:0:\"\";s:28:\"post_title_bar_bg_video_webm\";s:0:\"\";s:35:\"post_single_title_show_over_content\";s:1:\"1\";s:27:\"post_single_title_alignment\";s:7:\"default\";s:24:\"post_index_template_type\";s:1:\"1\";s:32:\"blog_archive_show_featured_image\";s:1:\"1\";s:29:\"post_archive_max_width_layout\";s:2:\"hd\";s:23:\"post_image_aspect_ratio\";s:4:\"0.56\";s:32:\"blog_archive_mask_featured_image\";s:1:\"1\";s:32:\"post_index_column_content_layout\";s:4:\"full\";s:17:\"display_post_info\";s:1:\"1\";s:18:\"post_info_position\";s:11:\"after-title\";s:22:\"display_post_info_date\";s:1:\"1\";s:24:\"display_post_info_author\";s:1:\"1\";s:28:\"display_post_info_categories\";b:0;s:26:\"display_post_info_comments\";b:0;s:28:\"display_post_comments_number\";s:1:\"1\";s:28:\"blog_display_author_readmore\";s:8:\"readmore\";s:26:\"blog_display_author_header\";s:1:\"1\";s:26:\"blog_display_author_footer\";s:0:\"\";s:24:\"post_index_column_number\";s:1:\"4\";s:31:\"post_index_column_number_tablet\";s:7:\"inherit\";s:31:\"post_index_column_number_mobile\";s:1:\"1\";s:21:\"exclude_without_media\";s:1:\"1\";s:31:\"post_exclude_quote_link_formats\";s:1:\"1\";s:24:\"post_index_loadmore_type\";s:0:\"\";s:25:\"post_index_read_more_text\";s:9:\"Read More\";s:29:\"post_index_timeline_alignment\";s:6:\"center\";s:27:\"post_index_sidebar_position\";s:10:\"no-sidebar\";s:29:\"post_index_sidebar_decoration\";s:6:\"border\";s:23:\"blog_content_on_listing\";s:7:\"excerpt\";s:30:\"blog_content_on_listing_length\";s:3:\"365\";s:24:\"post_archive_slider_show\";b:0;s:24:\"post_archive_slider_type\";s:7:\"default\";s:22:\"post_archive_slider_id\";s:4:\"none\";s:28:\"post_archive_slider_location\";s:5:\"block\";s:30:\"post_archive_slider_slides_num\";s:2:\"10\";s:27:\"post_archive_slider_exclude\";s:0:\"\";s:27:\"post_archive_slider_include\";s:0:\"\";s:26:\"post_archive_slider_offset\";s:0:\"\";s:28:\"post_archive_slider_order_by\";s:4:\"date\";s:29:\"post_archive_slider_order_dir\";s:4:\"DESC\";s:24:\"post_archive_slider_skin\";s:14:\"aux-light-skin\";s:29:\"post_archive_slider_add_title\";s:1:\"1\";s:28:\"post_archive_slider_add_meta\";s:1:\"1\";s:30:\"post_archive_slider_image_from\";s:4:\"auto\";s:32:\"post_archive_slider_custom_image\";s:0:\"\";s:42:\"post_archive_slider_exclude_without_images\";s:1:\"1\";s:25:\"post_archive_slider_width\";s:3:\"960\";s:26:\"post_archive_slider_height\";s:3:\"560\";s:26:\"post_archive_slider_arrows\";s:0:\"\";s:25:\"post_archive_slider_space\";s:1:\"5\";s:24:\"post_archive_slider_loop\";s:1:\"1\";s:29:\"post_archive_slider_slideshow\";s:0:\"\";s:35:\"post_archive_slider_slideshow_delay\";s:1:\"2\";s:35:\"post_taxonomy_archive_template_type\";s:7:\"default\";s:38:\"post_taxonomy_archive_sidebar_position\";s:13:\"right-sidebar\";s:40:\"post_taxonomy_archive_sidebar_decoration\";s:6:\"border\";s:40:\"post_taxonomy_archive_content_on_listing\";s:4:\"full\";s:39:\"post_taxonomy_archive_on_listing_length\";s:3:\"255\";s:26:\"display_post_taxonomy_info\";s:1:\"1\";s:31:\"display_post_taxonomy_info_date\";s:1:\"1\";s:33:\"display_post_taxonomy_info_author\";s:1:\"1\";s:37:\"display_post_taxonomy_info_categories\";s:1:\"1\";s:35:\"display_post_taxonomy_info_comments\";s:1:\"1\";s:37:\"display_post_taxonomy_widget_comments\";s:1:\"1\";s:37:\"display_post_taxonomy_author_readmore\";s:8:\"readmore\";s:35:\"display_post_taxonomy_author_header\";s:1:\"1\";s:35:\"display_post_taxonomy_author_footer\";s:0:\"\";s:27:\"post_taxonomy_loadmore_type\";s:0:\"\";s:28:\"single_post_title_typography\";s:417:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Playfair Display:regular,italic,700,700italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"var(--e-global-color-text)\",\"font-size-resp\":{\"desktop\":{\"value\":38,\"unit\":\"px\"}},\"font-weight\":\"400\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":52,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:30:\"single_post_content_typography\";s:495:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"var(--e-global-color-text)\",\"font-size-resp\":{\"desktop\":{\"value\":16,\"unit\":\"px\"}},\"font-weight\":\"500\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":23,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:27:\"single_post_info_typography\";s:509:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"var(--e-global-color-secondary)\",\"font-size-resp\":{\"desktop\":{\"value\":14,\"unit\":\"px\"}},\"font-weight\":\"500\",\"text-transform\":\"uppercase\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":18,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:33:\"single_post_info_terms_typography\";s:360:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"none\",\"type\":\" \"},\"color\":\"var(--e-global-color-secondary)\",\"font-size-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}},\"font-weight\":\"\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:27:\"single_post_meta_typography\";s:506:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"var(--e-global-color-secondary)\",\"font-size-resp\":{\"desktop\":{\"value\":14,\"unit\":\"px\"}},\"font-weight\":\"500\",\"text-transform\":\"\",\"font-style\":\"normal\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":18,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:33:\"single_post_meta_terms_typography\";s:359:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"none\",\"type\":\" \"},\"color\":\"var(--e-global-color-text)\",\"font-size-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}},\"font-weight\":\"\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"none\",\"line-height-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:31:\"single_post_subtitle_typography\";s:0:\"\";s:33:\"single_post_breadcrumb_typography\";s:0:\"\";s:26:\"blog_page_title_typography\";s:417:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Playfair Display:regular,italic,700,700italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"var(--e-global-color-text)\",\"font-size-resp\":{\"desktop\":{\"value\":38,\"unit\":\"px\"}},\"font-weight\":\"400\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":52,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:25:\"blog_page_info_typography\";s:509:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"var(--e-global-color-secondary)\",\"font-size-resp\":{\"desktop\":{\"value\":14,\"unit\":\"px\"}},\"font-weight\":\"500\",\"text-transform\":\"uppercase\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":18,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:31:\"blog_page_info_terms_typography\";s:0:\"\";s:28:\"blog_page_content_typography\";s:495:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"var(--e-global-color-text)\",\"font-size-resp\":{\"desktop\":{\"value\":16,\"unit\":\"px\"}},\"font-weight\":\"500\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":23,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:27:\"blog_page_button_typography\";s:0:\"\";s:28:\"page_single_sidebar_position\";s:10:\"no-sidebar\";s:30:\"page_single_sidebar_decoration\";s:6:\"border\";s:28:\"page_show_content_top_margin\";s:1:\"1\";s:21:\"page_max_width_layout\";s:0:\"\";s:19:\"page_content_layout\";s:5:\"boxed\";s:19:\"page_title_bar_show\";s:1:\"1\";s:21:\"page_title_bar_preset\";s:14:\"normal_title_1\";s:31:\"page_title_bar_enable_customize\";s:0:\"\";s:33:\"page_title_bar_content_width_type\";s:5:\"boxed\";s:37:\"page_title_bar_content_section_height\";s:4:\"auto\";s:29:\"page_title_bar_vertical_align\";s:0:\"\";s:27:\"page_title_bar_scroll_arrow\";s:0:\"\";s:25:\"page_title_bar_title_show\";s:1:\"1\";s:31:\"page_title_bar_heading_bordered\";s:0:\"\";s:28:\"page_title_bar_heading_boxed\";s:0:\"\";s:31:\"page_title_bar_heading_bg_color\";s:0:\"\";s:27:\"page_title_bar_meta_enabled\";s:0:\"\";s:28:\"page_title_bar_bread_enabled\";s:1:\"1\";s:29:\"page_title_bar_bread_bordered\";s:0:\"\";s:30:\"page_title_bar_bread_sep_style\";s:0:\"\";s:25:\"page_title_bar_text_align\";s:4:\"left\";s:28:\"page_title_bar_overlay_color\";s:0:\"\";s:30:\"page_title_bar_overlay_pattern\";s:4:\"none\";s:38:\"page_title_bar_overlay_pattern_opacity\";s:3:\"0.5\";s:26:\"page_title_bar_color_style\";s:4:\"dark\";s:22:\"page_title_bar_bg_show\";s:0:\"\";s:26:\"page_title_bar_bg_parallax\";s:0:\"\";s:23:\"page_title_bar_bg_color\";s:0:\"\";s:22:\"page_title_bar_bg_size\";s:0:\"\";s:23:\"page_title_bar_bg_image\";s:0:\"\";s:27:\"page_title_bar_bg_video_mp4\";s:0:\"\";s:27:\"page_title_bar_bg_video_ogg\";s:0:\"\";s:28:\"page_title_bar_bg_video_webm\";s:0:\"\";s:22:\"page_title__typography\";s:0:\"\";s:25:\"page_subtitle__typography\";s:0:\"\";s:32:\"page_title_breadcrumb_typography\";s:0:\"\";s:37:\"page_title_breadcrumb_link_typography\";s:0:\"\";s:31:\"page_title_breadcrumb_sep_color\";s:0:\"\";s:31:\"product_single_sidebar_position\";s:10:\"no-sidebar\";s:33:\"product_single_sidebar_decoration\";s:6:\"border\";s:24:\"product_max_width_layout\";s:2:\"hd\";s:30:\"product_index_sidebar_position\";s:12:\"left-sidebar\";s:32:\"product_index_sidebar_decoration\";s:6:\"simple\";s:32:\"product_archive_max_width_layout\";s:5:\"s-fhd\";s:35:\"product_archive_show_view_cart_link\";s:0:\"\";s:33:\"product_category_sidebar_position\";s:13:\"right-sidebar\";s:35:\"product_category_sidebar_decoration\";s:6:\"border\";s:35:\"site_elementor_footer_edit_template\";s:3:\"158\";s:30:\"site_elementor_footer_template\";s:3:\"158\";s:39:\"site_elementor_footer_templates_library\";s:0:\"\";s:22:\"site_footer_use_legacy\";b:0;s:21:\"site_footer_is_sticky\";s:0:\"\";s:9:\"copyright\";s:30:\"Copyright © 2006-2019 PHLOX\n\n\";s:11:\"attribution\";s:0:\"\";s:34:\"footer_privacy_policy_link_display\";s:0:\"\";s:17:\"site_footer_info3\";s:0:\"\";s:37:\"site_subfooter_bar_section_use_legacy\";b:0;s:18:\"show_subfooter_bar\";s:0:\"\";s:20:\"subfooter_bar_layout\";s:20:\"vertical-small-boxed\";s:29:\"subfooter_bar_layout_bg_color\";s:7:\"#fafafa\";s:30:\"subfooter_bar_top_border_color\";s:7:\"#EAEAEA\";s:33:\"site_subfooter_section_use_legacy\";b:0;s:14:\"show_subfooter\";b:1;s:16:\"subfooter_layout\";s:15:\"1-4_1-4_1-4_1-4\";s:25:\"subfooter_layout_bg_color\";s:7:\"#3d3d3d\";s:28:\"subfooter_layout_bg_gradient\";s:0:\"\";s:25:\"subfooter_layout_bg_image\";s:0:\"\";s:34:\"subfooter_layout_bg_image_position\";s:13:\"center center\";s:30:\"subfooter_layout_bg_image_size\";s:5:\"cover\";s:32:\"subfooter_layout_bg_image_repeat\";s:9:\"no-repeat\";s:23:\"footer_widget_dark_mode\";b:1;s:26:\"subfooter_top_border_color\";s:22:\"rgba(234, 234, 234, 0)\";s:24:\"subfooter_hide_on_tablet\";s:0:\"\";s:23:\"subfooter_hide_on_phone\";s:0:\"\";s:44:\"site_subfooter_appearance_section_use_legacy\";b:0;s:28:\"subfooter_appearance_padding\";s:0:\"\";s:33:\"subfooter_widget_title_typography\";s:418:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Playfair Display:regular,italic,700,700italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"rgb(255, 255, 255)\",\"font-size-resp\":{\"desktop\":{\"value\":16,\"unit\":\"px\"}},\"font-weight\":\"500\",\"text-transform\":\"uppercase\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":21,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:32:\"subfooter_widget_text_typography\";s:487:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"rgb(255, 255, 255)\",\"font-size-resp\":{\"desktop\":{\"value\":16,\"unit\":\"px\"}},\"font-weight\":\"300\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":23,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:32:\"subfooter_widget_link_typography\";s:487:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"rgb(255, 255, 255)\",\"font-size-resp\":{\"desktop\":{\"value\":16,\"unit\":\"px\"}},\"font-weight\":\"300\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":28,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:30:\"site_footer_section_use_legacy\";b:0;s:16:\"show_site_footer\";s:1:\"1\";s:29:\"site_footer_components_layout\";s:14:\"footer_preset4\";s:20:\"site_footer_bg_color\";s:7:\"#222222\";s:23:\"site_footer_bg_gradient\";s:0:\"\";s:23:\"footer_top_border_color\";s:22:\"rgba(234, 234, 234, 0)\";s:23:\"footer_top_border_width\";s:1:\"0\";s:41:\"site_footer_appearence_section_use_legacy\";b:0;s:27:\"footer_copyright_typography\";s:487:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"rgb(196, 196, 196)\",\"font-size-resp\":{\"desktop\":{\"value\":16,\"unit\":\"px\"}},\"font-weight\":\"300\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":24,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:34:\"footer_attribution_link_typography\";s:0:\"\";s:37:\"footer_privacy_policy_link_typography\";s:0:\"\";s:27:\"footer_main_menu_typography\";s:0:\"\";s:17:\"show_goto_top_btn\";s:1:\"1\";s:18:\"goto_top_alignment\";s:5:\"right\";s:33:\"enable_site_image_preload_preview\";s:0:\"\";s:38:\"site_image_prelaod_transition_duration\";s:0:\"\";s:27:\"breadcrumbs_text_max_length\";s:2:\"30\";s:25:\"auxin_user_custom_js_head\";s:0:\"\";s:20:\"auxin_user_custom_js\";s:195:\"var qty = document.querySelectorAll(\'.woocommerce-page .quantity\');\nqty.forEach( function( element) {\n    element.classList.add(\'aux-shop-quantity\');\n    element.classList.remove(\'quantity\');\n})\n\";s:16:\"enable_theme_seo\";s:1:\"1\";s:27:\"auxin_user_google_analytics\";s:0:\"\";s:24:\"auxin_google_map_api_key\";s:0:\"\";s:27:\"auxin_user_google_marketing\";s:0:\"\";s:39:\"auxin_user_google_marketing_second_part\";s:0:\"\";s:12:\"custom_logo2\";s:0:\"\";s:35:\"site_header_btn1_section_use_legacy\";b:0;s:21:\"site_header_show_btn1\";s:0:\"\";s:31:\"site_header_show_btn1_on_tablet\";s:1:\"1\";s:30:\"site_header_show_btn1_on_phone\";s:1:\"1\";s:22:\"site_header_btn1_label\";s:6:\"Button\";s:21:\"site_header_btn1_size\";s:5:\"large\";s:22:\"site_header_btn1_shape\";s:5:\"curve\";s:22:\"site_header_btn1_style\";s:0:\"\";s:27:\"site_header_btn1_typography\";s:0:\"\";s:21:\"site_header_btn1_icon\";s:0:\"\";s:27:\"site_header_btn1_icon_align\";s:7:\"default\";s:27:\"site_header_btn1_color_name\";s:9:\"ball-blue\";s:37:\"site_header_btn1_color_name_on_sticky\";s:9:\"ball-blue\";s:21:\"site_header_btn1_link\";s:1:\"#\";s:23:\"site_header_btn1_target\";s:5:\"_self\";s:35:\"site_header_btn2_section_use_legacy\";b:0;s:21:\"site_header_show_btn2\";s:0:\"\";s:31:\"site_header_show_btn2_on_tablet\";s:1:\"1\";s:30:\"site_header_show_btn2_on_phone\";s:1:\"1\";s:22:\"site_header_btn2_label\";s:6:\"Button\";s:21:\"site_header_btn2_size\";s:5:\"large\";s:22:\"site_header_btn2_shape\";s:5:\"curve\";s:22:\"site_header_btn2_style\";s:7:\"outline\";s:27:\"site_header_btn2_typography\";s:0:\"\";s:21:\"site_header_btn2_icon\";s:0:\"\";s:27:\"site_header_btn2_icon_align\";s:7:\"default\";s:27:\"site_header_btn2_color_name\";s:7:\"emerald\";s:37:\"site_header_btn2_color_name_on_sticky\";s:9:\"ball-blue\";s:21:\"site_header_btn2_link\";s:0:\"\";s:23:\"site_header_btn2_target\";s:5:\"_self\";s:25:\"site_secondary_logo_image\";s:0:\"\";s:30:\"site_secondary_logo_max_height\";s:2:\"50\";s:16:\"auxin_login_skin\";s:7:\"default\";s:19:\"auxin_login_message\";s:0:\"\";s:22:\"auxin_login_logo_image\";s:0:\"\";s:22:\"auxin_login_logo_width\";s:2:\"84\";s:23:\"auxin_login_logo_height\";s:2:\"84\";s:19:\"auxin_login_bg_show\";s:0:\"\";s:20:\"auxin_login_bg_color\";s:0:\"\";s:20:\"auxin_login_bg_image\";s:0:\"\";s:19:\"auxin_login_bg_size\";s:4:\"auto\";s:22:\"auxin_login_bg_pattern\";s:0:\"\";s:21:\"auxin_login_bg_repeat\";s:9:\"no-repeat\";s:23:\"auxin_login_bg_position\";s:8:\"left top\";s:21:\"auxin_login_bg_attach\";s:6:\"scroll\";s:22:\"auxin_login_body_class\";s:0:\"\";s:17:\"auxin_login_style\";s:0:\"\";s:14:\"auxin_404_page\";s:7:\"default\";s:24:\"auxin_maintenance_enable\";s:0:\"\";s:22:\"auxin_maintenance_page\";s:7:\"default\";s:31:\"auxin_search_exclude_post_types\";a:5:{i:0;s:4:\"page\";i:1;s:10:\"attachment\";i:2;s:14:\"e-landing-page\";i:3;s:18:\"e-floating-buttons\";i:4;s:3:\"faq\";}s:29:\"auxin_search_exclude_no_media\";s:0:\"\";s:28:\"auxin_search_pinned_contents\";s:0:\"\";s:23:\"auxin_customizer_export\";s:0:\"\";s:23:\"auxin_customizer_import\";s:0:\"\";s:29:\"product_index_pagination_skin\";s:10:\"aux-square\";s:25:\"product_index_thumb_ratio\";s:4:\"1.33\";s:32:\"product_index_thumb_ratio_custom\";s:1:\"1\";s:32:\"product_index_custom_widget_area\";s:0:\"\";s:39:\"product_index_sort_dropdown_modern_skin\";s:0:\"\";s:32:\"product_index_top_content_margin\";s:1:\"1\";s:31:\"product_index_custom_sale_badge\";s:0:\"\";s:36:\"product_index_custom_sale_badge_text\";s:5:\"Sale!\";s:30:\"product_index_add_to_cart_text\";s:11:\"Add to Cart\";s:27:\"product_index_custom_result\";s:0:\"\";s:33:\"product_index_custom_result_input\";s:0:\"\";s:35:\"product_index_display_image_flipper\";s:1:\"1\";s:33:\"product_index_display_star_rating\";b:0;s:29:\"product_index_display_excerpt\";s:0:\"\";s:33:\"product_index_display_meta_fields\";s:0:\"\";s:35:\"product_index_display_excerpt_count\";s:3:\"120\";s:27:\"product_index_display_share\";b:0;s:33:\"product_index_display_add_to_cart\";s:1:\"1\";s:31:\"product_index_display_quicklook\";s:0:\"\";s:30:\"product_index_ajax_add_to_cart\";b:1;s:30:\"product_index_display_category\";b:1;s:32:\"product_archive_titlebar_enabled\";b:0;s:43:\"product_archive_titlebar_breadcrumb_enabled\";s:1:\"1\";s:38:\"product_archive_titlebar_title_enabled\";b:0;s:38:\"product_archive_titlebar_title_context\";s:0:\"\";s:34:\"product_archive_disable_page_title\";b:1;s:41:\"product_archive_display_breadcrumb_header\";b:1;s:23:\"product_single_template\";s:6:\"slider\";s:35:\"product_single_template_slider_type\";b:0;s:25:\"product_single_breadcrumb\";s:0:\"\";s:36:\"product_single_template_slider_arrow\";s:0:\"\";s:41:\"product_single_template_slider_hide_arrow\";i:1;s:28:\"product_single_figure_spaces\";s:0:\"\";s:31:\"product_single_slider_thumb_dir\";s:1:\"h\";s:34:\"product_single_slider_thumb_margin\";s:1:\"5\";s:33:\"product_single_slider_thumb_width\";s:2:\"80\";s:34:\"product_single_slider_thumb_height\";s:2:\"80\";s:33:\"product_single_slider_thumb_space\";s:1:\"5\";s:26:\"product_grid_template_type\";s:6:\"grid-1\";s:26:\"product_image_aspect_ratio\";s:4:\"0.56\";s:18:\"product_grid_space\";s:2:\"30\";s:26:\"product_grid_column_number\";s:1:\"4\";s:33:\"product_grid_column_number_tablet\";s:7:\"inherit\";s:33:\"product_grid_column_number_mobile\";s:1:\"1\";s:29:\"product_single_sticky_sidebar\";s:0:\"\";s:33:\"show_product_single_next_prev_nav\";b:0;s:33:\"product_single_next_prev_nav_skin\";s:7:\"minimal\";s:34:\"product_single_display_star_rating\";s:1:\"1\";s:28:\"product_single_display_share\";s:1:\"1\";s:32:\"product_single_share_button_type\";s:4:\"icon\";s:32:\"product_single_share_button_icon\";s:13:\"auxicon-share\";s:38:\"product_single_share_button_icon_color\";s:0:\"\";s:44:\"product_single_share_button_icon_hover_color\";s:0:\"\";s:37:\"product_single_share_button_icon_size\";s:0:\"\";s:34:\"product_single_share_button_margin\";s:0:\"\";s:26:\"product_single_display_sku\";b:0;s:31:\"product_single_display_category\";s:1:\"1\";s:26:\"product_single_display_tag\";s:1:\"1\";s:27:\"product_single_display_meta\";s:0:\"\";s:31:\"product_single_lightbox_enabled\";s:1:\"1\";s:29:\"product_single_featured_color\";s:7:\"#1bb0ce\";s:33:\"product_single_review_avatar_size\";s:2:\"70\";s:43:\"product_single_product_feature_img_bg_color\";s:0:\"\";s:37:\"product_single_product_thumb_bg_color\";s:0:\"\";s:22:\"product_title_bar_show\";b:1;s:24:\"product_title_bar_preset\";s:14:\"normal_title_1\";s:34:\"product_title_bar_enable_customize\";b:1;s:36:\"product_title_bar_content_width_type\";s:5:\"boxed\";s:40:\"product_title_bar_content_section_height\";s:4:\"auto\";s:32:\"product_title_bar_vertical_align\";s:0:\"\";s:30:\"product_title_bar_scroll_arrow\";s:0:\"\";s:28:\"product_title_bar_title_show\";b:0;s:34:\"product_title_bar_heading_bordered\";s:0:\"\";s:31:\"product_title_bar_heading_boxed\";s:0:\"\";s:34:\"product_title_bar_heading_bg_color\";s:0:\"\";s:30:\"product_title_bar_meta_enabled\";s:0:\"\";s:31:\"product_title_bar_bread_enabled\";s:1:\"1\";s:32:\"product_title_bar_bread_bordered\";s:0:\"\";s:33:\"product_title_bar_bread_sep_style\";s:0:\"\";s:28:\"product_title_bar_text_align\";s:4:\"left\";s:31:\"product_title_bar_overlay_color\";s:0:\"\";s:33:\"product_title_bar_overlay_pattern\";s:4:\"none\";s:41:\"product_title_bar_overlay_pattern_opacity\";s:3:\"0.5\";s:29:\"product_title_bar_color_style\";s:4:\"dark\";s:25:\"product_title_bar_bg_show\";s:0:\"\";s:29:\"product_title_bar_bg_parallax\";s:0:\"\";s:26:\"product_title_bar_bg_color\";s:0:\"\";s:25:\"product_title_bar_bg_size\";s:0:\"\";s:26:\"product_title_bar_bg_image\";s:0:\"\";s:30:\"product_title_bar_bg_video_mp4\";s:0:\"\";s:30:\"product_title_bar_bg_video_ogg\";s:0:\"\";s:31:\"product_title_bar_bg_video_webm\";s:0:\"\";s:26:\"show_product_related_posts\";s:1:\"1\";s:27:\"product_related_posts_label\";s:16:\"Related Products\";s:32:\"product_related_posts_label_typo\";s:414:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Playfair Display:regular,italic,700,700italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"var(--e-global-color-text)\",\"font-size-resp\":{\"desktop\":{\"value\":28,\"unit\":\"px\"}},\"font-weight\":\"\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":37,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:34:\"product_related_posts_preview_mode\";s:4:\"grid\";s:35:\"product_related_posts_column_number\";s:1:\"3\";s:34:\"product_related_image_aspect_ratio\";s:0:\"\";s:36:\"product_related_posts_carousel_pages\";s:1:\"4\";s:39:\"product_related_posts_carousel_autoplay\";s:0:\"\";s:37:\"product_related_index_display_excerpt\";s:0:\"\";s:43:\"product_related_index_display_excerpt_count\";s:2:\"15\";s:34:\"product_related_posts_align_center\";s:0:\"\";s:32:\"product_related_posts_full_width\";s:0:\"\";s:32:\"product_related_posts_snap_items\";s:0:\"\";s:40:\"product_related_posts_display_categories\";b:1;s:35:\"product_related_posts_display_stars\";s:0:\"\";s:32:\"product_related_posts_title_typo\";s:0:\"\";s:32:\"product_related_posts_price_typo\";s:0:\"\";s:36:\"product_related_posts_reg_price_typo\";s:0:\"\";s:34:\"product_related_posts_excerpt_typo\";s:0:\"\";s:30:\"product_related_posts_btn_typo\";s:0:\"\";s:28:\"product_related_posts_btn_bg\";s:0:\"\";s:30:\"product_index_display_wishlist\";b:0;s:31:\"product_single_display_wishlist\";s:1:\"1\";s:35:\"product_wishlist_use_ti_plugin_info\";s:0:\"\";s:31:\"product_single_like_button_type\";s:4:\"icon\";s:35:\"product_single_wishlist_button_icon\";s:15:\"auxicon-heart-2\";s:41:\"product_single_wishlist_button_icon_color\";s:0:\"\";s:47:\"product_single_wishlist_button_icon_hover_color\";s:0:\"\";s:40:\"product_single_wishlist_button_icon_size\";s:0:\"\";s:37:\"product_single_wishlist_button_margin\";s:0:\"\";s:47:\"product_setting_section_single_appearance_title\";s:417:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Playfair Display:regular,italic,700,700italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"var(--e-global-color-text)\",\"font-size-resp\":{\"desktop\":{\"value\":22,\"unit\":\"px\"}},\"font-weight\":\"400\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":30,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:47:\"product_setting_section_single_appearance_price\";s:484:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"rgb(61, 61, 61)\",\"font-size-resp\":{\"desktop\":{\"value\":52,\"unit\":\"px\"}},\"font-weight\":\"500\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":63,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:51:\"product_setting_section_single_appearance_reg_price\";s:500:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"var(--e-global-color-secondary)\",\"font-size-resp\":{\"desktop\":{\"value\":22,\"unit\":\"px\"}},\"font-weight\":\"500\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":28,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:51:\"product_setting_section_single_appearance_star_text\";s:0:\"\";s:52:\"product_setting_section_single_appearance_meta_field\";s:0:\"\";s:53:\"product_setting_section_single_appearance_description\";s:495:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"var(--e-global-color-text)\",\"font-size-resp\":{\"desktop\":{\"value\":16,\"unit\":\"px\"}},\"font-weight\":\"500\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":24,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:52:\"product_setting_section_single_appearance_add_to_btn\";s:484:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Poppins:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"rgb(255, 255, 255)\",\"font-size-resp\":{\"desktop\":{\"value\":14,\"unit\":\"px\"}},\"font-weight\":\"600\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":21,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:50:\"product_setting_section_single_appearance_category\";s:0:\"\";s:56:\"product_setting_section_single_appearance_category_terms\";s:0:\"\";s:52:\"product_setting_section_single_appearance_tabs_title\";s:0:\"\";s:54:\"product_setting_section_single_appearance_tabs_content\";s:0:\"\";s:54:\"product_setting_section_single_appearance_review_title\";s:417:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Playfair Display:regular,italic,700,700italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"var(--e-global-color-text)\",\"font-size-resp\":{\"desktop\":{\"value\":22,\"unit\":\"px\"}},\"font-weight\":\"400\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":30,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:55:\"product_setting_section_single_appearance_review_author\";s:495:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"var(--e-global-color-text)\",\"font-size-resp\":{\"desktop\":{\"value\":16,\"unit\":\"px\"}},\"font-weight\":\"500\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":19,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:53:\"product_setting_section_single_appearance_review_date\";s:500:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"var(--e-global-color-secondary)\",\"font-size-resp\":{\"desktop\":{\"value\":16,\"unit\":\"px\"}},\"font-weight\":\"500\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":19,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:56:\"product_setting_section_single_appearance_review_content\";s:495:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"var(--e-global-color-text)\",\"font-size-resp\":{\"desktop\":{\"value\":16,\"unit\":\"px\"}},\"font-weight\":\"500\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":24,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:61:\"product_setting_section_single_appearance_review_replay_title\";s:484:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"rgb(61, 61, 61)\",\"font-size-resp\":{\"desktop\":{\"value\":16,\"unit\":\"px\"}},\"font-weight\":\"600\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":24,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:57:\"product_setting_section_single_appearance_review_cm_notes\";s:484:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\",\"type\":\"gFont\"},\"color\":\"rgb(61, 61, 61)\",\"font-size-resp\":{\"desktop\":{\"value\":16,\"unit\":\"px\"}},\"font-weight\":\"500\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":23,\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:44:\"product_setting_section_shop_page_title_typo\";s:0:\"\";s:44:\"product_setting_section_shop_page_bread_typo\";s:0:\"\";s:45:\"product_setting_section_shop_page_result_typo\";s:0:\"\";s:50:\"product_setting_section_shop_page_sales_badge_typo\";s:0:\"\";s:52:\"product_setting_section_shop_page_product_title_typo\";s:333:\"{\"typography-hover\":{\"normal\":{\"font-family\":{\"value\":\"none\",\"type\":null},\"color\":\"\",\"font-size-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}},\"font-weight\":\"400\",\"text-transform\":\"\",\"font-style\":\"\",\"text-decoration\":\"\",\"line-height-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}},\"letter-spacing-resp\":{\"desktop\":{\"value\":\"\",\"unit\":\"px\"}}}}}\";s:52:\"product_setting_section_shop_page_product_price_typo\";s:0:\"\";s:56:\"product_setting_section_shop_page_product_reg_price_typo\";s:0:\"\";s:54:\"product_setting_section_shop_page_product_excerpt_typo\";s:0:\"\";s:53:\"product_setting_section_shop_page_product_meta_fields\";s:0:\"\";s:44:\"product_setting_section_shop_page_pagination\";s:0:\"\";s:50:\"product_setting_section_shop_page_product_btn_typo\";s:0:\"\";s:48:\"product_setting_section_shop_page_product_btn_bg\";s:0:\"\";s:16:\"goto_top_animate\";s:1:\"1\";s:24:\"enable_custom_typography\";s:0:\"\";s:18:\"content_typography\";s:20:\"_gof_Raleway:regular\";s:21:\"main_title_typography\";s:16:\"_gof_Raleway:300\";s:21:\"page_title_typography\";s:16:\"_gof_Raleway:300\";s:22:\"header_menu_typography\";s:20:\"_gof_Raleway:regular\";s:18:\"buttons_typography\";s:20:\"_gof_Raleway:regular\";s:19:\"include_latin_chars\";s:0:\"\";s:30:\"product_index_add_to_cart_link\";s:11:\"add-to-cart\";s:19:\"enable_demo_buttons\";b:1;s:32:\"specify_demo_buttons_preview_url\";s:25:\"http://phlox.pro/go/#demo\";s:28:\"specify_demo_pro_preview_url\";s:25:\"http://phlox.pro/go/#demo\";s:32:\"specify_demo_buttons_target_type\";s:3:\"pro\";s:31:\"specify_demo_buttons_target_url\";s:95:\"https://themeforest.net/item/lotus-flexible-multipurpose-responsive-wp-theme/3909293?ref=averta\";s:27:\"specify_demo_pro_target_url\";s:95:\"https://themeforest.net/item/lotus-flexible-multipurpose-responsive-wp-theme/3909293?ref=averta\";s:24:\"special_css_file_enabled\";s:0:\"\";s:21:\"special_css_file_name\";s:10:\"special104\";s:24:\"special_php_file_enabled\";s:0:\"\";s:21:\"special_php_file_name\";s:12:\"functions104\";s:10:\"googleplus\";s:0:\"\";s:26:\"show_blog_post_like_button\";b:1;s:30:\"blog_post_like_button_position\";s:6:\"bottom\";s:29:\"site_header_override_template\";s:0:\"\";s:20:\"site_header_template\";s:1:\" \";s:29:\"header_fullscreen_search_skin\";s:0:\"\";s:29:\"site_footer_override_template\";s:0:\"\";s:20:\"site_footer_template\";s:1:\" \";s:20:\"auxin_import_options\";s:0:\"\";s:20:\"auxin_export_options\";s:0:\"\";s:29:\"show_blog_archive_like_button\";s:1:\"1\";s:12:\"gopro_option\";s:0:\"\";}","auto"),
("426","_elementor_installed_time","1556108243","auto"),
("434","_transient_timeout_auxin_auxin-pro-tools_version","1773918600","off"),
("435","_transient_auxin_auxin-pro-tools_version","1.9.7","off"),
("436","bdthemes-element-pack_license_notice_hidden","1802863679","auto"),
("437","auxin_faq_capabilities_added","1","off"),
("447","depicter_version_initial","4.7.1","on"),
("448","depicter_client_key","6daf6db5607942a11afabf48f6dbcdf8","on"),
("451","depicter_db_version","0.4.7","auto"),
("454","depicter_capabilities_added","1","on"),
("455","depicter_version_previous","0","on"),
("456","depicter_version","4.7.1","on"),
("457","depicter_last_document_migration","202203091150","on"),
("469","action_scheduler_hybrid_store_demarkation","10","auto"),
("470","schema-ActionScheduler_StoreSchema","8.0.1771327658","auto"),
("471","schema-ActionScheduler_LoggerSchema","3.0.1771327658","auto"),
("474","woocommerce_newly_installed","no","auto"),
("475","woocommerce_order_stats_has_fulfillment_column","no","off"),
("476","woocommerce_schema_version","920","auto"),
("477","woocommerce_store_address","","on"),
("478","woocommerce_store_address_2","","on"),
("479","woocommerce_store_city","","on"),
("480","woocommerce_default_country","FR","on"),
("481","woocommerce_store_postcode","","on"),
("482","woocommerce_allowed_countries","specific","on"),
("483","woocommerce_all_except_countries","a:0:{}","on"),
("484","woocommerce_specific_allowed_countries","a:1:{i:0;s:2:\"FR\";}","on"),
("485","woocommerce_ship_to_countries","specific","on"),
("486","woocommerce_specific_ship_to_countries","a:1:{i:0;s:2:\"FR\";}","on"),
("487","woocommerce_default_customer_address","geolocation","on"),
("488","woocommerce_address_autocomplete_enabled","no","on"),
("489","woocommerce_calc_taxes","yes","on"),
("490","woocommerce_enable_coupons","yes","on"),
("491","woocommerce_calc_discounts_sequentially","yes","off"),
("492","woocommerce_currency","EUR","on"),
("493","woocommerce_currency_pos","right_space","on"),
("494","woocommerce_price_thousand_sep"," ","on"),
("495","woocommerce_price_decimal_sep",",","on"),
("496","woocommerce_price_num_decimals","2","on"),
("497","woocommerce_shop_page_id","157","on"),
("498","woocommerce_cart_redirect_after_add","no","on"),
("499","woocommerce_enable_ajax_add_to_cart","yes","on"),
("500","woocommerce_placeholder_image","10","on"),
("501","woocommerce_weight_unit","kg","on"),
("502","woocommerce_dimension_unit","cm","on"),
("503","woocommerce_enable_reviews","yes","on"),
("504","woocommerce_review_rating_verification_label","yes","off"),
("505","woocommerce_review_rating_verification_required","yes","off"),
("506","woocommerce_enable_review_rating","yes","on"),
("507","woocommerce_review_rating_required","yes","off"),
("508","woocommerce_manage_stock","yes","on"),
("509","woocommerce_hold_stock_minutes","60","off"),
("510","woocommerce_notify_low_stock","yes","off"),
("511","woocommerce_notify_no_stock","yes","off"),
("512","woocommerce_stock_email_recipient","info@cigarettecorner.com","off"),
("513","woocommerce_notify_low_stock_amount","10","off"),
("514","woocommerce_notify_no_stock_amount","0","on"),
("515","woocommerce_hide_out_of_stock_items","no","on"),
("516","woocommerce_stock_format","","on"),
("517","woocommerce_file_download_method","force","off"),
("518","woocommerce_downloads_redirect_fallback_allowed","no","off"),
("519","woocommerce_downloads_require_login","no","off"),
("520","woocommerce_downloads_grant_access_after_payment","yes","off"),
("521","woocommerce_downloads_deliver_inline","","off"),
("522","woocommerce_downloads_add_hash_to_filename","yes","on"),
("523","woocommerce_downloads_count_partial","yes","on"),
("525","woocommerce_attribute_lookup_direct_updates","no","on"),
("526","woocommerce_attribute_lookup_optimized_updates","no","on"),
("527","woocommerce_product_match_featured_image_by_sku","no","on"),
("528","woocommerce_prices_include_tax","yes","on"),
("529","woocommerce_tax_based_on","shipping","on"),
("530","woocommerce_shipping_tax_class","inherit","on"),
("531","woocommerce_tax_round_at_subtotal","no","on"),
("532","woocommerce_tax_classes","","on"),
("533","woocommerce_tax_display_shop","incl","on"),
("534","woocommerce_tax_display_cart","incl","on"),
("535","woocommerce_price_display_suffix","","on"),
("536","woocommerce_tax_total_display","itemized","off"),
("537","woocommerce_enable_shipping_calc","yes","off"),
("538","woocommerce_shipping_cost_requires_address","yes","on"),
("539","woocommerce_shipping_hide_rates_when_free","no","off"),
("540","woocommerce_ship_to_destination","shipping","off"),
("541","woocommerce_shipping_debug_mode","yes","on"),
("542","woocommerce_enable_guest_checkout","yes","off"),
("543","woocommerce_enable_checkout_login_reminder","yes","off"),
("544","woocommerce_enable_signup_and_login_from_checkout","yes","off"),
("545","woocommerce_enable_myaccount_registration","yes","off"),
("546","woocommerce_registration_generate_password","yes","off"),
("547","woocommerce_registration_generate_username","yes","off"),
("548","woocommerce_erasure_request_removes_order_data","yes","off"),
("549","woocommerce_erasure_request_removes_download_data","no","off"),
("550","woocommerce_allow_bulk_remove_personal_data","no","off"),
("551","woocommerce_registration_privacy_policy_text","Your personal data will be used to support your experience throughout this website, to manage access to your account, and for other purposes described in our [privacy_policy].","on"),
("552","woocommerce_checkout_privacy_policy_text","Vos données personnelles seront utilisées pour traiter votre commande, améliorer votre expérience sur ce site web et à d’autres fins décrites dans notre [politique de confidentialité].","on"),
("553","woocommerce_delete_inactive_accounts","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}","off"),
("554","woocommerce_trash_pending_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}","off"),
("555","woocommerce_trash_failed_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}","off"),
("556","woocommerce_trash_cancelled_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}","off"),
("557","woocommerce_anonymize_refunded_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}","off"),
("558","woocommerce_anonymize_completed_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}","off"),
("559","woocommerce_email_from_address","hedi.chqir@gmail.com","off"),
("560","woocommerce_email_header_image","","off"),
("561","woocommerce_email_header_image_width","120","on"),
("562","woocommerce_email_header_alignment","left","on"),
("563","woocommerce_email_font_family","Helvetica","on"),
("564","woocommerce_email_footer_text","{site_title}<br />{store_address}","off"),
("565","woocommerce_email_base_color","#8526ff","off"),
("566","woocommerce_email_background_color","#ffffff","off"),
("567","woocommerce_email_body_background_color","#ffffff","off"),
("568","woocommerce_email_text_color","#1e1e1e","off"),
("569","woocommerce_email_footer_text_color","#787c82","off"),
("570","woocommerce_email_auto_sync_with_theme","yes","off"),
("571","woocommerce_pos_store_name","Legging de sport femme | Liberté de mouvement","on"),
("572","woocommerce_pos_store_address","TX","on"),
("573","woocommerce_pos_store_phone","","on"),
("574","woocommerce_pos_store_email","info@cigarettecorner.com","on"),
("575","woocommerce_pos_refund_returns_policy","","on"),
("576","woocommerce_cart_page_id","154","off"),
("577","woocommerce_checkout_page_id","155","off"),
("578","woocommerce_myaccount_page_id","156","off"),
("579","woocommerce_terms_page_id","0","off"),
("580","woocommerce_checkout_pay_endpoint","order-pay","on"),
("581","woocommerce_checkout_order_received_endpoint","order-received","on"),
("582","woocommerce_myaccount_add_payment_method_endpoint","add-payment-method","on"),
("583","woocommerce_myaccount_delete_payment_method_endpoint","delete-payment-method","on"),
("584","woocommerce_myaccount_set_default_payment_method_endpoint","set-default-payment-method","on"),
("585","woocommerce_myaccount_orders_endpoint","orders","on"),
("586","woocommerce_myaccount_view_order_endpoint","view-order","on"),
("587","woocommerce_myaccount_downloads_endpoint","downloads","on"),
("588","woocommerce_myaccount_edit_account_endpoint","edit-account","on"),
("589","woocommerce_myaccount_edit_address_endpoint","edit-address","on"),
("590","woocommerce_myaccount_payment_methods_endpoint","payment-methods","on"),
("591","woocommerce_myaccount_lost_password_endpoint","lost-password","on"),
("592","woocommerce_logout_endpoint","customer-logout","on"),
("593","woocommerce_api_enabled","no","on"),
("594","woocommerce_allow_tracking","yes","on"),
("595","woocommerce_show_marketplace_suggestions","yes","off"),
("596","woocommerce_custom_orders_table_enabled","yes","on"),
("597","woocommerce_analytics_enabled","yes","on"),
("598","woocommerce_feature_rate_limit_checkout_enabled","no","on"),
("599","woocommerce_feature_order_attribution_enabled","yes","on"),
("600","woocommerce_feature_site_visibility_badge_enabled","yes","on"),
("601","woocommerce_hpos_datastore_caching_enabled","no","on"),
("602","woocommerce_feature_remote_logging_enabled","yes","on"),
("603","woocommerce_feature_email_improvements_enabled","yes","on"),
("606","woocommerce_email_improvements_disabled_count","1","auto"),
("607","woocommerce_email_improvements_first_disabled_at","2026-02-17 11:27:39","auto"),
("608","woocommerce_email_improvements_last_disabled_at","2026-02-17 11:27:39","auto"),
("609","woocommerce_feature_blueprint_enabled","yes","on"),
("610","woocommerce_feature_cost_of_goods_sold_enabled","no","on"),
("611","woocommerce_hpos_fts_index_enabled","no","on"),
("612","woocommerce_feature_block_email_editor_enabled","no","on"),
("613","woocommerce_feature_point_of_sale_enabled","yes","on"),
("614","woocommerce_feature_mcp_integration_enabled","no","on"),
("615","woocommerce_feature_destroy-empty-sessions_enabled","no","on"),
("616","woocommerce_feature_rest_api_caching_enabled","no","on"),
("617","woocommerce_feature_product_instance_caching_enabled","no","on"),
("618","woocommerce_single_image_width","600","on"),
("619","woocommerce_thumbnail_image_width","300","on"),
("620","woocommerce_checkout_highlight_required_fields","yes","on"),
("621","woocommerce_demo_store","no","off"),
("622","wc_downloads_approved_directories_mode","enabled","auto"),
("623","woocommerce_permalinks","a:5:{s:12:\"product_base\";s:7:\"produit\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}","auto"),
("624","current_theme_supports_woocommerce","yes","auto"),
("625","woocommerce_queue_flush_rewrite_rules","no","auto"),
("628","default_product_cat","16","auto"),
("631","woocommerce_paypal_settings","a:25:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:6:\"PayPal\";s:11:\"description\";s:85:\"Pay via PayPal; you can pay with your credit card if you don\'t have a PayPal account.\";s:5:\"email\";s:20:\"hedi.chqir@gmail.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:14:\"paypal_buttons\";s:3:\"yes\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:9:\"image_url\";s:0:\"\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:20:\"hedi.chqir@gmail.com\";s:14:\"identity_token\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:28:\"transact_onboarding_complete\";s:2:\"no\";s:12:\"_should_load\";s:2:\"no\";}","on"),
("632","woocommerce_version","10.5.2","auto"),
("633","woocommerce_db_version","10.5.2","auto"),
("634","woocommerce_store_id","272ee229-14f5-4be6-8c8a-c29366f9f04a","auto"),
("635","woocommerce_admin_install_timestamp","1771327659","auto"),
("636","woocommerce_inbox_variant_assignment","5","auto"),
("637","woocommerce_remote_variant_assignment","77","auto"),
("638","woocommerce_attribute_lookup_enabled","no","auto"),
("642","_transient_jetpack_autoloader_plugin_paths","a:1:{i:0;s:29:\"{{WP_PLUGIN_DIR}}/woocommerce\";}","on"),
("643","action_scheduler_lock_async-request-runner","6995d7017b7524.37362739|1771427645","no"),
("644","woocommerce_admin_notices","a:1:{i:0;s:19:\"maxmind_license_key\";}","auto"),
("645","woocommerce_maxmind_geolocation_settings","a:1:{s:15:\"database_prefix\";s:32:\"r3CYo6jsAUNHrL9xFiTurWJbWYGa3Cjv\";}","on"),
("646","_transient_woocommerce_webhook_ids_status_active","a:0:{}","on"),
("647","widget_woocommerce_widget_cart","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("648","widget_woocommerce_layered_nav_filters","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("649","widget_woocommerce_layered_nav","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("650","widget_woocommerce_price_filter","a:2:{i:2;a:1:{s:5:\"title\";s:12:\"Price Filter\";}s:12:\"_multiwidget\";i:1;}","auto"),
("651","widget_woocommerce_product_categories","a:2:{i:2;a:8:{s:5:\"title\";s:10:\"Categories\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;s:9:\"max_depth\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","auto"),
("652","widget_woocommerce_product_search","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("653","widget_woocommerce_product_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("654","widget_woocommerce_products","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("655","widget_woocommerce_recently_viewed_products","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("656","widget_woocommerce_top_rated_products","a:2:{i:2;a:2:{s:5:\"title\";s:4:\"CART\";s:6:\"number\";i:3;}s:12:\"_multiwidget\";i:1;}","auto"),
("657","widget_woocommerce_recent_reviews","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("658","widget_woocommerce_rating_filter","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("659","widget_wc_brands_brand_description","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("660","widget_woocommerce_brand_nav","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("661","widget_wc_brands_brand_thumbnails","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("664","_site_transient_timeout_woocommerce_blocks_patterns","1773919661","off"),
("665","_site_transient_woocommerce_blocks_patterns","a:2:{s:7:\"version\";s:6:\"10.5.2\";s:8:\"patterns\";a:41:{i:0;a:11:{s:5:\"title\";s:6:\"Banner\";s:4:\"slug\";s:25:\"woocommerce-blocks/banner\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:10:\"banner.php\";}i:1;a:11:{s:5:\"title\";s:23:\"Coming Soon Entire Site\";s:4:\"slug\";s:35:\"woocommerce/coming-soon-entire-site\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"coming-soon-entire-site.php\";}i:2;a:11:{s:5:\"title\";s:22:\"Coming Soon Store Only\";s:4:\"slug\";s:34:\"woocommerce/coming-soon-store-only\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:26:\"coming-soon-store-only.php\";}i:3;a:11:{s:5:\"title\";s:11:\"Coming Soon\";s:4:\"slug\";s:23:\"woocommerce/coming-soon\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:15:\"coming-soon.php\";}i:4;a:11:{s:5:\"title\";s:29:\"Content right with image left\";s:4:\"slug\";s:48:\"woocommerce-blocks/content-right-with-image-left\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, About\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:28:\"content-right-image-left.php\";}i:5;a:11:{s:5:\"title\";s:29:\"Featured Category Cover Image\";s:4:\"slug\";s:48:\"woocommerce-blocks/featured-category-cover-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:33:\"featured-category-cover-image.php\";}i:6;a:11:{s:5:\"title\";s:24:\"Featured Category Triple\";s:4:\"slug\";s:43:\"woocommerce-blocks/featured-category-triple\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:28:\"featured-category-triple.php\";}i:7;a:11:{s:5:\"title\";s:12:\"Large Footer\";s:4:\"slug\";s:31:\"woocommerce-blocks/footer-large\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:16:\"footer-large.php\";}i:8;a:11:{s:5:\"title\";s:23:\"Footer with Simple Menu\";s:4:\"slug\";s:37:\"woocommerce-blocks/footer-simple-menu\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:22:\"footer-simple-menu.php\";}i:9;a:11:{s:5:\"title\";s:17:\"Footer with menus\";s:4:\"slug\";s:38:\"woocommerce-blocks/footer-with-3-menus\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:23:\"footer-with-3-menus.php\";}i:10;a:11:{s:5:\"title\";s:28:\"Four Image Grid Content Left\";s:4:\"slug\";s:47:\"woocommerce-blocks/form-image-grid-content-left\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, About\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"four-image-grid-content-left.php\";}i:11;a:11:{s:5:\"title\";s:20:\"Centered Header Menu\";s:4:\"slug\";s:39:\"woocommerce-blocks/header-centered-menu\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"header-centered-pattern.php\";}i:12;a:11:{s:5:\"title\";s:23:\"Distraction Free Header\";s:4:\"slug\";s:42:\"woocommerce-blocks/header-distraction-free\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"header-distraction-free.php\";}i:13;a:11:{s:5:\"title\";s:16:\"Essential Header\";s:4:\"slug\";s:35:\"woocommerce-blocks/header-essential\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:20:\"header-essential.php\";}i:14;a:11:{s:5:\"title\";s:12:\"Large Header\";s:4:\"slug\";s:31:\"woocommerce-blocks/header-large\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:16:\"header-large.php\";}i:15;a:11:{s:5:\"title\";s:14:\"Minimal Header\";s:4:\"slug\";s:33:\"woocommerce-blocks/header-minimal\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:18:\"header-minimal.php\";}i:16;a:11:{s:5:\"title\";s:47:\"Heading with three columns of content with link\";s:4:\"slug\";s:66:\"woocommerce-blocks/heading-with-three-columns-of-content-with-link\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:21:\"WooCommerce, Services\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:51:\"heading-with-three-columns-of-content-with-link.php\";}i:17;a:11:{s:5:\"title\";s:20:\"Hero Product 3 Split\";s:4:\"slug\";s:39:\"woocommerce-blocks/hero-product-3-split\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:24:\"hero-product-3-split.php\";}i:18;a:11:{s:5:\"title\";s:23:\"Hero Product Chessboard\";s:4:\"slug\";s:42:\"woocommerce-blocks/hero-product-chessboard\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"hero-product-chessboard.php\";}i:19;a:11:{s:5:\"title\";s:18:\"Hero Product Split\";s:4:\"slug\";s:37:\"woocommerce-blocks/hero-product-split\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:22:\"hero-product-split.php\";}i:20;a:11:{s:5:\"title\";s:33:\"Centered content with image below\";s:4:\"slug\";s:52:\"woocommerce-blocks/centered-content-with-image-below\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:43:\"intro-centered-content-with-image-below.php\";}i:21;a:11:{s:5:\"title\";s:22:\"Just Arrived Full Hero\";s:4:\"slug\";s:41:\"woocommerce-blocks/just-arrived-full-hero\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:26:\"just-arrived-full-hero.php\";}i:22;a:11:{s:5:\"title\";s:33:\"No Products Found - Clear Filters\";s:4:\"slug\";s:43:\"woocommerce/no-products-found-clear-filters\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:29:\"no-products-found-filters.php\";}i:23;a:11:{s:5:\"title\";s:17:\"No Products Found\";s:4:\"slug\";s:29:\"woocommerce/no-products-found\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:21:\"no-products-found.php\";}i:24;a:11:{s:5:\"title\";s:19:\"Default Coming Soon\";s:4:\"slug\";s:36:\"woocommerce/page-coming-soon-default\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:28:\"page-coming-soon-default.php\";}i:25;a:11:{s:5:\"title\";s:25:\"Coming Soon Image Gallery\";s:4:\"slug\";s:42:\"woocommerce/page-coming-soon-image-gallery\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:34:\"page-coming-soon-image-gallery.php\";}i:26;a:11:{s:5:\"title\";s:30:\"Coming Soon Minimal Left Image\";s:4:\"slug\";s:47:\"woocommerce/page-coming-soon-minimal-left-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:39:\"page-coming-soon-minimal-left-image.php\";}i:27;a:11:{s:5:\"title\";s:24:\"Coming Soon Modern Black\";s:4:\"slug\";s:41:\"woocommerce/page-coming-soon-modern-black\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:33:\"page-coming-soon-modern-black.php\";}i:28;a:11:{s:5:\"title\";s:29:\"Coming Soon Split Right Image\";s:4:\"slug\";s:46:\"woocommerce/page-coming-soon-split-right-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:38:\"page-coming-soon-split-right-image.php\";}i:29;a:11:{s:5:\"title\";s:34:\"Coming Soon With Header and Footer\";s:4:\"slug\";s:47:\"woocommerce/page-coming-soon-with-header-footer\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:39:\"page-coming-soon-with-header-footer.php\";}i:30;a:11:{s:5:\"title\";s:28:\"Product Collection 3 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-3-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"product-collection-3-columns.php\";}i:31;a:11:{s:5:\"title\";s:28:\"Product Collection 4 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-4-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"product-collection-4-columns.php\";}i:32;a:11:{s:5:\"title\";s:28:\"Product Collection 5 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-5-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"product-collection-5-columns.php\";}i:33;a:11:{s:5:\"title\";s:47:\"Product Collection: Featured Products 5 Columns\";s:4:\"slug\";s:65:\"woocommerce-blocks/product-collection-featured-products-5-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:50:\"product-collection-featured-products-5-columns.php\";}i:34;a:11:{s:5:\"title\";s:15:\"Product Gallery\";s:4:\"slug\";s:48:\"woocommerce-blocks/product-query-product-gallery\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:36:\"core/query/woocommerce/product-query\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:33:\"product-query-product-gallery.php\";}i:35;a:11:{s:5:\"title\";s:14:\"Product Search\";s:4:\"slug\";s:31:\"woocommerce/product-search-form\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:23:\"product-search-form.php\";}i:36;a:11:{s:5:\"title\";s:16:\"Related Products\";s:4:\"slug\";s:35:\"woocommerce-blocks/related-products\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:20:\"related-products.php\";}i:37;a:11:{s:5:\"title\";s:33:\"Social: Follow us on social media\";s:4:\"slug\";s:51:\"woocommerce-blocks/social-follow-us-in-social-media\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:25:\"WooCommerce, social-media\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:36:\"social-follow-us-in-social-media.php\";}i:38;a:11:{s:5:\"title\";s:22:\"Testimonials 3 Columns\";s:4:\"slug\";s:41:\"woocommerce-blocks/testimonials-3-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:20:\"WooCommerce, Reviews\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:26:\"testimonials-3-columns.php\";}i:39;a:11:{s:5:\"title\";s:19:\"Testimonials Single\";s:4:\"slug\";s:38:\"woocommerce-blocks/testimonials-single\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:20:\"WooCommerce, Reviews\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:23:\"testimonials-single.php\";}i:40;a:11:{s:5:\"title\";s:37:\"Three columns with images and content\";s:4:\"slug\";s:56:\"woocommerce-blocks/three-columns-with-images-and-content\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:21:\"WooCommerce, Services\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:41:\"three-columns-with-images-and-content.php\";}}}","off"),
("666","woocommerce_custom_orders_table_created","yes","auto"),
("667","woocommerce_coming_soon","no","auto"),
("668","woocommerce_store_pages_only","yes","auto"),
("669","woocommerce_email_improvements_default_enabled","yes","auto"),
("670","woocommerce_email_improvements_first_enabled_at","2026-02-17 11:27:41","auto"),
("671","woocommerce_email_improvements_last_enabled_at","2026-02-17 11:27:41","auto"),
("672","woocommerce_email_improvements_enabled_count","1","auto"),
("673","woocommerce_back_in_stock_allow_signups","yes","auto"),
("674","woocommerce_analytics_scheduled_import","yes","auto"),
("675","woocommerce_admin_scheduler_last_processed_order_modified_date","2026-02-18 15:05:32","off"),
("676","woocommerce_admin_scheduler_last_processed_order_id","0","off"),
("677","woocommerce_initial_installed_version","10.5.2","off"),
("678","wc_blocks_db_schema_version","260","auto"),
("679","wc_remote_inbox_notifications_stored_state","O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:1;}","off"),
("680","_transient_timeout_woocommerce_blocks_asset_api_script_data_ssl","1773930876","off"),
("681","_transient_woocommerce_blocks_asset_api_script_data_ssl","{\"script_data\":{\"assets\\/client\\/blocks\\/wc-settings.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-settings.js\",\"version\":\"508473c3c2ece9af8f8f\",\"dependencies\":[\"wc-types\",\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-types.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-types.js\",\"version\":\"f0cc692c0367e0930c80\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-entities.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-entities.js\",\"version\":\"cdb01de69fb7dbbbb30f\",\"dependencies\":[\"wc-settings\",\"wp-core-data\",\"wp-data\",\"wp-i18n\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-middleware.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-middleware.js\",\"version\":\"d79dedade2f2e4dc9df4\",\"dependencies\":[\"wp-api-fetch\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-data.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-data.js\",\"version\":\"cb3e0de73209d78c5dc0\",\"dependencies\":[\"wc-blocks-checkout-events\",\"wc-blocks-registry\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-data\",\"wp-data-controls\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-vendors.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-vendors.js\",\"version\":\"1155eafae09ee832d59f\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-registry.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-registry.js\",\"version\":\"a16aa912ffa0a15063f1\",\"dependencies\":[\"react-jsx-runtime\",\"wc-settings\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks.js\",\"version\":\"0db759a8a6e010732c50\",\"dependencies\":[\"react-jsx-runtime\",\"wp-blocks\",\"wp-compose\",\"wp-element\",\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-context.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-context.js\",\"version\":\"621353d8a3a7c8d44b41\",\"dependencies\":[\"react-jsx-runtime\",\"wp-element\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\",\"version\":\"c18bbb2325f333897e6b\",\"dependencies\":[\"react-jsx-runtime\",\"wc-blocks-data-store\",\"wc-blocks-shared-context\",\"wc-types\",\"wp-data\",\"wp-element\",\"wp-is-shallow-equal\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/price-format.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/price-format.js\",\"version\":\"0df720e448f7ab3c5d0d\",\"dependencies\":[\"wc-settings\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-frontend-vendors-frontend.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-frontend-vendors-frontend.js\",\"version\":\"00b931bcc27024fa60ca\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-cart-checkout-vendors-frontend.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-cart-checkout-vendors-frontend.js\",\"version\":\"bcad3fab21852551edee\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-cart-checkout-base-frontend.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-cart-checkout-base-frontend.js\",\"version\":\"7a3e5664185d4651f7f9\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/blocks-checkout.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-checkout.js\",\"version\":\"fd501851f2904ac6131a\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-sanitize\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/blocks-checkout-events.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-checkout-events.js\",\"version\":\"2d0fd4590f6cc663947c\",\"dependencies\":[\"wc-types\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/blocks-components.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-components.js\",\"version\":\"8b64025baef8d338aa5e\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-blocks-data-store\",\"wc-sanitize\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/wc-schema-parser.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-schema-parser.js\",\"version\":\"f762078aeb4207fe9c3d\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/admin\\/sanitize\\/index.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/admin\\/sanitize\\/index.js\",\"version\":\"c7a741f8dc5bec166999\",\"dependencies\":[]},\"assets\\/client\\/admin\\/customer-effort-score\\/index.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/admin\\/customer-effort-score\\/index.js\",\"version\":\"ebdc0b2d7487174621e6\",\"dependencies\":[\"react\",\"wc-experimental\",\"wc-navigation\",\"wc-store-data\",\"wc-tracks\",\"wp-api-fetch\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-data-controls\",\"wp-element\",\"wp-i18n\"]},\"assets\\/client\\/blocks\\/wc-shipping-method-pickup-location.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-shipping-method-pickup-location.js\",\"version\":\"0446a66f2604add5f739\",\"dependencies\":[\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/active-filters.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/active-filters.js\",\"version\":\"1fc0584596ef2b4cb41a\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/active-filters-frontend.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/active-filters-frontend.js\",\"version\":\"1c9e0590fb17c8e908a1\",\"dependencies\":[\"wc-blocks-frontend-vendors\",\"react\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-data\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/add-to-cart-form.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/add-to-cart-form.js\",\"version\":\"6411f1e4b694b6311644\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-settings\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-editor\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/all-products.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/all-products.js\",\"version\":\"667dc34ba66495cd6189\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-context\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-sanitize\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-autop\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-core-data\",\"wp-data\",\"wp-editor\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/all-products-frontend.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/all-products-frontend.js\",\"version\":\"7ca40794c640a5f22b9b\",\"dependencies\":[\"wc-blocks-frontend-vendors\",\"react\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-context\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-sanitize\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-autop\",\"wp-block-editor\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/all-reviews.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/all-reviews.js\",\"version\":\"0e51554cc0957d0d67d6\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-sanitize\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/reviews-frontend.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/reviews-frontend.js\",\"version\":\"ca0ecd857aa9d4e0272d\",\"dependencies\":[\"wc-blocks-frontend-vendors\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-sanitize\",\"wc-settings\",\"wp-a11y\",\"wp-api-fetch\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/attribute-filter.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/attribute-filter.js\",\"version\":\"3c37022d63be289bf6f3\",\"dependencies\":[\"lodash\",\"react\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/attribute-filter-frontend.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/attribute-filter-frontend.js\",\"version\":\"82b1bb246f81cdc4fbe7\",\"dependencies\":[\"wc-blocks-frontend-vendors\",\"lodash\",\"react\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/cart-link.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-link.js\",\"version\":\"12be2ae90ebeffa4c891\",\"dependencies\":[\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/category-title.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/category-title.js\",\"version\":\"6f41be4a50d2e91ef1f2\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-core-data\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/category-title-frontend.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/category-title-frontend.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/category-description.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/category-description.js\",\"version\":\"124523c451cb38f87217\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-core-data\",\"wp-data\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/category-description-frontend.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/category-description-frontend.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/classic-shortcode.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/classic-shortcode.js\",\"version\":\"58e5c198813c75e1906e\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/coming-soon.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/coming-soon.js\",\"version\":\"ae2b4f7b2f202be4a142\",\"dependencies\":[\"react-jsx-runtime\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-editor\",\"wp-i18n\",\"wp-plugins\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/coupon-code.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/coupon-code.js\",\"version\":\"22dc7312f3a2a721db88\",\"dependencies\":[\"react-jsx-runtime\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-hooks\",\"wp-i18n\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/coupon-code-frontend.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/coupon-code-frontend.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/customer-account.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/customer-account.js\",\"version\":\"2a921e28e98970103c5c\",\"dependencies\":[\"react-jsx-runtime\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/email-content.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/email-content.js\",\"version\":\"6c869054c245b8aba494\",\"dependencies\":[\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-server-side-render\"]},\"assets\\/client\\/blocks\\/featured-category.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/featured-category.js\",\"version\":\"ba054e18712bfeaf4b88\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-blocks-shared-context\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-core-data\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\"]},\"assets\\/client\\/blocks\\/featured-product.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/featured-product.js\",\"version\":\"8d8507ff46fbd7f892df\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-blocks-shared-context\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-core-data\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\"]},\"assets\\/client\\/blocks\\/filter-wrapper.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/filter-wrapper.js\",\"version\":\"f30d38dadc1b82e9ccd8\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/filter-wrapper-frontend.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/filter-wrapper-frontend.js\",\"version\":\"4b97827bd62f46bb411d\",\"dependencies\":[\"wc-blocks-frontend-vendors\",\"lodash\",\"react\",\"react-jsx-runtime\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/handpicked-products.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/handpicked-products.js\",\"version\":\"18d3d8d36ba8565555a4\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"assets\\/client\\/blocks\\/mini-cart.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart.js\",\"version\":\"8edcab2ab2ce9e193113\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-gallery-large-image-next-previous.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-gallery-large-image-next-previous.js\",\"version\":\"5431edba92953219c62c\",\"dependencies\":[\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-i18n\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/store-notices.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/store-notices.js\",\"version\":\"5806c78bb3296162c841\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wp-a11y\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/payment-method-icons.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/payment-method-icons.js\",\"version\":\"f06aac6ea533a03d6d64\",\"dependencies\":[\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-i18n\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/price-filter.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/price-filter.js\",\"version\":\"d75b71a15598b75fce9a\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/price-filter-frontend.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/price-filter-frontend.js\",\"version\":\"a390ba717af294c42935\",\"dependencies\":[\"wc-blocks-frontend-vendors\",\"react\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-best-sellers.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-best-sellers.js\",\"version\":\"87aac3da44cb82f52353\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-button.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-button.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/product-categories.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-categories.js\",\"version\":\"fdd5827e0d7e306e1332\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\"]},\"assets\\/client\\/blocks\\/product-category.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-category.js\",\"version\":\"1c37f728872ca88000c6\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-collection.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-collection.js\",\"version\":\"2c7cd0ad77689c5b1bd4\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-blocks-registry\",\"wc-customer-effort-score\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-core-data\",\"wp-data\",\"wp-editor\",\"wp-element\",\"wp-escape-html\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-collection-no-results.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-collection-no-results.js\",\"version\":\"08c18db782b6fe6fc023\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-filters.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-filters.js\",\"version\":\"0d0e10973391235da95a\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-filter-status.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-filter-status.js\",\"version\":\"cb931b3e41f6157fc49f\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-filter-price.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-filter-price.js\",\"version\":\"0ce9d06ba777ef3c4e61\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-blocks-data-store\",\"wc-price-format\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-filter-price-slider.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-filter-price-slider.js\",\"version\":\"243941f6ad7fdb0f2c32\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-price-format\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-filter-attribute.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-filter-attribute.js\",\"version\":\"a983020a74d6f1118801\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-filter-rating.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-filter-rating.js\",\"version\":\"05ecf25c3615901a5135\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-filter-active.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-filter-active.js\",\"version\":\"d25dff8dc16ad6327b29\",\"dependencies\":[\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-filter-removable-chips.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-filter-removable-chips.js\",\"version\":\"7bde2b6f86aecedadde1\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-filter-clear-button.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-filter-clear-button.js\",\"version\":\"7c92ad22d30ae9eb414e\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-filter-checkbox-list.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-filter-checkbox-list.js\",\"version\":\"61b17d60c9c01facc7d2\",\"dependencies\":[\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-filter-chips.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-filter-chips.js\",\"version\":\"8e5311156f40dfb0d094\",\"dependencies\":[\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-filter-taxonomy.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-filter-taxonomy.js\",\"version\":\"5f812765e915092c2a37\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-core-data\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-gallery.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-gallery.js\",\"version\":\"84c40d788c2db34b9aa7\",\"dependencies\":[\"react-jsx-runtime\",\"wc-blocks-shared-hocs\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-editor\",\"wp-i18n\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/product-gallery-large-image.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-gallery-large-image.js\",\"version\":\"be7f3c98cd6a86661b3d\",\"dependencies\":[\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/product-gallery-thumbnails.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-gallery-thumbnails.js\",\"version\":\"cca5a6c9afc8c80cb3de\",\"dependencies\":[\"react-jsx-runtime\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-core-data\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/product-new.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-new.js\",\"version\":\"b2798001f381d7cff4dd\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-on-sale.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-on-sale.js\",\"version\":\"702b17d104535d0cec18\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-template.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-template.js\",\"version\":\"d5a6a839796d5cc61403\",\"dependencies\":[\"react-jsx-runtime\",\"wc-blocks-shared-context\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-core-data\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-query.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-query.js\",\"version\":\"63619a162cef6ab35ae5\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-editor\",\"wp-element\",\"wp-escape-html\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-query-frontend.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-query-frontend.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/product-search.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-search.js\",\"version\":\"a27c9ff0785bf7887058\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-hooks\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-tag.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-tag.js\",\"version\":\"4392a796f9f7e675e525\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-title.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-title.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/product-title-frontend.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-title-frontend.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/product-top-rated.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-top-rated.js\",\"version\":\"6b13dcaa14b5bd3d5e15\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"assets\\/client\\/blocks\\/products-by-attribute.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/products-by-attribute.js\",\"version\":\"098e377e6dd0c96b6c4f\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"assets\\/client\\/blocks\\/rating-filter.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/rating-filter.js\",\"version\":\"31a990ac2f4506f7a1c4\",\"dependencies\":[\"lodash\",\"react\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/reviews-by-category.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/reviews-by-category.js\",\"version\":\"5eedfbb68b279579e441\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-sanitize\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/reviews-by-product.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/reviews-by-product.js\",\"version\":\"5c067b017644ff66cb62\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-sanitize\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/single-product.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/single-product.js\",\"version\":\"69fdc13bdd86c0480066\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-context\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-sanitize\",\"wc-settings\",\"wc-store-data\",\"wc-types\",\"wp-api-fetch\",\"wp-autop\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/stock-filter.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/stock-filter.js\",\"version\":\"5dc4965e7678d9fcb76b\",\"dependencies\":[\"lodash\",\"react\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/stock-filter-frontend.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/stock-filter-frontend.js\",\"version\":\"0947d16539ebd2e3354d\",\"dependencies\":[\"wc-blocks-frontend-vendors\",\"lodash\",\"react\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/page-content-wrapper.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/page-content-wrapper.js\",\"version\":\"a95a8bfb64c5af64db2b\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-create-account.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-create-account.js\",\"version\":\"94293bc8940212da41f7\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-create-account-frontend.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-create-account-frontend.js\",\"version\":\"f516e875395c1803ec8f\",\"dependencies\":[\"wc-blocks-frontend-vendors\",\"react\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/product-details.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-details.js\",\"version\":\"409665aec6d31ce1a279\",\"dependencies\":[\"react-jsx-runtime\",\"wc-settings\",\"wc-store-data\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-editor\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-description.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-description.js\",\"version\":\"9ab90af909f3cca2b7da\",\"dependencies\":[\"react-jsx-runtime\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-core-data\",\"wp-data\",\"wp-editor\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-specifications.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-specifications.js\",\"version\":\"e5445d4e2d19ed7c5e13\",\"dependencies\":[\"react-jsx-runtime\",\"wc-store-data\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-editor\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/accordion-group.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/accordion-group.js\",\"version\":\"1290468f8006af88f9f7\",\"dependencies\":[\"react-jsx-runtime\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-i18n\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/accordion-item.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/accordion-item.js\",\"version\":\"a3b5870b2b50a51e12b5\",\"dependencies\":[\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/accordion-panel.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/accordion-panel.js\",\"version\":\"e761d578e4437d990129\",\"dependencies\":[\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/accordion-header.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/accordion-header.js\",\"version\":\"07e2bde1874e0c6b2f66\",\"dependencies\":[\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-i18n\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/product-reviews.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-reviews.js\",\"version\":\"8a4d9f1b069b6b176640\",\"dependencies\":[\"react-jsx-runtime\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-editor\",\"wp-i18n\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/product-review-rating.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-review-rating.js\",\"version\":\"53a7d80e7221a373e848\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-store-data\",\"wp-block-editor\",\"wp-blocks\",\"wp-data\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-reviews-title.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-reviews-title.js\",\"version\":\"d301b9108a6e71e12bc7\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-store-data\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-core-data\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-review-form.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-review-form.js\",\"version\":\"e654c35b9768c66bf56b\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-store-data\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-core-data\",\"wp-data\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-review-date.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-review-date.js\",\"version\":\"8556342e8f84afc5b936\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-core-data\",\"wp-date\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-review-content.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-review-content.js\",\"version\":\"c380ae7e00d3a77fa860\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-core-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-review-author-name.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-review-author-name.js\",\"version\":\"48056e8e398ceee8f2b4\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-core-data\",\"wp-data\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-reviews-pagination.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-reviews-pagination.js\",\"version\":\"49fbc890134eaed052df\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-reviews-pagination-next.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-reviews-pagination-next.js\",\"version\":\"9e11f0b065467814c2b5\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-reviews-pagination-previous.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-reviews-pagination-previous.js\",\"version\":\"7dabcbfbc8f6a5762567\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-reviews-pagination-numbers.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-reviews-pagination-numbers.js\",\"version\":\"f5c92289fabe27a3b05e\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-review-template.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-review-template.js\",\"version\":\"b0113127896f7a734b42\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-core-data\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/cart.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart.js\",\"version\":\"e59b539aa2072d909c5a\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-blocks-checkout\",\"wc-blocks-checkout-events\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-context\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-sanitize\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-core-data\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-notices\",\"wp-plugins\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/cart-frontend.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-frontend.js\",\"version\":\"fdd1fd0fdad7e63222ff\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-jsx-runtime\",\"wc-blocks-checkout\",\"wc-blocks-checkout-events\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-context\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-sanitize\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-notices\",\"wp-plugins\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/cart-order-summary-taxes-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-taxes-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-subtotal-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-subtotal-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-totals-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-totals-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/filled-cart-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/filled-cart-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/empty-cart-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/empty-cart-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-totals-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-totals-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-items-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-items-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-line-items-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-line-items-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-express-payment-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-express-payment-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/proceed-to-checkout-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/proceed-to-checkout-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-accepted-payment-methods-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-accepted-payment-methods-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-coupon-form-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-coupon-form-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-discount-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-discount-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-fee-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-fee-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-heading-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-heading-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-shipping-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-shipping-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-cross-sells-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-cross-sells-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-cross-sells-products-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-cross-sells-products-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout.js\",\"version\":\"e8094507740c220b04ae\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-blocks-checkout\",\"wc-blocks-checkout-events\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-sanitize\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-core-data\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-notices\",\"wp-plugins\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/checkout-frontend.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-frontend.js\",\"version\":\"2c8271ca80879401990e\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-jsx-runtime\",\"wc-blocks-checkout\",\"wc-blocks-checkout-events\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-sanitize\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-dom-ready\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-plugins\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-express-payment--checkout-blocks\\/express-payment-frontend.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-express-payment--checkout-blocks\\/express-payment-frontend.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-actions-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-actions-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-additional-information-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-additional-information-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-billing-address-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-billing-address-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-contact-information-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-contact-information-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-express-payment-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-express-payment-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-fields-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-fields-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-note-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-note-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-cart-items-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-cart-items-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-coupon-form-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-coupon-form-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-discount-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-discount-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-fee-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-fee-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-shipping-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-shipping-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-subtotal-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-subtotal-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-taxes-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-taxes-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-totals-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-totals-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-payment-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-payment-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-shipping-address-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-shipping-address-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-shipping-methods-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-shipping-methods-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-shipping-method-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-shipping-method-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-pickup-options-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-pickup-options-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-terms-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-terms-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-totals-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-totals-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents.js\",\"version\":\"4443847aaea5a5736056\",\"dependencies\":[\"react\",\"react-jsx-runtime\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-sanitize\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-autop\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/empty-mini-cart-contents-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/empty-mini-cart-contents-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/filled-mini-cart-contents-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/filled-mini-cart-contents-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-footer-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-footer-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-items-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-items-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-products-table-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-products-table-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-shopping-button-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-shopping-button-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-cart-button-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-cart-button-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-checkout-button-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-checkout-button-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-title-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-title-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-title-items-counter-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-title-items-counter-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-title-label-block.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-title-label-block.js\",\"version\":\"wc-10.5.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/breadcrumbs.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/breadcrumbs.js\",\"version\":\"686bdfcc16b8c7d96379\",\"dependencies\":[\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/catalog-sorting.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/catalog-sorting.js\",\"version\":\"ec3bfa29e93018850a0a\",\"dependencies\":[\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-results-count.js\":{\"src\":\"https:\\/\\/leg.miklub.fr\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-results-count.js\",\"version\":\"8e333cecccaf5341ff94\",\"dependencies\":[\"react-jsx-runtime\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]}},\"version\":\"wc-10.5.2\",\"hash\":\"e571d660f3f1d754eb645dd1c47f0e53\"}","off");

INSERT IGNORE INTO `wp_options` VALUES 
("684","woocommerce_admin_pes_incentive_woopayments_store_had_woopayments","no","auto"),
("685","_transient_timeout_woocommerce_admin_pes_incentive_woopayments_cache","1771576942","off"),
("686","_transient_woocommerce_admin_pes_incentive_woopayments_cache","a:3:{s:10:\"incentives\";a:2:{i:0;a:8:{s:2:\"id\";s:32:\"wcpay-promo-2023-action-discount\";s:8:\"promo_id\";s:32:\"wcpay-promo-2023-action-discount\";s:4:\"type\";s:12:\"welcome_page\";s:9:\"cta_label\";s:28:\"Install WooPayments for free\";s:6:\"tc_url\";s:75:\"https://woocommerce.com/terms-conditions/woopayments-action-promotion-2023/\";s:11:\"description\";s:117:\"<b>Save 10%</b> on payment processing costs in your <b>first three months</b> when you sign up for WooPayments today.\";s:19:\"task_header_content\";s:256:\"Power your payments with a simple, all-in-one option and <b>save 10% on payment processing costs in your first three months</b>. See <a href=\"https://woocommerce.com/terms-conditions/woopayments-action-promotion-2023/\">Terms and Conditions</a> for details.\";s:10:\"task_badge\";s:35:\"Save 10% on payment processing fees\";}i:1;a:9:{s:2:\"id\";s:54:\"wcpay-promo-2023-action-discount__wc_settings_payments\";s:8:\"promo_id\";s:32:\"wcpay-promo-2023-action-discount\";s:4:\"type\";s:20:\"wc_settings_payments\";s:11:\"description\";s:161:\"Use the native payments solution built and supported by Woo to accept online and in-person payments, track revenue, and handle all payment activity in one place.\";s:9:\"cta_label\";s:20:\"Install and save 10%\";s:6:\"tc_url\";s:75:\"https://woocommerce.com/terms-conditions/woopayments-action-promotion-2023/\";s:5:\"title\";s:88:\"Save 10% on processing fees during your first 3 months when you sign up for WooPayments.\";s:17:\"short_description\";s:88:\"Save 10% on processing fees during your first 3 months when you sign up for WooPayments.\";s:5:\"badge\";s:27:\"Save 10% on processing fees\";}}s:12:\"context_hash\";s:32:\"5a6689c9d38b7e7b1df5b89c17d0f126\";s:9:\"timestamp\";i:1771404142;}","off"),
("687","woocommerce_gateway_order","a:6:{s:19:\"_wc_pes_woopayments\";i:0;s:25:\"_wc_pes_paypal_full_stack\";i:1;s:33:\"_wc_offline_payment_methods_group\";i:2;s:4:\"bacs\";i:3;s:6:\"cheque\";i:4;s:3:\"cod\";i:5;}","auto"),
("705","auxshp_wishlist_page","11","auto"),
("707","_transient_timeout_woocommerce_admin_remote_inbox_notifications_specs","1772025037","off"),
("708","_transient_woocommerce_admin_remote_inbox_notifications_specs","a:1:{s:5:\"fr_FR\";a:53:{s:18:\"your-first-product\";O:8:\"stdClass\":8:{s:4:\"slug\";s:18:\"your-first-product\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:18:\"Your first product\";s:7:\"content\";s:467:\"That’s huge! You’re well on your way to building a successful online store — now it’s time to think about how you’ll fulfill your orders.<br/><br/>Read our shipping guide to learn best practices and options for putting together your shipping strategy. And for WooCommerce stores in the United States, you can print discounted shipping labels via USPS with <a href=\"https://href.li/?https://woocommerce.com/shipping\" target=\"_blank\">WooCommerce Shipping</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:130:\"https://woocommerce.com/posts/ecommerce-shipping-solutions-guide/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:19:13\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_were_no_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_are_now_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:1;}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_types\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"physical\";s:7:\"default\";a:0:{}}}}s:37:\"wc-admin-optimizing-the-checkout-flow\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-optimizing-the-checkout-flow\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:28:\"Optimizing the checkout flow\";s:7:\"content\";s:177:\"It’s crucial to get your store’s checkout as smooth as possible to avoid losing sales. Let’s take a look at how you can optimize the checkout experience for your shoppers.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:28:\"optimizing-the-checkout-flow\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:144:\"https://woocommerce.com/posts/optimizing-woocommerce-checkout?utm_source=inbox_note&utm_medium=product&utm_campaign=optimizing-the-checkout-flow\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:19:49\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"payments\";s:7:\"default\";a:0:{}}}}s:32:\"wc-payments-qualitative-feedback\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"wc-payments-qualitative-feedback\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:46:\"WooPayments setup - let us know what you think\";s:7:\"content\";s:137:\"Congrats on enabling WooPayments for your store. Please share your feedback in this 2 minute survey to help us improve the setup process.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"qualitative-feedback-from-new-users\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:58:\"https://automattic.survey.fm/woopayments-new-user-feedback\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:21:13\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:20:\"woocommerce-payments\";s:7:\"default\";a:0:{}}}}s:29:\"share-your-feedback-on-paypal\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"share-your-feedback-on-paypal\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:29:\"Share your feedback on PayPal\";s:7:\"content\";s:127:\"Share your feedback in this 2 minute survey about how we can make the process of accepting payments more useful for your store.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:43:\"http://automattic.survey.fm/paypal-feedback\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:21:50\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}}}s:31:\"google_listings_and_ads_install\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"google_listings_and_ads_install\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Drive traffic and sales with Google\";s:7:\"content\";s:123:\"Reach online shoppers to drive traffic and sales for your store by showcasing products across Google, for free or with ads.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"get-started\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Get started\";}}s:3:\"url\";s:122:\"https://woocommerce.com/products/google-listings-and-ads?utm_source=inbox_note&utm_medium=product&utm_campaign=get-started\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-06-09 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:23:\"google_listings_and_ads\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:10;}}}s:39:\"wc-subscriptions-security-update-3-0-15\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"wc-subscriptions-security-update-3-0-15\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:42:\"WooCommerce Subscriptions security update!\";s:7:\"content\";s:738:\"We recently released an important security update to WooCommerce Subscriptions. To ensure your site’s data is protected, please upgrade <strong>WooCommerce Subscriptions to version 3.0.15</strong> or later.<br/><br/>Click the button below to view and update to the latest Subscriptions version, or log in to <a href=\"https://woocommerce.com/my-dashboard\">WooCommerce.com Dashboard</a> and navigate to your <strong>Downloads</strong> page.<br/><br/>We recommend always using the latest version of WooCommerce Subscriptions, and other software running on your site, to ensure maximum security.<br/><br/>If you have any questions we are here to help — just <a href=\"https://woocommerce.com/my-account/create-a-ticket/\">open a ticket</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:30:\"update-wc-subscriptions-3-0-15\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"View latest version\";}}s:3:\"url\";s:30:\"&page=wc-addons&section=helper\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:30:32\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:6:\"3.0.15\";}}}s:29:\"woocommerce-core-update-5-4-0\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"woocommerce-core-update-5-4-0\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Update to WooCommerce 5.4.1 now\";s:7:\"content\";s:140:\"WooCommerce 5.4.1 addresses a checkout issue discovered in WooCommerce 5.4. We recommend upgrading to WooCommerce 5.4.1 as soon as possible.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:20:\"update-wc-core-5-4-0\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:25:\"How to update WooCommerce\";}}s:3:\"url\";s:64:\"https://docs.woocommerce.com/document/how-to-update-woocommerce/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:31:08\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.0\";}}}s:19:\"wcpay-promo-2020-11\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-11\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-11\";s:7:\"content\";s:19:\"wcpay-promo-2020-11\";}}s:7:\"actions\";a:0:{}s:5:\"rules\";a:0:{}}s:19:\"wcpay-promo-2020-12\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-12\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-12\";s:7:\"content\";s:19:\"wcpay-promo-2020-12\";}}s:7:\"actions\";a:0:{}s:5:\"rules\";a:0:{}}s:34:\"ppxo-pps-upgrade-paypal-payments-1\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-1\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Get the latest PayPal extension for WooCommerce\";s:7:\"content\";s:442:\"Heads up! There’s a new PayPal on the block!<br/><br/>Now is a great time to upgrade to our latest <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal extension</a> to continue to receive support and updates with PayPal.<br/><br/>Get access to a full suite of PayPal payment methods, extensive currency and country coverage, and pay later options with the all-new PayPal extension for WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-1\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:33:53\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:7;s:7:\"default\";i:1;s:9:\"operation\";s:1:\"<\";}}}s:34:\"ppxo-pps-upgrade-paypal-payments-2\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-2\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Upgrade your PayPal experience!\";s:7:\"content\";s:358:\"Get access to a full suite of PayPal payment methods, extensive currency and country coverage, offer subscription and recurring payments, and the new PayPal pay later options.<br /><br />Start using our <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">latest PayPal today</a> to continue to receive support and updates.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-2\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:34:30\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:6;s:7:\"default\";i:1;s:9:\"operation\";s:1:\">\";}}}s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:56:\"Action required: Critical vulnerabilities in WooCommerce\";s:7:\"content\";s:574:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br /><br />Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br /><br />For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:59:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:35:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.6\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.8\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.9\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.6\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.2\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.3\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.4\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.4\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.5\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.2\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.4\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.3\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.2\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.3\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.4\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.2\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.2\";}i:32;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.3\";}i:33;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.4\";}i:34;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:35;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:36;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.2\";}i:37;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.3\";}i:38;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}i:39;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"3.5.10\";}i:40;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.7\";}i:41;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.3\";}i:42;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.3\";}i:43;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.5\";}i:44;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.4\";}i:45;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.4\";}i:46;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.5\";}i:47;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.6\";}i:48;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.4\";}i:49;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.5\";}i:50;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.5\";}i:51;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.4\";}i:52;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.3\";}i:53;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.5\";}i:54;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.3\";}i:55;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.3\";}i:56;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.5\";}i:57;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.3\";}i:58;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.4\";}}}s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"Action required: Critical vulnerabilities in WooCommerce Blocks\";s:7:\"content\";s:570:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/>Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br/><br/>For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:32:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:35:42\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"2.5.16\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.6.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.7.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.8.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.9.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.0.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.1.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.2.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.1\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"ver